/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.cvsclient.command;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.netbeans.lib.cvsclient.ClientServices;
import org.netbeans.lib.cvsclient.command.CommandException;
import org.netbeans.lib.cvsclient.command.KeywordSubstitutionOptions;
import org.netbeans.lib.cvsclient.util.SimpleStringPattern;

public class WrapperUtils {
    private static void parseWrappers(BufferedReader reader, Map theMap) throws IOException {
        String line;
        while ((line = reader.readLine()) != null) {
            StringTokenizer tokenizer = new StringTokenizer(line);
            SimpleStringPattern pattern = new SimpleStringPattern(tokenizer.nextToken());
            while (tokenizer.hasMoreTokens()) {
                String option = tokenizer.nextToken();
                String value = tokenizer.nextToken();
                if (!option.equals("-k")) continue;
                int first = value.indexOf(39);
                int last = value.lastIndexOf(39);
                if (first >= 0 && last >= 0) {
                    value = value.substring(first + 1, last);
                }
                KeywordSubstitutionOptions keywordOption = KeywordSubstitutionOptions.findKeywordSubstOption(value);
                if (theMap.containsKey(pattern)) continue;
                theMap.put(pattern, keywordOption);
            }
        }
    }

    public static void readWrappersFromFile(File file, Map wrapperMap) throws IOException, FileNotFoundException {
        WrapperUtils.parseWrappers(new BufferedReader(new FileReader(file)), wrapperMap);
    }

    private static void readWrappersFromProperty(String envVar, Map wrapperMap) throws IOException {
        String propertyValue = System.getenv(envVar);
        if (propertyValue != null) {
            WrapperUtils.parseWrappers(new BufferedReader(new StringReader(propertyValue)), wrapperMap);
        }
    }

    public static Map mergeWrapperMap(ClientServices client) throws CommandException {
        String wrapperSource = null;
        HashMap wrappersMap = new HashMap(client.getWrappersMap());
        try {
            File home = new File(System.getProperty("user.home"));
            File wrappers = new File(home, "./cvswrappers");
            wrapperSource = CommandException.getLocalMessage("WrapperUtils.clientDotWrapper.text");
            if (wrappers.exists()) {
                WrapperUtils.readWrappersFromFile(wrappers, wrappersMap);
            }
            wrapperSource = CommandException.getLocalMessage("WrapperUtils.environmentWrapper.text");
            WrapperUtils.readWrappersFromProperty("CVSWRAPPERS", wrappersMap);
        }
        catch (FileNotFoundException fnex) {
        }
        catch (Exception ioex) {
            Object[] parms = new Object[]{wrapperSource};
            String localizedMessage = CommandException.getLocalMessage("WrapperUtils.wrapperError.text", parms);
            throw new CommandException(ioex, localizedMessage);
        }
        return wrappersMap;
    }
}

