/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.output2;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.core.output2.Controller;
import org.netbeans.core.output2.IntList;
import org.netbeans.core.output2.IntMap;
import org.netbeans.core.output2.Lines;
import org.netbeans.core.output2.SparseIntList;
import org.netbeans.core.output2.Storage;
import org.openide.util.Exceptions;
import org.openide.util.Mutex;
import org.openide.windows.OutputListener;

abstract class AbstractLines
implements Lines,
Runnable {
    IntList lineStartList;
    IntMap linesToListeners;
    private int longestLine = 0;
    private static Boolean unitTestUseCache;
    private int knownCharCount = -1;
    private SparseIntList knownLogicalLineCounts = null;
    private int lastCharCountForWrapCalculation = -1;
    private int lastWrappedLineCount = -1;
    private int lastCharCountForWrapAboveCalculation = -1;
    private int lastWrappedAboveLineCount = -1;
    private int lastWrappedAboveLine = -1;
    private IntList errLines = null;
    private int lastErrLineMarked = -1;
    private ChangeListener listener = null;
    private boolean dirty;
    private IntList importantLines = new IntList(10);
    private String lastSearchString = null;
    private Matcher matcher = null;
    static final /* synthetic */ boolean $assertionsDisabled;

    AbstractLines() {
        if (Controller.LOG) {
            Controller.log("Creating a new AbstractLines");
        }
        this.init();
    }

    protected abstract Storage getStorage();

    protected abstract boolean isDisposed();

    protected abstract boolean isTrouble();

    protected abstract void handleException(Exception var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public char[] getText(int start, int end, char[] chars) {
        if (this.isDisposed() || this.isTrouble()) {
            if (Controller.LOG) {
                Controller.log(this + "  !!!!!REQUEST FOR SUBRANGE " + start + "-" + end + " AFTER OUTWRITER HAS BEEN DISPOSED!!");
            }
            char[] msg = "THIS OUTPUT HAS BEEN DISPOSED! ".toCharArray();
            if (chars == null) {
                chars = new char[end - start];
            }
            int pos = 0;
            for (int i = 0; i < chars.length; ++i) {
                if (pos == msg.length - 1) {
                    pos = 0;
                }
                chars[i] = msg[pos];
                ++pos;
            }
            return chars;
        }
        if (end < start) {
            throw new IllegalArgumentException("Illogical text range from " + start + " to " + end);
        }
        Object object = this.readLock();
        synchronized (object) {
            int fileStart = AbstractLines.toByteIndex(start);
            int byteCount = AbstractLines.toByteIndex(end - start);
            try {
                CharBuffer chb = this.getStorage().getReadBuffer(fileStart, byteCount).asCharBuffer();
                int len = Math.min(end - start, chb.remaining());
                if (chars.length < len) {
                    chars = new char[len];
                }
                chb.get(chars, 0, len);
                return chars;
            }
            catch (Exception e) {
                this.handleException(e);
                return new char[0];
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getText(int start, int end) {
        if (this.isDisposed() || this.isTrouble()) {
            return new String(new char[end - start]);
        }
        if (end < start) {
            throw new IllegalArgumentException("Illogical text range from " + start + " to " + end);
        }
        Object object = this.readLock();
        synchronized (object) {
            int fileStart = AbstractLines.toByteIndex(start);
            int byteCount = AbstractLines.toByteIndex(end - start);
            int available = this.getStorage().size();
            if (available < fileStart + byteCount) {
                throw new ArrayIndexOutOfBoundsException("Bytes from " + fileStart + " to " + (fileStart + byteCount) + " requested, " + "but storage is only " + available + " bytes long");
            }
            try {
                return this.getStorage().getReadBuffer(fileStart, byteCount).asCharBuffer().toString();
            }
            catch (Exception e) {
                this.handleException(e);
                return new String(new char[end - start]);
            }
        }
    }

    void markErr() {
        int linecount;
        if (this.isTrouble() || this.getStorage().isClosed()) {
            return;
        }
        if (this.errLines == null) {
            this.errLines = new IntList(20);
        }
        if ((linecount = this.getLineCount()) != this.lastErrLineMarked) {
            this.errLines.add(linecount == 0 ? 0 : linecount - 1);
            this.lastErrLineMarked = linecount;
        }
    }

    public boolean isErr(int line) {
        return this.errLines != null ? this.errLines.contains(line) : false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addChangeListener(ChangeListener cl) {
        this.listener = cl;
        AbstractLines abstractLines = this;
        synchronized (abstractLines) {
            if (this.getLineCount() > 0) {
                this.fire();
            }
        }
    }

    public void removeChangeListener(ChangeListener cl) {
        if (this.listener == cl) {
            this.listener = null;
        }
    }

    public void fire() {
        if (this.isTrouble()) {
            return;
        }
        if (Controller.LOG) {
            Controller.log(this + ": Writer firing " + this.getStorage().size() + " bytes written");
        }
        if (this.listener != null) {
            Mutex.EVENT.readAccess((Runnable)this);
        }
    }

    public void run() {
        if (this.listener != null) {
            this.listener.stateChanged(new ChangeEvent(this));
        }
    }

    public boolean hasHyperlinks() {
        return this.firstListenerLine() != -1;
    }

    public boolean isHyperlink(int line) {
        return this.getListenerForLine(line) != null;
    }

    private void init() {
        this.knownLogicalLineCounts = null;
        this.lineStartList = new IntList(100);
        this.linesToListeners = new IntMap();
        this.setLastWrappedLineCount(-1);
        this.longestLine = 0;
        this.errLines = null;
        this.matcher = null;
        this.listener = null;
        this.dirty = false;
    }

    public boolean checkDirty(boolean clear) {
        if (this.isTrouble()) {
            return false;
        }
        boolean wasDirty = this.dirty;
        if (clear) {
            this.dirty = false;
        }
        return wasDirty;
    }

    public int[] allListenerLines() {
        return this.linesToListeners.getKeys();
    }

    void clear() {
        this.init();
    }

    public int getCharCount() {
        if (this.isDisposed() || this.isTrouble()) {
            return 0;
        }
        Storage storage = this.getStorage();
        return storage == null ? 0 : AbstractLines.toCharIndex(this.getStorage().size());
    }

    public String getLine(int idx) throws IOException {
        if (this.isDisposed() || this.isTrouble()) {
            return "";
        }
        int lineStart = this.lineStartList.get(idx);
        int lineEnd = idx != this.lineStartList.size() - 1 ? this.lineStartList.get(idx + 1) : this.getStorage().size();
        CharBuffer cb = this.getStorage().getReadBuffer(lineStart, lineEnd - lineStart).asCharBuffer();
        char[] chars = new char[cb.limit()];
        cb.get(chars);
        return new String(chars);
    }

    private int getLineLength(int idx) {
        int lineStart = this.lineStartList.get(idx);
        int lineEnd = idx != this.lineStartList.size() - 1 ? this.lineStartList.get(idx + 1) : this.getStorage().size();
        return lineEnd - lineStart;
    }

    public boolean isLineStart(int chpos) {
        int bpos = AbstractLines.toByteIndex(chpos);
        return this.lineStartList.contains(bpos);
    }

    public int length(int idx) {
        if (this.isDisposed() || this.isTrouble()) {
            return 0;
        }
        if (this.lineStartList.size() == 0) {
            return 0;
        }
        int lineStart = this.lineStartList.get(idx);
        int lineEnd = idx != this.lineStartList.size() - 1 ? this.lineStartList.get(idx + 1) : this.getStorage().size();
        return AbstractLines.toCharIndex(lineEnd - lineStart);
    }

    public int getLineStart(int line) {
        if (this.isDisposed() || this.isTrouble()) {
            return 0;
        }
        if (this.lineStartList.size() == 0) {
            return 0;
        }
        return AbstractLines.toCharIndex(this.lineStartList.get(line));
    }

    public int getLineAt(int position) {
        if (this.isDisposed() || this.isTrouble()) {
            return -1;
        }
        int bytePos = AbstractLines.toByteIndex(position);
        int i = this.lineStartList.indexOf(bytePos);
        if (i != -1) {
            return i;
        }
        return this.lineStartList.findNearest(bytePos);
    }

    public int getLineCount() {
        if (this.isDisposed() || this.isTrouble()) {
            return 0;
        }
        return this.lineStartList.size();
    }

    public OutputListener getListenerForLine(int line) {
        return (OutputListener)this.linesToListeners.get(line);
    }

    public int firstListenerLine() {
        if (this.isDisposed() || this.isTrouble()) {
            return -1;
        }
        return this.linesToListeners.isEmpty() ? -1 : this.linesToListeners.first();
    }

    public int nearestListenerLine(int line, boolean backward) {
        if (this.isDisposed() || this.isTrouble()) {
            return -1;
        }
        return this.linesToListeners.nearest(line, backward);
    }

    public int getLongestLineLength() {
        return AbstractLines.toCharIndex(this.longestLine);
    }

    public void toLogicalLineIndex(int[] physIdx, int charsPerLine) {
        int physicalLine = physIdx[0];
        physIdx[1] = 0;
        if (physicalLine == 0) {
            physIdx[1] = 0;
            physIdx[2] = this.length(physicalLine) / charsPerLine;
        }
        if (charsPerLine >= this.getLongestLineLength() || this.getLineCount() <= 1) {
            physIdx[1] = 0;
            physIdx[2] = 1;
            return;
        }
        int logicalLine = this.findFirstLineWithoutMoreLinesAboveItThan(physicalLine, charsPerLine);
        int linesAbove = this.getLogicalLineCountAbove(logicalLine, charsPerLine);
        int len = this.length(logicalLine);
        int wrapCount = len > charsPerLine ? len / charsPerLine + 1 : 1;
        physIdx[0] = logicalLine;
        int lcount = linesAbove + wrapCount;
        physIdx[1] = wrapCount - (lcount - physicalLine);
        physIdx[2] = wrapCount;
    }

    private int findFirstLineWithoutMoreLinesAboveItThan(int target, int charsPerLine) {
        int start = 0;
        int end = this.getLineCount();
        int midpoint = start + (end - start >> 1);
        int linesAbove = this.getLogicalLineCountAbove(midpoint, charsPerLine);
        int result = this.divideAndConquer(target, start, midpoint, end, charsPerLine, linesAbove);
        return Math.min(end, result) - 1;
    }

    private int divideAndConquer(int target, int start, int midpoint, int end, int charsPerLine, int midValue) {
        if (midValue == target) {
            return midpoint + 1;
        }
        if (end - start <= 1 || midpoint == start || midpoint == end) {
            return end;
        }
        if (midValue > target) {
            int upperMidPoint = start + (midpoint - start >> 1);
            if ((midpoint - start) % 2 != 0) {
                ++upperMidPoint;
            }
            int upperMidValue = this.getLogicalLineCountAbove(upperMidPoint, charsPerLine);
            return this.divideAndConquer(target, start, upperMidPoint, midpoint, charsPerLine, upperMidValue);
        }
        int lowerMidPoint = (end - start >> 2) + midpoint;
        if ((end - midpoint) % 2 != 0) {
            ++lowerMidPoint;
        }
        int lowerMidValue = this.getLogicalLineCountAbove(lowerMidPoint, charsPerLine);
        return this.divideAndConquer(target, midpoint, lowerMidPoint, end, charsPerLine, lowerMidValue);
    }

    public int getLogicalLineCountAbove(int line, int charCount) {
        if (line == 0) {
            return 0;
        }
        if (AbstractLines.toByteIndex(charCount) > this.longestLine) {
            return line;
        }
        if (unitTestUseCache != null) {
            if (Boolean.TRUE.equals(unitTestUseCache)) {
                return this.dynLogicalLineCountAbove(line, charCount);
            }
            return this.cachedLogicalLineCountAbove(line, charCount);
        }
        if (this.getStorage().size() < 100000) {
            return this.dynLogicalLineCountAbove(line, charCount);
        }
        return this.cachedLogicalLineCountAbove(line, charCount);
    }

    public int getLogicalLineCountIfWrappedAt(int charCount) {
        if (AbstractLines.toByteIndex(charCount) > this.longestLine) {
            return this.getLineCount();
        }
        if (unitTestUseCache != null) {
            if (Boolean.TRUE.equals(unitTestUseCache)) {
                return this.dynLogicalLineCountIfWrappedAt(charCount);
            }
            return this.cachedLogicalLineCountIfWrappedAt(charCount);
        }
        if (this.getStorage().size() < 100000) {
            return this.dynLogicalLineCountIfWrappedAt(charCount);
        }
        return this.cachedLogicalLineCountIfWrappedAt(charCount);
    }

    public void addListener(int line, OutputListener l, boolean important) {
        if (l == null) {
            Logger.getLogger(AbstractLines.class.getName()).log(Level.WARNING, "Issue #56826 - Adding a null OutputListener for line: " + line, new NullPointerException());
        } else {
            this.linesToListeners.put(line, l);
            if (important) {
                this.importantLines.add(line);
            }
        }
    }

    public int firstImportantListenerLine() {
        return this.importantLines.size() == 0 ? -1 : this.importantLines.get(0);
    }

    public boolean isImportantHyperlink(int line) {
        return this.importantLines.contains(line);
    }

    static void unitTestUseCache(Boolean val) {
        unitTestUseCache = val;
    }

    private int cachedLogicalLineCountAbove(int line, int charCount) {
        if (charCount != this.knownCharCount || this.knownLogicalLineCounts == null) {
            this.knownCharCount = charCount;
            this.calcCharCounts(charCount);
        }
        return this.knownLogicalLineCounts.get(line);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int cachedLogicalLineCountIfWrappedAt(int charCount) {
        int lineCount = this.getLineCount();
        if (charCount == 0 || lineCount == 0) {
            return 0;
        }
        Object object = this.readLock();
        synchronized (object) {
            if (charCount != this.knownCharCount || this.knownLogicalLineCounts == null) {
                this.knownCharCount = charCount;
                this.calcCharCounts(charCount);
            }
            int result = this.knownLogicalLineCounts.get(lineCount - 1);
            int len = this.length(lineCount - 1);
            return result += len / charCount + 1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void calcCharCounts(int width) {
        Object object = this.readLock();
        synchronized (object) {
            int lineCount = this.getLineCount();
            this.knownLogicalLineCounts = new SparseIntList(30);
            int val = 0;
            for (int i = 1; i < lineCount; ++i) {
                int len = this.length(i);
                if (len > width) {
                    this.knownLogicalLineCounts.add(val += len / width + 1, i);
                    continue;
                }
                ++val;
            }
            this.knownCharCount = width;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int dynLogicalLineCountIfWrappedAt(int charCount) {
        Object object = this.readLock();
        synchronized (object) {
            int bcount = AbstractLines.toByteIndex(charCount);
            if (this.longestLine <= bcount) {
                return this.lineStartList.size();
            }
            if (charCount == this.lastCharCountForWrapCalculation && this.lastWrappedLineCount != -1) {
                return this.lastWrappedLineCount;
            }
            if (this.lineStartList.size() == 0) {
                return 0;
            }
            int nOfLines = this.lineStartList.size();
            int lineCount = 0;
            for (int i = 0; i < nOfLines; ++i) {
                int currLength = this.getLineLength(i);
                lineCount += currLength > bcount ? currLength / bcount + 1 : 1;
            }
            this.setLastCharCountForWrapCalculation(charCount);
            this.lastWrappedLineCount = lineCount;
            return lineCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int dynLogicalLineCountAbove(int line, int charCount) {
        int lineCount = this.getLineCount();
        if (line == 0 || lineCount == 0) {
            return 0;
        }
        if (charCount == this.lastCharCountForWrapAboveCalculation && this.lastWrappedAboveLineCount != -1 && line == this.lastWrappedAboveLine) {
            return this.lastWrappedAboveLineCount;
        }
        Object object = this.readLock();
        synchronized (object) {
            this.lastWrappedAboveLineCount = 0;
            for (int i = 0; i < line; ++i) {
                int len = this.length(i);
                if (len > charCount) {
                    this.lastWrappedAboveLineCount += len / charCount + 1;
                    continue;
                }
                ++this.lastWrappedAboveLineCount;
            }
            this.lastWrappedAboveLine = line;
            this.setLastCharCountForWrapAboveCalculation(charCount);
            return this.lastWrappedAboveLineCount;
        }
    }

    void markDirty() {
        this.dirty = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void lineStarted(int start) {
        if (Controller.VERBOSE) {
            Controller.log("AbstractLines.lineStarted " + start);
        }
        int lineCount = 0;
        Object object = this.readLock();
        synchronized (object) {
            this.setLastWrappedLineCount(-1);
            this.setLastCharCountForWrapAboveCalculation(-1);
            this.lineStartList.add(start);
            this.matcher = null;
            lineCount = this.lineStartList.size();
        }
        if (lineCount == 20 || lineCount == 10 || lineCount == 1) {
            if (Controller.LOG) {
                Controller.log("Firing initial write event");
            }
            this.fire();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void lineFinished(int lineLength) {
        Object object = this.readLock();
        synchronized (object) {
            this.setLastWrappedLineCount(-1);
            this.setLastCharCountForWrapAboveCalculation(-1);
            this.longestLine = Math.max(this.longestLine, lineLength);
            this.matcher = null;
            int lineCount = this.lineStartList.size();
            int lastline = lineCount - 1;
            this.checkLogicalLineCount(lastline);
        }
    }

    private void checkLogicalLineCount(int lastline) {
        int len;
        if (this.knownLogicalLineCounts != null && (len = this.length(lastline)) > this.knownCharCount) {
            int aboveLineCount = this.knownLogicalLineCounts.lastIndex() != -1 ? lastline - (this.knownLogicalLineCounts.lastIndex() + 1) + this.knownLogicalLineCounts.lastAdded() : Math.max(0, lastline - 1);
            this.knownLogicalLineCounts.add(aboveLineCount += len / this.knownCharCount + 1, lastline);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void lineWritten(int start, int lineLength) {
        if (Controller.VERBOSE) {
            Controller.log("AbstractLines.lineWritten " + start + " length:" + lineLength);
        }
        int lineCount = 0;
        Object object = this.readLock();
        synchronized (object) {
            this.setLastWrappedLineCount(-1);
            this.setLastCharCountForWrapAboveCalculation(-1);
            this.longestLine = Math.max(this.longestLine, lineLength);
            this.lineStartList.add(start);
            this.matcher = null;
            lineCount = this.lineStartList.size();
            int lastline = lineCount - 1;
            this.checkLogicalLineCount(lastline);
        }
        if (lineCount == 20 || lineCount == 10 || lineCount == 1) {
            if (Controller.LOG) {
                Controller.log("Firing initial write event");
            }
            this.fire();
        }
    }

    static int toByteIndex(int charIndex) {
        return charIndex << 1;
    }

    static int toCharIndex(int byteIndex) {
        if (!$assertionsDisabled && byteIndex % 2 != 0) {
            throw new AssertionError((Object)("bad index: " + byteIndex));
        }
        return byteIndex >> 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveAs(String path) throws IOException {
        if (this.getStorage() == null) {
            throw new IOException("Data has already been disposed");
        }
        File f = new File(path);
        CharBuffer cb = this.getStorage().getReadBuffer(0, this.getStorage().size()).asCharBuffer();
        FileOutputStream fos = new FileOutputStream(f);
        try {
            String encoding = System.getProperty("file.encoding");
            if (encoding == null) {
                encoding = "UTF-8";
            }
            Charset charset = Charset.forName(encoding);
            CharsetEncoder encoder = charset.newEncoder();
            ByteBuffer bb = encoder.encode(cb);
            FileChannel ch = fos.getChannel();
            ch.write(bb);
            ch.close();
        }
        finally {
            fos.close();
        }
    }

    public Matcher getForwardMatcher() {
        return this.matcher;
    }

    public Matcher getReverseMatcher() {
        try {
            Storage storage = this.getStorage();
            if (storage == null) {
                return null;
            }
            if (this.matcher != null && this.lastSearchString != null && this.lastSearchString.length() > 0 && storage.size() > 0) {
                StringBuffer sb = new StringBuffer(this.lastSearchString);
                sb.reverse();
                CharBuffer buf = storage.getReadBuffer(0, storage.size()).asCharBuffer();
                StringBuffer data = new StringBuffer(buf.toString());
                data.reverse();
                Pattern pat = AbstractLines.escapePattern(sb.toString());
                return pat.matcher(data);
            }
        }
        catch (Exception e) {
            Exceptions.printStackTrace((Throwable)e);
        }
        return null;
    }

    public Matcher find(String s) {
        Storage storage;
        if (Controller.LOG) {
            Controller.log(this + ": Executing find for string " + s + " on ");
        }
        if ((storage = this.getStorage()) == null) {
            return null;
        }
        if (this.matcher != null && s.equals(this.lastSearchString)) {
            return this.matcher;
        }
        try {
            int size = storage.size();
            if (size > 0) {
                CharBuffer buf;
                Pattern pat = AbstractLines.escapePattern(s);
                Matcher m = pat.matcher(buf = storage.getReadBuffer(0, size).asCharBuffer());
                if (!m.find(0)) {
                    return null;
                }
                this.matcher = m;
                this.matcher.reset();
                this.lastSearchString = s;
                return this.matcher;
            }
        }
        catch (IOException ioe) {
            Exceptions.printStackTrace((Throwable)ioe);
        }
        return null;
    }

    static Pattern escapePattern(String s) {
        String replacement = s.replaceAll("([\\(\\)\\[\\]\\^\\*\\.\\$\\{\\}\\?\\+\\\\])", "\\\\$1");
        return Pattern.compile(replacement, 2);
    }

    private void setLastCharCountForWrapCalculation(int lastCharCountForWrapCalculation) {
        this.lastCharCountForWrapCalculation = lastCharCountForWrapCalculation;
    }

    private void setLastWrappedLineCount(int lastWrappedLineCount) {
        this.lastWrappedLineCount = lastWrappedLineCount;
    }

    private void setLastCharCountForWrapAboveCalculation(int lastCharCountForWrapAboveCalculation) {
        this.lastCharCountForWrapAboveCalculation = lastCharCountForWrapAboveCalculation;
    }

    public String toString() {
        return this.lineStartList.toString();
    }

    static {
        $assertionsDisabled = !AbstractLines.class.desiredAssertionStatus();
        unitTestUseCache = null;
    }
}

