/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.output2;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.netbeans.core.output2.FileMapStorage;
import org.netbeans.core.output2.OutWriter;
import org.netbeans.core.output2.Storage;

class HeapStorage
implements Storage {
    private boolean closed = true;
    private byte[] bytes = new byte[2048];
    private int size = 0;

    HeapStorage() {
    }

    public Storage toFileMapStorage() throws IOException {
        FileMapStorage result = new FileMapStorage();
        result.write(this.getReadBuffer(0, this.size), false);
        return result;
    }

    public ByteBuffer getReadBuffer(int start, int length) throws IOException {
        return ByteBuffer.wrap(this.bytes, start, Math.min(length, this.bytes.length - start));
    }

    public ByteBuffer getWriteBuffer(int length) throws IOException {
        return ByteBuffer.allocate(length);
    }

    public synchronized int write(ByteBuffer buf, boolean addNewLine) throws IOException {
        this.closed = false;
        int oldSize = this.size;
        this.size += buf.limit() + (addNewLine ? OutWriter.lineSepBytes.length : 0);
        if (this.size > this.bytes.length) {
            byte[] oldBytes = this.bytes;
            this.bytes = new byte[Math.max(oldSize * 2, buf.limit() * 2 + oldSize)];
            System.arraycopy(oldBytes, 0, this.bytes, 0, oldSize);
        }
        buf.flip();
        buf.get(this.bytes, oldSize, buf.limit());
        if (addNewLine) {
            System.arraycopy(OutWriter.lineSepBytes, 0, this.bytes, this.size - OutWriter.lineSepBytes.length, OutWriter.lineSepBytes.length);
        }
        return oldSize;
    }

    public synchronized void dispose() {
        this.bytes = new byte[0];
        this.size = 0;
    }

    public synchronized int size() {
        return this.size;
    }

    public void flush() throws IOException {
    }

    public void close() throws IOException {
        this.closed = true;
    }

    public boolean isClosed() {
        return this.closed;
    }
}

