/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.output2;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import javax.swing.InputMap;
import javax.swing.JEditorPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;
import javax.swing.text.Segment;
import org.netbeans.core.output2.OutputDocument;
import org.netbeans.core.output2.OutputEditorKit;
import org.netbeans.core.output2.OutputTab;
import org.netbeans.core.output2.WrappedTextView;
import org.netbeans.core.output2.ui.AbstractOutputPane;
import org.openide.util.NbPreferences;

class OutputPane
extends AbstractOutputPane
implements ComponentListener {
    private Segment seg = new Segment();
    private static final boolean GTK;
    private int prevW = -1;
    static final /* synthetic */ boolean $assertionsDisabled;

    OutputPane() {
    }

    protected void documentChanged() {
        super.documentChanged();
        this.findOutputTab().documentChanged();
    }

    protected void caretEnteredLine(int line) {
        this.findOutputTab().caretEnteredLine(line);
    }

    protected void lineClicked(int line, Point p) {
        if (!(this.getDocument() instanceof OutputDocument) || !this.inLeadingOrTrailingWhitespace(line, p)) {
            this.findOutputTab().lineClicked(line);
        }
    }

    private boolean linePressed(int line, Point p) {
        boolean result = !(this.getDocument() instanceof OutputDocument) || !this.inLeadingOrTrailingWhitespace(line, p) ? this.findOutputTab().linePressed(line, p) : false;
        return result;
    }

    protected void postPopupMenu(Point p, Component src) {
        this.findOutputTab().postPopupMenu(p, src);
    }

    public void setMouseLine(int line, Point p) {
        Document doc = this.getDocument();
        if (doc instanceof OutputDocument) {
            boolean link;
            boolean bl = link = line != -1 && ((OutputDocument)doc).getLines().isHyperlink(line);
            if (link && p != null && this.inLeadingOrTrailingWhitespace(line, p)) {
                link = false;
                line = -1;
            }
            this.textView.setCursor(link ? Cursor.getPredefinedCursor(12) : Cursor.getPredefinedCursor(2));
        }
        super.setMouseLine(line, p);
    }

    private boolean inLeadingOrTrailingWhitespace(int line, Point p) {
        if (line == -1) {
            return true;
        }
        if (!$assertionsDisabled && !(this.getDocument() instanceof OutputDocument)) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && p == null) {
            throw new AssertionError();
        }
        OutputDocument doc = (OutputDocument)this.getDocument();
        int lineStart = doc.getLineStart(line);
        int lineEnd = doc.getLineEnd(line);
        try {
            doc.getText(lineStart, lineEnd - lineStart, this.seg);
            char curr = this.seg.first();
            while (Character.isWhitespace(curr) && curr != '\uffff') {
                ++lineStart;
                curr = this.seg.next();
            }
            curr = this.seg.last();
            while (Character.isWhitespace(curr) && curr != '\uffff') {
                --lineEnd;
                curr = this.seg.previous();
            }
            if (lineEnd <= lineStart) {
                line = -1;
            } else {
                boolean cursorIsNotOverLeadingOrTrailingWhitespace;
                Rectangle startRect = this.textView.modelToView(lineStart);
                Rectangle endRect = this.textView.modelToView(lineEnd);
                if (p.y >= startRect.y && p.y <= endRect.y && this.isWrapped()) {
                    endRect.x = 0;
                    endRect.width = this.getWidth();
                }
                boolean bl = cursorIsNotOverLeadingOrTrailingWhitespace = p.x >= startRect.x && p.y >= startRect.y && p.x <= endRect.x + endRect.width && p.y <= endRect.y + endRect.height;
                if (!cursorIsNotOverLeadingOrTrailingWhitespace) {
                    line = -1;
                }
            }
        }
        catch (BadLocationException e) {
            // empty catch block
        }
        return line == -1;
    }

    public void mouseMoved(MouseEvent evt) {
        Document doc = this.getDocument();
        if (doc instanceof OutputDocument && ((OutputDocument)doc).getLines().hasHyperlinks()) {
            super.mouseMoved(evt);
        }
    }

    public void mousePressed(MouseEvent e) {
        int line;
        int pos;
        super.mousePressed(e);
        if (e.getSource() == this.textView && SwingUtilities.isLeftMouseButton(e) && (pos = this.textView.viewToModel(e.getPoint())) != -1 && (line = this.textView.getDocument().getDefaultRootElement().getElementIndex(pos)) >= 0 && this.linePressed(line, e.getPoint())) {
            e.consume();
            return;
        }
        this.findOutputTab().setToFocus((Component)e.getSource());
        this.findOutputTab().requestActive();
    }

    private OutputTab findOutputTab() {
        return (OutputTab)SwingUtilities.getAncestorOfClass(OutputTab.class, this);
    }

    protected void setDocument(Document doc) {
        if (doc == null) {
            Document d = this.getDocument();
            if (d != null) {
                d.removeDocumentListener(this);
            }
            this.textView.setDocument(new PlainDocument());
            return;
        }
        this.textView.setEditorKit(new OutputEditorKit(this.isWrapped(), this.textView));
        super.setDocument(doc);
        this.updateKeyBindings();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setWrapped(boolean val) {
        if (val != this.isWrapped() || !(this.getEditorKit() instanceof OutputEditorKit)) {
            NbPreferences.forModule((Class)OutputPane.class).putBoolean("wrap", val);
            final int pos = this.textView.getCaret().getDot();
            Cursor cursor = this.textView.getCursor();
            try {
                this.textView.setCursor(Cursor.getPredefinedCursor(3));
                this.setEditorKit(new OutputEditorKit(val, this.textView));
            }
            finally {
                this.textView.setCursor(cursor);
            }
            if (val) {
                this.getViewport().addChangeListener(this);
            } else {
                this.getViewport().removeChangeListener(this);
            }
            SwingUtilities.invokeLater(new Runnable(){
                private boolean first = true;

                public void run() {
                    if (this.first) {
                        this.first = false;
                        SwingUtilities.invokeLater(this);
                        return;
                    }
                    OutputPane.this.textView.getCaret().setDot(pos);
                }
            });
            if (this.getDocument() instanceof OutputDocument && ((OutputDocument)this.getDocument()).getLines().isGrowing()) {
                this.lockScroll();
            }
            if (!val) {
                this.getHorizontalScrollBar().setValue(this.getHorizontalScrollBar().getModel().getMinimum());
            }
            this.validate();
        }
    }

    public boolean isWrapped() {
        if (this.getEditorKit() instanceof OutputEditorKit) {
            return this.getEditorKit() instanceof OutputEditorKit && ((OutputEditorKit)this.getEditorKit()).isWrapped();
        }
        return NbPreferences.forModule((Class)OutputPane.class).getBoolean("wrap", false);
    }

    protected JEditorPane createTextView() {
        JEditorPane result = GTK ? new GEP() : new JEditorPane();
        result.addComponentListener(this);
        result.setDisabledTextColor(result.getBackground());
        InputMap map = result.getInputMap();
        MyInputMap myMap = new MyInputMap();
        myMap.setParent(map);
        result.setInputMap(0, myMap);
        return result;
    }

    public void componentResized(ComponentEvent e) {
        WrappedTextView view;
        int w = this.textView.getWidth();
        if (this.prevW != w && this.isWrapped() && (view = ((OutputEditorKit)this.getEditorKit()).view()) != null) {
            view.setChanged();
            this.textView.repaint();
        }
        this.prevW = w;
    }

    public void componentMoved(ComponentEvent e) {
    }

    public void componentShown(ComponentEvent e) {
    }

    public void componentHidden(ComponentEvent e) {
    }

    static {
        $assertionsDisabled = !OutputPane.class.desiredAssertionStatus();
        GTK = "GTK".equals(UIManager.getLookAndFeel().getID());
    }

    private static final class GEP
    extends JEditorPane {
        private GEP() {
        }

        public Color getBackground() {
            return UIManager.getColor("text");
        }
    }

    protected class MyInputMap
    extends InputMap {
        public Object get(KeyStroke keyStroke) {
            KeyStroke stroke = KeyStroke.getKeyStroke("control shift O");
            if (keyStroke.equals(stroke)) {
                return null;
            }
            stroke = KeyStroke.getKeyStroke(8, 2);
            if (keyStroke.equals(stroke)) {
                return null;
            }
            Object retValue = super.get(keyStroke);
            return retValue;
        }
    }
}

