/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.output2;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.ObjectStreamException;
import java.util.HashSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.UIManager;
import org.netbeans.core.output2.Controller;
import org.netbeans.core.output2.IOEvent;
import org.netbeans.core.output2.NbIO;
import org.netbeans.core.output2.OutputTab;
import org.netbeans.core.output2.ui.AbstractOutputTab;
import org.netbeans.core.output2.ui.AbstractOutputWindow;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

public class OutputWindow
extends AbstractOutputWindow {
    private Controller controller;
    static OutputWindow DEFAULT = null;
    public static final String ICON_RESOURCE = "org/netbeans/core/resources/frames/output.png";
    private MouseListener activateListener = new MouseAdapter(){

        public void mouseClicked(MouseEvent e) {
            OutputWindow.this.requestActive();
        }
    };
    private boolean activated = false;
    private HashSet hiddenTabs = null;

    public OutputWindow() {
        this(new Controller());
        this.enableEvents(4L);
        this.putClientProperty("dontActivate", Boolean.TRUE);
        this.getActionMap().put("PreviousViewAction", this.controller.prevTabAction);
        this.getActionMap().put("NextViewAction", this.controller.nextTabAction);
    }

    public void addNotify() {
        super.addNotify();
        this.pane.addMouseListener(this.activateListener);
    }

    public void removeNotify() {
        super.removeNotify();
        this.pane.removeMouseListener(this.activateListener);
    }

    protected void closeRequest(AbstractOutputTab tab) {
        this.controller.close(this, (OutputTab)tab, false);
    }

    OutputWindow(Controller controller) {
        if (Controller.LOG) {
            Controller.log("Created an output window");
        }
        this.controller = controller;
        this.setDisplayName(NbBundle.getMessage((Class)OutputWindow.class, (String)"LBL_OUTPUT"));
        this.setName(NbBundle.getMessage((Class)OutputWindow.class, (String)"LBL_OUTPUT"));
        this.setIcon(Utilities.loadImage((String)ICON_RESOURCE));
        this.putClientProperty("SlidingName", this.getDisplayName());
    }

    public static synchronized OutputWindow findDefault() {
        if (DEFAULT == null) {
            TopComponent tc = WindowManager.getDefault().findTopComponent("output");
            if (tc != null) {
                if (!(tc instanceof OutputWindow)) {
                    IllegalStateException exc = new IllegalStateException("Incorrect settings file. Unexpected class returned. Expected:" + OutputWindow.class.getName() + " Returned:" + tc.getClass().getName());
                    Logger.getLogger(OutputWindow.class.getName()).log(Level.WARNING, null, exc);
                    OutputWindow.getDefault();
                }
            } else {
                OutputWindow.getDefault();
            }
        }
        return DEFAULT;
    }

    public static synchronized OutputWindow getDefault() {
        if (DEFAULT == null) {
            DEFAULT = new OutputWindow();
        }
        return DEFAULT;
    }

    public int getPersistenceType() {
        return 0;
    }

    public String preferredID() {
        return "output";
    }

    public Object readResolve() throws ObjectStreamException {
        return OutputWindow.getDefault();
    }

    public String getToolTipText() {
        return this.getDisplayName();
    }

    Controller getController() {
        return this.controller;
    }

    public void requestVisible() {
        if (Controller.LOG) {
            Controller.log("Request visible");
            Controller.logStack();
        }
        super.requestVisible();
    }

    void requestVisibleForNewTab() {
        if (Controller.LOG) {
            Controller.log("Request visible for new tab");
        }
        if (this.isOpened() && this.isShowing()) {
            if (!this.isActivated()) {
                super.requestVisible();
            }
        } else {
            if (Controller.LOG) {
                Controller.log("CALLING OPEN() ON OUTPUT WINDOW!");
            }
            this.open();
            super.requestVisible();
            if (Boolean.TRUE.equals(this.getClientProperty("isSliding"))) {
                this.requestActiveForNewTab();
            }
        }
    }

    public void processFocusEvent(FocusEvent fe) {
        super.processFocusEvent(fe);
        if (Boolean.TRUE.equals(this.getClientProperty("isSliding"))) {
            this.repaint(200L);
        }
    }

    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.hasFocus()) {
            Insets ins = this.getInsets();
            Color col = UIManager.getColor("controlShadow");
            if (col == null) {
                col = Color.GRAY;
            }
            g.setColor(col);
            g.drawRect(ins.left + 2, ins.top + 2, this.getWidth() - (ins.left + ins.right + 4), this.getHeight() - (ins.top + ins.bottom + 4));
        }
    }

    void requestActiveForNewTab() {
        this.requestActive();
    }

    public void requestActive() {
        boolean activated = this.isActivated();
        if (Controller.LOG) {
            Controller.log("Request active");
        }
        super.requestActive();
        if (!activated) {
            this.requestFocus();
        }
    }

    protected void componentActivated() {
        if (Controller.LOG) {
            Controller.log("ComponentActivated");
        }
        super.componentActivated();
        this.activated = true;
        this.controller.notifyActivated(this);
        this.requestFocus();
    }

    protected void componentDeactivated() {
        if (Controller.LOG) {
            Controller.log("ComponentDeactivated");
        }
        super.componentDeactivated();
        this.activated = false;
    }

    protected void removed(AbstractOutputTab view) {
        if (Controller.LOG) {
            Controller.log("Removed tab " + view);
        }
        if (Controller.LOG) {
            Controller.log("Tab has been removed.  Notifying controller.");
        }
        this.controller.notifyRemoved((OutputTab)view);
    }

    protected void selectionChanged(AbstractOutputTab former, AbstractOutputTab current) {
        this.controller.selectionChanged(this, (OutputTab)former, (OutputTab)current);
    }

    public void lineClicked(OutputTab outputComponent, int line) {
        this.controller.lineClicked(this, outputComponent, line);
    }

    public void postPopupMenu(OutputTab outputComponent, Point p, Component src) {
        this.controller.postPopupMenu(this, outputComponent, p, src);
    }

    public void caretEnteredLine(OutputTab outputComponent, int line) {
        this.controller.caretEnteredLine(outputComponent, line);
    }

    public void documentChanged(OutputTab comp) {
        this.controller.documentChanged(this, comp);
    }

    public void putHiddenView(OutputTab comp) {
        if (this.hiddenTabs == null) {
            this.hiddenTabs = new HashSet();
        }
        comp.putClientProperty("outputWindow", this);
        this.hiddenTabs.add(comp);
        if (comp.getParent() != null) {
            comp.getParent().remove(comp);
        }
    }

    public void removeHiddenView(OutputTab comp) {
        this.hiddenTabs.remove(comp);
        comp.putClientProperty("outputWindow", null);
    }

    public void setSelectedTab(AbstractOutputTab op) {
        if (op.getParent() == null && this.hiddenTabs.contains(op)) {
            this.removeHiddenView((OutputTab)op);
            this.add(op);
        }
        super.setSelectedTab(op);
    }

    protected void updateSingletonName(String name) {
        String winName = NbBundle.getMessage((Class)OutputWindow.class, (String)"LBL_OUTPUT");
        if (name != null) {
            String newName = NbBundle.getMessage((Class)OutputWindow.class, (String)"FMT_OUTPUT", (Object[])new Object[]{winName, name});
            if (newName.indexOf("<html>") != -1) {
                newName = Utilities.replaceString((String)newName, (String)"<html>", (String)"");
                this.setHtmlDisplayName("<html>" + newName);
            } else {
                this.setDisplayName(newName);
                this.setHtmlDisplayName(null);
            }
        } else {
            this.setDisplayName(winName);
            this.setHtmlDisplayName(null);
        }
    }

    public OutputTab[] getHiddenTabs() {
        if (this.hiddenTabs != null && !this.hiddenTabs.isEmpty()) {
            OutputTab[] result = new OutputTab[this.hiddenTabs.size()];
            return this.hiddenTabs.toArray(result);
        }
        return new OutputTab[0];
    }

    public OutputTab getTabForIO(NbIO io) {
        AbstractOutputTab[] views = this.getTabs();
        for (int i = 0; i < views.length; ++i) {
            if (((OutputTab)views[i]).getIO() != io) continue;
            return (OutputTab)views[i];
        }
        OutputTab[] hidden = this.getHiddenTabs();
        for (int i = 0; i < hidden.length; ++i) {
            if (hidden[i].getIO() != io) continue;
            return hidden[i];
        }
        return null;
    }

    public void eventDispatched(IOEvent ioe) {
        if (Controller.LOG) {
            Controller.log("Event received: " + ioe);
        }
        NbIO io = ioe.getIO();
        int command = ioe.getCommand();
        boolean value = ioe.getValue();
        Object data = ioe.getData();
        OutputTab comp = this.getTabForIO(io);
        if (command == 11 && !ioe.isConsumed()) {
            ioe.consume();
            DEFAULT = null;
            return;
        }
        if (Controller.LOG) {
            Controller.log("Passing command to controller " + ioe);
        }
        this.controller.performCommand(this, comp, io, command, value, data);
        ioe.consume();
    }

    public void hasSelectionChanged(OutputTab tab, boolean val) {
        this.controller.hasSelectionChanged(this, tab, val);
    }

    public boolean isActivated() {
        return this.activated;
    }

    public void hasOutputListenersChanged(OutputTab tab, boolean hasOutputListeners) {
        this.controller.hasOutputListenersChanged(this, tab, hasOutputListeners);
    }

    public void inputEof(OutputTab tab) {
        if (Controller.LOG) {
            Controller.log("Input EOF on " + this);
        }
        this.controller.inputEof(tab);
    }

    public void inputSent(OutputTab c, String txt) {
        if (Controller.LOG) {
            Controller.log("Notifying controller input sent " + txt);
        }
        this.controller.notifyInput(this, c, txt);
    }
}

