/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.output2.ui;

import java.awt.Component;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.KeyStroke;
import javax.swing.text.Document;
import org.netbeans.core.output2.Controller;
import org.netbeans.core.output2.ui.AbstractOutputPane;
import org.netbeans.core.output2.ui.InputPanel;
import org.netbeans.core.output2.ui.WeakAction;

public abstract class AbstractOutputTab
extends JComponent
implements ActionListener,
Accessible {
    private InputPanel input = null;
    private AbstractOutputPane outputPane;
    private Action[] actions = new Action[0];
    private JButton[] buttons = new JButton[0];
    private Component toFocus;

    public AbstractOutputTab() {
        this.outputPane = this.createOutputPane();
        this.add(this.outputPane);
        this.setFocusable(false);
    }

    public void setDocument(Document doc) {
        this.outputPane.setDocument(doc);
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new JComponent.AccessibleJComponent(){

                public AccessibleRole getAccessibleRole() {
                    return AccessibleRole.PANEL;
                }

                public String getAccessibleName() {
                    if (this.accessibleName != null) {
                        return this.accessibleName;
                    }
                    return AbstractOutputTab.this.getName();
                }
            };
        }
        return this.accessibleContext;
    }

    public void setToFocus(Component foc) {
        this.toFocus = foc;
    }

    public void requestFocus() {
        if (this.toFocus != null) {
            this.toFocus.requestFocus();
            this.toFocus = null;
            return;
        }
        if (this.isInputVisible()) {
            this.input.requestFocus();
        } else {
            this.outputPane.requestFocus();
        }
    }

    public boolean requestFocusInWindow() {
        if (this.isInputVisible()) {
            return this.input.requestFocusInWindow();
        }
        return this.getOutputPane().requestFocusInWindow();
    }

    protected abstract AbstractOutputPane createOutputPane();

    protected abstract void inputSent(String var1);

    public final AbstractOutputPane getOutputPane() {
        return this.outputPane;
    }

    public final void setToolbarActions(Action[] a) {
        if (a == null || a.length == 0) {
            this.actions = new Action[0];
            this.buttons = new JButton[0];
            return;
        }
        if (a.length > 5) {
            throw new IllegalArgumentException("No more than 5 actions allowedin the output window toolbar");
        }
        this.actions = new Action[a.length];
        this.buttons = new JButton[a.length];
        for (int i = 0; i < this.buttons.length; ++i) {
            this.actions[i] = a[i];
            this.installKeyboardAction(this.actions[i]);
            this.buttons[i] = new JButton(this.actions[i]);
            this.buttons[i].setBorderPainted(false);
            this.buttons[i].setOpaque(false);
            this.buttons[i].setText(null);
            this.buttons[i].putClientProperty("hideActionText", Boolean.TRUE);
            if (a[i].getValue("SmallIcon") != null) continue;
            throw new IllegalStateException("No icon provided for " + a[i]);
        }
    }

    public Action[] getToolbarActions() {
        return this.actions;
    }

    public void installKeyboardAction(Action a) {
        if (!(a instanceof WeakAction)) {
            a = new WeakAction(a);
        }
        KeyStroke accel = null;
        Object o = a.getValue("AcceleratorKey");
        if (o instanceof KeyStroke) {
            accel = (KeyStroke)o;
        }
        String name = (String)a.getValue("Name");
        if (accel != null) {
            if (Controller.LOG) {
                Controller.log("Installed action " + name + " on " + accel);
            }
            JEditorPane c = this.getOutputPane().textView;
            c.getInputMap().put(accel, name);
            c.getActionMap().put(name, a);
            this.getInputMap(1).put(accel, name);
            this.getActionMap().put(name, a);
        }
    }

    public final boolean isInputVisible() {
        return this.input != null && this.input.getParent() == this && this.input.isVisible();
    }

    public final void setInputVisible(boolean val) {
        if (val == this.isInputVisible()) {
            return;
        }
        if (val) {
            if (this.input == null) {
                this.input = new InputPanel();
                this.input.addActionListener(this);
            }
            if (this.input.getParent() != this) {
                this.add(this.input);
                this.validate();
            }
        }
        this.input.setVisible(val);
        this.validate();
        this.getOutputPane().ensureCaretPosition();
    }

    public void actionPerformed(ActionEvent ae) {
        InputPanel ip = (InputPanel)ae.getSource();
        if ("eof".equals(ae.getActionCommand())) {
            this.inputEof();
        } else {
            this.inputSent(ip.getText());
        }
    }

    protected abstract void inputEof();

    public void doLayout() {
        boolean hasInput = this.isInputVisible();
        Insets ins = this.getInsets();
        int left = ins.left;
        int bottom = hasInput ? this.getHeight() - ins.bottom - this.input.getPreferredSize().height - 3 : this.getHeight() - ins.bottom;
        AbstractOutputPane main = this.outputPane;
        if (main != null) {
            main.setBounds(left, ins.top, this.getWidth() - (left + ins.right), bottom - ins.top);
        }
        if (hasInput) {
            this.input.setBounds(left, bottom, this.getWidth() - (left + ins.right), this.getHeight() - bottom);
        }
    }

    public abstract void hasSelectionChanged(boolean var1);

    void notifyInputFocusGained() {
        this.getOutputPane().lockScroll();
        this.getOutputPane().ensureCaretPosition();
    }

    JButton[] getToolbarButtons() {
        return this.buttons;
    }
}

