/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.autoupdate;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import org.netbeans.updater.UpdateTracking;
import org.openide.LifecycleManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.Repository;
import org.openide.modules.InstalledFileLocator;
import org.openide.modules.ModuleInfo;
import org.openide.util.Lookup;
import org.openide.util.NbPreferences;
import org.openide.util.RequestProcessor;
import org.openide.windows.WindowManager;

class Autoupdater {
    private static final Logger LOG = Logger.getLogger("org.netbeans.modules.autoupdate.Autoupdater");
    private static Preferences proxySettingsNode;

    Autoupdater() {
    }

    static void restart() {
        LifecycleManager.getDefault().exit();
    }

    static void installUpdateChecker(final Runnable updateChecker) {
        if (Boolean.getBoolean("netbeans.full.hack") || Boolean.getBoolean("netbeans.close")) {
            return;
        }
        WindowManager.getDefault().invokeWhenUIReady(new Runnable(){

            public void run() {
                Autoupdater.doInstallUpdateChecker(updateChecker);
            }
        });
    }

    private static void doInstallUpdateChecker(Runnable updateChecker) {
        RequestProcessor.getDefault().post(updateChecker, 5000);
    }

    private static synchronized Preferences getProxyPreferences() {
        if (proxySettingsNode == null) {
            proxySettingsNode = NbPreferences.root().node("/org/netbeans/core");
            assert (proxySettingsNode != null);
        }
        return proxySettingsNode;
    }

    static int getProxyType() {
        return Autoupdater.getProxyPreferences().getInt("proxyType", 1);
    }

    static String getUserProxyHost() {
        return Autoupdater.getProxyPreferences().get("proxyHttpHost", "");
    }

    static String getUserProxyPort() {
        return Autoupdater.getProxyPreferences().get("proxyHttpPort", "");
    }

    static void setProxyConfiguration(int proxyType, String host, String port) {
        Autoupdater.getProxyPreferences().putInt("proxyType", proxyType);
        Autoupdater.getProxyPreferences().put("proxyHttpHost", host);
        Autoupdater.getProxyPreferences().put("proxyHttpPort", port);
    }

    static class Support {
        private static final String FILE_SEPARATOR = System.getProperty("file.separator");
        private static final String UPDATE_DIR = "update";
        private static final String DOWNLOAD_DIR = "update" + FILE_SEPARATOR + "download";
        private static final String PATCH_DIR = "lib" + FILE_SEPARATOR + "patches";
        private static final String KS_FILE = "core" + FILE_SEPARATOR + "ide.ks";
        public static final String LOG_FILE_NAME = "update.log";
        public static final String LATER_FILE_NAME = "install_later.xml";
        private static final String UPDATE_TEMP = "autoupdateTemp";
        private static FileObject tempDir = null;

        private Support() {
        }

        public static ModuleInfo[] getModuleDescriptions() {
            Collection descs = Lookup.getDefault().lookup(new Lookup.Template(ModuleInfo.class)).allInstances();
            return descs.toArray(new ModuleInfo[descs.size()]);
        }

        public static File getDownloadDirectory(File base) {
            File downloadDirectory;
            if (base == null) {
                base = new File(System.getProperty("netbeans.user"));
            }
            if (!(downloadDirectory = new File(base, DOWNLOAD_DIR)).isDirectory()) {
                downloadDirectory.mkdirs();
            }
            return downloadDirectory;
        }

        public static List getPatchDirectories() {
            ArrayList<File> patches = new ArrayList<File>();
            List clusters = UpdateTracking.clusters((boolean)true);
            assert (clusters != null) : "Clusters cannot be empty.";
            for (File dir : clusters) {
                if (!dir.isDirectory()) continue;
                patches.add(new File(dir.getPath() + FILE_SEPARATOR + PATCH_DIR));
            }
            return patches;
        }

        static File getKSFile() {
            File ksFileLocated = InstalledFileLocator.getDefault().locate(KS_FILE, null, true);
            return ksFileLocated;
        }

        static File getInstall_Later(File root) {
            File file = new File(root.getPath() + FILE_SEPARATOR + DOWNLOAD_DIR + FILE_SEPARATOR + LATER_FILE_NAME);
            return file;
        }

        static File getTempCopyFile(FileObject original) {
            File f = null;
            if (tempDir == null) {
                FileSystem fs = Repository.getDefault().getDefaultFileSystem();
                tempDir = fs.getRoot().getFileObject(UPDATE_TEMP);
                try {
                    if (tempDir == null) {
                        tempDir = fs.getRoot().createFolder(UPDATE_TEMP);
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (tempDir != null) {
                try {
                    FileObject fo = tempDir.getFileObject(original.getName(), "nbm");
                    if (fo == null) {
                        fo = FileUtil.copyFile((FileObject)original, (FileObject)tempDir, (String)original.getName());
                    }
                    f = FileUtil.toFile((FileObject)fo);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            return f;
        }

        static void deleteTempDir() {
            if (tempDir == null) {
                FileSystem fs = Repository.getDefault().getDefaultFileSystem();
                tempDir = fs.getRoot().getFileObject(UPDATE_TEMP);
            }
            if (tempDir != null) {
                try {
                    tempDir.delete();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }
}

