/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.autoupdate;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.autoupdate.IdeDescription;
import org.netbeans.modules.autoupdate.L10NUpdate;
import org.netbeans.modules.autoupdate.ModuleUpdate;
import org.netbeans.modules.autoupdate.Updates;
import org.netbeans.modules.autoupdate.Wizard;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.modules.Dependency;
import org.openide.modules.ModuleInfo;
import org.openide.modules.SpecificationVersion;
import org.openide.util.NbBundle;

class DependencyChecker {
    private static final Logger err = Logger.getLogger("org.netbeans.modules.autoupdate");

    DependencyChecker() {
    }

    Collection modulesToAdd(ModuleUpdate toAdd, Enumeration selected, List group, StringBuffer dontAddModuleName) {
        err.log(Level.FINE, "DO modulesToAdd: " + toAdd.getCodeNameBase() + "[L10N? " + (toAdd instanceof L10NUpdate) + "], group: " + group + ", dontAddModuleName: " + dontAddModuleName);
        ArrayList result = new ArrayList();
        this.checkDependencies(toAdd.getRemoteModule(), result, selected, group, dontAddModuleName, toAdd.getLocalModule() != null);
        if (err.isLoggable(Level.FINE)) {
            String res = "";
            for (ModuleUpdate mu : result) {
                res = res + mu.getCodeNameBase() + "[L10N? " + (mu instanceof L10NUpdate) + "], ";
                err.log(Level.FINE, "modulesToAdd: " + toAdd.getCodeNameBase() + ", RETURNS: " + res);
            }
        }
        err.log(Level.FINE, "Do find localization for " + toAdd.getCodeNameBase() + " on locale " + Locale.getDefault());
        DependencyChecker.checkFreeLocalizationDependency(toAdd, Locale.getDefault().toString(), result, selected, group);
        return result;
    }

    Collection modulesToRemove(ModuleUpdate toRemove, ModuleUpdate toReplace) {
        ArrayList result = new ArrayList();
        this.checkReverseDependencies(toRemove.getRemoteModule(), result, toReplace);
        return result;
    }

    private boolean checkDependencies(ModuleInfo md, Collection result, Enumeration selected, List group, StringBuffer dontAddModuleName, boolean isUpgrade) {
        NotifyDescriptor.Confirmation nd;
        List brokenlist;
        Set depsS = md.getDependencies();
        Dependency[] deps = depsS.toArray(new Dependency[depsS.size()]);
        boolean[] satisfied = new boolean[deps.length];
        ModuleInfo[] installedModules = Updates.getInstalledModules();
        ModuleInfo[] installedPatches = Updates.getInstalledPatches();
        for (int j = 0; j < deps.length; ++j) {
            if (deps[j].getType() == 1 || deps[j].getType() == 5) {
                int i;
                boolean ok = false;
                for (i = 0; i < installedModules.length && !(ok = DependencyChecker.checkModuleDependency(deps[j], installedModules[i])); ++i) {
                }
                if (!ok) {
                    for (i = 0; i < installedPatches.length && !(ok = DependencyChecker.checkModuleDependency(deps[j], installedPatches[i])); ++i) {
                    }
                }
                if (!ok && selected != null) {
                    while (selected.hasMoreElements()) {
                        ModuleUpdate mu = (ModuleUpdate)selected.nextElement();
                        if (mu instanceof L10NUpdate || !(ok = DependencyChecker.checkModuleDependency(deps[j], mu.getRemoteModule()))) continue;
                        if (result.contains(mu)) break;
                        err.log(Level.FINE, "  ADDED[SELECTED]: " + mu.getCodeNameBase() + "[L10N? " + (mu instanceof L10NUpdate) + "]: DEP: " + deps[j]);
                        result.add(mu);
                        break;
                    }
                }
                if (!ok && group != null) {
                    for (ModuleUpdate mu : group) {
                        if (mu instanceof L10NUpdate || !(ok = DependencyChecker.checkModuleDependency(deps[j], mu.getRemoteModule()))) continue;
                        if (result.contains(mu)) break;
                        err.log(Level.FINE, "  ADDED[GROUP]: " + mu.getCodeNameBase() + "[L10N? " + (mu instanceof L10NUpdate) + "]: DEP: " + deps[j]);
                        result.add(mu);
                        break;
                    }
                }
                if (!ok) {
                    for (ModuleUpdate mu : Wizard.getAllModules()) {
                        if (mu instanceof L10NUpdate || !(ok = DependencyChecker.checkModuleDependency(deps[j], mu.getRemoteModule()))) continue;
                        if (result.contains(mu)) break;
                        err.log(Level.FINE, "  ADDED[ALL]: " + mu.getCodeNameBase() + "[L10N? " + (mu instanceof L10NUpdate) + "]: DEP: " + deps[j]);
                        result.add(mu);
                        break;
                    }
                }
                if (!ok) {
                    satisfied[j] = false;
                    continue;
                }
                satisfied[j] = true;
                continue;
            }
            if (deps[j].getType() == 4) {
                if (this.checkIdeDependency(deps[j], IdeDescription.getIdeDescription())) {
                    satisfied[j] = true;
                    continue;
                }
                Iterator it = Wizard.getAllModules().iterator();
                boolean ok = false;
                while (it.hasNext()) {
                    ModuleUpdate mu;
                    mu = (ModuleUpdate)it.next();
                    if (mu instanceof L10NUpdate || !(ok = DependencyChecker.checkModuleDependency(deps[j], mu.getRemoteModule()))) continue;
                    if (result.contains(mu)) break;
                    err.log(Level.FINE, "  ADDED[GROUP]: " + mu.getCodeNameBase() + "[L10N? " + (mu instanceof L10NUpdate) + "]: DEP: " + deps[j]);
                    result.add(mu);
                    break;
                }
                satisfied[j] = ok;
                continue;
            }
            satisfied[j] = true;
        }
        StringBuffer sb = new StringBuffer(280);
        sb.append(this.getBundle("MSG_NotSatisfied"));
        sb.append(NbBundle.getMessage(DependencyChecker.class, (String)"TXT_DependencyChecker_Module", (Object)md.getDisplayName(), (Object)md.getCodeName()));
        int notSatisfied = 0;
        for (int j = 0; j < deps.length; ++j) {
            if (satisfied[j]) continue;
            sb.append(deps[j] + "\n");
            ++notSatisfied;
        }
        StringBuffer sbbroken = null;
        if (isUpgrade && (brokenlist = this.checkBrokenImplDependency(md, result)).size() > 0) {
            sbbroken = new StringBuffer(280);
            sbbroken.append(NbBundle.getMessage(DependencyChecker.class, (String)"TXT_BrokenDependencyChecker_Module", (Object)md.getDisplayName(), (Object)md.getCodeName()));
            sbbroken.append(this.getBundle("MSG_BadsList"));
            Iterator it = brokenlist.iterator();
            while (it.hasNext()) {
                sbbroken.append(((ModuleInfo)it.next()).getCodeName() + "\n");
            }
            sbbroken.append(this.getBundle("MSG_IncludeBadsAnyway"));
        }
        if (notSatisfied == 0 && sbbroken == null) {
            return true;
        }
        if (notSatisfied > 0) {
            sb.append(this.getBundle("MSG_IncludeAnyway"));
            nd = new NotifyDescriptor.Confirmation((Object)sb.toString(), 0, 0);
            if (!DialogDisplayer.getDefault().notify((NotifyDescriptor)nd).equals(NotifyDescriptor.YES_OPTION)) {
                dontAddModuleName.append(md.getDisplayName());
                return false;
            }
        }
        if (sbbroken != null) {
            nd = new NotifyDescriptor.Confirmation((Object)sbbroken.toString(), 0, 0);
            if (!DialogDisplayer.getDefault().notify((NotifyDescriptor)nd).equals(NotifyDescriptor.YES_OPTION)) {
                dontAddModuleName.append(md.getDisplayName());
            }
        }
        return false;
    }

    boolean checkReverseDependencies(ModuleInfo module, Collection result, ModuleUpdate toReplace) {
        ModuleInfo[] installedModules = Updates.getInstalledModules();
        ModuleInfo[] installedPatches = Updates.getInstalledPatches();
        for (ModuleUpdate mu : Wizard.getAllModules()) {
            ModuleInfo md = mu.getRemoteModule();
            Set depsS = md.getDependencies();
            Dependency[] deps = depsS.toArray(new Dependency[depsS.size()]);
            boolean moduleOk = true;
            for (int j = 0; j < deps.length; ++j) {
                if (deps[j].getType() == 1 && (deps[j].getName() + "/").startsWith(module.getCodeNameBase() + "/") || deps[j].getType() == 5 && Arrays.asList(module.getProvides()).contains(deps[j].getName())) {
                    int k;
                    boolean ok = false;
                    for (k = 0; k < installedModules.length && !(ok = DependencyChecker.checkModuleDependency(deps[j], installedModules[k])); ++k) {
                    }
                    if (!ok && toReplace != null) {
                        ok = DependencyChecker.checkModuleDependency(deps[j], toReplace.getRemoteModule());
                    }
                    if (!ok) {
                        for (k = 0; k < installedPatches.length && !(ok = DependencyChecker.checkModuleDependency(deps[j], installedPatches[k])); ++k) {
                        }
                    }
                    if (ok) continue;
                    moduleOk = false;
                    break;
                }
                if (deps[j].getType() != 4 || !deps[j].getName().equals(module.getCodeName()) || DependencyChecker.checkModuleDependency(deps[j], IdeDescription.getIdeDescription())) continue;
                moduleOk = false;
                break;
            }
            if (moduleOk || result.contains(mu)) continue;
            result.add(mu);
        }
        return result.size() == 0;
    }

    static boolean checkModuleDependency(Dependency dep, ModuleInfo otherModule) {
        if (dep.getType() == 5) {
            return Arrays.asList(otherModule.getProvides()).contains(dep.getName());
        }
        String depName = dep.getName();
        if (depName.equals(otherModule.getCodeName())) {
            if (dep.getComparison() == 3) {
                return true;
            }
            if (dep.getComparison() == 1) {
                if (otherModule.getSpecificationVersion() == null) {
                    return false;
                }
                return new SpecificationVersion(dep.getVersion()).compareTo((Object)otherModule.getSpecificationVersion()) <= 0;
            }
            if (otherModule.getImplementationVersion() == null) {
                return false;
            }
            return otherModule.getImplementationVersion().equals(dep.getVersion());
        }
        int dash = depName.indexOf(45);
        if (dash != -1) {
            int slash = depName.indexOf(47);
            String cnb = depName.substring(0, slash);
            int relMin = Integer.parseInt(depName.substring(slash + 1, dash));
            int relMax = Integer.parseInt(depName.substring(dash + 1));
            if (cnb.equals(otherModule.getCodeNameBase()) && relMin <= otherModule.getCodeNameRelease() && relMax >= otherModule.getCodeNameRelease()) {
                if (dep.getComparison() == 3) {
                    return true;
                }
                if (otherModule.getCodeNameRelease() > relMin) {
                    return true;
                }
                if (otherModule.getSpecificationVersion() == null) {
                    return false;
                }
                return new SpecificationVersion(dep.getVersion()).compareTo((Object)otherModule.getSpecificationVersion()) <= 0;
            }
        }
        return false;
    }

    boolean checkIdeDependency(Dependency dep, ModuleInfo ide) {
        String IDEName = ide.getCodeName();
        SpecificationVersion IDESpecVersion = ide.getSpecificationVersion();
        String IDEImplVersion = ide.getImplementationVersion();
        if (!IDEName.equals(dep.getName())) {
            return false;
        }
        if (dep.getComparison() == 1) {
            return new SpecificationVersion(dep.getVersion()).compareTo((Object)IDESpecVersion) <= 0;
        }
        if (dep.getComparison() == 2) {
            return dep.getVersion().equals(IDEImplVersion);
        }
        throw new IllegalStateException("Cannot have COMPARE_ANY on IDE dependency");
    }

    private List checkBrokenImplDependency(ModuleInfo md, Collection result) {
        ModuleInfo[] installedModules = Updates.getInstalledModules();
        ArrayList<ModuleInfo> brokenlist = new ArrayList<ModuleInfo>();
        block0: for (int i = 0; i < installedModules.length; ++i) {
            for (Dependency dep : installedModules[i].getDependencies()) {
                if (!dep.getName().equals(md.getCodeName()) || dep.getComparison() != 2) continue;
                if (dep.getVersion().equals(md.getImplementationVersion())) continue block0;
                Iterator it = Wizard.getAllModules().iterator();
                boolean found = false;
                while (it.hasNext()) {
                    ModuleUpdate mu = (ModuleUpdate)it.next();
                    if (!mu.getRemoteModule().getCodeName().equals(installedModules[i].getCodeName()) || mu.getRemoteModule().getSpecificationVersion().compareTo((Object)installedModules[i].getSpecificationVersion()) <= 0) continue;
                    boolean maybeOK = true;
                    for (Dependency depR : mu.getRemoteModule().getDependencies()) {
                        if (!depR.getName().equals(md.getCodeName()) || depR.getComparison() != 2 || depR.getVersion().equals(md.getImplementationVersion())) continue;
                        maybeOK = false;
                        break;
                    }
                    if (!maybeOK) continue;
                    if (!result.contains(mu)) {
                        result.add(mu);
                    }
                    found = true;
                    break;
                }
                if (found) continue block0;
                brokenlist.add(installedModules[i]);
                continue block0;
            }
        }
        return brokenlist;
    }

    static boolean checkPlatformDependency(ModuleInfo module) {
        Set deps = module.getDependencies();
        Iterator it = deps.iterator();
        boolean res = true;
        while (it.hasNext()) {
            Dependency d = (Dependency)it.next();
            if (5 != d.getType() || !d.getName().startsWith("org.openide.modules.os")) continue;
            res = false;
            ModuleInfo[] installedModules = Updates.getInstalledModules();
            for (int i = 0; !res && i < installedModules.length; ++i) {
                res = DependencyChecker.checkModuleDependency(d, installedModules[i]);
            }
            err.log(Level.FINE, "checkPlatformDependency on module " + module.getCodeNameBase() + " which requires " + d + " returns " + res);
        }
        return res;
    }

    private static boolean checkFreeLocalizationDependency(ModuleUpdate baseModule, String locale, Collection result, Enumeration selected, List group) {
        L10NUpdate lu;
        boolean ok = false;
        if (baseModule instanceof L10NUpdate) {
            return false;
        }
        if (selected != null) {
            while (selected.hasMoreElements()) {
                L10NUpdate lu2;
                ModuleUpdate mu = (ModuleUpdate)selected.nextElement();
                if (!(mu instanceof L10NUpdate) || !(ok = locale.equals((lu2 = (L10NUpdate)mu).getLangcode()) && lu2.getCodeNameBase().equals(baseModule.getCodeNameBase()))) continue;
                if (result.contains(lu2)) break;
                err.log(Level.FINE, "  ADDED[SELECTED]: " + lu2.getCodeNameBase() + "[" + lu2.getLangcode() + "]");
                result.add(lu2);
                break;
            }
        }
        if (!ok && group != null) {
            for (ModuleUpdate mu : group) {
                if (!(mu instanceof L10NUpdate) || !(ok = locale.equals((lu = (L10NUpdate)mu).getLangcode()) && lu.getCodeNameBase().equals(baseModule.getCodeNameBase()))) continue;
                if (result.contains(lu)) break;
                err.log(Level.FINE, "  ADDED[GROUP]: " + lu.getCodeNameBase() + "[" + lu.getLangcode() + "]");
                result.add(lu);
                break;
            }
        }
        if (!ok) {
            for (ModuleUpdate mu : Wizard.getAllModules()) {
                if (!(mu instanceof L10NUpdate) || !(ok = locale.equals((lu = (L10NUpdate)mu).getLangcode()) && lu.getCodeNameBase().equals(baseModule.getCodeNameBase()))) continue;
                if (result.contains(lu)) break;
                err.log(Level.FINE, "  ADDED[ALL]: " + lu.getCodeNameBase() + "[" + lu.getLangcode() + "]");
                result.add(lu);
                break;
            }
        }
        return ok;
    }

    private String getBundle(String key) {
        return NbBundle.getMessage(DependencyChecker.class, (String)key);
    }
}

