/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.autoupdate;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.autoupdate.ModuleUpdate;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.Repository;
import org.openide.xml.XMLUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

class SafeModule {
    public static final String PUBLIC_ID = "-//NetBeans//DTD Module Status 1.0//EN";
    public static final String SYSTEM_ID = "http://www.netbeans.org/dtds/module-status-1_0.dtd";
    static final String PROP_AUTOLOAD = "autoload";
    static final String PROP_EAGER = "eager";
    private static final String PROP_SPEC = "specversion";
    private static final String PROP_ENABLED = "enabled";
    private static final String PROP_JAR = "jar";
    private static final String PROP_ORIGIN = "origin";
    private static final String PROP_USER = "user";
    private static final String PROP_INSTALL = "installation";
    private static final String PROP_RELEASE = "release";
    private static final String PROP_RELOADABLE = "reloadable";
    private static final String ATTR_NAME = "name";
    private static final String ATTR_PARAM = "param";
    private static final String AUTOLOAD_SLASH = "autoload/";
    private static final String EAGER_SLASH = "eager/";
    private static final String FILE_SEPARATOR = System.getProperty("file.separator");
    private static final Logger LOG = Logger.getLogger("org.netbeans.modules.autoupdate.SafeModule");
    private static Map prepared = new HashMap();

    SafeModule() {
    }

    private static boolean register(ModuleUpdate mu) {
        boolean success = true;
        Iterator it = mu.getJarList().iterator();
        while (success && it.hasNext()) {
            String name = (String)it.next();
            success = SafeModule.register(mu, name);
        }
        return success;
    }

    static boolean write(Map installNow) {
        boolean success = true;
        prepared = new HashMap();
        Iterator it = installNow.entrySet().iterator();
        while (success && it.hasNext()) {
            Map.Entry me = it.next();
            ModuleUpdate mu = (ModuleUpdate)me.getKey();
            File f = (File)me.getValue();
            if (f.exists()) {
                success = false;
                continue;
            }
            success = SafeModule.register(mu);
        }
        if (!success) {
            return false;
        }
        try {
            FileSystem deffs = Repository.getDefault().getDefaultFileSystem();
            deffs.runAtomicAction((FileSystem.AtomicAction)new DocAtomicAction(deffs));
        }
        catch (IOException ioe) {
            return false;
        }
        return true;
    }

    private static boolean register(ModuleUpdate mu, String jarName) {
        Module module = new Module();
        try {
            SafeModule.loadManifest(jarName, module, mu);
        }
        catch (IOException ioe) {
            return false;
        }
        HashMap<String, Object> m = new HashMap<String, Object>();
        m.put(ATTR_NAME, module.getName());
        boolean autoloaded = false;
        if (jarName.startsWith(AUTOLOAD_SLASH)) {
            autoloaded = true;
            jarName = jarName.substring(AUTOLOAD_SLASH.length());
        }
        m.put(PROP_AUTOLOAD, autoloaded ? Boolean.TRUE : Boolean.FALSE);
        boolean eagered = false;
        if (jarName.startsWith(EAGER_SLASH)) {
            eagered = true;
            jarName = jarName.substring(EAGER_SLASH.length());
        }
        m.put(PROP_EAGER, eagered ? Boolean.TRUE : Boolean.FALSE);
        if (!autoloaded && !eagered) {
            m.put(PROP_ENABLED, Boolean.TRUE);
        }
        m.put(PROP_JAR, jarName);
        String origin = "";
        origin = mu.isToInstallDir() ? PROP_INSTALL : PROP_USER;
        if (autoloaded) {
            origin = origin + '/' + PROP_AUTOLOAD;
        } else if (eagered) {
            origin = origin + '/' + PROP_EAGER;
        }
        m.put(PROP_ORIGIN, origin);
        if (module.getRelease() != null) {
            m.put(PROP_RELEASE, module.getRelease());
        }
        m.put(PROP_RELOADABLE, Boolean.FALSE);
        if (module.getSpecVersion() != null) {
            m.put(PROP_SPEC, module.getSpecVersion());
        }
        String nameDashes = module.getName().replace('.', '-');
        prepared.put(nameDashes, m);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadManifest(String jar, Module module, ModuleUpdate mu) throws IOException {
        String path = null;
        path = mu.isToInstallDir() ? mu.findInstallDirectory().toString() : System.getProperty("netbeans.user");
        path = path + FILE_SEPARATOR + "modules" + FILE_SEPARATOR + jar;
        JarFile jarFile = new JarFile(path);
        try {
            Manifest m = jarFile.getManifest();
            String name = m.getMainAttributes().getValue("OpenIDE-Module");
            int slash = name.indexOf(47);
            if (slash > -1) {
                module.setRelease(name.substring(slash + 1));
                name = name.substring(0, slash);
            }
            module.setName(name);
            String spec = m.getMainAttributes().getValue("OpenIDE-Module-Specification-Version");
            module.setSpecVersion(spec);
        }
        finally {
            jarFile.close();
        }
    }

    static ModuleStatus getModuleStatus(String codenamebase) {
        Document document;
        String name = "Modules/" + codenamebase.replace('.', '-') + ".xml";
        FileObject fo = Repository.getDefault().getDefaultFileSystem().findResource(name);
        if (fo == null) {
            return null;
        }
        InputStream is = null;
        try {
            is = fo.getInputStream();
            InputSource xmlInputSource = new InputSource(is);
            document = XMLUtil.parse((InputSource)xmlInputSource, (boolean)false, (boolean)false, (ErrorHandler)new ErrorCatcher(), (EntityResolver)new EntityResolver(){

                public InputSource resolveEntity(String pubid, String sysid) throws SAXException, IOException {
                    return new InputSource(SafeModule.class.getResource("module-status-1_0.dtd").toExternalForm());
                }
            });
            if (is != null) {
                is.close();
            }
        }
        catch (SAXException e) {
            System.out.println("Bad update_tracking");
            e.printStackTrace();
            return null;
        }
        catch (IOException e) {
            System.out.println("Missing update_tracking");
            e.printStackTrace();
            return null;
        }
        ModuleStatus status = new ModuleStatus();
        Element element = document.getDocumentElement();
        if (element != null && element.getTagName().equals("module")) {
            NodeList nodes = element.getChildNodes();
            for (int i = 0; i < nodes.getLength(); ++i) {
                Element nodeElement;
                Node node = nodes.item(i);
                if (node.getNodeType() != 1 || !(nodeElement = (Element)node).getTagName().equals(ATTR_PARAM)) continue;
                try {
                    SafeModule.readParam(nodeElement, status);
                    continue;
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
        return status;
    }

    private static void readParam(Element elem, ModuleStatus status) throws Exception {
        Node n = elem.getChildNodes().item(0);
        if (elem.getAttribute(ATTR_NAME).equals(PROP_AUTOLOAD)) {
            status.setAutoload(Boolean.valueOf(n.getNodeValue()));
        } else if (elem.getAttribute(ATTR_NAME).equals(PROP_EAGER)) {
            status.setEager(Boolean.valueOf(n.getNodeValue()));
        } else if (elem.getAttribute(ATTR_NAME).equals(PROP_JAR)) {
            status.setJar(n.getNodeValue());
        } else if (elem.getAttribute(ATTR_NAME).equals(PROP_ORIGIN)) {
            status.setOrigin(n.getNodeValue());
        }
    }

    private static class DocAtomicAction
    implements FileSystem.AtomicAction {
        private FileSystem fs;

        public DocAtomicAction(FileSystem fs) {
            this.fs = fs;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() throws IOException {
            this.fs.refresh(true);
            FileObject sysm = this.fs.findResource("Modules");
            for (Map.Entry me : prepared.entrySet()) {
                String filename = (String)me.getKey();
                Map m = (Map)me.getValue();
                if (sysm.getFileObject(filename + ".xml") != null) continue;
                FileObject fo = sysm.createData(filename + ".xml");
                FileLock lock = fo.lock();
                OutputStream os = null;
                try {
                    os = fo.getOutputStream(lock);
                    this.writeStatus(m, os);
                }
                finally {
                    if (os != null) {
                        os.close();
                    }
                    lock.releaseLock();
                }
            }
        }

        private void writeStatus(Map m, OutputStream os) throws IOException {
            String codeName = (String)m.get(SafeModule.ATTR_NAME);
            if (codeName == null) {
                throw new IllegalArgumentException("no code name present");
            }
            OutputStreamWriter w = new OutputStreamWriter(os, "UTF-8");
            w.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
            w.write("<!DOCTYPE module PUBLIC \"");
            w.write(SafeModule.PUBLIC_ID);
            w.write("\"\n                        \"");
            w.write(SafeModule.SYSTEM_ID);
            w.write("\">\n");
            w.write("<module name=\"");
            w.write(XMLUtil.toAttributeValue((String)codeName));
            w.write("\">\n");
            for (Map.Entry entry : new TreeMap(m).entrySet()) {
                String name = (String)entry.getKey();
                if (name.equals("installerState") || name.equals(SafeModule.ATTR_NAME)) continue;
                Object val = entry.getValue();
                w.write("    <param name=\"");
                w.write(XMLUtil.toAttributeValue((String)name));
                w.write("\">");
                w.write(XMLUtil.toElementContent((String)val.toString()));
                w.write("</param>\n");
            }
            w.write("</module>\n");
            ((Writer)w).flush();
        }
    }

    static class ErrorCatcher
    implements ErrorHandler {
        ErrorCatcher() {
        }

        private void message(String level, SAXParseException e) {
        }

        public void error(SAXParseException e) {
        }

        public void warning(SAXParseException e) {
            LOG.log(Level.WARNING, null, e);
        }

        public void fatalError(SAXParseException e) {
        }
    }

    static class Module {
        private String name;
        private String specVersion;
        private String release;

        Module() {
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getSpecVersion() {
            return this.specVersion;
        }

        public void setSpecVersion(String specVersion) {
            this.specVersion = specVersion;
        }

        public String getRelease() {
            return this.release;
        }

        public void setRelease(String release) {
            this.release = release;
        }
    }

    static class ModuleStatus {
        private boolean autoload;
        private boolean eager;
        private String origin;
        private String jar;

        ModuleStatus() {
        }

        boolean isAutoload() {
            return this.autoload;
        }

        void setAutoload(boolean autoload) {
            this.autoload = autoload;
        }

        boolean isEager() {
            return this.eager;
        }

        void setEager(boolean eager) {
            this.eager = eager;
        }

        String getOrigin() {
            return this.origin;
        }

        void setOrigin(String origin) {
            this.origin = origin;
        }

        String getJar() {
            return this.jar;
        }

        String getJarName() {
            return this.jar.substring(this.getJarPath().length(), this.jar.indexOf(46));
        }

        void setJar(String jar) {
            this.jar = jar;
        }

        boolean isFromUser() {
            return this.origin.startsWith(SafeModule.PROP_USER);
        }

        String getJarPath() {
            String path = "modules/";
            if (this.autoload) {
                path = path + SafeModule.AUTOLOAD_SLASH;
            } else if (this.eager) {
                path = path + SafeModule.EAGER_SLASH;
            }
            return path;
        }
    }
}

