/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.autoupdate;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.modules.autoupdate.Autoupdater;
import org.netbeans.modules.autoupdate.DownloadProgressPanel;
import org.netbeans.modules.autoupdate.Downloader;
import org.netbeans.modules.autoupdate.ModuleUpdate;
import org.netbeans.modules.autoupdate.Wizard;
import org.openide.util.NbBundle;

class SignVerifier {
    private static final String KS_PSSWD = "open4all";
    private static final String ENTRY_SEPARATOR = "/";
    private static final String NBM_MAIN = "main";
    private static final String NBM_MODULES = "netbeans/modules";
    private static final String NBM_AUTOLOAD = "netbeans/modules/autoload";
    private static final String NBM_EAGER = "netbeans/modules/eager";
    private static final String JAR_EXT = ".jar";
    public static final int NOT_CHECKED = -1;
    public static final int BAD_DOWNLOAD = 0;
    public static final int CORRUPTED = 1;
    public static final int NOT_SIGNED = 2;
    public static final int SIGNED = 3;
    public static final int TRUSTED = 4;
    private static final String NEW_LINE = "\n";
    private static final String SPACE = " ";
    private static final String TAB = "\t";
    DownloadProgressPanel progressDialog;
    private Wizard.Validator validator;
    private int verifySize;
    private int totalVerified;
    private long modulesCount;
    private boolean verifyCanceled = false;
    private boolean wizardCanceled = false;
    ProgressHandle partialHandle;
    ProgressHandle overallHandle;
    long startTime;
    private static final Logger err = Logger.getLogger("org.netbeans.modules.autoupdate");

    SignVerifier(DownloadProgressPanel progressDialog, Wizard.Validator validator) {
        this.validator = validator;
        this.progressDialog = progressDialog;
    }

    void doVerify() {
        this.verifyCanceled = false;
        this.progressDialog.setPartialLabel(SignVerifier.getBundle("CTL_PreparingVerify_Label"));
        this.verifySize = this.getTotalVerifySize();
        err.log(Level.FINE, "Runing doVerify, check the total size " + this.verifySize + ", verifyCanceled? " + this.verifyCanceled);
        if (this.verifyCanceled) {
            return;
        }
        this.verifyAll();
        err.log(Level.FINE, "Verification done.");
        if (this.verifyCanceled) {
            return;
        }
        this.validator.setValid(true);
    }

    private int getTotalVerifySize() {
        int result = 0;
        this.modulesCount = 0L;
        for (ModuleUpdate mu : Wizard.getAllModules()) {
            if (!mu.isSelected() || !mu.isDownloadOK() || mu.getSecurity() != -1 && mu.getSecurity() != 0) continue;
            File file = Downloader.getNBM(mu);
            result = (int)((long)result + file.length());
            ++this.modulesCount;
        }
        return result;
    }

    void verifyAll() {
        this.overallHandle = this.getOverallHandle(this.verifySize);
        this.progressDialog.setPartialLabel("");
        this.progressDialog.setOverallLabel("");
        this.progressDialog.setExtraLabel("");
        int currentModule = 0;
        this.totalVerified = 0;
        Iterator it = Wizard.getAllModules().iterator();
        while (it.hasNext()) {
            if (this.verifyCanceled) {
                return;
            }
            ModuleUpdate mu = (ModuleUpdate)it.next();
            if (!mu.isSelected() || !mu.isDownloadOK() || mu.getSecurity() != -1 && mu.getSecurity() != 0) continue;
            if (this.verifyCanceled) {
                return;
            }
            this.progressDialog.setPartialLabel(mu.getName() + " [" + (currentModule + 1) + ENTRY_SEPARATOR + this.modulesCount + "]");
            File file = Downloader.getNBM(mu);
            try {
                Collection certificates = this.verifyJar(file, mu);
                if (certificates == null) {
                    err.log(Level.FINE, mu.getName() + " was verified as NOT_SIGNED");
                    mu.setSecurity(2);
                    mu.setInstallApproved(false);
                } else {
                    mu.setCerts(certificates);
                    if (this.isTrusted(certificates)) {
                        err.log(Level.FINE, mu.getName() + " was verified as TRUSTED");
                        mu.setSecurity(4);
                        mu.setInstallApproved(true);
                    } else {
                        err.log(Level.FINE, mu.getName() + " was verified as SIGNED");
                        mu.setSecurity(3);
                        mu.setInstallApproved(false);
                    }
                }
            }
            catch (SecurityException e) {
                err.log(Level.FINE, mu.getName() + " was verified as CORRUPTED");
                mu.setSecurity(1);
                mu.setInstallApproved(false);
            }
            catch (IOException e) {
                err.log(Level.FINE, mu.getName() + " was verified as BAD_DOWNLOAD");
                mu.setSecurity(0);
                mu.setInstallApproved(false);
                mu.setDownloadOK(false);
            }
            catch (NullPointerException npe) {
                err.log(Level.FINE, mu.getName() + " was verified as BAD_DOWNLOAD");
                mu.setSecurity(0);
                mu.setInstallApproved(false);
                mu.setDownloadOK(false);
            }
            ++currentModule;
            this.overallHandle.progress(this.totalVerified);
        }
        this.overallHandle.finish();
        String mssgTotal = NbBundle.getMessage(SignVerifier.class, (String)"FMT_VerifiedTotal", (Object[])new Object[]{new Integer(this.verifySize / 1024), new Integer(this.verifySize / 1024)});
        this.progressDialog.setOverallLabel(mssgTotal);
    }

    static void processJarEntry(JarEntry entry, ModuleUpdate mu) {
        if (entry.getName().startsWith("netbeans/lib/")) {
            mu.setDepending(true);
        }
        if (entry.getName().startsWith(NBM_MAIN)) {
            mu.setSafeToInstall(false);
        }
        String jarname = null;
        if (entry.getName().startsWith(NBM_AUTOLOAD) && entry.getName().endsWith(JAR_EXT)) {
            jarname = SignVerifier.getJarModuleName(entry.getName(), "netbeans/modules/autoload/");
            if (jarname != null) {
                mu.addToJarList(jarname);
            }
        } else if (entry.getName().startsWith(NBM_EAGER) && entry.getName().endsWith(JAR_EXT)) {
            jarname = SignVerifier.getJarModuleName(entry.getName(), "netbeans/modules/eager/");
            if (jarname != null) {
                mu.addToJarList(jarname);
            }
        } else if (entry.getName().startsWith(NBM_MODULES) && entry.getName().endsWith(JAR_EXT) && (jarname = SignVerifier.getJarModuleName(entry.getName(), "netbeans/modules/")) != null) {
            mu.addToJarList(jarname);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Collection verifyJar(File jarName, ModuleUpdate mu) throws SecurityException, IOException {
        Object jis = null;
        boolean anySigned = false;
        boolean anyUnsigned = false;
        int moduleVerified = 0;
        int flen = (int)jarName.length();
        this.partialHandle = this.getPartialHandle(flen);
        JarFile jf = new JarFile(jarName);
        Manifest man = jf.getManifest();
        Enumeration<JarEntry> entries = jf.entries();
        LinkedList<JarEntry> entriesList = new LinkedList<JarEntry>();
        byte[] buffer = new byte[8192];
        try {
            JarEntry entry;
            while (entries.hasMoreElements()) {
                Collection collection;
                entry = entries.nextElement();
                SignVerifier.processJarEntry(entry, mu);
                entriesList.add(entry);
                InputStream is = null;
                try {
                    int n;
                    is = jf.getInputStream(entry);
                    while ((n = is.read(buffer, 0, buffer.length)) != -1) {
                        if (++moduleVerified % 4096 == 0) {
                            this.partialHandle.progress(moduleVerified < flen ? moduleVerified : flen);
                        }
                        if (!this.verifyCanceled) continue;
                        collection = null;
                        if (is == null) break block18;
                    }
                }
                catch (Throwable throwable) {
                    if (is != null) {
                        is.close();
                    }
                    this.totalVerified = (int)((long)this.totalVerified + entry.getCompressedSize());
                    String mssgTotal = NbBundle.getMessage(SignVerifier.class, (String)"FMT_VerifiedTotal", (Object[])new Object[]{new Integer(this.totalVerified / 1024), new Integer(this.verifySize / 1024)});
                    this.progressDialog.setOverallLabel(mssgTotal);
                    throw throwable;
                }
                {
                    block18: {
                        is.close();
                    }
                    this.totalVerified = (int)((long)this.totalVerified + entry.getCompressedSize());
                    String mssgTotal = NbBundle.getMessage(SignVerifier.class, (String)"FMT_VerifiedTotal", (Object[])new Object[]{new Integer(this.totalVerified / 1024), new Integer(this.verifySize / 1024)});
                    this.progressDialog.setOverallLabel(mssgTotal);
                    return collection;
                }
                if (is != null) {
                    is.close();
                }
                this.totalVerified = (int)((long)this.totalVerified + entry.getCompressedSize());
                String mssgTotal = NbBundle.getMessage(SignVerifier.class, (String)"FMT_VerifiedTotal", (Object[])new Object[]{new Integer(this.totalVerified / 1024), new Integer(this.verifySize / 1024)});
                this.progressDialog.setOverallLabel(mssgTotal);
            }
            err.log(Level.FINE, "Update " + mu.getCodeNameBase() + " was verified as forced to intall global: " + mu.isForcedGlobal() + " and safeToInstall: " + mu.isSafeToInstall());
            if (this.verifyCanceled) {
                entry = null;
                return entry;
            }
        }
        finally {
            jf.close();
            if (this.wizardCanceled) {
                Downloader.getNBM(mu).delete();
            }
        }
        this.partialHandle.finish();
        HashSet<Certificate> certificates = new HashSet<Certificate>();
        if (man != null) {
            for (JarEntry je : entriesList) {
                String name = je.getName();
                Certificate[] certs = je.getCertificates();
                boolean isSigned = certs != null && certs.length > 0;
                anySigned |= isSigned;
                if (certs != null) {
                    for (int i = 0; i < certs.length; ++i) {
                        certificates.add(certs[i]);
                        if (!this.verifyCanceled) continue;
                        return null;
                    }
                    continue;
                }
                if (je.isDirectory() || name.toUpperCase().startsWith("META-INF/") || je.getSize() == 0L) continue;
                anyUnsigned = true;
            }
        }
        if (anySigned && anyUnsigned) {
            throw new SecurityException(SignVerifier.getBundle("EXC_NotSignedEntity"));
        }
        return anySigned ? certificates : null;
    }

    public static String formatCerts(Collection collection) {
        StringBuffer sb = new StringBuffer(collection.size() * 300);
        for (Certificate cert : collection) {
            if (cert instanceof X509Certificate) {
                try {
                    sb.append("\n\n");
                    sb.append(SignVerifier.X509CertToString((X509Certificate)cert));
                }
                catch (Exception e) {
                    sb.append(cert.toString());
                }
            } else {
                sb.append(cert.toString());
            }
            sb.append("\n\n");
        }
        return sb.toString();
    }

    boolean isTrusted(Collection certs) {
        Collection trustedCerts = this.getTrustedCerts();
        if (trustedCerts.size() <= 0 || certs.size() <= 0) {
            return false;
        }
        return trustedCerts.containsAll(certs);
    }

    static void addCertificates(Collection certs) throws CertificateException, KeyStoreException, IOException, NoSuchAlgorithmException {
        KeyStore ks = SignVerifier.getKeyStore(Autoupdater.Support.getKSFile(), KS_PSSWD, null);
        for (Certificate c : certs) {
            if (ks.getCertificateAlias(c) != null) continue;
            String alias = null;
            for (int i = 0; i < 9999 && ks.containsAlias(alias = "genAlias" + i); ++i) {
            }
            if (alias == null) {
                throw new KeyStoreException(SignVerifier.getBundle("EXC_TooManyCertificates"));
            }
            ks.setCertificateEntry(alias, c);
        }
        SignVerifier.saveKeyStore(ks, Autoupdater.Support.getKSFile(), KS_PSSWD, null);
    }

    static void removeCertificates(Collection certs) throws CertificateException, KeyStoreException, IOException, NoSuchAlgorithmException {
        KeyStore ks = SignVerifier.getKeyStore(Autoupdater.Support.getKSFile(), KS_PSSWD, null);
        for (Certificate c : certs) {
            String alias = ks.getCertificateAlias(c);
            if (alias == null) continue;
            ks.deleteEntry(alias);
        }
        SignVerifier.saveKeyStore(ks, Autoupdater.Support.getKSFile(), KS_PSSWD, null);
    }

    Collection getTrustedCerts() {
        ArrayList trustedCerts = new ArrayList(10);
        File ksFile = Autoupdater.Support.getKSFile();
        try {
            if (ksFile.canRead()) {
                KeyStore ks = SignVerifier.getKeyStore(ksFile, KS_PSSWD, null);
                trustedCerts.addAll(SignVerifier.getCertificates(ks));
            }
        }
        catch (CertificateException e) {
        }
        catch (KeyStoreException e) {
        }
        catch (IOException e) {
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            // empty catch block
        }
        return trustedCerts;
    }

    private static KeyStore getKeyStore(File file, String password, String storetype) throws IOException, CertificateException, KeyStoreException, NoSuchAlgorithmException {
        if (file == null) {
            return null;
        }
        FileInputStream is = null;
        try {
            is = new FileInputStream(file);
        }
        catch (IOException e) {
            // empty catch block
        }
        KeyStore keyStore = null;
        if (storetype == null) {
            keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
            keyStore.load(is, password.toCharArray());
            if (is != null) {
                ((InputStream)is).close();
            }
        }
        return keyStore;
    }

    public static void saveKeyStore(KeyStore keyStore, File file, String password, String storetype) throws CertificateException, KeyStoreException, IOException, NoSuchAlgorithmException {
        if (file == null) {
            return;
        }
        FileOutputStream os = new FileOutputStream(file);
        keyStore.store(os, password.toCharArray());
        ((OutputStream)os).close();
    }

    public static Collection getCertificates(KeyStore keyStore) throws KeyStoreException {
        ArrayList<Certificate> certificates = new ArrayList<Certificate>(10);
        Enumeration<String> en = keyStore.aliases();
        while (en.hasMoreElements()) {
            String alias = en.nextElement();
            Certificate cert = keyStore.getCertificate(alias);
            certificates.add(cert);
        }
        return certificates;
    }

    void cancelVerify(boolean wizardCanceled) {
        this.verifyCanceled = true;
        this.wizardCanceled = wizardCanceled;
    }

    private static String X509CertToString(X509Certificate cert) throws Exception {
        return SignVerifier.getBundle("MSG_Owner") + SPACE + cert.getSubjectDN() + NEW_LINE + SignVerifier.getBundle("MSG_Issuer") + SPACE + cert.getIssuerDN() + NEW_LINE + SignVerifier.getBundle("MSG_SerNumber") + SPACE + cert.getSerialNumber().toString(16) + NEW_LINE + SignVerifier.getBundle("MSG_Valid") + SPACE + cert.getNotBefore().toString() + SPACE + SignVerifier.getBundle("MSG_Until") + SPACE + cert.getNotAfter().toString() + NEW_LINE + SignVerifier.getBundle("MSG_CertFinger") + NEW_LINE + SPACE + TAB + SignVerifier.getBundle("MSG_MD5") + SPACE + SPACE + SignVerifier.getCertFingerPrint("MD5", cert) + NEW_LINE + SPACE + TAB + SignVerifier.getBundle("MSG_SHA1") + SPACE + SignVerifier.getCertFingerPrint("SHA1", cert);
    }

    private static String getCertFingerPrint(String mdAlg, Certificate cert) throws Exception {
        byte[] encCertInfo = cert.getEncoded();
        MessageDigest md = MessageDigest.getInstance(mdAlg);
        byte[] digest = md.digest(encCertInfo);
        return SignVerifier.toHexString(digest);
    }

    private static String toHexString(byte[] block) {
        StringBuffer buf = new StringBuffer();
        int len = block.length;
        for (int i = 0; i < len; ++i) {
            SignVerifier.byte2hex(block[i], buf);
            if (i >= len - 1) continue;
            buf.append(":");
        }
        return buf.toString();
    }

    private static void byte2hex(byte b, StringBuffer buf) {
        char[] hexChars = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        int high = (b & 0xF0) >> 4;
        int low = b & 0xF;
        buf.append(hexChars[high]);
        buf.append(hexChars[low]);
    }

    private static String getJarModuleName(String name, String prefix) {
        if (name.substring(prefix.length()).indexOf(ENTRY_SEPARATOR) == -1) {
            String common = "netbeans/modules/";
            return name.substring(common.length());
        }
        return null;
    }

    private static String getBundle(String key) {
        return NbBundle.getMessage(SignVerifier.class, (String)key);
    }

    private ProgressHandle getPartialHandle(int units) {
        assert (this.progressDialog != null);
        ProgressHandle handle = ProgressHandleFactory.createHandle((String)SignVerifier.getBundle("DownloadProgressPanel_partialHandle_name"));
        this.progressDialog.setPartialProgressComponent(handle);
        handle.start(units);
        return handle;
    }

    private ProgressHandle getOverallHandle(int units) {
        assert (this.progressDialog != null);
        ProgressHandle handle = ProgressHandleFactory.createHandle((String)SignVerifier.getBundle("DownloadProgressPanel_overallHandle_name"));
        this.progressDialog.setOverallProgressComponent(handle);
        handle.start(units);
        return handle;
    }
}

