/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.autoupdate;

import java.awt.Dialog;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.GZIPInputStream;
import javax.swing.SwingUtilities;
import org.netbeans.modules.autoupdate.AutoupdateType;
import org.netbeans.modules.autoupdate.ConnectingDialog;
import org.netbeans.modules.autoupdate.L10NUpdate;
import org.netbeans.modules.autoupdate.ModuleGroup;
import org.netbeans.modules.autoupdate.ModuleUpdate;
import org.netbeans.modules.autoupdate.Settings;
import org.netbeans.modules.autoupdate.Updates;
import org.netbeans.modules.autoupdate.Wizard;
import org.netbeans.updater.XMLUtil;
import org.openide.util.Exceptions;
import org.openide.util.RequestProcessor;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

class XMLUpdates
extends Updates {
    private static final String TAG_MODULE_UPDATES = "module_updates";
    private static final String TAG_MODULE = "module";
    private static final String TAG_MODULE_GROUP = "module_group";
    private static final String TAG_NOTIFICATION = "notification";
    private static final String ATTR_NOTIFICATION_URL = "url";
    private static final String TAG_ERROR = "error";
    private static final String TAG_AUTH_ERROR = "auth_error";
    private static final String TAG_OTHER_ERROR = "other_error";
    private static final String ATTR_MESSAGE_ERROR = "message";
    private static final Logger err = Logger.getLogger("org.netbeans.modules.autoupdate.XMLUpdates");
    private ArrayList modules;
    private HashMap checkOnceMore;
    private ModuleGroup rootGroup;
    private int pError = 0;
    private String errorMess = null;
    private Date timeStamp = null;
    private String notificationText = null;
    private URL notificationURL = null;
    private URL xmlURL;
    private File[] files;
    private static ArrayList groupFiles = new ArrayList();
    private static boolean timerSet = false;
    private static boolean groupStarted = false;
    private static int oldGroupSize = 0;
    private InputSource xmlInputSource = null;
    private AutoupdateType currentAT = null;
    private static String GZIP_EXTENSION = ".gz";

    XMLUpdates(URL xmlURL) {
        this.xmlURL = xmlURL;
    }

    XMLUpdates(File[] files) {
        this.files = files;
    }

    static void startGroupUpdates(File file) {
        if (groupStarted) {
            new XMLUpdates(new File[]{file}).go();
        } else {
            groupFiles.add(file);
            XMLUpdates.setTimer();
        }
    }

    private static void setTimer() {
        if (!timerSet) {
            timerSet = true;
            oldGroupSize = groupFiles.size();
            RequestProcessor.getDefault().post(new Runnable(){

                public void run() {
                    if (!SwingUtilities.isEventDispatchThread()) {
                        SwingUtilities.invokeLater(this);
                        return;
                    }
                    if (oldGroupSize < groupFiles.size()) {
                        oldGroupSize = groupFiles.size();
                        RequestProcessor.getDefault().post((Runnable)this, 500);
                    } else {
                        timerSet = false;
                        groupStarted = true;
                        File[] arrFiles = new File[groupFiles.size()];
                        Iterator it = groupFiles.iterator();
                        int j = 0;
                        while (it.hasNext()) {
                            File fn = (File)it.next();
                            if (fn != null) {
                                arrFiles[j] = fn;
                            }
                            ++j;
                        }
                        groupFiles.clear();
                        groupStarted = false;
                        new XMLUpdates(arrFiles).go();
                    }
                }
            }, 500);
        }
    }

    private void go() {
        HashMap<XMLUpdates, XMLUpdates> allUpdates = new HashMap<XMLUpdates, XMLUpdates>();
        allUpdates.put(this, this);
        Wizard wiz = Wizard.go(allUpdates, 1);
        if (wiz != null) {
            this.checkDownloadedModules();
            wiz.refreshUpdatePanel();
        }
    }

    public void checkUpdates(Wizard.Validator validator) {
        this.checkUpdates(validator, "");
    }

    public void checkUpdates(Wizard.Validator validator, String ucname) {
        this.checkUpdates(validator, AutoupdateType.find(ucname));
    }

    public void checkUpdates(Wizard.Validator validator, AutoupdateType at) {
        this.checkUpdates(validator, at, false);
    }

    public void checkUpdates(final Wizard.Validator validator, final AutoupdateType at, boolean hidden) {
        this.currentAT = at;
        this.pError = 0;
        this.checkCanceled = false;
        final Dialog connDialog = ConnectingDialog.getDialog(at != null ? at.getName() : null);
        Runnable runConnect = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    Document document = XMLUpdates.this.parseDocument();
                    if (XMLUpdates.this.pError == 0 && document != null) {
                        XMLUpdates.this.buildStructures(document);
                        if (!XMLUpdates.this.checkCanceled) {
                            Settings.getShared().setLastCheck(new Date());
                        }
                    } else if (XMLUpdates.this.pError == 0) assert (document != null || XMLUpdates.this.checkCanceled) : "Document is not null or connecting is canceled if no error caught.";
                    validator.setValid(true);
                    int countOfAvailableModules = 0;
                    if (XMLUpdates.this.getModules() != null) {
                        countOfAvailableModules = XMLUpdates.this.getModules().size();
                    }
                    if (countOfAvailableModules == 0 && XMLUpdates.this.pError == 0) {
                        XMLUpdates.this.errorMess = at.getName();
                        XMLUpdates.this.pError = 4;
                    }
                }
                catch (Exception x) {
                    XMLUpdates.this.pError = 5;
                    err.log(Level.INFO, null, x);
                }
                finally {
                    if (connDialog != null) {
                        ConnectingDialog.closeDialog(connDialog);
                    }
                }
            }
        };
        RequestProcessor.Task task = RequestProcessor.getDefault().post(runConnect);
        if (!hidden) {
            connDialog.setVisible(true);
            if (ConnectingDialog.isCanceled()) {
                this.cancelCheck();
            }
        } else {
            task.waitFinished();
        }
    }

    public void cancelCheck() {
        this.checkCanceled = true;
        if (this.xmlInputSource != null) {
            try {
                if (this.xmlInputSource.getByteStream() != null) {
                    this.xmlInputSource.getByteStream().close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public ModuleGroup getRootGroup() {
        return this.rootGroup;
    }

    public Collection getModules() {
        return this.modules;
    }

    public boolean isError() {
        return this.pError > 0;
    }

    public int getError() {
        return this.pError;
    }

    public String getErrorMessage() {
        return this.errorMess;
    }

    public Date getTimeStamp() {
        return this.timeStamp;
    }

    public String getNotificationText() {
        return this.notificationText;
    }

    public URL getNotificationURL() {
        return this.notificationURL;
    }

    void checkDownloadedModules() {
        this.modules = new ArrayList();
        this.rootGroup = new ModuleGroup();
        this.checkOnceMore = new HashMap();
        for (int i = 0; i < this.files.length; ++i) {
            ModuleUpdate update = ModuleUpdate.getModuleUpdate(this.files[i]);
            if (update == null) continue;
            if (update.isUpdateAvailable()) {
                this.modules.add(update);
                this.rootGroup.addItem(update);
                continue;
            }
            if (!(update instanceof L10NUpdate)) continue;
            this.checkOnceMore.put(update, this.rootGroup);
        }
        this.checkAvailablesOnceMore();
    }

    void checkAvailablesOnceMore() {
        for (Map.Entry entry : this.checkOnceMore.entrySet()) {
            L10NUpdate update = (L10NUpdate)entry.getKey();
            if (!update.isRemoteModuleAvailable(this.modules)) continue;
            this.modules.add(update);
            ((ModuleGroup)entry.getValue()).addItem(update);
        }
    }

    private Document parseDocument() {
        Document document;
        block5: {
            document = null;
            if (this.checkCanceled) {
                return null;
            }
            String showStr = System.getProperty("autoupdate.show.url");
            if (showStr != null && Boolean.valueOf(showStr).booleanValue()) {
                System.out.println("URL: " + this.xmlURL);
            }
            try {
                document = this.parseDocumentImpl();
            }
            catch (SAXException e) {
                this.pError = 6;
                this.showParseError(e);
            }
            catch (IOException e) {
                this.pError = 5;
                if (this.checkCanceled) break block5;
                this.showParseError(e);
            }
        }
        return document;
    }

    private Document parseDocumentImpl() throws SAXException, IOException {
        Document document = null;
        HttpURLConnection.setFollowRedirects(true);
        err.log(Level.FINE, "Processing URL: " + this.xmlURL);
        URL urlToGZip = null;
        try {
            String gzipFile = this.xmlURL.getPath() + GZIP_EXTENSION;
            String query = this.xmlURL.getQuery();
            if (query != null && query.trim().length() > 0) {
                gzipFile = gzipFile + '?' + query;
            }
            urlToGZip = new URL(this.xmlURL.getProtocol(), this.xmlURL.getHost(), this.xmlURL.getPort(), gzipFile);
            this.xmlInputSource = new InputSource(new BufferedInputStream(new GZIPInputStream(urlToGZip.openStream())));
            err.log(Level.FINE, "Successfully read URL " + urlToGZip);
        }
        catch (IOException ioe) {
            err.log(Level.FINE, "Reading GZIP URL " + urlToGZip + " failed (" + ioe + "). Try read XML directly " + this.xmlURL);
            this.xmlInputSource = new InputSource(this.xmlURL.toExternalForm());
            err.log(Level.FINE, "Successfully read URL " + this.xmlURL);
        }
        if (this.checkCanceled) {
            err.log(Level.FINE, "Connection canceled on user's demand.");
            return null;
        }
        document = XMLUtil.parse((InputSource)this.xmlInputSource, (boolean)false, (boolean)false, (ErrorHandler)new ErrorCatcher(), (EntityResolver)XMLUtil.createAUResolver());
        assert (document != null) : "Parser in XMLUtil return not null document for input " + this.xmlInputSource;
        return document;
    }

    private void showParseError(Throwable t) {
        Exceptions.attachMessage((Throwable)t, (String)("URL: " + this.xmlURL));
        err.log(Level.INFO, null, t);
    }

    private void buildStructures(Document document) {
        if (this.checkCanceled) {
            return;
        }
        if (document.getDocumentElement() != null) {
            this.modules = new ArrayList();
            this.rootGroup = new ModuleGroup();
            this.checkOnceMore = new HashMap();
            if (this.detectErrorType(document)) {
                return;
            }
            NodeList allModules = document.getElementsByTagName(TAG_MODULE);
            this.processElement(document, document.getDocumentElement(), this.rootGroup);
            Node attr = document.getDocumentElement().getAttributes().getNamedItem("timestamp");
            if (attr != null) {
                String timeString = attr.getNodeValue() + "/GMT";
                SimpleDateFormat formatter = new SimpleDateFormat("ss/mm/HH/dd/MM/yyyy/zzz");
                ParsePosition pos = new ParsePosition(0);
                this.timeStamp = formatter.parse(timeString, pos);
            }
            this.checkAvailablesOnceMore();
        }
    }

    private boolean detectErrorType(Document document) {
        NodeList errors = document.getElementsByTagName(TAG_ERROR);
        if (errors.getLength() > 0) {
            NodeList auth_errors = document.getElementsByTagName(TAG_AUTH_ERROR);
            if (auth_errors.getLength() > 0) {
                this.pError = 2;
                assert (false) : "Unexcepted auth_error in document " + document;
            } else {
                this.pError = 6;
                NodeList other_errors = document.getElementsByTagName(TAG_OTHER_ERROR);
                if (other_errors.getLength() > 0) {
                    this.errorMess = other_errors.item(0).getAttributes().getNamedItem(ATTR_MESSAGE_ERROR).getNodeValue();
                }
            }
        }
        return this.pError > 0;
    }

    private void processElement(Document document, Element element, ModuleGroup moduleGroup) {
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            if (this.checkCanceled) {
                return;
            }
            Node node = nodeList.item(i);
            if (node.getNodeType() != 1) continue;
            if (((Element)node).getTagName().equals(TAG_MODULE)) {
                ModuleUpdate update = ModuleUpdate.getModuleUpdate(this.xmlURL, node, document.getDocumentElement(), this.currentAT);
                if (update == null) continue;
                if (update.isUpdateAvailable()) {
                    this.modules.add(update);
                    moduleGroup.addItem(update);
                    continue;
                }
                if (!(update instanceof L10NUpdate)) continue;
                this.checkOnceMore.put(update, moduleGroup);
                continue;
            }
            if (((Element)node).getTagName().equals(TAG_MODULE_GROUP)) {
                ModuleGroup group = new ModuleGroup(node);
                moduleGroup.addItem(group);
                this.processElement(document, (Element)node, group);
                continue;
            }
            if (!((Element)node).getTagName().equals(TAG_NOTIFICATION)) continue;
            this.readNotification(node);
        }
    }

    private void readNotification(Node node) {
        if (this.getNotificationText() != null) {
            return;
        }
        try {
            String textURL;
            Node attr = node.getAttributes().getNamedItem(ATTR_NOTIFICATION_URL);
            String string = textURL = attr == null ? null : attr.getNodeValue();
            if (textURL != null) {
                this.notificationURL = new URL(textURL);
            }
        }
        catch (MalformedURLException e) {
            // empty catch block
        }
        StringBuffer sb = new StringBuffer();
        NodeList innerList = node.getChildNodes();
        for (int i = 0; i < innerList.getLength(); ++i) {
            if (innerList.item(i).getNodeType() != 3) continue;
            sb.append(innerList.item(i).getNodeValue());
        }
        this.notificationText = sb.length() > 0 ? sb.toString() : null;
    }

    class ErrorCatcher
    implements ErrorHandler {
        ErrorCatcher() {
        }

        public void error(SAXParseException e) throws SAXParseException {
            throw e;
        }

        public void warning(SAXParseException e) throws SAXParseException {
            XMLUpdates.this.showParseError(e);
        }

        public void fatalError(SAXParseException e) throws SAXParseException {
            throw e;
        }
    }
}

