/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.autoupdate.catalog;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.Module;
import org.netbeans.modules.autoupdate.catalog.ModuleDeleter;
import org.netbeans.modules.autoupdate.catalog.ModuleNodeUtils;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.Repository;
import org.openide.modules.InstalledFileLocator;
import org.openide.util.Exceptions;
import org.openide.util.RequestProcessor;
import org.openide.xml.EntityCatalog;
import org.openide.xml.XMLUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public final class ModuleDeleterImpl
implements ModuleDeleter {
    private static final String ELEMENT_MODULE = "module";
    private static final String ELEMENT_VERSION = "module_version";
    private static final String ATTR_ORIGIN = "origin";
    private static final String ATTR_LAST = "last";
    private static final String ATTR_FILE_NAME = "name";
    private static final String UPDATE_TRACKING = "update_tracking";
    private static final String INST_ORIGIN = "updater";
    private static final boolean ONLY_FROM_AUTOUPDATE = false;
    private static final int TIME_TO_CHECK = 2000;
    private static final int MAX_CHECKS_OF_STATE = 50;
    private static final int HOLD_ON_PROPAGATE_DISABLE = 1000;
    private Logger err = Logger.getLogger("org.netbeans.modules.autoupdate.catalog.ModuleDeleterImpl");

    public boolean canDelete(Module module) {
        if (module.isFixed()) {
            this.err.log(Level.FINE, "Cannot delete module because module " + module.getCodeName() + " isFixed.");
        } else if (module.isAutoload()) {
            this.err.log(Level.FINE, "Cannot delete module because module " + module.getCodeName() + " isAutoload. See issue #74819.");
        } else if (module.isEager()) {
            this.err.log(Level.FINE, "Cannot delete module because module " + module.getCodeName() + " isEager. See issue #74819.");
        }
        return ModuleNodeUtils.isUninstallAllowed(module) && this.findUpdateTracking(module, false);
    }

    public void delete(final Module module) throws IOException {
        if (module == null) {
            throw new IllegalArgumentException("Module argument cannot be null.");
        }
        this.err.log(Level.FINE, "Locate and remove config file of " + module.getCodeNameBase());
        this.removeControlModuleFile(module);
        RequestProcessor.Task cleaner = RequestProcessor.getDefault().create(new Runnable(){

            public void run() {
                try {
                    ModuleDeleterImpl.this.removeModuleFiles(module);
                }
                catch (IOException ioe) {
                    Exceptions.attachLocalizedMessage((Throwable)ioe, (String)("ERROR: During processing removeModuleFiles (" + module.getDisplayName() + ")"));
                    Exceptions.printStackTrace((Throwable)ioe);
                }
            }
        });
        if (!module.isAutoload() && !module.isEager()) {
            RequestProcessor.getDefault().post((Runnable)new HackModuleListRefresher());
        }
        if (!module.isAutoload() && !module.isEager()) {
            RequestProcessor.getDefault().post((Runnable)new ModuleStateChecker(module, cleaner), 2000);
        } else {
            cleaner.run();
        }
    }

    private File locateControlFile(Module m) {
        String configFile = "config/Modules/" + m.getCodeNameBase().replace('.', '-') + ".xml";
        return InstalledFileLocator.getDefault().locate(configFile, m.getCodeNameBase(), false);
    }

    private void removeControlModuleFile(Module m) throws IOException {
        File configFile = null;
        while ((configFile = this.locateControlFile(m)) != null) {
            if (configFile != null && configFile.exists()) {
                this.err.log(Level.FINE, "Try delete the config File " + configFile);
                FileUtil.toFileObject((File)configFile).delete();
                continue;
            }
            this.err.log(Level.FINE, "Warning: Config File " + configFile + " doesn't exist!");
        }
    }

    private File locateUpdateTracking(Module m) {
        String fileNameToFind = "update_tracking/" + m.getCodeNameBase().replace('.', '-') + ".xml";
        return InstalledFileLocator.getDefault().locate(fileNameToFind, m.getCodeNameBase(), false);
    }

    private boolean findUpdateTracking(Module module, boolean checkIfFromAutoupdate) {
        File updateTracking = this.locateUpdateTracking(module);
        if (updateTracking != null && updateTracking.exists()) {
            if (!updateTracking.getParentFile().canWrite()) {
                this.err.log(Level.FINE, "Cannot delete module " + module.getCodeName() + " because no write permission to directory " + updateTracking.getParent());
                return false;
            }
            if (checkIfFromAutoupdate) {
                boolean isFromAutoupdate = this.fromAutoupdate(this.getModuleConfiguration(updateTracking));
                this.err.log(Level.FINE, "Is Module " + module.getCodeName() + " installed by AutoUpdate? " + isFromAutoupdate);
                return isFromAutoupdate;
            }
            return true;
        }
        this.err.log(Level.FINE, "Cannot delete module " + module.getCodeName() + " because no update_tracking file found.");
        return false;
    }

    private boolean fromAutoupdate(Node moduleNode) {
        Node attrOrigin = moduleNode.getAttributes().getNamedItem(ATTR_ORIGIN);
        assert (attrOrigin != null) : "ELEMENT_VERSION must contain ATTR_ORIGIN attribute.";
        String origin = attrOrigin.getNodeValue();
        return INST_ORIGIN.equals(origin);
    }

    private void removeModuleFiles(Module m) throws IOException {
        this.err.log(Level.FINE, "Entry removing files of module " + m);
        File updateTracking = null;
        while ((updateTracking = this.locateUpdateTracking(m)) != null) {
            this.removeModuleFilesInCluster(m, updateTracking);
        }
        this.err.log(Level.FINE, "Exit removing files of module " + m);
    }

    private void removeModuleFilesInCluster(Module module, File updateTracking) throws IOException {
        this.err.log(Level.FINE, "Read update_tracking " + updateTracking + " file.");
        Set moduleFiles = this.readModuleFiles(this.getModuleConfiguration(updateTracking));
        String configFile = "config/Modules/" + module.getCodeNameBase().replace('.', '-') + ".xml";
        if (moduleFiles.contains(configFile)) {
            File file = InstalledFileLocator.getDefault().locate(configFile, module.getCodeNameBase(), false);
            assert (file == null || !file.exists()) : "Config file " + configFile + " must be already removed.";
        }
        for (String fileName : moduleFiles) {
            File file;
            if (fileName.equals(configFile) || (file = InstalledFileLocator.getDefault().locate(fileName, module.getCodeNameBase(), false)).equals(updateTracking)) continue;
            assert (file.exists()) : "File " + file + " exists.";
            if (!file.exists()) continue;
            this.err.log(Level.FINE, "File " + file + " is deleted.");
            try {
                FileUtil.toFileObject((File)file).delete();
            }
            catch (IOException ioe) {
                assert (false) : "Waring: IOException " + ioe.getMessage() + " was caught. Propably file lock on the file.";
                this.err.log(Level.FINE, "Waring: IOException " + ioe.getMessage() + " was caught. Propably file lock on the file.");
                this.err.log(Level.FINE, "Try call File.deleteOnExit() on " + file);
                file.deleteOnExit();
            }
        }
        FileUtil.toFileObject((File)updateTracking).delete();
        this.err.log(Level.FINE, "File " + updateTracking + " is deleted.");
    }

    private Node getModuleConfiguration(File moduleUpdateTracking) {
        Document document = null;
        try {
            FileInputStream is = new FileInputStream(moduleUpdateTracking);
            InputSource xmlInputSource = new InputSource(is);
            document = XMLUtil.parse((InputSource)xmlInputSource, (boolean)false, (boolean)false, null, (EntityResolver)EntityCatalog.getDefault());
            if (is != null) {
                ((InputStream)is).close();
            }
        }
        catch (SAXException saxe) {
            this.err.log(Level.WARNING, null, saxe);
            return null;
        }
        catch (IOException ioe) {
            this.err.log(Level.WARNING, null, ioe);
        }
        assert (document.getDocumentElement() != null) : "File " + moduleUpdateTracking + " must contain <module> element.";
        return this.getModuleElement(document.getDocumentElement());
    }

    private Node getModuleElement(Element element) {
        Node lastElement = null;
        assert (ELEMENT_MODULE.equals(element.getTagName())) : "The root element is: module but was: " + element.getTagName();
        NodeList listModuleVersions = element.getElementsByTagName(ELEMENT_VERSION);
        for (int i = 0; i < listModuleVersions.getLength() && (lastElement = this.getModuleLastVersion(listModuleVersions.item(i))) == null; ++i) {
        }
        return lastElement;
    }

    private Node getModuleLastVersion(Node version) {
        Node attrLast = version.getAttributes().getNamedItem(ATTR_LAST);
        assert (attrLast != null) : "ELEMENT_VERSION must contain ATTR_LAST attribute.";
        if (Boolean.valueOf(attrLast.getNodeValue()).booleanValue()) {
            return version;
        }
        return null;
    }

    private Set readModuleFiles(Node version) {
        HashSet<String> files = new HashSet<String>();
        NodeList fileNodes = version.getChildNodes();
        for (int i = 0; i < fileNodes.getLength(); ++i) {
            if (!fileNodes.item(i).hasAttributes()) continue;
            NamedNodeMap map = fileNodes.item(i).getAttributes();
            files.add(map.getNamedItem(ATTR_FILE_NAME).getNodeValue());
            this.err.log(Level.FINE, "Mark to delete: " + map.getNamedItem(ATTR_FILE_NAME).getNodeValue());
        }
        return files;
    }

    private class HackModuleListRefresher
    implements Runnable {
        private HackModuleListRefresher() {
        }

        public void run() {
            FileObject modulesRoot = Repository.getDefault().getDefaultFileSystem().findResource("Modules");
            ModuleDeleterImpl.this.err.log(Level.FINE, "It's a hack: Call refresh on " + modulesRoot + " file object.");
            if (modulesRoot != null) {
                modulesRoot.refresh();
            }
        }
    }

    private class ModuleStateChecker
    implements Runnable {
        RequestProcessor.Task cleaner;
        Module m;
        int checks;

        public ModuleStateChecker(Module module, RequestProcessor.Task filesCleaner) {
            this.cleaner = filesCleaner;
            this.m = module;
            this.checks = 0;
        }

        public void run() {
            ++this.checks;
            if (this.m.isEnabled() && this.m.isValid()) {
                if (this.checks < 50) {
                    ModuleDeleterImpl.this.err.log(Level.FINE, "Module " + this.m.getCodeNameBase() + " is still valid, repost later.");
                    RequestProcessor.getDefault().post((Runnable)this, 2000);
                } else {
                    ModuleDeleterImpl.this.err.log(Level.FINE, "Warning: Module " + this.m.getCodeNameBase() + " is still valid but time-out. Task is terminated.");
                }
                return;
            }
            this.cleaner.schedule(1000);
        }
    }
}

