/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.autoupdate.catalog;

import java.awt.Component;
import java.util.HashSet;
import java.util.Set;
import org.netbeans.Module;
import org.netbeans.modules.autoupdate.catalog.ModuleBean;
import org.netbeans.modules.autoupdate.catalog.ModuleNode;
import org.netbeans.modules.autoupdate.catalog.ModuleNodeActions;
import org.netbeans.modules.autoupdate.catalog.ModuleSelectionPanel;
import org.netbeans.modules.autoupdate.catalog.ModuleUninstallPanel;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ModuleNodeUtils {
    private ModuleNodeUtils() {
    }

    private static Set<ModuleNode.Item> getCategoryModules(Node category) {
        assert (!category.isLeaf()) : "Parent " + category + " cannot be leaf.";
        HashSet<ModuleNode.Item> modules = new HashSet<ModuleNode.Item>();
        for (Node child : category.getChildren().getNodes(true)) {
            if (!(child instanceof ModuleNode.Item)) continue;
            modules.add((ModuleNode.Item)child);
        }
        return modules;
    }

    static Set<ModuleNode.Item> getAllSelectedModuleItems(Node[] nodes) {
        HashSet<ModuleNode.Item> modules = new HashSet<ModuleNode.Item>();
        for (Node node : nodes) {
            if (node instanceof ModuleNode.Item) {
                modules.add((ModuleNode.Item)node);
                continue;
            }
            if (node.isLeaf()) continue;
            modules.addAll(ModuleNodeUtils.getCategoryModules(node));
        }
        return modules;
    }

    static Set<ModuleBean> getAllSelectedModuleBeans(Node[] nodes) {
        HashSet<ModuleBean> beans = new HashSet<ModuleBean>();
        for (Node node : nodes) {
            if (node instanceof ModuleNode.Item) {
                beans.add(((ModuleNode.Item)node).getItem());
                continue;
            }
            if (node.isLeaf()) continue;
            beans.addAll(ModuleNodeUtils.getAllSelectedModuleBeans(node.getChildren().getNodes(true)));
        }
        return beans;
    }

    static Boolean isEnableCandidate(Node[] nodes) {
        Boolean res = null;
        for (ModuleBean b : ModuleNodeUtils.getAllSelectedModuleBeans(nodes)) {
            if (res == null) {
                res = !b.isEnabled();
                continue;
            }
            if (res.booleanValue() != b.isEnabled()) continue;
            return null;
        }
        return res;
    }

    static boolean isEnableAllowed(Module m) {
        if (!m.isValid()) {
            return false;
        }
        return m.getProblems().isEmpty() && !m.isAutoload() && !m.isEager() && m.getJarFile() != null;
    }

    static String getUninstallActionName(Node[] activatedNodes, String oldName) {
        Set<ModuleNode.Item> items;
        if (activatedNodes == null || activatedNodes.length == 0) {
            return oldName;
        }
        String name = activatedNodes.length == 1 && !(activatedNodes[0] instanceof ModuleNode.Item) ? NbBundle.getMessage(ModuleNodeActions.class, (String)"CTL_ModuleNodeActions_UninstallAction", (Object)activatedNodes[0].getDisplayName()) : NbBundle.getMessage(ModuleNodeActions.class, (String)"CTL_ModuleNodeActions_UninstallAction", (Object)((items = ModuleNodeUtils.getAllSelectedModuleItems(activatedNodes)).size() > 1 ? NbBundle.getMessage(ModuleNodeActions.class, (String)"CTL_ModuleNodeActions_UninstallAction_many") : items.iterator().next().getDisplayName()));
        return name;
    }

    static boolean isUninstallAllowed(Module m) {
        return !m.isAutoload() && !m.isEager() && !m.isFixed();
    }

    static boolean canUninstall(Node[] activatedNodes) {
        if (activatedNodes == null || activatedNodes.length == 0) {
            return false;
        }
        Set<ModuleNode.Item> items = ModuleNodeUtils.getAllSelectedModuleItems(activatedNodes);
        if (items.isEmpty()) {
            return false;
        }
        for (ModuleNode.Item item : items) {
            if (item.canDestroy()) continue;
            return false;
        }
        return true;
    }

    static void doUninstall(final Node[] activatedNodes) {
        if (ModuleNodeUtils.confirmUninstall(activatedNodes)) {
            ModuleSelectionPanel.getGUI(false).setWaitingState(true, true);
            RequestProcessor.getDefault().post(new Runnable(){

                public void run() {
                    ModuleNodeUtils.uninstallNodes(activatedNodes);
                }
            });
        }
    }

    static boolean confirmUninstall(Node[] activatedNodes) {
        assert (activatedNodes != null) : "Any ModuleNode must be selected";
        Set<ModuleNode.Item> items = ModuleNodeUtils.getAllSelectedModuleItems(activatedNodes);
        assert (!items.isEmpty()) : "Any module must be selected";
        String category = null;
        if (activatedNodes.length == 1 && !(activatedNodes[0] instanceof ModuleNode.Item)) {
            category = activatedNodes[0].getDisplayName();
        }
        HashSet<Module> modules = new HashSet<Module>(items.size());
        for (ModuleNode.Item item : items) {
            modules.add(item.getItem().getModule());
        }
        ModuleUninstallPanel c = new ModuleUninstallPanel(modules, category);
        ((Component)c).getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ModuleSelectionPanel.class, (String)"ACD_ModuleUninstallPanel_form"));
        NotifyDescriptor.Confirmation nd = new NotifyDescriptor.Confirmation((Object)c, NbBundle.getMessage(ModuleSelectionPanel.class, (String)"CTL_ModuleUninstallPanel_UninstallConfirmation"), 0);
        return NotifyDescriptor.YES_OPTION.equals(DialogDisplayer.getDefault().notify((NotifyDescriptor)nd));
    }

    private static void uninstallNodes(Node[] nodes) {
        assert (nodes != null) : "uninstallNodes cannot be called on null nodes.";
        for (Node node : nodes) {
            if (node.isLeaf()) {
                ((ModuleNode.Item)node).uninstall();
                continue;
            }
            ModuleNodeUtils.uninstallNodes(node.getChildren().getNodes(true));
        }
    }
}

