/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.autoupdate.catalog;

import java.awt.BorderLayout;
import java.awt.Component;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.netbeans.Module;
import org.netbeans.ModuleManager;
import org.netbeans.modules.autoupdate.catalog.ModuleBean;
import org.netbeans.modules.autoupdate.catalog.ModulesAndDescription;
import org.openide.util.NbBundle;

class ModuleUninstallPanel
extends JPanel {
    Set modules;
    String category;
    private JPanel jPanel1;
    private JLabel uninstallConfirmation;

    public ModuleUninstallPanel(Set m, String category) {
        this.modules = m;
        this.category = category;
        this.initComponents();
        this.postInitComponents();
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.uninstallConfirmation = new JLabel();
        this.setLayout(new BorderLayout(0, 2));
        this.add((Component)this.jPanel1, "Center");
        this.uninstallConfirmation.setText(NbBundle.getMessage(ModuleUninstallPanel.class, (String)"LBL_ModuleUninstallPanel_UninstallConfirmation", (Object[])new Object[0]));
        this.add((Component)this.uninstallConfirmation, "South");
    }

    private String getModuleNames() {
        if (this.category != null) {
            return this.category;
        }
        return this.modules.size() == 1 ? ((Module)this.modules.iterator().next()).getDisplayName() : NbBundle.getMessage(ModuleUninstallPanel.class, (String)"CTL_ModuleNodeActions_UninstallAction_many");
    }

    private void postInitComponents() {
        HashSet<Module> disableCandidates = new HashSet<Module>();
        Iterator it = this.modules.iterator();
        ModuleManager manager = null;
        while (it.hasNext()) {
            Module module = (Module)it.next();
            if (manager == null) {
                manager = module.getManager();
            }
            if (!module.isEnabled() || module.isAutoload() || module.isEager()) continue;
            disableCandidates.add(module);
        }
        boolean simple = true;
        if (!disableCandidates.isEmpty()) {
            List toDisable = manager.simulateDisable(disableCandidates);
            Iterator it2 = toDisable.iterator();
            TreeSet<Module> others = new TreeSet<Module>(ModuleBean.AllModulesBean.getDefault());
            while (it2.hasNext()) {
                Module m = (Module)it2.next();
                if (m.isAutoload() || m.isEager() || this.modules.contains(m)) continue;
                others.add(m);
            }
            if (!others.isEmpty()) {
                ModulesAndDescription c = new ModulesAndDescription(others.toArray(new Module[others.size()]), NbBundle.getMessage(ModuleUninstallPanel.class, (String)"LBL_ModuleUninstallPanel_UninstallLabel_depend", (Object[])new Object[]{this.getModuleNames()}));
                this.add((Component)c, "Center");
                simple = false;
            }
        }
        if (simple) {
            JLabel uninstallLabel = new JLabel();
            if (this.category != null) {
                uninstallLabel.setText(NbBundle.getMessage(ModuleUninstallPanel.class, (String)"LBL_ModuleUninstallPanel_UninstallLabel_noDepend", (Object)this.category, (Object)NbBundle.getMessage(ModuleUninstallPanel.class, (String)"CTL_ModuleNodeActions_EnableDisableAction_category")));
            } else {
                uninstallLabel.setText(NbBundle.getMessage(ModuleUninstallPanel.class, (String)"LBL_ModuleUninstallPanel_UninstallLabel_noDepend", (Object)(this.modules.size() == 1 ? ((Module)this.modules.iterator().next()).getDisplayName() : String.valueOf(this.modules.size())), (Object)(this.modules.size() == 1 ? NbBundle.getMessage(ModuleUninstallPanel.class, (String)"CTL_ModuleNodeActions_EnableDisableAction_single") : NbBundle.getMessage(ModuleUninstallPanel.class, (String)"CTL_ModuleNodeActions_EnableDisableAction_many"))));
            }
            this.uninstallConfirmation.setVisible(false);
            this.add((Component)uninstallLabel, "Center");
        }
    }
}

