/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.java.queries;

import java.net.URL;
import java.util.Arrays;
import javax.swing.event.ChangeListener;
import org.netbeans.spi.java.queries.JavadocForBinaryQueryImplementation;
import org.openide.ErrorManager;
import org.openide.filesystems.FileUtil;
import org.openide.util.Lookup;

public class JavadocForBinaryQuery {
    private static final ErrorManager ERR = ErrorManager.getDefault().getInstance(JavadocForBinaryQuery.class.getName());
    private static final Lookup.Result<? extends JavadocForBinaryQueryImplementation> implementations = Lookup.getDefault().lookupResult(JavadocForBinaryQueryImplementation.class);
    private static final Result EMPTY_RESULT = new EmptyResult();

    private JavadocForBinaryQuery() {
    }

    public static Result findJavadoc(URL binary) {
        if (FileUtil.isArchiveFile((URL)binary)) {
            throw new IllegalArgumentException("File URL pointing to JAR is not valid classpath entry. Use jar: URL. Was: " + binary);
        }
        boolean log = ERR.isLoggable(1);
        if (log) {
            ERR.log("JFBQ.findJavadoc: " + binary);
        }
        for (JavadocForBinaryQueryImplementation impl : implementations.allInstances()) {
            Result r = impl.findJavadoc(binary);
            if (r != null) {
                if (log) {
                    ERR.log("  got result " + Arrays.asList(r.getRoots()) + " from " + impl);
                }
                return r;
            }
            if (!log) continue;
            ERR.log("  got no result from " + impl);
        }
        if (log) {
            ERR.log("  got no results from any impl");
        }
        return EMPTY_RESULT;
    }

    private static final class EmptyResult
    implements Result {
        private static final URL[] NO_ROOTS = new URL[0];

        EmptyResult() {
        }

        public URL[] getRoots() {
            return NO_ROOTS;
        }

        public void addChangeListener(ChangeListener l) {
        }

        public void removeChangeListener(ChangeListener l) {
        }
    }

    public static interface Result {
        public URL[] getRoots();

        public void addChangeListener(ChangeListener var1);

        public void removeChangeListener(ChangeListener var1);
    }
}

