/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.lexer;

import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.util.Map;
import java.util.WeakHashMap;
import org.netbeans.api.lexer.Language;
import org.netbeans.api.lexer.TokenId;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class LanguagePath {
    private static final LanguagePath EMPTY = new LanguagePath();
    private final Language<? extends TokenId>[] languages;
    private Map<Object, Reference<LanguagePath>> language2path;
    private String mimePath;

    public static LanguagePath get(Language<? extends TokenId> language) {
        return LanguagePath.get(null, language);
    }

    public static LanguagePath get(LanguagePath prefix, Language<? extends TokenId> language) {
        if (prefix == null) {
            prefix = EMPTY;
        }
        return prefix.embedded(language);
    }

    private LanguagePath(LanguagePath prefix, Language<? extends TokenId> language) {
        int prefixSize = prefix.size();
        this.languages = this.allocateLanguageArray(prefixSize + 1);
        System.arraycopy(prefix.languages, 0, this.languages, 0, prefixSize);
        this.languages[prefixSize] = language;
    }

    private LanguagePath() {
        this.languages = this.allocateLanguageArray(0);
    }

    public int size() {
        return this.languages.length;
    }

    public Language<? extends TokenId> language(int index) {
        return this.languages[index];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LanguagePath embedded(Language<? extends TokenId> language) {
        if (language == null) {
            throw new IllegalArgumentException("language cannot be null");
        }
        Language<? extends TokenId>[] languageArray = this.languages;
        synchronized (this.languages) {
            LanguagePath lp;
            this.initLanguage2path();
            Reference<LanguagePath> lpRef = this.language2path.get(language);
            if (lpRef == null || (lp = lpRef.get()) == null) {
                lp = new LanguagePath(this, language);
                this.language2path.put(language, new SoftReference<LanguagePath>(lp));
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return lp;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LanguagePath embedded(LanguagePath suffix) {
        if (suffix == null) {
            throw new IllegalArgumentException("suffix cannot be null");
        }
        Language<? extends TokenId>[] languageArray = this.languages;
        synchronized (this.languages) {
            LanguagePath lp;
            this.initLanguage2path();
            Reference<LanguagePath> lpRef = this.language2path.get(suffix);
            if (lpRef == null || (lp = lpRef.get()) == null) {
                lp = this;
                for (int i = 0; i < suffix.size(); ++i) {
                    lp = lp.embedded(suffix.language(i));
                }
                this.language2path.put(suffix, new SoftReference<LanguagePath>(lp));
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return lp;
        }
    }

    public boolean isLanguage(int index, Language<? extends TokenId> language) {
        return this.language(index) == language;
    }

    public Language<? extends TokenId> topLanguage() {
        return this.language(0);
    }

    public boolean isTopLanguage(Language<? extends TokenId> language) {
        return this.topLanguage() == language;
    }

    public Language<? extends TokenId> innerLanguage() {
        return this.language(this.size() - 1);
    }

    public boolean isInnerLanguage(Language<? extends TokenId> language) {
        return this.innerLanguage() == language;
    }

    public boolean endsWith(LanguagePath languagePath) {
        if (languagePath == this || languagePath == EMPTY) {
            return true;
        }
        int lpSize = languagePath.size();
        if (lpSize <= this.size()) {
            for (int i = 1; i <= lpSize; ++i) {
                if (this.language(this.size() - i) == languagePath.language(lpSize - i)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public LanguagePath subPath(int startIndex) {
        return this.subPath(startIndex, this.size());
    }

    public LanguagePath subPath(int startIndex, int endIndex) {
        if (startIndex < 0) {
            throw new IndexOutOfBoundsException("startIndex=" + startIndex + " < 0");
        }
        if (endIndex > this.size()) {
            throw new IndexOutOfBoundsException("endIndex=" + endIndex + " > size()=" + this.size());
        }
        if (startIndex >= endIndex) {
            throw new IndexOutOfBoundsException("startIndex=" + startIndex + " >= endIndex=" + endIndex);
        }
        if (startIndex == 0 && endIndex == this.size()) {
            return this;
        }
        LanguagePath lp = LanguagePath.get(this.language(startIndex++));
        while (startIndex < endIndex) {
            lp = LanguagePath.get(lp, this.language(startIndex++));
        }
        return lp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String mimePath() {
        Language<? extends TokenId>[] languageArray = this.languages;
        synchronized (this.languages) {
            if (this.mimePath == null) {
                StringBuilder sb = new StringBuilder(15 * this.languages.length);
                for (Language<? extends TokenId> language : this.languages) {
                    if (sb.length() > 0) {
                        sb.append('/');
                    }
                    sb.append(language.mimeType());
                }
                this.mimePath = sb.toString().intern();
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.mimePath;
        }
    }

    private void initLanguage2path() {
        if (this.language2path == null) {
            this.language2path = new WeakHashMap<Object, Reference<LanguagePath>>();
        }
    }

    private Language<? extends TokenId>[] allocateLanguageArray(int length) {
        return new Language[length];
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("LanguagePath: size=");
        sb.append(this.size());
        sb.append('\n');
        for (int i = 0; i < this.size(); ++i) {
            sb.append('[').append(i).append("]: ");
            sb.append(this.language(i)).append('\n');
        }
        return sb.toString();
    }
}

