/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.lexer;

import org.netbeans.api.lexer.Language;
import org.netbeans.api.lexer.LanguagePath;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.lib.lexer.LexerUtilsConstants;
import org.netbeans.lib.lexer.inc.RemovedTokenList;
import org.netbeans.lib.lexer.inc.TokenChangeInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TokenChange<T extends TokenId> {
    private final TokenChangeInfo<T> info;

    TokenChange(TokenChangeInfo<T> info) {
        this.info = info;
    }

    public int embeddedChangeCount() {
        return this.info.embeddedChanges().length;
    }

    public TokenChange<? extends TokenId> embeddedChange(int index) {
        return this.info.embeddedChanges()[index];
    }

    public <T extends TokenId> TokenChange<T> embeddedChange(Language<T> language) {
        TokenChange<TokenId>[] ecs = this.info.embeddedChanges();
        for (int i = ecs.length - 1; i >= 0; --i) {
            TokenChange<TokenId> c = ecs[i];
            if (c.language() != language) continue;
            TokenChange<TokenId> ec = c;
            return ec;
        }
        return null;
    }

    public Language<T> language() {
        return LexerUtilsConstants.mostEmbeddedLanguage(this.languagePath());
    }

    public LanguagePath languagePath() {
        return this.info.currentTokenList().languagePath();
    }

    public int index() {
        return this.info.index();
    }

    public int offset() {
        return this.info.offset();
    }

    public int removedTokenCount() {
        RemovedTokenList<T> rtl = this.info.removedTokenList();
        return rtl != null ? rtl.tokenCount() : 0;
    }

    public TokenSequence<T> removedTokenSequence() {
        return new TokenSequence<T>(this.info.removedTokenList());
    }

    public int addedTokenCount() {
        return this.info.addedTokenCount();
    }

    public TokenSequence<T> currentTokenSequence() {
        TokenSequence<T> ts = new TokenSequence<T>(this.info.currentTokenList());
        ts.moveIndex(this.index());
        return ts;
    }

    public boolean isBoundsChange() {
        return this.info.isBoundsChange();
    }

    TokenChangeInfo<T> info() {
        return this.info;
    }
}

