/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.lexer;

import java.io.Reader;
import java.util.List;
import java.util.Set;
import javax.swing.text.Document;
import org.netbeans.api.lexer.InputAttributes;
import org.netbeans.api.lexer.Language;
import org.netbeans.api.lexer.LanguagePath;
import org.netbeans.api.lexer.TokenHierarchyListener;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.lib.lexer.TokenHierarchyOperation;
import org.netbeans.lib.lexer.TokenList;
import org.netbeans.lib.lexer.TokenListList;
import org.netbeans.lib.lexer.inc.DocumentInput;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TokenHierarchy<I> {
    private TokenHierarchyOperation<I, ?> operation;

    public static <D extends Document> TokenHierarchy<D> get(D doc) {
        DocumentInput<D> di = DocumentInput.get(doc);
        return di.tokenHierarchyControl().tokenHierarchy();
    }

    public static TokenHierarchy<Void> create(CharSequence inputText, Language<? extends TokenId> language) {
        return TokenHierarchy.create(inputText, false, language, null, null);
    }

    public static <T extends TokenId> TokenHierarchy<Void> create(CharSequence inputText, boolean copyInputText, Language<T> language, Set<T> skipTokenIds, InputAttributes inputAttributes) {
        return new TokenHierarchyOperation(inputText, copyInputText, language, skipTokenIds, inputAttributes).tokenHierarchy();
    }

    public static <T extends TokenId> TokenHierarchy<Void> create(Reader inputReader, Language<T> language, Set<T> skipTokenIds, InputAttributes inputAttributes) {
        return new TokenHierarchyOperation(inputReader, language, skipTokenIds, inputAttributes).tokenHierarchy();
    }

    TokenHierarchy(TokenHierarchyOperation<I, ?> operation) {
        this.operation = operation;
    }

    public TokenSequence<? extends TokenId> tokenSequence() {
        TokenSequence ts = new TokenSequence(this.operation.checkedTokenList());
        return ts;
    }

    public <T extends TokenId> TokenSequence<T> tokenSequence(Language<T> language) {
        TokenList<?> tokenList = this.operation.checkedTokenList();
        TokenSequence ts = tokenList.languagePath().topLanguage() == language ? new TokenSequence(tokenList) : null;
        return ts;
    }

    public List<TokenSequence<? extends TokenId>> tokenSequenceList(LanguagePath languagePath, int startOffset, int endOffset) {
        return TokenListList.createTokenSequenceList(this.operation, languagePath, startOffset, endOffset);
    }

    public Set<LanguagePath> languagePaths() {
        return this.operation.languagePaths();
    }

    public boolean isMutable() {
        return this.operation.isMutable();
    }

    public I mutableInputSource() {
        return this.operation.mutableInputSource();
    }

    public boolean isActive() {
        return this.operation.isActive();
    }

    public void addTokenHierarchyListener(TokenHierarchyListener listener) {
        this.operation.addTokenHierarchyListener(listener);
    }

    public void removeTokenHierarchyListener(TokenHierarchyListener listener) {
        this.operation.removeTokenHierarchyListener(listener);
    }

    public TokenHierarchy<I> createSnapshot() {
        return this.operation.createSnapshot();
    }

    public boolean isSnapshot() {
        return this.operation.isSnapshot();
    }

    public void snapshotRelease() {
        this.operation.snapshotRelease();
    }

    public boolean isSnapshotReleased() {
        return this.operation.isSnapshotReleased();
    }

    public TokenHierarchy<I> snapshotOf() {
        return this.operation.snapshotOf();
    }

    public int tokenShiftStartOffset() {
        return this.operation.tokenShiftStartOffset();
    }

    public int tokenShiftEndOffset() {
        return this.operation.tokenShiftEndOffset();
    }

    TokenHierarchyOperation<I, ?> operation() {
        return this.operation;
    }
}

