/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.lexer;

import java.util.ConcurrentModificationException;
import org.netbeans.api.lexer.Language;
import org.netbeans.api.lexer.LanguagePath;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.lib.lexer.EmbeddingContainer;
import org.netbeans.lib.lexer.LexerUtilsConstants;
import org.netbeans.lib.lexer.SubSequenceTokenList;
import org.netbeans.lib.lexer.TokenList;
import org.netbeans.lib.lexer.token.AbstractToken;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TokenSequence<T extends TokenId> {
    private TokenList<T> tokenList;
    private AbstractToken<T> token;
    private int tokenIndex;
    private int tokenOffset = -1;
    private final int modCount;
    private int[] parentTokenIndexes;

    TokenSequence(TokenList<T> tokenList) {
        this.tokenList = tokenList;
        this.modCount = tokenList.modCount();
    }

    public Language<T> language() {
        return LexerUtilsConstants.mostEmbeddedLanguage(this.languagePath());
    }

    public LanguagePath languagePath() {
        return this.tokenList.languagePath();
    }

    public Token<T> token() {
        return this.token;
    }

    public Token<T> offsetToken() {
        this.checkTokenNotNull();
        if (this.token.isFlyweight()) {
            this.token = this.tokenList.replaceFlyToken(this.tokenIndex, this.token, this.offset());
        }
        return this.token;
    }

    public int offset() {
        this.checkTokenNotNull();
        if (this.tokenOffset == -1) {
            this.tokenOffset = this.tokenList.tokenOffset(this.tokenIndex);
        }
        return this.tokenOffset;
    }

    public int index() {
        return this.tokenIndex;
    }

    public TokenSequence<? extends TokenId> embedded() {
        this.checkTokenNotNull();
        return this.embeddedImpl(null);
    }

    private <ET extends TokenId> TokenSequence<ET> embeddedImpl(Language<ET> embeddedLanguage) {
        TokenList<ET> embeddedTokenList = LexerUtilsConstants.embeddedTokenList(this.tokenList, this.tokenIndex, embeddedLanguage);
        return embeddedTokenList != null ? new TokenSequence<ET>(embeddedTokenList) : null;
    }

    public <ET extends TokenId> TokenSequence<ET> embedded(Language<ET> embeddedLanguage) {
        this.checkTokenNotNull();
        return this.embeddedImpl(embeddedLanguage);
    }

    public boolean createEmbedding(Language<? extends TokenId> embeddedLanguage, int startSkipLength, int endSkipLength) {
        return this.createEmbedding(embeddedLanguage, startSkipLength, endSkipLength, false);
    }

    public boolean createEmbedding(Language<? extends TokenId> embeddedLanguage, int startSkipLength, int endSkipLength, boolean joinSections) {
        this.checkTokenNotNull();
        return EmbeddingContainer.createEmbedding(this.tokenList, this.tokenIndex, embeddedLanguage, startSkipLength, endSkipLength, joinSections);
    }

    public boolean moveNext() {
        Object tokenOrEmbeddingContainer;
        this.checkModCount();
        if (this.token != null) {
            ++this.tokenIndex;
        }
        if ((tokenOrEmbeddingContainer = this.tokenList.tokenOrEmbeddingContainer(this.tokenIndex)) != null) {
            AbstractToken<T> origToken = this.token;
            this.token = LexerUtilsConstants.token(tokenOrEmbeddingContainer);
            if (this.tokenOffset != -1) {
                this.tokenOffset = origToken != null ? (this.tokenList.isContinuous() || this.token.isFlyweight() ? (this.tokenOffset += origToken.length()) : -1) : -1;
            }
            return true;
        }
        if (this.token != null) {
            --this.tokenIndex;
        }
        return false;
    }

    public boolean movePrevious() {
        this.checkModCount();
        if (this.tokenIndex > 0) {
            AbstractToken<T> origToken = this.token;
            --this.tokenIndex;
            this.token = LexerUtilsConstants.token(this.tokenList.tokenOrEmbeddingContainer(this.tokenIndex));
            if (this.tokenOffset != -1) {
                this.tokenOffset = this.tokenList.isContinuous() || origToken.isFlyweight() ? (this.tokenOffset -= this.token.length()) : -1;
            }
            return true;
        }
        return false;
    }

    public int moveIndex(int index) {
        this.checkModCount();
        if (index >= 0) {
            Object tokenOrEmbeddingContainer = this.tokenList.tokenOrEmbeddingContainer(index);
            if (tokenOrEmbeddingContainer != null) {
                this.resetTokenIndex(index);
            } else {
                this.resetTokenIndex(this.tokenCount());
            }
        } else {
            this.resetTokenIndex(0);
        }
        return index - this.tokenIndex;
    }

    public void moveStart() {
        this.moveIndex(0);
    }

    public void moveEnd() {
        this.moveIndex(this.tokenCount());
    }

    public int move(int offset) {
        int prevTokenOffset;
        this.checkModCount();
        int tokenCount = this.tokenList.tokenCountCurrent();
        if (tokenCount == 0) {
            if (this.tokenList.tokenOrEmbeddingContainer(0) == null) {
                this.resetTokenIndex(0);
                return offset;
            }
            tokenCount = this.tokenList.tokenCountCurrent();
        }
        if (offset > (prevTokenOffset = this.tokenList.tokenOffset(tokenCount - 1))) {
            int tokenLength = LexerUtilsConstants.token(this.tokenList, tokenCount - 1).length();
            while (offset >= prevTokenOffset + tokenLength) {
                Object tokenOrEmbeddingContainer = this.tokenList.tokenOrEmbeddingContainer(tokenCount);
                if (tokenOrEmbeddingContainer != null) {
                    AbstractToken t = LexerUtilsConstants.token(tokenOrEmbeddingContainer);
                    prevTokenOffset = t.isFlyweight() ? (prevTokenOffset += tokenLength) : this.tokenList.tokenOffset(tokenCount);
                    tokenLength = t.length();
                    ++tokenCount;
                    continue;
                }
                this.resetTokenIndex(tokenCount);
                this.tokenOffset = prevTokenOffset + tokenLength;
                return offset - this.tokenOffset;
            }
            this.resetTokenIndex(tokenCount - 1);
            this.tokenOffset = prevTokenOffset;
            return offset - prevTokenOffset;
        }
        int low = 0;
        int high = tokenCount - 1;
        while (low <= high) {
            int mid = (low + high) / 2;
            int midStartOffset = this.tokenList.tokenOffset(mid);
            if (midStartOffset < offset) {
                low = mid + 1;
                continue;
            }
            if (midStartOffset > offset) {
                high = mid - 1;
                continue;
            }
            this.resetTokenIndex(mid);
            this.tokenOffset = midStartOffset;
            return 0;
        }
        if (high >= 0) {
            AbstractToken<T> t = LexerUtilsConstants.token(this.tokenList, high);
            prevTokenOffset = this.tokenList.tokenOffset(high);
            if (!this.tokenList.isContinuous() && offset > prevTokenOffset + t.length()) {
                ++high;
                prevTokenOffset += t.length();
            }
        } else {
            high = 0;
            prevTokenOffset = this.tokenList.tokenOffset(0);
        }
        this.resetTokenIndex(high);
        this.tokenOffset = prevTokenOffset;
        return offset - prevTokenOffset;
    }

    public boolean isEmpty() {
        return this.tokenIndex == 0 && this.tokenList.tokenOrEmbeddingContainer(0) == null;
    }

    public int tokenCount() {
        this.checkModCount();
        return this.tokenList.tokenCount();
    }

    public TokenSequence<T> subSequence(int startOffset) {
        return this.subSequence(startOffset, Integer.MAX_VALUE);
    }

    public TokenSequence<T> subSequence(int startOffset, int endOffset) {
        TokenList<T> tl;
        this.checkModCount();
        if (this.tokenList.getClass() == SubSequenceTokenList.class) {
            SubSequenceTokenList stl = (SubSequenceTokenList)this.tokenList;
            tl = stl.delegate();
            startOffset = Math.max(startOffset, stl.limitStartOffset());
            endOffset = Math.min(endOffset, stl.limitEndOffset());
        } else {
            tl = this.tokenList;
        }
        return new TokenSequence<T>(new SubSequenceTokenList<T>(tl, startOffset, endOffset));
    }

    public String toString() {
        return LexerUtilsConstants.appendTokenList(null, this.tokenList, this.tokenIndex).toString();
    }

    int[] parentTokenIndexes() {
        return this.parentTokenIndexes;
    }

    private void resetTokenIndex(int index) {
        this.tokenIndex = index;
        this.token = null;
        this.tokenOffset = -1;
    }

    private void checkTokenNotNull() {
        if (this.token == null) {
            throw new IllegalStateException("Caller of TokenSequence forgot to call moveNext(): tokenIndex=" + this.tokenIndex);
        }
    }

    private void checkModCount() {
        if (this.tokenList.modCount() != this.modCount) {
            throw new ConcurrentModificationException("Caller uses token sequence which is no longer valid. Underlying token hierarchy has been modified: " + this.modCount + " != " + this.tokenList.modCount());
        }
    }
}

