/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.lexer;

import java.util.List;
import java.util.Set;
import org.netbeans.api.lexer.InputAttributes;
import org.netbeans.api.lexer.LanguagePath;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.lib.editor.util.FlyOffsetGapList;
import org.netbeans.lib.lexer.EmbeddingContainer;
import org.netbeans.lib.lexer.LAState;
import org.netbeans.lib.lexer.LexerInputOperation;
import org.netbeans.lib.lexer.LexerUtilsConstants;
import org.netbeans.lib.lexer.TextLexerInputOperation;
import org.netbeans.lib.lexer.TokenHierarchyOperation;
import org.netbeans.lib.lexer.TokenList;
import org.netbeans.lib.lexer.inc.MutableTokenList;
import org.netbeans.lib.lexer.inc.TokenHierarchyEventInfo;
import org.netbeans.lib.lexer.inc.TokenListChange;
import org.netbeans.lib.lexer.token.AbstractToken;
import org.netbeans.lib.lexer.token.TextToken;
import org.netbeans.spi.lexer.LanguageEmbedding;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class EmbeddedTokenList<T extends TokenId>
extends FlyOffsetGapList<Object>
implements MutableTokenList<T> {
    private static final boolean testing = Boolean.getBoolean("netbeans.debug.lexer.test");
    private EmbeddingContainer<? extends TokenId> embeddingContainer;
    private final LanguageEmbedding<T> embedding;
    private final LanguagePath languagePath;
    private LAState laState;
    private EmbeddedTokenList<? extends TokenId> nextEmbeddedTokenList;

    public EmbeddedTokenList(EmbeddingContainer<? extends TokenId> embeddingContainer, LanguagePath languagePath, LanguageEmbedding<T> embedding, EmbeddedTokenList<? extends TokenId> nextEmbedding) {
        this.embeddingContainer = embeddingContainer;
        this.languagePath = languagePath;
        this.embedding = embedding;
        this.nextEmbeddedTokenList = nextEmbedding;
        if (this.modCount() != -1 || testing) {
            this.laState = LAState.empty();
        }
        this.init();
    }

    private void init() {
        LexerInputOperation<T> lexerInputOperation = this.createLexerInputOperation(0, this.startOffset(), null);
        AbstractToken<T> token = lexerInputOperation.nextToken();
        while (token != null) {
            this.updateElementOffsetAdd(token);
            this.add(token);
            if (this.laState != null) {
                this.laState = this.laState.add(lexerInputOperation.lookahead(), lexerInputOperation.lexerState());
            }
            token = lexerInputOperation.nextToken();
        }
        lexerInputOperation.release();
        lexerInputOperation = null;
        this.trimToSize();
        if (this.laState != null) {
            this.laState.trimToSize();
        }
    }

    EmbeddedTokenList<? extends TokenId> nextEmbeddedTokenList() {
        return this.nextEmbeddedTokenList;
    }

    void setNextEmbeddedTokenList(EmbeddedTokenList<? extends TokenId> nextEmbeddedTokenList) {
        this.nextEmbeddedTokenList = nextEmbeddedTokenList;
    }

    @Override
    public LanguagePath languagePath() {
        return this.languagePath;
    }

    public LanguageEmbedding embedding() {
        return this.embedding;
    }

    @Override
    public int tokenCount() {
        return this.size();
    }

    @Override
    public synchronized Object tokenOrEmbeddingContainer(int index) {
        return index < this.size() ? this.get(index) : null;
    }

    private Token existingToken(int index) {
        return LexerUtilsConstants.token(this.tokenOrEmbeddingContainer(index));
    }

    @Override
    public int lookahead(int index) {
        return this.laState != null ? this.laState.lookahead(index) : -1;
    }

    @Override
    public Object state(int index) {
        return this.laState != null ? this.laState.state(index) : null;
    }

    @Override
    public int tokenOffset(int index) {
        return this.elementOffset(index);
    }

    @Override
    public int childTokenOffset(int rawOffset) {
        this.embeddingContainer.updateStatus();
        return this.embeddingContainer.tokenStartOffset() + this.embedding.startSkipLength() + this.childTokenRelOffset(rawOffset);
    }

    public int childTokenOffsetShift(int rawOffset) {
        this.updateStatus();
        return this.embeddingContainer.rootTokenOffsetShift() + this.childTokenRelOffset(rawOffset);
    }

    private int childTokenRelOffset(int rawOffset) {
        return rawOffset < this.offsetGapStart() ? rawOffset : rawOffset - this.offsetGapLength();
    }

    @Override
    public char childTokenCharAt(int rawOffset, int index) {
        return this.embeddingContainer.charAt(this.embedding.startSkipLength() + this.childTokenRelOffset(rawOffset) + index);
    }

    @Override
    public int modCount() {
        return this.root().modCount();
    }

    @Override
    public int startOffset() {
        return this.embeddingContainer.tokenStartOffset() + this.embedding.startSkipLength();
    }

    public boolean updateStatus() {
        return this.embeddingContainer.updateStatus();
    }

    @Override
    public int endOffset() {
        return this.embeddingContainer.tokenStartOffset() + this.embeddingContainer.token().length() - this.embedding.endSkipLength();
    }

    @Override
    public TokenList<? extends TokenId> root() {
        return this.embeddingContainer.rootTokenList();
    }

    @Override
    public TokenHierarchyOperation<?, ? extends TokenId> tokenHierarchyOperation() {
        return this.root().tokenHierarchyOperation();
    }

    public AbstractToken<? extends TokenId> rootToken() {
        return this.embeddingContainer.rootToken();
    }

    protected int elementRawOffset(Object elem) {
        return elem.getClass() == EmbeddingContainer.class ? ((EmbeddingContainer)elem).token().rawOffset() : ((AbstractToken)elem).rawOffset();
    }

    protected void setElementRawOffset(Object elem, int rawOffset) {
        if (elem.getClass() == EmbeddingContainer.class) {
            ((EmbeddingContainer)elem).token().setRawOffset(rawOffset);
        } else {
            ((AbstractToken)elem).setRawOffset(rawOffset);
        }
    }

    protected boolean isElementFlyweight(Object elem) {
        return elem.getClass() != EmbeddingContainer.class && ((AbstractToken)elem).isFlyweight();
    }

    protected int elementLength(Object elem) {
        return LexerUtilsConstants.token(elem).length();
    }

    @Override
    public synchronized AbstractToken<T> replaceFlyToken(int index, AbstractToken<T> flyToken, int offset) {
        TextToken nonFlyToken = ((TextToken)flyToken).createCopy(this, this.offset2Raw(offset));
        this.set(index, nonFlyToken);
        return nonFlyToken;
    }

    @Override
    public synchronized void wrapToken(int index, EmbeddingContainer embeddingContainer) {
        this.set(index, embeddingContainer);
    }

    @Override
    public InputAttributes inputAttributes() {
        return this.root().inputAttributes();
    }

    @Override
    public Object tokenOrEmbeddingContainerUnsync(int index) {
        return this.get(index);
    }

    @Override
    public int tokenCountCurrent() {
        return this.size();
    }

    @Override
    public LexerInputOperation<T> createLexerInputOperation(int tokenIndex, int relexOffset, Object relexState) {
        CharSequence tokenText = this.embeddingContainer.token().text();
        int tokenStartOffset = this.embeddingContainer.tokenStartOffset();
        int endOffset = tokenStartOffset + tokenText.length() - this.embedding.endSkipLength();
        return new TextLexerInputOperation(this, tokenIndex, relexState, tokenText, tokenStartOffset, relexOffset, endOffset);
    }

    @Override
    public boolean isFullyLexed() {
        return true;
    }

    @Override
    public void replaceTokens(TokenHierarchyEventInfo eventInfo, TokenListChange<T> change, int removeTokenCount) {
        int index = change.index();
        Object[] removedTokensOrEmbeddingContainers = new Object[removeTokenCount];
        this.copyElements(index, index + removeTokenCount, removedTokensOrEmbeddingContainers, 0);
        int offset = change.offset();
        for (int i = 0; i < removeTokenCount; ++i) {
            Object tokenOrEmbeddingContainer = removedTokensOrEmbeddingContainers[i];
            AbstractToken token = LexerUtilsConstants.token(tokenOrEmbeddingContainer);
            if (!token.isFlyweight()) {
                this.updateElementOffsetRemove(token);
                token.setTokenList(null);
            }
            offset += token.length();
        }
        this.remove(index, removeTokenCount);
        this.laState.remove(index, removeTokenCount);
        change.setRemovedTokens(removedTokensOrEmbeddingContainers);
        change.setRemovedEndOffset(offset);
        int startOffset = this.startOffset();
        int diffLength = eventInfo.insertedLength() - eventInfo.removedLength();
        if (this.offsetGapStart() != change.offset() - startOffset) {
            this.moveOffsetGap(change.offset() - startOffset, Math.min(index, change.offsetGapIndex()));
        }
        this.updateOffsetGapLength(-diffLength);
        List<Object> addedTokensOrBranches = change.addedTokensOrBranches();
        if (addedTokensOrBranches != null) {
            Object id;
            for (Object tokenOrBranch : addedTokensOrBranches) {
                AbstractToken token = (AbstractToken)tokenOrBranch;
                this.updateElementOffsetAdd(token);
            }
            this.addAll(index, addedTokensOrBranches);
            this.laState = this.laState.addAll(index, change.laState());
            change.syncAddedTokenCount();
            if (removeTokenCount == 1 && addedTokensOrBranches.size() == 1 && (id = LexerUtilsConstants.token(removedTokensOrEmbeddingContainers[0]).id()) == change.addedToken(0).id()) {
                change.markBoundsChange();
            }
        }
    }

    @Override
    public boolean isContinuous() {
        return true;
    }

    @Override
    public Set<T> skipTokenIds() {
        return null;
    }

    public EmbeddingContainer embeddingContainer() {
        return this.embeddingContainer;
    }

    public void setEmbeddingContainer(EmbeddingContainer<? extends TokenId> embeddingContainer) {
        this.embeddingContainer = embeddingContainer;
    }

    public String toString() {
        return LexerUtilsConstants.appendTokenList(null, this, -1).toString();
    }
}

