/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.lexer;

import org.netbeans.api.lexer.Language;
import org.netbeans.api.lexer.LanguagePath;
import org.netbeans.api.lexer.TokenHierarchyEventType;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.lib.lexer.EmbeddedTokenList;
import org.netbeans.lib.lexer.LexerApiPackageAccessor;
import org.netbeans.lib.lexer.LexerUtilsConstants;
import org.netbeans.lib.lexer.TokenHierarchyOperation;
import org.netbeans.lib.lexer.TokenList;
import org.netbeans.lib.lexer.inc.TokenChangeInfo;
import org.netbeans.lib.lexer.inc.TokenHierarchyEventInfo;
import org.netbeans.lib.lexer.token.AbstractToken;
import org.netbeans.spi.lexer.LanguageEmbedding;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class EmbeddingContainer<T extends TokenId> {
    private static final boolean testing = Boolean.getBoolean("netbeans.debug.lexer.test");
    private final AbstractToken<T> token;
    private int cachedModCount;
    private final TokenList<? extends TokenId> rootTokenList;
    private AbstractToken<? extends TokenId> rootToken;
    private int tokenStartOffset;
    private EmbeddedTokenList<? extends TokenId> firstEmbeddedTokenList;
    private int rootTokenOffsetShift;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T extends TokenId, ET extends TokenId> EmbeddedTokenList<ET> getEmbedding(TokenList<T> tokenList, int index, Language<ET> language) {
        EmbeddedTokenList<TokenId> lastEtl = null;
        TokenList<TokenId> tokenList2 = tokenList.root();
        synchronized (tokenList2) {
            AbstractToken<T> token;
            EmbeddingContainer<T> ec;
            Object tokenOrEmbeddingContainer = tokenList.tokenOrEmbeddingContainer(index);
            if (tokenOrEmbeddingContainer.getClass() == EmbeddingContainer.class) {
                EmbeddingContainer<T> ecUC;
                ec = ecUC = (EmbeddingContainer<T>)tokenOrEmbeddingContainer;
                ec.updateStatus();
                for (EmbeddedTokenList<TokenId> etl = ec.firstEmbeddedTokenList(); etl != null; etl = etl.nextEmbeddedTokenList()) {
                    if (language == null || etl.languagePath().innerLanguage() == language) {
                        EmbeddedTokenList<TokenId> etlUC = etl;
                        return etlUC;
                    }
                    lastEtl = etl;
                }
                token = ec.token();
            } else {
                ec = null;
                AbstractToken<T> t = (AbstractToken<T>)tokenOrEmbeddingContainer;
                token = t;
                if (token.isFlyweight()) {
                    return null;
                }
            }
            LanguagePath languagePath = tokenList.languagePath();
            LanguageEmbedding<TokenId> embedding = LexerUtilsConstants.findEmbedding(token, languagePath, tokenList.inputAttributes());
            if (embedding != null && (language == null || language == embedding.language()) && embedding.startSkipLength() + embedding.endSkipLength() <= token.length()) {
                if (ec == null) {
                    ec = new EmbeddingContainer<T>(token);
                    tokenList.wrapToken(index, ec);
                }
                LanguagePath embeddedLanguagePath = LanguagePath.get(languagePath, embedding.language());
                EmbeddedTokenList<TokenId> etl = new EmbeddedTokenList<TokenId>(ec, embeddedLanguagePath, embedding, null);
                if (lastEtl != null) {
                    lastEtl.setNextEmbeddedTokenList(etl);
                } else {
                    ec.setFirstEmbeddedTokenList(etl);
                }
                return etl;
            }
            return null;
        }
    }

    public static EmbeddedTokenList<? extends TokenId> getEmbeddingIfExists(Object tokenOrEmbeddingContainer) {
        if (tokenOrEmbeddingContainer.getClass() == EmbeddingContainer.class) {
            EmbeddingContainer ec = (EmbeddingContainer)tokenOrEmbeddingContainer;
            ec.updateStatus();
            EmbeddedTokenList<TokenId> etl = ec.firstEmbeddedTokenList();
            return etl;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T extends TokenId, ET extends TokenId> boolean createEmbedding(TokenList<T> tokenList, int index, Language<ET> embeddedLanguage, int startSkipLength, int endSkipLength, boolean joinSections) {
        EmbeddedTokenList<ET> etl;
        LanguageEmbedding<ET> embedding;
        AbstractToken<T> token;
        TokenList<TokenId> etl2;
        EmbeddingContainer<T> ec;
        TokenHierarchyOperation<?, TokenId> tokenHierarchyOperation = tokenList.tokenHierarchyOperation();
        if (tokenHierarchyOperation == null) {
            return false;
        }
        TokenList<TokenId> root = tokenList.root();
        Object tokenOrEmbeddingContainer = tokenList.tokenOrEmbeddingContainer(index);
        TokenList<TokenId> tokenList2 = root;
        synchronized (tokenList2) {
            if (tokenOrEmbeddingContainer.getClass() == EmbeddingContainer.class) {
                EmbeddingContainer<T> ecUC;
                ec = ecUC = (EmbeddingContainer<T>)tokenOrEmbeddingContainer;
                for (etl2 = ec.firstEmbeddedTokenList(); etl2 != null; etl2 = etl2.nextEmbeddedTokenList()) {
                    if (embeddedLanguage != etl2.languagePath().innerLanguage()) continue;
                    return false;
                }
                token = ec.token();
            } else {
                AbstractToken<T> t = (AbstractToken<T>)tokenOrEmbeddingContainer;
                token = t;
                if (token.isFlyweight()) {
                    return false;
                }
                ec = new EmbeddingContainer<T>(token);
                tokenList.wrapToken(index, ec);
            }
        }
        etl2 = root;
        synchronized (etl2) {
            if (startSkipLength + endSkipLength > token.length()) {
                return false;
            }
            embedding = LanguageEmbedding.create(embeddedLanguage, startSkipLength, endSkipLength, joinSections);
            LanguagePath languagePath = tokenList.languagePath();
            LanguagePath embeddedLanguagePath = LanguagePath.get(languagePath, embeddedLanguage);
            etl = new EmbeddedTokenList<ET>(ec, embeddedLanguagePath, embedding, ec.firstEmbeddedTokenList());
            ec.setFirstEmbeddedTokenList(etl);
        }
        int aOffset = ec.tokenStartOffset();
        TokenHierarchyEventInfo eventInfo = new TokenHierarchyEventInfo(tokenHierarchyOperation, TokenHierarchyEventType.EMBEDDING, aOffset, 0, "", 0);
        eventInfo.setAffectedStartOffset(aOffset);
        eventInfo.setAffectedEndOffset(aOffset + token.length());
        TokenChangeInfo<T> info = new TokenChangeInfo<T>(tokenList);
        info.setIndex(index);
        info.setOffset(aOffset);
        eventInfo.setTokenChangeInfo(info);
        TokenChangeInfo<ET> embeddedInfo = new TokenChangeInfo<ET>(etl);
        embeddedInfo.setIndex(0);
        embeddedInfo.setOffset(aOffset + embedding.startSkipLength());
        info.addEmbeddedChange(embeddedInfo);
        tokenHierarchyOperation.fireTokenHierarchyChanged(LexerApiPackageAccessor.get().createTokenChangeEvent(eventInfo));
        return true;
    }

    public EmbeddingContainer(AbstractToken<T> token) {
        this.token = token;
        TokenList<T> embeddedTokenList = token.tokenList();
        this.rootTokenList = embeddedTokenList.root();
        this.rootToken = embeddedTokenList.getClass() == EmbeddedTokenList.class ? ((EmbeddedTokenList)embeddedTokenList).rootToken() : token;
        this.cachedModCount = -3;
        this.updateStatus();
    }

    public AbstractToken<T> token() {
        return this.token;
    }

    public TokenList<? extends TokenId> rootTokenList() {
        return this.rootTokenList;
    }

    public AbstractToken<? extends TokenId> rootToken() {
        return this.rootToken;
    }

    public int tokenStartOffset() {
        return this.tokenStartOffset;
    }

    public int rootTokenOffsetShift() {
        return this.rootTokenOffsetShift;
    }

    public char charAt(int tokenRelOffset) {
        return this.rootToken.charAt(this.rootTokenOffsetShift + tokenRelOffset);
    }

    public EmbeddedTokenList<? extends TokenId> firstEmbeddedTokenList() {
        return this.firstEmbeddedTokenList;
    }

    void setFirstEmbeddedTokenList(EmbeddedTokenList<? extends TokenId> firstEmbeddedTokenList) {
        this.firstEmbeddedTokenList = firstEmbeddedTokenList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean updateStatus() {
        TokenList<? extends TokenId> tokenList = this.rootTokenList;
        synchronized (tokenList) {
            this.rootToken = this.updateStatusImpl();
            return this.rootToken != null;
        }
    }

    AbstractToken<? extends TokenId> updateStatusImpl() {
        if (this.rootToken == null) {
            return null;
        }
        int rootModCount = this.rootTokenList.modCount();
        if (this.cachedModCount != rootModCount) {
            this.cachedModCount = rootModCount;
            this.tokenStartOffset = this.token.offset(null);
            this.rootTokenOffsetShift = this.tokenStartOffset - this.rootToken.offset(null);
            TokenList<T> tl = this.token.tokenList();
            if (tl == null) {
                return null;
            }
            if (tl instanceof EmbeddedTokenList) {
                EmbeddingContainer ec = ((EmbeddedTokenList)tl).embeddingContainer();
                return ec.updateStatusImpl();
            }
        }
        return this.rootToken;
    }
}

