/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.lexer;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.netbeans.api.lexer.InputAttributes;
import org.netbeans.api.lexer.Language;
import org.netbeans.api.lexer.LanguagePath;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.lib.lexer.EmbeddingContainer;
import org.netbeans.lib.lexer.LexerUtilsConstants;
import org.netbeans.lib.lexer.TokenHierarchyOperation;
import org.netbeans.lib.lexer.TokenList;
import org.netbeans.lib.lexer.token.AbstractToken;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JoinTokenList<T extends TokenId>
implements TokenList<T> {
    private final TokenHierarchyOperation operation;
    private final LanguagePath languagePath;
    private final List<TokenListWrapper<T>> wrappers;
    private int lastWrapperIndex = -1;
    private List<TokenListExplorer> explorers;
    private int activeExplorerIndex;
    private boolean closed;

    public JoinTokenList(TokenHierarchyOperation operation, LanguagePath languagePath) {
        this.operation = operation;
        this.languagePath = languagePath;
        this.wrappers = new ArrayList<TokenListWrapper<T>>(2);
        this.explorers = new ArrayList<TokenListExplorer>(2);
    }

    @Override
    public LanguagePath languagePath() {
        return this.languagePath;
    }

    @Override
    public Object tokenOrEmbeddingContainer(int index) {
        int high;
        TokenListWrapper<T> wrapper;
        int wrapperIndex = this.lastWrapperIndex;
        if (wrapperIndex >= 0) {
            wrapper = this.wrappers.get(wrapperIndex);
            if (wrapper.containsIndex(index)) {
                return wrapper.tokenOrEmbeddingContainer(index);
            }
            if (index == wrapper.globalStartIndex() - 1 && --wrapperIndex >= 0) {
                this.lastWrapperIndex = wrapperIndex;
                return wrapper.tokenOrEmbeddingContainer(index);
            }
        }
        if ((high = this.wrappers.size() - 1) >= 0 && index >= (wrapper = this.wrappers.get(high)).endGlobalIndex()) {
            if (this.closed) {
                return null;
            }
            wrapper = this.findNextWrapper();
            if (wrapper != null) {
                // empty if block
            }
        }
        return null;
    }

    @Override
    public AbstractToken<T> replaceFlyToken(int index, AbstractToken<T> flyToken, int offset) {
        return null;
    }

    @Override
    public void wrapToken(int index, EmbeddingContainer<T> embeddingContainer) {
    }

    @Override
    public int tokenOffset(int index) {
        return 0;
    }

    @Override
    public int tokenCount() {
        return 0;
    }

    @Override
    public int tokenCountCurrent() {
        return 0;
    }

    @Override
    public int modCount() {
        return 0;
    }

    @Override
    public int childTokenOffset(int rawOffset) {
        return 0;
    }

    @Override
    public char childTokenCharAt(int rawOffset, int index) {
        return ' ';
    }

    @Override
    public TokenList<? extends TokenId> root() {
        return null;
    }

    @Override
    public TokenHierarchyOperation<?, ? extends TokenId> tokenHierarchyOperation() {
        return null;
    }

    @Override
    public InputAttributes inputAttributes() {
        return null;
    }

    @Override
    public int lookahead(int index) {
        return 0;
    }

    @Override
    public Object state(int index) {
        return null;
    }

    @Override
    public boolean isContinuous() {
        return false;
    }

    @Override
    public Set<T> skipTokenIds() {
        return null;
    }

    @Override
    public int startOffset() {
        if (this.tokenCountCurrent() > 0 || this.tokenCount() > 0) {
            return this.tokenOffset(0);
        }
        return 0;
    }

    @Override
    public int endOffset() {
        int cntM1 = this.tokenCount() - 1;
        if (cntM1 >= 0) {
            return this.tokenOffset(cntM1) + LexerUtilsConstants.token(this, cntM1).length();
        }
        return 0;
    }

    private TokenListWrapper<T> findNextWrapper() {
        int globalStartIndex = this.wrappers.size() > 0 ? this.wrappers.get(this.wrappers.size() - 1).endGlobalIndex() : 0;
        TokenListExplorer explorer = this.explorers.get(this.activeExplorerIndex);
        this.wrappers.add(new TokenListWrapper(null, globalStartIndex));
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class TokenListExplorer<T extends TokenId> {
        private final TokenList<T> tokenList;
        private int index;

        TokenListExplorer(TokenList<T> tokenList) {
            this.tokenList = tokenList;
        }

        <ET extends TokenId> TokenList<ET> nextEmbeddedTokenList(Language<ET> embeddedLanguage) {
            if (!this.isFinished()) {
                TokenList<ET> embeddedTokenList = LexerUtilsConstants.embeddedTokenList(this.tokenList, this.index++, embeddedLanguage);
                return embeddedTokenList;
            }
            return null;
        }

        boolean isFinished() {
            return this.index >= this.tokenList.tokenCount();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class TokenListWrapper<T extends TokenId> {
        private final TokenList<T> tokenList;
        private int globalStartIndex;

        TokenListWrapper(TokenList<T> tokenList, int globalStartIndex) {
            this.tokenList = tokenList;
            this.globalStartIndex = globalStartIndex;
        }

        TokenList<T> tokenList() {
            return this.tokenList;
        }

        int globalStartIndex() {
            return this.globalStartIndex;
        }

        void setGlobalStartIndex(int globalStartIndex) {
            this.globalStartIndex = globalStartIndex;
        }

        boolean containsIndex(int globalIndex) {
            return (globalIndex -= this.globalStartIndex) >= 0 && globalIndex < this.tokenList.tokenCount();
        }

        Object tokenOrEmbeddingContainer(int validGlobalIndex) {
            return this.tokenList.tokenOrEmbeddingContainer(validGlobalIndex - this.globalStartIndex);
        }

        int endGlobalIndex() {
            return this.globalStartIndex + this.tokenList.tokenCount();
        }
    }
}

