/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.lexer;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collections;
import java.util.EventListener;
import java.util.HashSet;
import java.util.Set;
import org.netbeans.api.lexer.Language;
import org.netbeans.api.lexer.LanguagePath;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.lib.editor.util.CharSequenceUtilities;
import org.netbeans.lib.lexer.LanguageManager;
import org.netbeans.lib.lexer.LexerApiPackageAccessor;
import org.netbeans.lib.lexer.LexerSpiPackageAccessor;
import org.netbeans.lib.lexer.LexerUtilsConstants;
import org.netbeans.lib.lexer.token.DefaultToken;
import org.netbeans.lib.lexer.token.TextToken;
import org.netbeans.spi.lexer.LanguageEmbedding;
import org.netbeans.spi.lexer.LanguageHierarchy;
import org.netbeans.spi.lexer.TokenFactory;
import org.netbeans.spi.lexer.TokenValidator;
import org.openide.util.WeakListeners;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class LanguageOperation<T extends TokenId>
implements PropertyChangeListener {
    private static final int MAX_START_SKIP_LENGTH_CACHED = 10;
    private static final int MAX_END_SKIP_LENGTH_CACHED = 10;
    private static final TokenValidator<TokenId> NULL_VALIDATOR = new TokenValidator<TokenId>(){

        @Override
        public Token<TokenId> validateToken(Token<TokenId> token, TokenFactory<TokenId> factory, CharSequence tokenText, int modRelOffset, int removedLength, CharSequence removedText, int insertedLength, CharSequence insertedText) {
            return null;
        }
    };
    private LanguageHierarchy<T> languageHierarchy;
    private Language<T> language;
    private LanguageEmbedding<T>[][] cachedEmbeddings;
    private LanguageEmbedding<T>[][] cachedJoinSectionsEmbeddings;
    private TokenValidator<T>[] tokenValidators;
    private Set<LanguagePath> languagePaths;
    private Set<Language<? extends TokenId>> exploredLanguages;
    private FlyItem<T>[] flyItems;

    public static <T extends TokenId> void findLanguagePaths(Set<LanguagePath> existingLanguagePaths, Set<LanguagePath> newLanguagePaths, Set<Language<? extends TokenId>> exploredLanguages, LanguagePath lp, Language<T> language) {
        if (!existingLanguagePaths.contains(lp)) {
            newLanguagePaths.add(lp);
        }
        if (!exploredLanguages.contains(language)) {
            exploredLanguages.add(language);
            Set<T> ids = language.tokenIds();
            for (TokenId id : ids) {
                DefaultToken<TokenId> emptyToken = new DefaultToken<TokenId>(id);
                LanguageEmbedding<TokenId> embedding = LexerUtilsConstants.findEmbedding(emptyToken, lp, null);
                if (embedding == null) continue;
                LanguagePath elp = LanguagePath.get(lp, embedding.language());
                LanguageOperation.findLanguagePaths(existingLanguagePaths, newLanguagePaths, exploredLanguages, elp, embedding.language());
            }
        }
    }

    public LanguageOperation(LanguageHierarchy<T> languageHierarchy) {
        this.languageHierarchy = languageHierarchy;
        LanguageManager.getInstance().addPropertyChangeListener((PropertyChangeListener)WeakListeners.create(PropertyChangeListener.class, (EventListener)this, (Object)LanguageManager.getInstance()));
    }

    public LanguageHierarchy<T> languageHierarchy() {
        return this.languageHierarchy;
    }

    public synchronized Language<T> language() {
        if (this.language == null) {
            try {
                Class.forName(Language.class.getName(), true, LanguageOperation.class.getClassLoader());
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            this.language = LexerApiPackageAccessor.get().createLanguage(this.languageHierarchy);
        }
        return this.language;
    }

    public synchronized TokenValidator<T> tokenValidator(T id) {
        TokenValidator<T> validator;
        if (this.tokenValidators == null) {
            this.tokenValidators = this.allocateTokenValidatorArray(this.language.maxOrdinal() + 1);
        }
        if ((validator = this.tokenValidators[id.ordinal()]) == null) {
            validator = LexerSpiPackageAccessor.get().createTokenValidator(this.languageHierarchy(), id);
            if (validator == null) {
                validator = this.nullValidator();
            }
            this.tokenValidators[id.ordinal()] = validator;
        }
        return validator == this.nullValidator() ? null : validator;
    }

    public synchronized TextToken<T> getFlyweightToken(T id, String text) {
        TextToken<T> token;
        FlyItem<T> item;
        if (this.flyItems == null) {
            FlyItem[] arr = new FlyItem[this.language.maxOrdinal() + 1];
            this.flyItems = arr;
        }
        if ((item = this.flyItems[id.ordinal()]) == null) {
            token = new TextToken<T>(id, text);
            token.makeFlyweight();
            this.flyItems[id.ordinal()] = new FlyItem<T>(token);
        } else {
            token = item.token();
            if (token.text() != text) {
                token = item.token2();
                if (token == null || token.text() != text) {
                    token = item.token();
                    if (!CharSequenceUtilities.textEquals((CharSequence)token.text(), (CharSequence)text)) {
                        token = item.token2();
                        if (token == null || !CharSequenceUtilities.textEquals((CharSequence)token.text(), (CharSequence)text)) {
                            token = new TextToken<T>(id, text);
                            token.makeFlyweight();
                        }
                        item.pushToken(token);
                    }
                } else {
                    item.pushToken(token);
                }
            }
        }
        assert (token != null);
        return token;
    }

    public synchronized LanguageEmbedding<T> getEmbedding(int startSkipLength, int endSkipLength, boolean joinSections) {
        LanguageEmbedding<T> e;
        LanguageEmbedding<T>[] byESL;
        LanguageEmbedding<T>[][] ce;
        LanguageEmbedding<T>[][] languageEmbeddingArray = ce = joinSections ? this.cachedJoinSectionsEmbeddings : this.cachedEmbeddings;
        if (ce == null || startSkipLength >= ce.length) {
            if (startSkipLength > 10) {
                return this.createEmbedding(startSkipLength, endSkipLength, joinSections);
            }
            LanguageEmbedding[][] tmp = new LanguageEmbedding[startSkipLength + 1][];
            if (ce != null) {
                System.arraycopy(ce, 0, tmp, 0, ce.length);
            }
            ce = tmp;
            if (joinSections) {
                this.cachedJoinSectionsEmbeddings = ce;
            } else {
                this.cachedEmbeddings = ce;
            }
        }
        if ((byESL = ce[startSkipLength]) == null || endSkipLength >= byESL.length) {
            if (endSkipLength > 10) {
                return this.createEmbedding(startSkipLength, endSkipLength, joinSections);
            }
            LanguageEmbedding[] tmp = new LanguageEmbedding[endSkipLength + 1];
            if (byESL != null) {
                System.arraycopy(byESL, 0, tmp, 0, byESL.length);
            }
            byESL = tmp;
            ce[startSkipLength] = byESL;
        }
        if ((e = byESL[endSkipLength]) == null) {
            byESL[endSkipLength] = e = this.createEmbedding(startSkipLength, endSkipLength, joinSections);
        }
        return e;
    }

    private LanguageEmbedding<T> createEmbedding(int startSkipLength, int endSkipLength, boolean joinSections) {
        return LexerSpiPackageAccessor.get().createLanguageEmbedding(this.language(), startSkipLength, endSkipLength, joinSections);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<LanguagePath> languagePaths() {
        Set<LanguagePath> lps;
        LanguageOperation languageOperation = this;
        synchronized (languageOperation) {
            lps = this.languagePaths;
        }
        if (lps == null) {
            lps = new HashSet<LanguagePath>();
            Set<LanguagePath> existingLps = Collections.emptySet();
            HashSet<Language<? extends TokenId>> exploredLangs = new HashSet<Language<? extends TokenId>>();
            LanguageOperation.findLanguagePaths(existingLps, lps, exploredLangs, LanguagePath.get(this.language()), this.language());
            LanguageOperation languageOperation2 = this;
            synchronized (languageOperation2) {
                this.languagePaths = lps;
                this.exploredLanguages = exploredLangs;
            }
        }
        return lps;
    }

    public Set<Language<? extends TokenId>> exploredLanguages() {
        this.languagePaths();
        return this.exploredLanguages;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        LanguageOperation languageOperation = this;
        synchronized (languageOperation) {
            this.languagePaths = null;
            this.exploredLanguages = null;
        }
    }

    private final TokenValidator<T> nullValidator() {
        return NULL_VALIDATOR;
    }

    private final TokenValidator<T>[] allocateTokenValidatorArray(int length) {
        return new TokenValidator[length];
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class FlyItem<T extends TokenId> {
        private TextToken<T> token;
        private TextToken<T> token2;

        public FlyItem(TextToken<T> token) {
            this.token = token;
        }

        public TextToken<T> token() {
            return this.token;
        }

        public TextToken<T> token2() {
            return this.token2;
        }

        public void pushToken(TextToken<T> token) {
            this.token2 = this.token;
            this.token = token;
        }
    }
}

