/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.lexer;

import org.netbeans.api.lexer.TokenId;
import org.netbeans.lib.lexer.LexerInputOperation;
import org.netbeans.lib.lexer.TokenList;
import org.netbeans.lib.lexer.token.AbstractToken;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TextLexerInputOperation<T extends TokenId>
extends LexerInputOperation<T> {
    private final CharSequence inputText;
    private final int inputTextStartOffset;
    private int readEndIndex;

    public TextLexerInputOperation(TokenList<T> tokenList, CharSequence inputText) {
        this(tokenList, 0, null, inputText, 0, 0, inputText.length());
    }

    public TextLexerInputOperation(TokenList<T> tokenList, int tokenIndex, Object lexerRestartState, CharSequence inputText, int inputTextStartOffset, int startOffset, int endOffset) {
        super(tokenList, tokenIndex, lexerRestartState);
        this.inputText = inputText;
        this.inputTextStartOffset = inputTextStartOffset;
        assert (0 <= (startOffset -= inputTextStartOffset) && startOffset <= (endOffset -= inputTextStartOffset) && endOffset <= inputText.length());
        this.setTokenStartIndex(startOffset);
        this.readEndIndex = endOffset;
    }

    @Override
    public int read(int index) {
        if ((index += this.tokenStartIndex()) < this.readEndIndex) {
            return this.inputText.charAt(index);
        }
        return -1;
    }

    @Override
    public char readExisting(int index) {
        return this.inputText.charAt(this.tokenStartIndex() + index);
    }

    @Override
    public void approveToken(AbstractToken<T> token) {
        int tokenLength = this.tokenLength();
        if (this.isSkipToken(token)) {
            this.preventFlyToken();
        } else if (token.isFlyweight()) {
            assert (this.isFlyTokenAllowed());
            this.flyTokenAdded();
        } else {
            token.setTokenList(this.tokenList());
            token.setRawOffset(this.inputTextStartOffset + this.tokenStartIndex());
            this.clearFlySequence();
        }
        this.tokenApproved();
    }

    protected final int readEndIndex() {
        return this.readEndIndex;
    }
}

