/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.lexer;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.netbeans.api.lexer.Language;
import org.netbeans.api.lexer.LanguagePath;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.lib.editor.util.ArrayUtilities;
import org.netbeans.lib.lexer.LexerApiPackageAccessor;
import org.netbeans.lib.lexer.LexerUtilsConstants;
import org.netbeans.lib.lexer.SubSequenceTokenList;
import org.netbeans.lib.lexer.TokenHierarchyOperation;
import org.netbeans.lib.lexer.TokenList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TokenListList
extends AbstractList<TokenList<?>> {
    private final TokenHierarchyOperation operation;
    private final LanguagePath languagePath;
    private final List<TokenList<?>> tokenLists;
    private boolean closed;
    private List<TokenListExplorer> explorers;

    public static List<TokenSequence<?>> createTokenSequenceList(TokenHierarchyOperation operation, LanguagePath languagePath, int startOffset, int endOffset) {
        TokenListList tll = operation.tokenListList(languagePath);
        int low = 0;
        int high = tll.size() - 1;
        if (startOffset > 0) {
            while (low <= high) {
                int mid = (low + high) / 2;
                Object tl = tll.get(mid);
                int tlEndOffset = tl.endOffset();
                if (tlEndOffset < startOffset) {
                    low = mid + 1;
                    continue;
                }
                if (tlEndOffset > startOffset) {
                    high = mid - 1;
                    continue;
                }
                low = mid + 1;
                break;
            }
        }
        int startIndex = low;
        low = 0;
        high = tll.size() - 1;
        if (startIndex <= high) {
            if (endOffset < Integer.MAX_VALUE) {
                while (low <= high) {
                    int mid = (low + high) / 2;
                    Object tl = tll.get(mid);
                    int tlStartOffset = tl.startOffset();
                    if (tlStartOffset < endOffset) {
                        low = mid + 1;
                        continue;
                    }
                    if (tlStartOffset > endOffset) {
                        high = mid - 1;
                        continue;
                    }
                    high = mid;
                    break;
                }
            }
            int endIndex = high + 1;
            assert (startIndex <= endIndex);
            if (endIndex - startIndex > 0) {
                boolean wrapEnd;
                Object[] tss = new TokenSequence[endIndex - startIndex];
                SubSequenceTokenList startTokenList = tll.get(startIndex);
                boolean wrapStart = startTokenList.startOffset() < startOffset && startOffset < startTokenList.endOffset();
                SubSequenceTokenList endTokenList = tll.get(endIndex - 1);
                boolean bl = wrapEnd = endTokenList.startOffset() < endOffset && endOffset < endTokenList.endOffset();
                if (endIndex == startIndex + 1) {
                    if (wrapStart || wrapEnd) {
                        startTokenList = SubSequenceTokenList.create(startTokenList, startOffset, endOffset);
                    }
                } else {
                    if (wrapStart) {
                        startTokenList = SubSequenceTokenList.create(startTokenList, startOffset, Integer.MAX_VALUE);
                    }
                    if (wrapEnd) {
                        endTokenList = SubSequenceTokenList.create(endTokenList, 0, endOffset);
                    }
                    tss[--endIndex] = LexerApiPackageAccessor.get().createTokenSequence(endTokenList);
                    for (int i = 1; i < endIndex; ++i) {
                        tss[i] = LexerApiPackageAccessor.get().createTokenSequence(tll.get(i));
                    }
                }
                tss[0] = LexerApiPackageAccessor.get().createTokenSequence(startTokenList);
                return ArrayUtilities.unmodifiableList((Object[])tss);
            }
        }
        return Collections.emptyList();
    }

    public TokenListList(TokenHierarchyOperation<?, ?> operation, LanguagePath languagePath) {
        assert (languagePath != null);
        this.operation = operation;
        this.languagePath = languagePath;
        if (languagePath.size() == 1) {
            if (operation.checkedTokenList().languagePath() == languagePath) {
                List<TokenList<?>> l;
                List<TokenList<?>> tls = l = Collections.singletonList(operation.checkedTokenList());
                this.tokenLists = tls;
            } else {
                this.tokenLists = Collections.emptyList();
            }
            this.explorers = Collections.emptyList();
            this.closed = true;
        } else {
            this.tokenLists = new ArrayList(2);
            this.explorers = new ArrayList<TokenListExplorer>(languagePath.size());
            this.explorers.add(new TokenListExplorer(operation.checkedTokenList()));
        }
    }

    public LanguagePath languagePath() {
        return this.languagePath;
    }

    @Override
    public TokenList<?> get(int index) {
        if (!this.closed && index >= this.tokenLists.size()) {
            this.findTokenListWithIndex(index);
        }
        return this.tokenLists.get(index);
    }

    @Override
    public int size() {
        this.findTokenListWithIndex(Integer.MAX_VALUE);
        return this.tokenLists.size();
    }

    private void findTokenListWithIndex(int tokenListIndex) {
        while (this.explorers.size() > 0) {
            int explorerIndex = this.explorers.size() - 1;
            TokenListExplorer explorer = this.explorers.get(explorerIndex);
            int tokenCount = explorer.tokenCount();
            Language<? extends TokenId> language = this.languagePath.language(explorerIndex + 1);
            while (explorer.index < tokenCount) {
                TokenList<? extends TokenId> embeddedTL = LexerUtilsConstants.embeddedTokenList(explorer.tokenList, explorer.index, language);
                ++explorer.index;
                if (embeddedTL == null) continue;
                if (explorerIndex + 2 == this.languagePath.size()) {
                    this.tokenLists.add(embeddedTL);
                    if (this.tokenLists.size() <= tokenListIndex) continue;
                    return;
                }
                explorer = new TokenListExplorer(embeddedTL);
                this.explorers.add(explorer);
                tokenCount = explorer.tokenCount();
                language = this.languagePath.language(++explorerIndex + 1);
            }
            this.explorers.remove(explorerIndex);
        }
        this.closed = true;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class TokenListExplorer {
        final TokenList<?> tokenList;
        int index;

        TokenListExplorer(TokenList<?> tokenList) {
            this.tokenList = tokenList;
        }

        int tokenCount() {
            return this.tokenList.tokenCount();
        }
    }
}

