/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.lexer.inc;

import java.util.List;
import java.util.Set;
import org.netbeans.api.lexer.InputAttributes;
import org.netbeans.api.lexer.LanguagePath;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.lib.editor.util.FlyOffsetGapList;
import org.netbeans.lib.lexer.EmbeddingContainer;
import org.netbeans.lib.lexer.LAState;
import org.netbeans.lib.lexer.LexerInputOperation;
import org.netbeans.lib.lexer.LexerSpiPackageAccessor;
import org.netbeans.lib.lexer.LexerUtilsConstants;
import org.netbeans.lib.lexer.TextLexerInputOperation;
import org.netbeans.lib.lexer.TokenHierarchyOperation;
import org.netbeans.lib.lexer.TokenList;
import org.netbeans.lib.lexer.inc.MutableTokenList;
import org.netbeans.lib.lexer.inc.TokenHierarchyEventInfo;
import org.netbeans.lib.lexer.inc.TokenListChange;
import org.netbeans.lib.lexer.token.AbstractToken;
import org.netbeans.lib.lexer.token.TextToken;
import org.netbeans.spi.lexer.MutableTextInput;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class IncTokenList<T extends TokenId>
extends FlyOffsetGapList<Object>
implements MutableTokenList<T> {
    private final TokenHierarchyOperation<?, T> tokenHierarchyOperation;
    private final MutableTextInput<?> mutableTextInput;
    private final LanguagePath languagePath;
    private final InputAttributes inputAttributes;
    private CharSequence text;
    private LexerInputOperation<T> lexerInputOperation;
    private int rootModCount;
    private LAState laState;

    public IncTokenList(TokenHierarchyOperation<?, T> tokenHierarchyOperation, MutableTextInput<?> mutableTextInput) {
        this.tokenHierarchyOperation = tokenHierarchyOperation;
        this.mutableTextInput = mutableTextInput;
        this.languagePath = LanguagePath.get(LexerSpiPackageAccessor.get().language(mutableTextInput));
        this.inputAttributes = LexerSpiPackageAccessor.get().inputAttributes(mutableTextInput);
        this.text = LexerSpiPackageAccessor.get().text(mutableTextInput);
        this.laState = LAState.empty();
        this.initLexing();
    }

    private void initLexing() {
        this.lexerInputOperation = new TextLexerInputOperation(this, this.text);
    }

    @Override
    public LanguagePath languagePath() {
        return this.languagePath;
    }

    @Override
    public synchronized int tokenCount() {
        if (this.lexerInputOperation != null) {
            this.tokenOrEmbeddingContainerImpl(Integer.MAX_VALUE);
        }
        return this.size();
    }

    @Override
    public char childTokenCharAt(int rawOffset, int index) {
        return this.text.charAt(this.childTokenOffset(rawOffset) + index);
    }

    @Override
    public int childTokenOffset(int rawOffset) {
        return rawOffset < this.offsetGapStart() ? rawOffset : rawOffset - this.offsetGapLength();
    }

    @Override
    public int tokenOffset(int index) {
        return this.elementOffset(index);
    }

    public int existingTokensEndOffset() {
        return this.elementOrEndOffset(this.tokenCountCurrent());
    }

    @Override
    public int modCount() {
        return this.rootModCount;
    }

    public void incrementModCount() {
        ++this.rootModCount;
    }

    @Override
    public synchronized Object tokenOrEmbeddingContainer(int index) {
        return this.tokenOrEmbeddingContainerImpl(index);
    }

    private Object tokenOrEmbeddingContainerImpl(int index) {
        while (this.lexerInputOperation != null && index >= this.size()) {
            AbstractToken<T> token = this.lexerInputOperation.nextToken();
            if (token != null) {
                this.updateElementOffsetAdd(token);
                this.add(token);
                this.laState = this.laState.add(this.lexerInputOperation.lookahead(), this.lexerInputOperation.lexerState());
                continue;
            }
            this.lexerInputOperation.release();
            this.lexerInputOperation = null;
            this.trimToSize();
            this.laState.trimToSize();
        }
        return index < this.size() ? this.get(index) : null;
    }

    @Override
    public synchronized AbstractToken<T> replaceFlyToken(int index, AbstractToken<T> flyToken, int offset) {
        TextToken nonFlyToken = ((TextToken)flyToken).createCopy(this, this.offset2Raw(offset));
        this.set(index, nonFlyToken);
        return nonFlyToken;
    }

    @Override
    public synchronized void wrapToken(int index, EmbeddingContainer embeddingContainer) {
        this.set(index, embeddingContainer);
    }

    @Override
    public InputAttributes inputAttributes() {
        return this.inputAttributes;
    }

    protected int elementRawOffset(Object elem) {
        return LexerUtilsConstants.token(elem).rawOffset();
    }

    protected void setElementRawOffset(Object elem, int rawOffset) {
        LexerUtilsConstants.token(elem).setRawOffset(rawOffset);
    }

    protected boolean isElementFlyweight(Object elem) {
        return elem.getClass() != EmbeddingContainer.class && ((AbstractToken)elem).isFlyweight();
    }

    protected int elementLength(Object elem) {
        return LexerUtilsConstants.token(elem).length();
    }

    private AbstractToken<T> existingToken(int index) {
        return LexerUtilsConstants.token(this.tokenOrEmbeddingContainer(index));
    }

    @Override
    public Object tokenOrEmbeddingContainerUnsync(int index) {
        return this.get(index);
    }

    @Override
    public int lookahead(int index) {
        return this.laState.lookahead(index);
    }

    @Override
    public Object state(int index) {
        return this.laState.state(index);
    }

    @Override
    public int tokenCountCurrent() {
        return this.size();
    }

    @Override
    public TokenList<? extends TokenId> root() {
        return this;
    }

    @Override
    public TokenHierarchyOperation<?, ? extends TokenId> tokenHierarchyOperation() {
        return this.tokenHierarchyOperation;
    }

    @Override
    public LexerInputOperation<T> createLexerInputOperation(int tokenIndex, int relexOffset, Object relexState) {
        return new TextLexerInputOperation(this, tokenIndex, relexState, this.text, 0, relexOffset, this.text.length());
    }

    @Override
    public boolean isFullyLexed() {
        return this.lexerInputOperation == null;
    }

    @Override
    public void replaceTokens(TokenHierarchyEventInfo eventInfo, TokenListChange<T> change, int removeTokenCount) {
        int index = change.index();
        Object[] removedTokensOrBranches = new Object[removeTokenCount];
        this.copyElements(index, index + removeTokenCount, removedTokensOrBranches, 0);
        int offset = change.offset();
        for (int i = 0; i < removeTokenCount; ++i) {
            Object tokenOrEmbeddingContainer = removedTokensOrBranches[i];
            AbstractToken token = LexerUtilsConstants.token(tokenOrEmbeddingContainer);
            if (!token.isFlyweight()) {
                this.updateElementOffsetRemove(token);
                token.setTokenList(null);
            }
            offset += token.length();
        }
        this.remove(index, removeTokenCount);
        this.laState.remove(index, removeTokenCount);
        change.setRemovedTokens(removedTokensOrBranches);
        change.setRemovedEndOffset(offset);
        int diffLength = eventInfo.insertedLength() - eventInfo.removedLength();
        if (this.offsetGapStart() != change.offset()) {
            this.moveOffsetGap(change.offset(), Math.min(index, change.offsetGapIndex()));
        }
        this.updateOffsetGapLength(-diffLength);
        List<Object> addedTokensOrBranches = change.addedTokensOrBranches();
        if (addedTokensOrBranches != null) {
            Object id;
            for (Object tokenOrBranch : addedTokensOrBranches) {
                AbstractToken token = (AbstractToken)tokenOrBranch;
                this.updateElementOffsetAdd(token);
            }
            this.addAll(index, addedTokensOrBranches);
            this.laState = this.laState.addAll(index, change.laState());
            change.syncAddedTokenCount();
            if (removeTokenCount == 1 && addedTokensOrBranches.size() == 1 && (id = LexerUtilsConstants.token(removedTokensOrBranches[0]).id()) == change.addedToken(0).id()) {
                change.markBoundsChange();
            }
        }
    }

    private void releaseLexerInputOperation() {
        if (this.lexerInputOperation != null) {
            this.lexerInputOperation.release();
        }
    }

    public void refreshLexerInputOperation() {
        this.releaseLexerInputOperation();
        int lastTokenIndex = this.tokenCountCurrent() - 1;
        this.lexerInputOperation = this.createLexerInputOperation(lastTokenIndex + 1, this.existingTokensEndOffset(), lastTokenIndex >= 0 ? this.state(lastTokenIndex) : null);
    }

    public void restartLexing() {
        this.releaseLexerInputOperation();
        this.initLexing();
    }

    @Override
    public boolean isContinuous() {
        return true;
    }

    @Override
    public Set<T> skipTokenIds() {
        return null;
    }

    @Override
    public int startOffset() {
        return 0;
    }

    @Override
    public int endOffset() {
        return this.text.length();
    }

    public String toString() {
        return LexerUtilsConstants.appendTokenList(null, this, -1).toString();
    }
}

