/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.lexer.inc;

import java.util.Set;
import org.netbeans.api.lexer.InputAttributes;
import org.netbeans.api.lexer.LanguagePath;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.lib.lexer.EmbeddingContainer;
import org.netbeans.lib.lexer.LexerUtilsConstants;
import org.netbeans.lib.lexer.TokenHierarchyOperation;
import org.netbeans.lib.lexer.TokenList;
import org.netbeans.lib.lexer.token.AbstractToken;
import org.netbeans.lib.lexer.token.TextToken;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class RemovedTokenList<T extends TokenId>
implements TokenList<T> {
    private final LanguagePath languagePath;
    private Object[] tokensOrBranches;
    private int removedTokensStartOffset;

    public RemovedTokenList(LanguagePath languagePath, Object[] tokensOrBranches) {
        this.languagePath = languagePath;
        this.tokensOrBranches = tokensOrBranches;
    }

    @Override
    public LanguagePath languagePath() {
        return this.languagePath;
    }

    @Override
    public Object tokenOrEmbeddingContainer(int index) {
        return index < this.tokensOrBranches.length ? this.tokensOrBranches[index] : null;
    }

    @Override
    public int lookahead(int index) {
        return -1;
    }

    @Override
    public Object state(int index) {
        return null;
    }

    @Override
    public int tokenOffset(int index) {
        Token<T> token = this.existingToken(index);
        if (token.isFlyweight()) {
            int offset = 0;
            while (--index >= 0) {
                token = this.existingToken(index);
                offset += token.length();
                if (token.isFlyweight()) continue;
                return offset + token.offset(null);
            }
            return this.removedTokensStartOffset + offset;
        }
        return token.offset(null);
    }

    private Token<T> existingToken(int index) {
        return LexerUtilsConstants.token(this.tokensOrBranches[index]);
    }

    @Override
    public synchronized AbstractToken<T> replaceFlyToken(int index, AbstractToken<T> flyToken, int offset) {
        TextToken nonFlyToken;
        this.tokensOrBranches[index] = nonFlyToken = ((TextToken)flyToken).createCopy(this, offset);
        return nonFlyToken;
    }

    @Override
    public int tokenCount() {
        return this.tokenCountCurrent();
    }

    @Override
    public int tokenCountCurrent() {
        return this.tokensOrBranches.length;
    }

    @Override
    public int modCount() {
        return -1;
    }

    @Override
    public int childTokenOffset(int rawOffset) {
        return rawOffset;
    }

    @Override
    public char childTokenCharAt(int rawOffset, int index) {
        throw new IllegalStateException("Querying of text for removed tokens not supported");
    }

    @Override
    public void wrapToken(int index, EmbeddingContainer embeddingContainer) {
        throw new IllegalStateException("Branching of removed tokens not supported");
    }

    @Override
    public TokenList<? extends TokenId> root() {
        return this;
    }

    @Override
    public TokenHierarchyOperation<?, ? extends TokenId> tokenHierarchyOperation() {
        return null;
    }

    @Override
    public InputAttributes inputAttributes() {
        return null;
    }

    @Override
    public int startOffset() {
        if (this.tokenCountCurrent() > 0 || this.tokenCount() > 0) {
            return this.tokenOffset(0);
        }
        return 0;
    }

    @Override
    public int endOffset() {
        int cntM1 = this.tokenCount() - 1;
        if (cntM1 >= 0) {
            return this.tokenOffset(cntM1) + LexerUtilsConstants.token(this, cntM1).length();
        }
        return 0;
    }

    @Override
    public boolean isContinuous() {
        return true;
    }

    @Override
    public Set<T> skipTokenIds() {
        return null;
    }
}

