/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.lexer.inc;

import org.netbeans.api.lexer.TokenChange;
import org.netbeans.api.lexer.TokenHierarchyEventType;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.lib.lexer.LexerApiPackageAccessor;
import org.netbeans.lib.lexer.LexerSpiPackageAccessor;
import org.netbeans.lib.lexer.TokenHierarchyOperation;
import org.netbeans.lib.lexer.inc.OriginalText;
import org.netbeans.lib.lexer.inc.TokenChangeInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TokenHierarchyEventInfo {
    private final TokenHierarchyOperation<?, ?> tokenHierarchyOperation;
    private final TokenHierarchyEventType type;
    private TokenChange<? extends TokenId> tokenChange;
    private final int modificationOffset;
    private final int removedLength;
    private final CharSequence removedText;
    private final int insertedLength;
    private OriginalText originalText;
    private int affectedStartOffset;
    private int affectedEndOffset;

    public TokenHierarchyEventInfo(TokenHierarchyOperation<?, ? extends TokenId> tokenHierarchyOperation, TokenHierarchyEventType type, int modificationOffset, int removedLength, CharSequence removedText, int insertedLength) {
        if (modificationOffset < 0) {
            throw new IllegalArgumentException("modificationOffset=" + modificationOffset + " < 0");
        }
        if (removedLength < 0) {
            throw new IllegalArgumentException("removedLength=" + removedLength + " < 0");
        }
        if (insertedLength < 0) {
            throw new IllegalArgumentException("insertedLength=" + insertedLength + " < 0");
        }
        this.tokenHierarchyOperation = tokenHierarchyOperation;
        this.type = type;
        this.modificationOffset = modificationOffset;
        this.removedLength = removedLength;
        this.removedText = removedText;
        this.insertedLength = insertedLength;
    }

    public TokenHierarchyOperation<?, ? extends TokenId> tokenHierarchyOperation() {
        return this.tokenHierarchyOperation;
    }

    public TokenHierarchyEventType type() {
        return this.type;
    }

    public TokenChange<? extends TokenId> tokenChange() {
        return this.tokenChange;
    }

    public void setTokenChangeInfo(TokenChangeInfo<? extends TokenId> info) {
        this.tokenChange = LexerApiPackageAccessor.get().createTokenChange(info);
    }

    public int affectedStartOffset() {
        return this.affectedStartOffset;
    }

    public void setAffectedStartOffset(int affectedStartOffset) {
        this.affectedStartOffset = affectedStartOffset;
    }

    public void setMinAffectedStartOffset(int affectedStartOffset) {
        if (affectedStartOffset < this.affectedStartOffset) {
            this.affectedStartOffset = affectedStartOffset;
        }
    }

    public int affectedEndOffset() {
        return this.affectedEndOffset;
    }

    public void setAffectedEndOffset(int affectedEndOffset) {
        this.affectedEndOffset = Math.max(this.affectedEndOffset, affectedEndOffset);
    }

    public void setMaxAffectedEndOffset(int affectedEndOffset) {
        if (affectedEndOffset > this.affectedEndOffset) {
            this.affectedEndOffset = affectedEndOffset;
        }
    }

    public int modificationOffset() {
        return this.modificationOffset;
    }

    public int removedLength() {
        return this.removedLength;
    }

    public CharSequence removedText() {
        return this.removedText;
    }

    public int insertedLength() {
        return this.insertedLength;
    }

    public OriginalText originalText() {
        if (this.originalText == null) {
            if (this.removedLength != 0 && this.removedText == null) {
                throw new IllegalStateException("Cannot obtain removed text for " + this.tokenHierarchyOperation.mutableInputSource() + " which breaks token snapshots operation and" + " token text retaining after token's removal." + " Valid removedText in TokenHierarchyControl.textModified()" + " should be provided.");
            }
            this.originalText = new OriginalText(LexerSpiPackageAccessor.get().text(this.tokenHierarchyOperation.mutableTextInput()), this.modificationOffset, this.removedText, this.insertedLength);
        }
        return this.originalText;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("modOffset=");
        sb.append(this.modificationOffset());
        if (this.removedLength() > 0) {
            sb.append(", removedLength=");
            sb.append(this.removedLength());
        }
        if (this.insertedLength() > 0) {
            sb.append(", insertedLength=");
            sb.append(this.insertedLength());
        }
        sb.append(", Affected(");
        sb.append(this.affectedStartOffset());
        sb.append(",");
        sb.append(this.affectedEndOffset());
        sb.append(')');
        return sb.toString();
    }
}

