/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.lexer.inc;

import org.netbeans.api.lexer.TokenId;
import org.netbeans.lib.lexer.EmbeddedTokenList;
import org.netbeans.lib.lexer.LanguageOperation;
import org.netbeans.lib.lexer.LexerInputOperation;
import org.netbeans.lib.lexer.LexerUtilsConstants;
import org.netbeans.lib.lexer.inc.IncTokenList;
import org.netbeans.lib.lexer.inc.MutableTokenList;
import org.netbeans.lib.lexer.inc.TokenHierarchyEventInfo;
import org.netbeans.lib.lexer.inc.TokenListChange;
import org.netbeans.lib.lexer.token.AbstractToken;
import org.netbeans.spi.lexer.TokenValidator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TokenListUpdater {
    /*
     * Enabled aggressive block sorting
     */
    public static <T extends TokenId> void update(MutableTokenList<T> tokenList, TokenHierarchyEventInfo eventInfo, TokenListChange<T> change) {
        int lookahead;
        boolean relex;
        int matchOffset;
        int relexOffset;
        int relexIndex;
        int index;
        int modTokenOffset;
        AbstractToken<T> modToken;
        if (tokenList.getClass() == EmbeddedTokenList.class) {
            ((EmbeddedTokenList)tokenList).updateStatus();
        }
        int modOffset = eventInfo.modificationOffset();
        LanguageOperation<T> languageOperation = LexerUtilsConstants.mostEmbeddedLanguageOperation(tokenList.languagePath());
        int tokenCount = tokenList.tokenCountCurrent();
        if (tokenCount == 0) {
            if (!tokenList.isFullyLexed()) {
                return;
            }
            modToken = null;
            modTokenOffset = modOffset;
            index = 0;
        } else {
            index = tokenCount - 1;
            modTokenOffset = tokenList.tokenOffset(index);
            if (modOffset >= modTokenOffset) {
                modToken = TokenListUpdater.token(tokenList, index);
                int modTokenEndOffset = modTokenOffset + modToken.length();
                if (modOffset >= modTokenEndOffset) {
                    if (!tokenList.isFullyLexed() && modOffset >= modTokenEndOffset + tokenList.lookahead(index)) {
                        return;
                    }
                    ++index;
                    modToken = null;
                    modTokenOffset = modTokenEndOffset;
                }
            } else {
                int low = 0;
                while (low <= index) {
                    int mid = (low + index) / 2;
                    int midStartOffset = tokenList.tokenOffset(mid);
                    if (midStartOffset < modOffset) {
                        low = mid + 1;
                        continue;
                    }
                    if (midStartOffset > modOffset) {
                        index = mid - 1 < 0 ? 0 : mid - 1;
                        continue;
                    }
                    index = mid;
                    modTokenOffset = midStartOffset;
                    break;
                }
                if (index < low) {
                    modTokenOffset = tokenList.tokenOffset(index);
                }
                modToken = TokenListUpdater.token(tokenList, index);
            }
        }
        change.setOffsetGapIndex(index);
        boolean attemptValidation = false;
        if (index == 0) {
            relexIndex = index;
            relexOffset = modTokenOffset;
            if (modToken != null && eventInfo.removedLength() < modToken.length()) {
                attemptValidation = true;
            }
        } else {
            if (modOffset == modTokenOffset && eventInfo.removedLength() == 0) {
                modToken = TokenListUpdater.token(tokenList, --index);
                modTokenOffset -= modToken.length();
            }
            if (index == 0 || modTokenOffset + tokenList.lookahead(index - 1) <= modOffset) {
                relexIndex = index;
                relexOffset = modTokenOffset;
                if (modOffset + eventInfo.removedLength() < modTokenOffset + modToken.length()) {
                    attemptValidation = true;
                }
            } else {
                AbstractToken<T> token;
                relexOffset = modTokenOffset - TokenListUpdater.token(tokenList, index - 1).length();
                for (relexIndex = index - 2; relexIndex >= 0; --relexIndex, relexOffset -= token.length()) {
                    token = TokenListUpdater.token(tokenList, relexIndex);
                    if (relexOffset + tokenList.lookahead(relexIndex) <= modOffset) break;
                }
                ++relexIndex;
            }
        }
        if (attemptValidation) {
            matchOffset = modTokenOffset + modToken.length();
            TokenValidator tokenValidator = languageOperation.tokenValidator(modToken.id());
            if (tokenValidator != null && tokenList.getClass() == IncTokenList.class && !eventInfo.tokenHierarchyOperation().canModifyToken(index, modToken)) {
                // empty if block
            }
        } else if (index < tokenCount) {
            int removeEndOffset = modOffset + eventInfo.removedLength();
            for (matchOffset = modTokenOffset + modToken.length(); matchOffset < removeEndOffset && index + 1 < tokenCount; matchOffset += TokenListUpdater.token(tokenList, ++index).length()) {
            }
        } else {
            matchOffset = modTokenOffset;
        }
        Object relexState = relexIndex > 0 ? tokenList.state(relexIndex - 1) : null;
        change.setOffset(relexOffset);
        boolean bl = relex = relexOffset != (matchOffset += eventInfo.insertedLength() - eventInfo.removedLength()) || index >= tokenCount || !LexerUtilsConstants.statesEqual(relexState, tokenList.state(index));
        if (!relex && (lookahead = tokenList.lookahead(index)) > 1 && index + 1 < tokenCount) {
            boolean bl2 = relex = lookahead > TokenListUpdater.token(tokenList, index + 1).length();
        }
        if (relex) {
            LexerInputOperation<T> lexerInputOperation = tokenList.createLexerInputOperation(relexIndex, relexOffset, relexState);
            do {
                AbstractToken<T> token;
                if ((token = lexerInputOperation.nextToken()) == null) {
                    attemptValidation = false;
                    break;
                }
                lookahead = lexerInputOperation.lookahead();
                Object state = lexerInputOperation.lexerState();
                change.addToken(token, lookahead, state);
                if ((relexOffset += token.length()) > matchOffset && index < tokenCount) {
                    attemptValidation = false;
                    do {
                        if (++index != tokenCount) continue;
                        modToken = null;
                        if (tokenList.isFullyLexed()) {
                            matchOffset = Integer.MAX_VALUE;
                            break;
                        }
                        relex = false;
                        break;
                    } while (relexOffset > (matchOffset += TokenListUpdater.token(tokenList, index).length()));
                }
                if (relexOffset != matchOffset || index >= tokenCount || !LexerUtilsConstants.statesEqual(state, tokenList.state(index))) continue;
                int matchTokenLookahead = tokenList.lookahead(index);
                boolean lookaheadOK = true;
                if (matchTokenLookahead > 1 || lookahead > 1) {
                    int laCheckTokenOffset = matchOffset;
                    for (int laCheckIndex = index + 1; laCheckIndex < tokenCount; ++laCheckIndex) {
                        int laCheckTokenLength = TokenListUpdater.token(tokenList, laCheckIndex).length();
                        laCheckTokenOffset += laCheckTokenLength;
                        if ((lookahead -= laCheckTokenLength) <= 0 && (matchTokenLookahead -= laCheckTokenLength) <= 0) break;
                        if (lookahead == tokenList.lookahead(laCheckIndex) && matchTokenLookahead <= 0) continue;
                        index = laCheckIndex;
                        matchOffset = laCheckTokenOffset;
                        lookaheadOK = false;
                    }
                }
                if (!lookaheadOK) continue;
                if (!attemptValidation) break;
                attemptValidation = false;
                break;
            } while (relex);
            lexerInputOperation.release();
        }
        change.setIndex(relexIndex);
        change.setAddedEndOffset(relexOffset);
        tokenList.replaceTokens(eventInfo, change, modToken != null ? index - relexIndex + 1 : index - relexIndex);
    }

    private static <T extends TokenId> AbstractToken<T> token(MutableTokenList<T> tokenList, int index) {
        Object tokenOrEmbeddingContainer = tokenList.tokenOrEmbeddingContainerUnsync(index);
        return LexerUtilsConstants.token(tokenOrEmbeddingContainer);
    }
}

