/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.spi.lexer;

import org.netbeans.lib.editor.util.AbstractCharSequence;
import org.netbeans.lib.lexer.CharProvider;
import org.netbeans.lib.lexer.IntegerCache;
import org.netbeans.lib.lexer.LexerUtilsConstants;

public final class LexerInput {
    public static final int EOF = -1;
    private CharProvider charProvider;
    private ReadText readText;
    private int eof;

    LexerInput(CharProvider charProvider) {
        this.charProvider = charProvider;
    }

    public int read() {
        int c = this.charProvider.read();
        if (c == -1) {
            this.eof = 1;
        }
        return c;
    }

    public void backup(int count) {
        if (count < 0) {
            throw new IndexOutOfBoundsException("count=" + count + " <0");
        }
        LexerUtilsConstants.checkValidBackup(count, this.readLengthEOF());
        if (this.eof != 0) {
            this.eof = 0;
            --count;
        }
        this.charProvider.backup(count);
    }

    public int readLength() {
        return this.charProvider.readIndex();
    }

    public int readLengthEOF() {
        return this.readLength() + this.eof;
    }

    public CharSequence readText(int start, int end) {
        assert (start >= 0 && end >= start && end <= this.readLength()) : "start=" + start + ", end=" + end + ", readLength()=" + this.readLength();
        if (this.readText == null) {
            this.readText = new ReadText();
        }
        this.readText.reinit(start, end);
        return this.readText;
    }

    public CharSequence readText() {
        return this.readText(0, this.readLength());
    }

    public boolean consumeNewline() {
        if (this.read() == 10) {
            return true;
        }
        this.backup(1);
        return false;
    }

    public static Integer integerState(int state) {
        return IntegerCache.integer(state);
    }

    private final class ReadText
    extends AbstractCharSequence.StringLike {
        private int start;
        private int length;

        private ReadText() {
        }

        private void reinit(int start, int end) {
            this.start = start;
            this.length = end - start;
        }

        public int length() {
            return this.length;
        }

        public char charAt(int index) {
            if (index < 0 || index >= this.length) {
                throw new IndexOutOfBoundsException("index=" + index + ", length=" + this.length);
            }
            return LexerInput.this.charProvider.readExisting(index);
        }
    }
}

