/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorSupport;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import javax.beans.binding.BindingConverter;
import javax.beans.binding.BindingValidator;
import org.netbeans.modules.form.BindingCustomizer;
import org.netbeans.modules.form.BindingDescriptor;
import org.netbeans.modules.form.FormEditor;
import org.netbeans.modules.form.FormModel;
import org.netbeans.modules.form.FormProperty;
import org.netbeans.modules.form.FormPropertyContext;
import org.netbeans.modules.form.FormUtils;
import org.netbeans.modules.form.MetaBinding;
import org.netbeans.modules.form.RADComponent;
import org.netbeans.modules.form.RADComponentNode;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;

public class BindingProperty
extends PropertySupport.ReadWrite {
    private RADComponent bindingComponent;
    private BindingDescriptor bindingDescriptor;
    private MetaBinding binding;
    private Property nullValueProperty;
    private Property incompleteValueProperty;
    private Property validatorProperty;
    private Property converterProperty;

    public BindingProperty(RADComponent metacomp, BindingDescriptor desc) {
        super(desc.getPath(), MetaBinding.class, desc.getDisplayName(), desc.getShortDescription());
        this.bindingComponent = metacomp;
        this.bindingDescriptor = desc;
        FormProperty prop = (FormProperty)this.bindingComponent.getPropertyByName(this.bindingDescriptor.getPath());
        if (prop == null) {
            prop = this.bindingComponent.getAllBeanProperties()[0];
        }
        if (prop != null) {
            String name = FormUtils.getBundleString("MSG_Binding_NullProperty");
            this.nullValueProperty = new Property(prop, "nullValue", desc.getValueType(), name, name, false);
            name = FormUtils.getBundleString("MSG_Binding_IncompletePathProperty");
            this.incompleteValueProperty = new Property(prop, "incompletePathValue", desc.getValueType(), name, name, false);
            name = FormUtils.getBundleString("MSG_Binding_Validator");
            this.validatorProperty = new Property(prop, "validator", BindingValidator.class, name, name, true);
            name = FormUtils.getBundleString("MSG_Binding_Converter");
            this.converterProperty = new Property(prop, "converter", BindingConverter.class, name, name, true);
        }
    }

    public String getHtmlDisplayName() {
        return this.binding != null ? "<b>" + this.getDisplayName() : null;
    }

    public Object getValue() {
        return this.binding;
    }

    public void setValue(Object val) {
        MetaBinding old = this.binding;
        if (old == null && val != null) {
            FormEditor.getFormEditor(this.bindingComponent.getFormModel()).updateProjectForBeansBinding();
        }
        this.binding = (MetaBinding)val;
        FormEditor.getBindingSupport(this.getFormModel()).changeBindingInModel(old, this.binding);
        this.getFormModel().fireBindingChanged(this.getBindingComponent(), this.getBindingPath(), old, this.binding);
        RADComponentNode node = this.getBindingComponent().getNodeReference();
        if (node != null) {
            node.firePropertyChangeHelper(null, null, null);
        }
    }

    public boolean supportsDefaultValue() {
        return true;
    }

    public void restoreDefaultValue() {
        this.setValue(null);
        Node.Property prop = this.bindingComponent.getPropertyByName(this.bindingDescriptor.getPath());
        if (prop != null && prop.supportsDefaultValue()) {
            try {
                prop.restoreDefaultValue();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    public boolean isDefaultValue() {
        return this.getValue() == null;
    }

    public PropertyEditor getPropertyEditor() {
        return new BindingPropertyEditor();
    }

    public RADComponent getBindingComponent() {
        return this.bindingComponent;
    }

    public BindingDescriptor getBindingDescriptor() {
        return this.bindingDescriptor;
    }

    String getBindingPath() {
        return this.bindingDescriptor.getPath();
    }

    Class getBindingValueType() {
        return this.bindingDescriptor.getValueType();
    }

    private FormModel getFormModel() {
        return this.bindingComponent.getFormModel();
    }

    FormProperty getNullValueProperty() {
        return this.nullValueProperty;
    }

    FormProperty getIncompleteValueProperty() {
        return this.incompleteValueProperty;
    }

    FormProperty getValidatorProperty() {
        return this.validatorProperty;
    }

    FormProperty getConverterProperty() {
        return this.converterProperty;
    }

    private class BindingPropertyEditor
    extends PropertyEditorSupport {
        private BindingCustomizer customizer;
        private ActionListener customizerListener;

        private BindingPropertyEditor() {
        }

        public String getAsText() {
            RADComponent boundComp = null;
            String path = null;
            if (BindingProperty.this.binding != null) {
                boundComp = BindingProperty.this.binding.getSource();
                path = BindingProperty.this.binding.getSourcePath();
            }
            if (boundComp == null) {
                return "";
            }
            return path != null ? boundComp.getName() + "[" + path + "]" : boundComp.getName();
        }

        public void setAsText(String text) {
            if ("".equals(text)) {
                this.setValue(null);
            } else {
                int idx = text.indexOf(91);
                String compName = idx >= 0 ? text.substring(0, idx) : text;
                RADComponent boundComp = BindingProperty.this.getFormModel().findRADComponent(compName);
                if (boundComp != null) {
                    String path;
                    String string = path = idx >= 0 ? text.substring(idx + 1, text.length() - 1) : "";
                    if (!path.equals("")) {
                        if (boundComp != BindingProperty.this.getBindingComponent() || !path.equals(BindingProperty.this.getBindingPath())) {
                            this.setValue(new MetaBinding(boundComp, path, BindingProperty.this.getBindingComponent(), BindingProperty.this.getBindingPath()));
                        }
                    } else if (boundComp != BindingProperty.this.getBindingComponent() && Collection.class.isAssignableFrom(BindingProperty.this.getBindingValueType()) && BindingProperty.this.getBindingValueType().equals(boundComp.getBeanClass())) {
                        this.setValue(new MetaBinding(boundComp, null, BindingProperty.this.getBindingComponent(), BindingProperty.this.getBindingPath()));
                    }
                }
            }
        }

        public boolean supportsCustomEditor() {
            return true;
        }

        public Component getCustomEditor() {
            if (this.customizer == null) {
                this.customizer = new BindingCustomizer(BindingProperty.this);
                this.customizerListener = new ActionListener(){

                    public void actionPerformed(ActionEvent ev) {
                        BindingPropertyEditor.this.setValue(BindingPropertyEditor.this.customizer.getBinding());
                    }
                };
            }
            this.customizer.setBinding((MetaBinding)this.getValue());
            return this.customizer.getDialog(this.customizerListener);
        }
    }

    static class Property
    extends FormProperty {
        private Object value;
        private boolean supportsDefaultValue;

        Property(FormProperty prop, String name, Class type, String displayName, String description, boolean supportsDefaultValue) {
            super(new FormPropertyContext.SubProperty(prop), name, type, displayName, description);
            this.supportsDefaultValue = supportsDefaultValue;
        }

        public Object getTargetValue() throws IllegalAccessException, InvocationTargetException {
            return this.value;
        }

        public void setTargetValue(Object value) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
            this.value = value;
        }

        public boolean supportsDefaultValue() {
            return this.supportsDefaultValue;
        }
    }
}

