/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.LayoutManager;
import javax.swing.BorderFactory;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.editor.EditorUI;
import org.netbeans.modules.form.FormEditor;
import org.netbeans.modules.form.FormModel;
import org.netbeans.modules.form.FormProperty;
import org.netbeans.modules.form.FormUtils;
import org.netbeans.modules.form.RADComponent;
import org.netbeans.modules.form.RADConnectionPropertyEditor;
import org.netbeans.modules.form.RADProperty;
import org.openide.util.Utilities;

class CodeCustomEditor
extends JPanel
implements DocumentListener,
Runnable {
    private RADConnectionPropertyEditor propertyEditor;
    private JEditorPane codePane;
    private boolean ignoreUpdate;

    public CodeCustomEditor(RADConnectionPropertyEditor propertyEditor, FormModel formModel, FormProperty property) {
        this.propertyEditor = propertyEditor;
        JScrollPane jScrollPane = new JScrollPane(){

            public Dimension getPreferredSize() {
                Dimension prefSize = super.getPreferredSize();
                JScrollBar hBar = this.getHorizontalScrollBar();
                if (hBar != null && hBar.isVisible()) {
                    prefSize = new Dimension(prefSize.width, prefSize.height + ((Component)hBar).getPreferredSize().height);
                }
                return prefSize;
            }
        };
        this.codePane = new JEditorPane();
        jScrollPane.setViewportView(this.codePane);
        JLabel headerLabel = new JLabel();
        JLabel footerLabel = new JLabel();
        JTextField typeField = new JTextField();
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setAutocreateContainerGaps(true);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createSequentialGroup().add((Component)headerLabel, -2, -1, -2).add(3).add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)jScrollPane, -2, 320, Short.MAX_VALUE).add((Component)typeField)).add(3).add((Component)footerLabel));
        layout.setVerticalGroup((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add(jScrollPane.getInsets().top).add((GroupLayout.Group)layout.createParallelGroup().add((Component)headerLabel).add((Component)footerLabel))).add((Component)jScrollPane, -1, -1, -2)).add((Component)typeField, -2, -1, -2));
        this.codePane.setContentType("text/x-java");
        EditorUI eui = org.netbeans.editor.Utilities.getEditorUI((JTextComponent)this.codePane);
        eui.removeLayer("highlight-row-layer");
        this.codePane.getDocument().putProperty("stream", (Object)FormEditor.getFormDataObject(formModel));
        if (property instanceof RADProperty && property.getWriteMethod() != null) {
            RADComponent metacomp = ((RADProperty)property).getRADComponent();
            headerLabel.setFont(this.codePane.getFont());
            headerLabel.setText("<html>" + metacomp.getName() + ".<b>" + property.getWriteMethod().getName() + "</b>(");
            footerLabel.setFont(this.codePane.getFont());
            footerLabel.setText(");");
        } else {
            headerLabel.setText(FormUtils.getBundleString("CodeCustomEditor.codeLabel"));
        }
        typeField.setBorder(BorderFactory.createEmptyBorder());
        typeField.setEditable(false);
        typeField.setFont(this.codePane.getFont());
        typeField.setText(Utilities.getClassName((Class)property.getValueType()));
        this.codePane.getDocument().addDocumentListener(this);
    }

    void setValue(RADConnectionPropertyEditor.RADConnectionDesignValue value) {
        if (value != null && value.getType() == 2) {
            this.ignoreUpdate = true;
            this.codePane.setText(value.getCode());
            this.ignoreUpdate = false;
        }
    }

    private int getLineCount() {
        return this.codePane.getDocument().getRootElements()[0].getElementCount();
    }

    public void insertUpdate(DocumentEvent e) {
        this.invokeUpdate();
    }

    public void removeUpdate(DocumentEvent e) {
        this.invokeUpdate();
    }

    public void changedUpdate(DocumentEvent e) {
    }

    private void invokeUpdate() {
        if (!this.ignoreUpdate) {
            this.ignoreUpdate = true;
            EventQueue.invokeLater(this);
            this.revalidate();
            this.repaint();
        }
    }

    public void run() {
        this.propertyEditor.setValue(new RADConnectionPropertyEditor.RADConnectionDesignValue(this.codePane.getText()));
        this.ignoreUpdate = false;
    }
}

