/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public class ComboBoxWithTree
extends JComboBox {
    private Window popup;
    private JTree tree;
    private JScrollPane scrollPane;
    private Converter converter;

    public ComboBoxWithTree(TreeModel treeModel, TreeCellRenderer treeCellRenderer, Converter converter) {
        this.converter = converter;
        this.initCombo();
        this.initTree(treeModel, treeCellRenderer);
    }

    private void initCombo() {
        this.setEditable(true);
        this.addPopupMenuListener(new PopupMenuListener(){

            public void popupMenuCanceled(PopupMenuEvent e) {
            }

            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                ComboBoxWithTree.this.getPopup().setVisible(false);
            }

            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                ComboBoxWithTree.this.updateTreeSelection();
                Dimension dim = ComboBoxWithTree.this.getSize();
                Point p = ComboBoxWithTree.this.getLocationOnScreen();
                Window w = ComboBoxWithTree.this.getPopup();
                w.setLocation(p.x, p.y + dim.height);
                w.setSize(new Dimension(dim.width, ((ComboBoxWithTree)ComboBoxWithTree.this).scrollPane.getPreferredSize().height));
                w.setVisible(true);
            }
        });
        this.setModel(new DefaultComboBoxModel<Object>(new Object[]{""}));
        this.setRenderer(new DefaultListCellRenderer(){

            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                if (index == -1) {
                    return super.getListCellRendererComponent((JList<?>)list, "null", index, isSelected, cellHasFocus);
                }
                JLabel comp = new JLabel();
                comp.setPreferredSize(new Dimension(0, -1));
                return comp;
            }
        });
    }

    private void initTree(TreeModel treeModel, TreeCellRenderer treeCellRenderer) {
        this.tree = new JTree();
        DefaultTreeSelectionModel selectionModel = new DefaultTreeSelectionModel();
        selectionModel.setSelectionMode(1);
        this.tree.setRootVisible(false);
        this.tree.setShowsRootHandles(true);
        this.tree.setSelectionModel(selectionModel);
        this.tree.setVisibleRowCount(10);
        this.tree.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                int code = e.getKeyCode();
                if (code == 10 || code == 27) {
                    ComboBoxWithTree.this.setPopupVisible(false);
                }
            }
        });
        this.tree.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() > 1) {
                    ComboBoxWithTree.this.setPopupVisible(false);
                }
            }
        });
        this.tree.addTreeSelectionListener(new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent e) {
                String value = ComboBoxWithTree.this.converter.pathToString(e.getPath());
                ComboBoxWithTree.this.setSelectedItem(value);
            }
        });
        this.tree.setModel(treeModel);
        this.tree.setCellRenderer(treeCellRenderer);
    }

    private Window getPopup() {
        if (this.popup == null) {
            this.popup = new Window(SwingUtilities.getWindowAncestor(this));
            this.scrollPane = new JScrollPane(this.tree);
            this.scrollPane.setBorder(BorderFactory.createLineBorder(Color.BLACK));
            JPopupMenu menu = new JPopupMenu(){

                public boolean isVisible() {
                    return true;
                }
            };
            menu.setBorder(new EmptyBorder(0, 0, 0, 0));
            menu.setLayout(new BorderLayout());
            menu.add(this.scrollPane);
            this.popup.add(menu);
        }
        return this.popup;
    }

    private void updateTreeSelection() {
        String value = this.getEditor().getItem().toString();
        final TreePath path = this.converter.stringToPath(value);
        if (path == null) {
            this.tree.clearSelection();
        } else {
            this.tree.setSelectionPath(path);
            EventQueue.invokeLater(new Runnable(){

                public void run() {
                    ComboBoxWithTree.this.tree.scrollPathToVisible(path);
                }
            });
        }
    }

    public static interface Converter {
        public String pathToString(TreePath var1);

        public TreePath stringToPath(String var1);
    }
}

