/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyEditor;
import javax.accessibility.Accessible;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.modules.form.BeanSupport;
import org.netbeans.modules.form.FormDesignValue;
import org.netbeans.modules.form.FormProperty;
import org.netbeans.modules.form.FormPropertyEditor;
import org.netbeans.modules.form.FormUtils;
import org.netbeans.modules.form.NamedPropertyEditor;
import org.netbeans.modules.form.RADProperty;
import org.openide.awt.Mnemonics;
import org.openide.explorer.propertysheet.ExPropertyEditor;
import org.openide.explorer.propertysheet.PropertyEnv;
import org.openide.explorer.propertysheet.editors.EnhancedCustomPropertyEditor;
import org.openide.util.HelpCtx;
import org.openide.util.Utilities;

public class FormCustomEditor
extends JPanel
implements EnhancedCustomPropertyEditor {
    private static final int DEFAULT_WIDTH = 350;
    private static final int DEFAULT_HEIGHT = 350;
    private FormPropertyEditor editor;
    private PropertyEditor[] allEditors;
    private Component[] allCustomEditors;
    private boolean[] validValues;
    private int originalEditorIndex;
    private JPanel cardPanel;
    private JComboBox editorsCombo;

    public FormCustomEditor(FormPropertyEditor editor, Component currentCustomEditor) {
        JLabel modeLabel = new JLabel();
        this.editorsCombo = new JComboBox();
        this.editorsCombo.setRenderer(new EditorComboRenderer());
        JPanel borderPanel = new JPanel();
        borderPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(), BorderFactory.createEmptyBorder(1, 1, 2, 2)));
        borderPanel.setLayout(new BorderLayout());
        this.cardPanel = new JPanel();
        this.cardPanel.setLayout(new CardLayout());
        borderPanel.add((Component)this.cardPanel, "Center");
        FormProperty property = editor.getProperty();
        String selectModeText = property instanceof RADProperty ? FormUtils.getFormattedBundleString("FMT_EditingModeLabel1", new Object[]{((RADProperty)property).getRADComponent().getName(), property.getName()}) : FormUtils.getFormattedBundleString("FMT_EditingModeLabel2", new Object[]{property.getName()});
        Mnemonics.setLocalizedText((JLabel)modeLabel, (String)selectModeText);
        this.editorsCombo.setToolTipText(FormUtils.getBundleString("EditingMode_Hint"));
        modeLabel.setLabelFor(this.editorsCombo);
        this.editor = editor;
        this.allEditors = editor.getAllEditors();
        PropertyEditor currentEditor = editor.getCurrentEditor();
        this.allCustomEditors = new Component[this.allEditors.length];
        this.validValues = new boolean[this.allEditors.length];
        PropertyEnv env = editor.getPropertyEnv();
        Object currentValue = editor.getValue();
        for (int i = 0; i < this.allEditors.length; ++i) {
            String editorName;
            PropertyEditor prEd = this.allEditors[i];
            boolean current = currentEditor == prEd;
            boolean valueSet = false;
            Component custEd = null;
            if (current) {
                valueSet = true;
                custEd = currentCustomEditor;
            } else {
                Object defaultValue;
                editor.getPropertyContext().initPropertyEditor(prEd, property);
                if (env != null && prEd instanceof ExPropertyEditor) {
                    ((ExPropertyEditor)prEd).attachEnv(env);
                }
                if (currentValue != null) {
                    try {
                        Object realValue;
                        if (editor.getPropertyType().isAssignableFrom(currentValue.getClass())) {
                            prEd.setValue(currentValue);
                            valueSet = true;
                        } else if (currentValue instanceof FormDesignValue && (realValue = ((FormDesignValue)currentValue).getDesignValue()) != FormDesignValue.IGNORED_VALUE) {
                            prEd.setValue(realValue);
                            valueSet = true;
                        }
                    }
                    catch (IllegalArgumentException ex) {
                        // empty catch block
                    }
                }
                if (!valueSet && (defaultValue = property.getDefaultValue()) != BeanSupport.NO_VALUE) {
                    prEd.setValue(defaultValue);
                    valueSet = true;
                }
                if (prEd.supportsCustomEditor()) {
                    custEd = prEd.getCustomEditor();
                }
            }
            this.validValues[i] = valueSet;
            if (prEd instanceof NamedPropertyEditor) {
                editorName = ((NamedPropertyEditor)prEd).getDisplayName();
            } else {
                String string = editorName = i == 0 ? FormUtils.getBundleString("CTL_DefaultEditor_DisplayName") : Utilities.getShortClassName(prEd.getClass());
            }
            if (custEd == null || custEd instanceof Window) {
                JPanel p = new JPanel(new GridBagLayout());
                JLabel label = new JLabel(FormUtils.getBundleString("CTL_PropertyEditorDoesNot"));
                p.add(label);
                p.getAccessibleContext().setAccessibleDescription(label.getText());
                custEd = p;
            }
            this.allCustomEditors[i] = custEd;
            this.cardPanel.add(editorName, custEd);
            this.editorsCombo.addItem(editorName);
            if (!current) continue;
            this.originalEditorIndex = i;
            this.editorsCombo.setSelectedIndex(i);
            this.updateAccessibleDescription(custEd);
        }
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)borderPanel, -1, -1, Short.MAX_VALUE).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)modeLabel, -2, -1, -2).addPreferredGap(0).add((Component)this.editorsCombo, -2, this.editorsCombo.getPreferredSize().width * 5 / 4, -2))).addContainerGap());
        layout.setVerticalGroup((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)modeLabel).add((Component)this.editorsCombo, -2, -1, -2)).addPreferredGap(1).add((Component)borderPanel, -1, -1, Short.MAX_VALUE));
        CardLayout cl = (CardLayout)this.cardPanel.getLayout();
        cl.show(this.cardPanel, (String)this.editorsCombo.getSelectedItem());
        this.editorsCombo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CardLayout cl2 = (CardLayout)FormCustomEditor.this.cardPanel.getLayout();
                cl2.show(FormCustomEditor.this.cardPanel, (String)FormCustomEditor.this.editorsCombo.getSelectedItem());
                int i = FormCustomEditor.this.editorsCombo.getSelectedIndex();
                HelpCtx helpCtx = i < 0 ? null : HelpCtx.findHelp((Component)FormCustomEditor.this.cardPanel.getComponent(i));
                String helpID = helpCtx != null ? helpCtx.getHelpID() : "";
                HelpCtx.setHelpIDString((JComponent)FormCustomEditor.this, (String)helpID);
                FormCustomEditor.this.updateAccessibleDescription(i < 0 ? null : FormCustomEditor.this.cardPanel.getComponent(i));
            }
        });
        this.editorsCombo.getAccessibleContext().setAccessibleDescription(FormUtils.getBundleString("ACSD_EditingMode"));
    }

    private void updateAccessibleDescription(Component comp) {
        if (comp instanceof Accessible && comp.getAccessibleContext().getAccessibleDescription() != null) {
            this.getAccessibleContext().setAccessibleDescription(FormUtils.getFormattedBundleString("ACSD_FormCustomEditor", new Object[]{comp.getAccessibleContext().getAccessibleDescription()}));
        } else {
            this.getAccessibleContext().setAccessibleDescription(null);
        }
    }

    public Dimension getPreferredSize() {
        Dimension inh = super.getPreferredSize();
        return new Dimension(Math.max(inh.width, 350), Math.max(inh.height, 350));
    }

    public Object getPropertyValue() throws IllegalStateException {
        Component currentCustomEditor;
        int currentIndex = this.editorsCombo.getSelectedIndex();
        PropertyEditor currentEditor = currentIndex > -1 ? this.allEditors[currentIndex] : null;
        Component component = currentCustomEditor = currentIndex > -1 ? this.allCustomEditors[currentIndex] : null;
        Object value = currentCustomEditor instanceof EnhancedCustomPropertyEditor ? ((EnhancedCustomPropertyEditor)currentCustomEditor).getPropertyValue() : (currentIndex > -1 ? (this.validValues[currentIndex] ? currentEditor.getValue() : BeanSupport.NO_VALUE) : this.editor.getValue());
        if (currentIndex > -1) {
            Object[] nodes = this.editor.getPropertyEnv().getBeans();
            value = nodes == null || nodes.length <= 1 ? new FormProperty.ValueWithEditor(value, currentEditor) : new FormProperty.ValueWithEditor(value, currentIndex);
        }
        if (!this.editor.getProperty().canWrite() && value instanceof FormProperty.ValueWithEditor) {
            value = ((FormProperty.ValueWithEditor)value).getValue();
        }
        return value;
    }

    private class EditorComboRenderer
    extends DefaultListCellRenderer {
        private EditorComboRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            if (index == FormCustomEditor.this.originalEditorIndex && FormCustomEditor.this.editorsCombo.isPopupVisible()) {
                this.setFont(list.getFont().deriveFont(1));
            }
            return this;
        }
    }
}

