/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form;

import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.MenuComponent;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyEditor;
import java.beans.PropertyVetoException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JToggleButton;
import javax.swing.OverlayLayout;
import javax.swing.RepaintManager;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import javax.swing.UIDefaults;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.undo.UndoableEdit;
import org.jdesktop.layout.Baseline;
import org.netbeans.core.spi.multiview.CloseOperationState;
import org.netbeans.core.spi.multiview.MultiViewElement;
import org.netbeans.core.spi.multiview.MultiViewElementCallback;
import org.netbeans.core.spi.multiview.MultiViewFactory;
import org.netbeans.modules.form.ComponentContainer;
import org.netbeans.modules.form.ComponentInspector;
import org.netbeans.modules.form.ComponentLayer;
import org.netbeans.modules.form.Event;
import org.netbeans.modules.form.FormDataObject;
import org.netbeans.modules.form.FormEditor;
import org.netbeans.modules.form.FormEditorSupport;
import org.netbeans.modules.form.FormLAF;
import org.netbeans.modules.form.FormLoaderSettings;
import org.netbeans.modules.form.FormModel;
import org.netbeans.modules.form.FormModelEvent;
import org.netbeans.modules.form.FormModelListener;
import org.netbeans.modules.form.FormNode;
import org.netbeans.modules.form.FormProperty;
import org.netbeans.modules.form.FormToolBar;
import org.netbeans.modules.form.FormUtils;
import org.netbeans.modules.form.HandleLayer;
import org.netbeans.modules.form.InPlaceEditLayer;
import org.netbeans.modules.form.NonVisualTray;
import org.netbeans.modules.form.RADComponent;
import org.netbeans.modules.form.RADComponentNode;
import org.netbeans.modules.form.RADConnectionPropertyEditor;
import org.netbeans.modules.form.RADMenuComponent;
import org.netbeans.modules.form.RADProperty;
import org.netbeans.modules.form.RADVisualComponent;
import org.netbeans.modules.form.RADVisualContainer;
import org.netbeans.modules.form.RADVisualFormContainer;
import org.netbeans.modules.form.VisualReplicator;
import org.netbeans.modules.form.assistant.AssistantModel;
import org.netbeans.modules.form.assistant.AssistantView;
import org.netbeans.modules.form.layoutdesign.LayoutComponent;
import org.netbeans.modules.form.layoutdesign.LayoutConstants;
import org.netbeans.modules.form.layoutdesign.LayoutDesigner;
import org.netbeans.modules.form.layoutdesign.LayoutModel;
import org.netbeans.modules.form.layoutdesign.VisualMapper;
import org.netbeans.modules.form.layoutsupport.LayoutSupportManager;
import org.netbeans.modules.form.menu.MenuEditLayer;
import org.netbeans.modules.form.palette.PaletteItem;
import org.netbeans.modules.form.palette.PaletteUtils;
import org.netbeans.modules.form.wizard.ConnectionWizard;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.actions.FileSystemAction;
import org.openide.awt.UndoRedo;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.ExplorerUtils;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.Mutex;
import org.openide.util.Utilities;
import org.openide.util.actions.SystemAction;
import org.openide.util.lookup.Lookups;
import org.openide.util.lookup.ProxyLookup;
import org.openide.windows.TopComponent;

public class FormDesigner
extends TopComponent
implements MultiViewElement {
    static final String PROP_DESIGNER_SIZE = "designerSize";
    private JLayeredPane layeredPane;
    private ComponentLayer componentLayer;
    private HandleLayer handleLayer;
    private NonVisualTray nonVisualTray;
    private FormToolBar formToolBar;
    private InPlaceEditLayer textEditLayer;
    private FormProperty editedProperty;
    private InPlaceEditLayer.FinishListener finnishListener;
    private MenuEditLayer menuEditLayer;
    private FormModel formModel;
    private FormModelListener formModelListener;
    private RADVisualComponent topDesignComponent;
    private FormEditor formEditor;
    private List selectedComponents = new ArrayList();
    private List selectedLayoutComponents = new ArrayList();
    private VisualReplicator replicator;
    private LayoutDesigner layoutDesigner;
    private List designerActions;
    private List resizabilityActions;
    private JToggleButton[] resizabilityButtons;
    private int designerMode;
    static final int MODE_SELECT = 0;
    static final int MODE_CONNECT = 1;
    static final int MODE_ADD = 2;
    private boolean initialized = false;
    private boolean firstLayout;
    private RADComponent connectionSource;
    private RADComponent connectionTarget;
    MultiViewElementCallback multiViewObserver;
    private ExplorerManager explorerManager;
    private FormProxyLookup lookup;
    private AssistantView assistantView;
    private PreferenceChangeListener settingsListener;
    private static String iconURL = "org/netbeans/modules/form/resources/formDesigner.gif";
    private boolean hasPropertyChangeListener = false;
    private boolean formDesignerOpened;

    FormDesigner(FormEditor formEditor) {
        this.setIcon(Utilities.loadImage((String)iconURL));
        this.setLayout(new BorderLayout());
        FormLoaderSettings settings = FormLoaderSettings.getInstance();
        Color backgroundColor = settings.getFormDesignerBackgroundColor();
        Color borderColor = settings.getFormDesignerBorderColor();
        JPanel loadingPanel = new JPanel();
        loadingPanel.setLayout(new FlowLayout(0, 12, 12 + (settings.getAssistantShown() ? 40 : 0)));
        loadingPanel.setBackground(backgroundColor);
        JLabel loadingLbl = new JLabel(FormUtils.getBundleString("LBL_FormLoading"));
        loadingLbl.setOpaque(true);
        loadingLbl.setPreferredSize(new Dimension(410, 310));
        loadingLbl.setHorizontalAlignment(0);
        loadingPanel.add(loadingLbl);
        loadingLbl.setBorder(new CompoundBorder(new LineBorder(borderColor, 5), new EmptyBorder(new Insets(6, 6, 6, 6))));
        this.add(loadingPanel, "Center");
        this.formEditor = formEditor;
        if (formEditor != null) {
            this.explorerManager = new ExplorerManager();
            ActionMap map = ComponentInspector.getInstance().setupActionMap(this.getActionMap());
            FormDataObject formDataObject = formEditor.getFormDataObject();
            this.lookup = new FormProxyLookup(new Lookup[]{ExplorerUtils.createLookup((ExplorerManager)this.explorerManager, (ActionMap)map), Lookups.fixed((Object[])new Object[]{formDataObject}), PaletteUtils.getPaletteLookup(formDataObject.getPrimaryFile()), formDataObject.getNodeDelegate().getLookup()});
            this.associateLookup((Lookup)this.lookup);
            this.formToolBar = new FormToolBar(this);
        }
    }

    void initialize() {
        this.initialized = true;
        this.firstLayout = true;
        this.removeAll();
        this.componentLayer = new ComponentLayer();
        this.handleLayer = new HandleLayer(this);
        this.nonVisualTray = FormEditor.isNonVisualTrayEnabled() ? new NonVisualTray(this.formEditor.getFormModel()) : null;
        JPanel designPanel = new JPanel(new BorderLayout());
        designPanel.add((Component)this.componentLayer, "Center");
        if (this.nonVisualTray != null) {
            designPanel.add((Component)this.nonVisualTray, "South");
        }
        this.layeredPane = new JLayeredPane(){

            protected void paintChildren(Graphics g) {
                FormDesigner.this.handleLayer.maskDraggingComponents();
                super.paintChildren(g);
            }
        };
        this.layeredPane.setLayout(new OverlayLayout(this.layeredPane));
        this.layeredPane.add((Component)designPanel, new Integer(1000));
        this.layeredPane.add((Component)this.handleLayer, new Integer(1001));
        this.formModel = this.formEditor.getFormModel();
        FormLoaderSettings settings = FormLoaderSettings.getInstance();
        this.updateAssistant();
        this.settingsListener = new PreferenceChangeListener(){

            public void preferenceChange(PreferenceChangeEvent evt) {
                if ("assistantShown".equals(evt.getKey())) {
                    FormDesigner.this.updateAssistant();
                }
            }
        };
        settings.getPreferences().addPreferenceChangeListener(this.settingsListener);
        JScrollPane scrollPane = new JScrollPane(this.layeredPane);
        scrollPane.setBorder(null);
        scrollPane.setViewportBorder(null);
        scrollPane.getVerticalScrollBar().setUnitIncrement(5);
        scrollPane.getHorizontalScrollBar().setUnitIncrement(5);
        this.add(scrollPane, "Center");
        this.explorerManager.setRootContext((Node)this.formEditor.getFormRootNode());
        if (!this.hasPropertyChangeListener) {
            this.addPropertyChangeListener("activatedNodes", new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent evt) {
                    try {
                        Lookup[] lookups = FormDesigner.this.lookup.getSubLookups();
                        Node[] oldNodes = (Node[])evt.getOldValue();
                        Node[] nodes = (Node[])evt.getNewValue();
                        Lookup lastLookup = lookups[lookups.length - 1];
                        Node delegate = FormDesigner.this.formEditor.getFormDataObject().getNodeDelegate();
                        if (!(lastLookup instanceof NoNodeLookup) && oldNodes.length >= 1 && !oldNodes[0].equals((Object)delegate)) {
                            FormDesigner.this.switchLookup();
                        } else if (lastLookup instanceof NoNodeLookup && nodes.length == 0) {
                            FormDesigner.this.switchLookup();
                        }
                        ArrayList<Node> list = new ArrayList<Node>(nodes.length);
                        list.addAll(Arrays.asList(nodes));
                        list.remove(delegate);
                        FormDesigner.this.explorerManager.setSelectedNodes(list.toArray(new Node[list.size()]));
                    }
                    catch (PropertyVetoException ex) {
                        ex.printStackTrace();
                    }
                }
            });
            this.hasPropertyChangeListener = true;
        }
        if (this.formModelListener == null) {
            this.formModelListener = new FormListener();
        }
        this.formModel.addFormModelListener(this.formModelListener);
        this.replicator = new VisualReplicator(null, new Class[]{Window.class, Applet.class, MenuComponent.class}, 3, FormEditor.getBindingSupport(this.formModel));
        this.resetTopDesignComponent(false);
        this.handleLayer.setViewOnly(this.formModel.isReadOnly());
        if (this.formModel.getLayoutModel() != null) {
            this.layoutDesigner = new LayoutDesigner(this.formModel.getLayoutModel(), new LayoutMapper());
        }
        this.updateWholeDesigner();
        this.formEditor.reinstallListener();
        if (this.formEditor.getFormDesigner() == null) {
            this.formEditor.setFormDesigner(this);
        }
    }

    void reset(FormEditor formEditor) {
        if (this.initialized) {
            this.clearSelection();
        }
        this.initialized = false;
        this.removeAll();
        this.componentLayer = null;
        this.handleLayer = null;
        this.nonVisualTray = null;
        this.layeredPane = null;
        if (this.textEditLayer != null) {
            if (this.textEditLayer.isVisible()) {
                this.textEditLayer.finishEditing(false);
            }
            this.textEditLayer.removeFinishListener(this.getFinnishListener());
            this.textEditLayer = null;
        }
        if (this.menuEditLayer != null) {
            this.menuEditLayer = null;
        }
        if (this.formModel != null) {
            if (this.formModelListener != null) {
                this.formModel.removeFormModelListener(this.formModelListener);
            }
            this.topDesignComponent = null;
            this.formModel = null;
        }
        this.replicator = null;
        this.layoutDesigner = null;
        this.connectionSource = null;
        this.connectionTarget = null;
        this.formEditor = formEditor;
    }

    private void switchLookup() {
        Lookup[] lookups = this.lookup.getSubLookups();
        Lookup nodeLookup = this.formEditor.getFormDataObject().getNodeDelegate().getLookup();
        int index = lookups.length - 1;
        lookups[index] = lookups[index] instanceof NoNodeLookup ? nodeLookup : new NoNodeLookup(nodeLookup);
        this.lookup.setSubLookups(lookups);
    }

    private void updateAssistant() {
        if (FormLoaderSettings.getInstance().getAssistantShown()) {
            AssistantModel assistant = FormEditor.getAssistantModel(this.formModel);
            this.assistantView = new AssistantView(assistant);
            assistant.setContext("select");
            this.add(this.assistantView, "North");
        } else if (this.assistantView != null) {
            this.remove(this.assistantView);
            this.assistantView = null;
        }
        this.revalidate();
    }

    public FormModel getFormModel() {
        return this.formModel;
    }

    HandleLayer getHandleLayer() {
        return this.handleLayer;
    }

    ComponentLayer getComponentLayer() {
        return this.componentLayer;
    }

    NonVisualTray getNonVisualTray() {
        return this.nonVisualTray;
    }

    FormToolBar getFormToolBar() {
        return this.formToolBar;
    }

    public LayoutDesigner getLayoutDesigner() {
        return this.layoutDesigner;
    }

    FormEditor getFormEditor() {
        return this.formEditor;
    }

    public Action[] getActions() {
        Action[] actions = super.getActions();
        SystemAction fsAction = SystemAction.get(FileSystemAction.class);
        if (!Arrays.asList(actions).contains(fsAction)) {
            Action[] newActions = new Action[actions.length + 1];
            System.arraycopy(actions, 0, newActions, 0, actions.length);
            newActions[actions.length] = fsAction;
            actions = newActions;
        }
        return actions;
    }

    public Object getComponent(RADComponent metacomp) {
        return this.replicator.getClonedComponent(metacomp.getId());
    }

    public Object getComponent(String componentId) {
        return this.replicator.getClonedComponent(componentId);
    }

    public RADComponent getMetaComponent(Object comp) {
        String id = this.replicator.getClonedComponentId(comp);
        return id != null ? this.formModel.getMetaComponent(id) : null;
    }

    public RADVisualComponent getTopDesignComponent() {
        return this.topDesignComponent;
    }

    boolean isTopRADComponent() {
        RADComponent topMetaComp = this.formModel.getTopRADComponent();
        return topMetaComp != null && topMetaComp == this.topDesignComponent;
    }

    public void setTopDesignComponent(RADVisualComponent component, boolean update) {
        this.highlightTopDesignComponentName(false);
        this.topDesignComponent = component;
        this.highlightTopDesignComponentName(!this.isTopRADComponent());
        FormDataObject formDO = this.formEditor.getFormDataObject();
        if (formDO != null) {
            formDO.getFormEditorSupport().updateMVTCDisplayName();
        }
        if (update) {
            this.setSelectedComponent(this.topDesignComponent);
            this.updateWholeDesigner();
        }
    }

    private void highlightTopDesignComponentName(boolean bl) {
        RADComponentNode node;
        if (this.topDesignComponent != null && (node = this.topDesignComponent.getNodeReference()) != null) {
            node.highlightDisplayName(bl);
        }
    }

    public void resetTopDesignComponent(boolean update) {
        this.setTopDesignComponent(this.formModel.getTopRADComponent() instanceof RADVisualComponent ? (RADVisualComponent)this.formModel.getTopRADComponent() : null, update);
    }

    public boolean isInDesignedTree(RADComponent metacomp) {
        return this.topDesignComponent != null && (this.topDesignComponent == metacomp || this.topDesignComponent.isParentComponent(metacomp));
    }

    void updateWholeDesigner() {
        if (this.formModelListener != null) {
            this.formModelListener.formChanged(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateComponentLayer(boolean fireChange) {
        boolean firstLayout = this.firstLayout;
        this.firstLayout = false;
        if (this.getLayoutDesigner() == null) {
            return;
        }
        this.componentLayer.revalidate();
        RepaintManager.currentManager(this.componentLayer).validateInvalidComponents();
        LayoutModel layoutModel = this.formModel.getLayoutModel();
        Object layoutUndoMark = layoutModel.getChangeMark();
        UndoableEdit layoutUndoEdit = layoutModel.getUndoableEdit();
        boolean autoUndo = true;
        try {
            if (this.getLayoutDesigner().updateCurrentState() && fireChange) {
                this.formModel.fireFormChanged(true);
            }
            autoUndo = false;
        }
        finally {
            if (!(firstLayout && !autoUndo || layoutUndoMark.equals(layoutModel.getChangeMark()))) {
                this.formModel.addUndoableEdit(layoutUndoEdit);
            }
            if (autoUndo) {
                this.formModel.forceUndoOfCompoundEdit();
            }
        }
        layoutModel.endUndoableEdit();
        this.updateResizabilityActions();
        this.componentLayer.repaint();
    }

    void updateContainerLayout(RADVisualContainer metacont) {
        this.replicator.updateContainerLayout(metacont);
        this.componentLayer.revalidate();
        this.componentLayer.repaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Container createFormView(final RADVisualComponent metacomp, final Class contClass, final Class previewLaf) throws Exception {
        final UIDefaults uiDefaults = FormLAF.initPreviewLaf(previewLaf);
        Container result = null;
        Locale defaultLocale = FormDesigner.switchToDesignLocale(metacomp.getFormModel());
        try {
            FormLAF.setUsePreviewDefaults(true, previewLaf, uiDefaults);
            result = (Container)FormLAF.executeWithLookAndFeel(new Mutex.ExceptionAction(){

                public Object run() throws Exception {
                    VisualReplicator r = new VisualReplicator(contClass, null, 0, null);
                    r.setTopMetaComponent(metacomp);
                    Object container = r.createClone();
                    if (container instanceof RootPaneContainer) {
                        JRootPane rootPane = ((RootPaneContainer)container).getRootPane();
                        JLayeredPane newPane = new JLayeredPane(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            public void paint(Graphics g) {
                                try {
                                    FormLAF.setUsePreviewDefaults(true, previewLaf, uiDefaults);
                                    super.paint(g);
                                }
                                finally {
                                    FormLAF.setUsePreviewDefaults(false, null, null);
                                }
                            }
                        };
                        JLayeredPane oldPane = rootPane.getLayeredPane();
                        Component[] comps = oldPane.getComponents();
                        for (int i = 0; i < comps.length; ++i) {
                            newPane.add(comps[i], (Object)oldPane.getLayer(comps[i]));
                        }
                        rootPane.setLayeredPane(newPane);
                        rootPane.getGlassPane().setVisible(true);
                        rootPane.putClientProperty("designPreview", Boolean.TRUE);
                    }
                    return container;
                }
            });
        }
        finally {
            FormLAF.setUsePreviewDefaults(false, null, null);
            if (defaultLocale != null) {
                Locale.setDefault(defaultLocale);
            }
        }
        return result;
    }

    private static Locale switchToDesignLocale(FormModel formModel) {
        Locale defaultLocale = null;
        String locale = FormEditor.getResourceSupport(formModel).getDesignLocale();
        if (locale != null && !locale.equals("")) {
            String variant;
            int i;
            defaultLocale = Locale.getDefault();
            String[] parts = locale.split("_");
            if ("".equals(parts[i = 0])) {
                ++i;
            }
            String language = i < parts.length ? parts[i++] : null;
            String country = i < parts.length ? parts[i++] : "";
            String string = variant = i < parts.length ? parts[i] : "";
            if (language != null) {
                Locale.setDefault(new Locale(language, country, variant));
            }
        }
        return defaultLocale;
    }

    Container getTopVisualContainer() {
        RADVisualComponent topComp = this.replicator.getTopMetaComponent();
        if (!(topComp instanceof RADVisualContainer)) {
            return null;
        }
        return ((RADVisualContainer)topComp).getContainerDelegate(this.replicator.getClonedComponent(topComp));
    }

    Point pointFromComponentToHandleLayer(Point p, Component sourceComp) {
        Component comp;
        JLayeredPane commonParent = this.layeredPane;
        for (comp = sourceComp; comp != commonParent; comp = comp.getParent()) {
            p.x += comp.getX();
            p.y += comp.getY();
        }
        for (comp = this.handleLayer; comp != commonParent; comp = comp.getParent()) {
            p.x -= comp.getX();
            p.y -= comp.getY();
        }
        return p;
    }

    Point pointFromHandleToComponentLayer(Point p, Component targetComp) {
        Component comp;
        JLayeredPane commonParent = this.layeredPane;
        for (comp = this.handleLayer; comp != commonParent; comp = comp.getParent()) {
            p.x += comp.getX();
            p.y += comp.getY();
        }
        for (comp = targetComp; comp != commonParent; comp = comp.getParent()) {
            p.x -= comp.getX();
            p.y -= comp.getY();
        }
        return p;
    }

    boolean isCoordinatesRoot(Component comp) {
        return this.layeredPane == comp;
    }

    private Rectangle componentBoundsToTop(Component component) {
        if (component == null) {
            return null;
        }
        Container top = this.getTopVisualContainer();
        int dx = 0;
        int dy = 0;
        if (component != top) {
            for (Container comp = component.getParent(); comp != top && comp != null; comp = comp.getParent()) {
                dx += comp.getX();
                dy += comp.getY();
            }
        } else {
            dx = -top.getX();
            dy = -top.getY();
        }
        Rectangle bounds = component.getBounds();
        bounds.x += dx;
        bounds.y += dy;
        return bounds;
    }

    void setDesignerMode(int mode) {
        PaletteItem pitem;
        this.formToolBar.updateDesignerMode(mode);
        if (mode == this.designerMode) {
            return;
        }
        if (mode == 2 && (pitem = PaletteUtils.getSelectedItem()) != null && "chooseBean".equals(pitem.getExplicitComponentType())) {
            NotifyDescriptor.InputLine desc = new NotifyDescriptor.InputLine(FormUtils.getBundleString("MSG_Choose_Bean"), FormUtils.getBundleString("TITLE_Choose_Bean"));
            DialogDisplayer.getDefault().notify((NotifyDescriptor)desc);
            if (NotifyDescriptor.OK_OPTION.equals(desc.getValue())) {
                pitem.setComponentClassSource(desc.getInputText(), null, null);
            } else {
                this.toggleSelectionMode();
                return;
            }
        }
        this.designerMode = mode;
        this.resetConnection();
        if (mode == 1) {
            this.clearSelection();
        }
        this.handleLayer.endDragging(null);
        this.updateResizabilityActions();
        AssistantModel aModel = FormEditor.getAssistantModel(this.formModel);
        switch (mode) {
            case 1: {
                aModel.setContext("connectSource");
                break;
            }
            case 0: {
                aModel.setContext("select");
            }
        }
    }

    int getDesignerMode() {
        return this.designerMode;
    }

    void toggleSelectionMode() {
        this.setDesignerMode(0);
        PaletteUtils.clearPaletteSelection();
    }

    void toggleConnectionMode() {
        this.setDesignerMode(1);
        PaletteUtils.clearPaletteSelection();
    }

    void toggleAddMode() {
        this.setDesignerMode(2);
        PaletteUtils.clearPaletteSelection();
    }

    Dimension getDesignerSize() {
        return this.componentLayer.getDesignerSize();
    }

    void setDesignerSize(Dimension size, Dimension oldSize) {
        if (this.topDesignComponent instanceof RADVisualFormContainer) {
            ((RADVisualFormContainer)this.topDesignComponent).setDesignerSize(size);
        } else if (this.topDesignComponent != null) {
            if (this.topDesignComponent == this.formModel.getTopRADComponent()) {
                oldSize = (Dimension)this.topDesignComponent.getAuxValue(PROP_DESIGNER_SIZE);
                this.topDesignComponent.setAuxValue(PROP_DESIGNER_SIZE, size);
            }
            if (oldSize == null) {
                oldSize = this.getDesignerSize();
            }
            this.getFormModel().fireSyntheticPropertyChanged(this.topDesignComponent, PROP_DESIGNER_SIZE, oldSize, size);
        }
    }

    public void resetDesignerSize() {
        this.setDesignerSize(null, null);
    }

    void storeDesignerSize(Dimension size) {
        if (this.topDesignComponent instanceof RADVisualFormContainer) {
            ((RADVisualFormContainer)this.topDesignComponent).setDesignerSizeImpl(size);
        } else if (this.topDesignComponent == this.formModel.getTopRADComponent()) {
            this.topDesignComponent.setAuxValue(PROP_DESIGNER_SIZE, size);
        }
    }

    private void setupDesignerSize() {
        RADVisualFormContainer formCont;
        Dimension size = null;
        RADVisualFormContainer rADVisualFormContainer = formCont = this.topDesignComponent instanceof RADVisualFormContainer ? (RADVisualFormContainer)this.topDesignComponent : null;
        if (formCont == null || formCont.hasExplicitSize() || !RADVisualContainer.isFreeDesignContainer(this.topDesignComponent)) {
            if (formCont != null) {
                size = formCont.getDesignerSize();
            }
            if (size == null) {
                size = (Dimension)this.topDesignComponent.getAuxValue(PROP_DESIGNER_SIZE);
            }
            if (!(size != null || this.formModel.isFreeDesignDefaultLayout() && this.topDesignComponent != this.formModel.getTopRADComponent())) {
                size = new Dimension(400, 300);
            }
        }
        Dimension setSize = this.componentLayer.setDesignerSize(size);
        this.storeDesignerSize(setSize);
    }

    private void checkDesignerSize() {
        if (!(!this.formModel.isFreeDesignDefaultLayout() && !RADVisualContainer.isFreeDesignContainer(this.topDesignComponent) || !(this.topDesignComponent instanceof RADVisualComponent) || this.topDesignComponent instanceof RADVisualFormContainer && ((RADVisualFormContainer)this.topDesignComponent).hasExplicitSize())) {
            Component topComp = (Component)this.getComponent(this.topDesignComponent);
            Component topCont = this.getTopVisualContainer();
            if (topCont == null) {
                topCont = topComp;
            }
            int wDiff = topComp.getWidth() - topCont.getWidth();
            int hDiff = topComp.getHeight() - topCont.getHeight();
            Dimension designerSize = new Dimension(this.getDesignerSize());
            designerSize.width -= wDiff;
            designerSize.height -= hDiff;
            Dimension minSize = topCont.getMinimumSize();
            boolean corrected = false;
            if (designerSize.width < minSize.width) {
                designerSize.width = minSize.width;
                corrected = true;
            }
            if (designerSize.height < minSize.height) {
                designerSize.height = minSize.height;
                corrected = true;
            }
            if (corrected) {
                designerSize.width += wDiff;
                designerSize.height += hDiff;
                if (this.formModel.isCompoundEditInProgress()) {
                    FormModelEvent ev = new FormModelEvent(this.formModel, 11);
                    ev.setComponentAndContainer(this.topDesignComponent, null);
                    ev.setProperty(PROP_DESIGNER_SIZE, this.getDesignerSize(), designerSize);
                    this.formModel.addUndoableEdit(ev.getUndoableEdit());
                }
                this.componentLayer.setDesignerSize(designerSize);
                this.storeDesignerSize(designerSize);
            }
        }
    }

    public List getSelectedComponents() {
        return this.selectedComponents;
    }

    Node[] getSelectedComponentNodes() {
        Node[] selectedNodes = new Node[this.selectedComponents.size()];
        Iterator iter = this.selectedComponents.iterator();
        int i = 0;
        while (iter.hasNext()) {
            RADComponent metacomp = (RADComponent)iter.next();
            selectedNodes[i++] = metacomp.getNodeReference();
        }
        return selectedNodes;
    }

    List getSelectedLayoutComponents() {
        return this.selectedLayoutComponents;
    }

    boolean isComponentSelected(RADComponent metacomp) {
        return this.selectedComponents.contains(metacomp);
    }

    public void setSelectedComponent(RADComponent metacomp) {
        this.clearSelectionImpl();
        this.addComponentToSelectionImpl(metacomp);
        this.repaintSelection();
        this.updateComponentInspector();
    }

    void setSelectedComponents(RADComponent[] metacomps) {
        this.clearSelectionImpl();
        for (int i = 0; i < metacomps.length; ++i) {
            this.addComponentToSelectionImpl(metacomps[i]);
        }
        this.repaintSelection();
        this.updateComponentInspector();
    }

    void setSelectedNode(FormNode node) {
        if (node instanceof RADComponentNode) {
            this.setSelectedComponent(((RADComponentNode)node).getRADComponent());
        } else {
            this.clearSelectionImpl();
            this.repaintSelection();
            ComponentInspector ci = ComponentInspector.getInstance();
            if (ci.getFocusedForm() != this.formEditor) {
                return;
            }
            Node[] selectedNodes = new Node[]{node};
            try {
                ci.setSelectedNodes(selectedNodes, this.formEditor);
            }
            catch (PropertyVetoException ex) {
                ex.printStackTrace();
            }
        }
    }

    void addComponentToSelection(RADComponent metacomp) {
        this.addComponentToSelectionImpl(metacomp);
        this.repaintSelection();
        this.updateComponentInspector();
    }

    void addComponentsToSelection(RADComponent[] metacomps) {
        for (int i = 0; i < metacomps.length; ++i) {
            this.addComponentToSelectionImpl(metacomps[i]);
        }
        this.repaintSelection();
        this.updateComponentInspector();
    }

    void removeComponentFromSelection(RADComponent metacomp) {
        this.removeComponentFromSelectionImpl(metacomp);
        this.repaintSelection();
        this.updateComponentInspector();
    }

    public void clearSelection() {
        this.clearSelectionImpl();
        this.repaintSelection();
        this.updateComponentInspector();
    }

    void addComponentToSelectionImpl(RADComponent metacomp) {
        if (metacomp != null) {
            this.selectedComponents.add(metacomp);
            RADVisualComponent layoutComponent = this.componentToLayoutComponent(metacomp);
            if (layoutComponent != null) {
                this.selectedLayoutComponents.add(layoutComponent);
                this.ensureComponentIsShown((RADVisualComponent)metacomp);
                this.selectionChanged();
            }
        }
    }

    RADVisualComponent componentToLayoutComponent(RADComponent metacomp) {
        RADVisualComponent visualComp;
        if (metacomp instanceof RADVisualComponent && !(visualComp = (RADVisualComponent)metacomp).isMenuComponent()) {
            RADVisualContainer metacont = visualComp.getParentContainer();
            if (metacont != null && JScrollPane.class.isAssignableFrom(metacont.getBeanInstance().getClass()) && this.isInDesignedTree(metacont)) {
                return metacont;
            }
            return this.isInDesignedTree(visualComp) ? visualComp : null;
        }
        return null;
    }

    void removeComponentFromSelectionImpl(RADComponent metacomp) {
        this.selectedComponents.remove(metacomp);
        this.selectedLayoutComponents.remove(metacomp);
        this.selectionChanged();
    }

    void clearSelectionImpl() {
        this.selectedComponents.clear();
        this.selectedLayoutComponents.clear();
        this.selectionChanged();
    }

    void selectionChanged() {
        this.updateDesignerActions();
        this.updateResizabilityActions();
        this.updateAssistantContext();
    }

    void repaintSelection() {
        this.handleLayer.repaint();
    }

    private void updateDesignerActions() {
        LayoutModel layoutModel;
        LayoutComponent parentLC;
        RADComponent parent;
        Collection selectedIds = this.selectedLayoutComponentIds();
        boolean enabled = false;
        if (selectedIds.size() >= 2 && (parent = this.commonParent(selectedIds)) != null && (parentLC = (layoutModel = this.formModel.getLayoutModel()).getLayoutComponent(parent.getId())) != null && parentLC.isLayoutContainer()) {
            enabled = true;
        }
        for (Action action : this.getDesignerActions(true)) {
            action.setEnabled(enabled);
        }
    }

    void setResizabilityButtons(JToggleButton[] buttons) {
        this.resizabilityButtons = buttons;
    }

    public JToggleButton[] getResizabilityButtons() {
        return this.resizabilityButtons;
    }

    public void updateResizabilityActions() {
        Collection componentIds = this.componentIds();
        LayoutModel layoutModel = this.getFormModel().getLayoutModel();
        LayoutDesigner layoutDesigner = this.getLayoutDesigner();
        Iterator iter = componentIds.iterator();
        boolean[] resizable = new boolean[2];
        boolean[] nonResizable = new boolean[2];
        while (iter.hasNext()) {
            String id = (String)iter.next();
            LayoutComponent comp = layoutModel.getLayoutComponent(id);
            for (int i = 0; i < 2; ++i) {
                if (layoutDesigner.isComponentResizing(comp, i == 0 ? 0 : 1)) {
                    resizable[i] = true;
                    continue;
                }
                nonResizable[i] = true;
            }
        }
        for (int i = 0; i < 2; ++i) {
            boolean match = resizable[i];
            boolean miss = nonResizable[i];
            this.getResizabilityButtons()[i].setSelected(!miss && match);
            ((ResizabilityAction)this.getResizabilityActions().toArray()[i]).setEnabled(match || miss);
        }
    }

    private void updateAssistantContext() {
        String context = "select";
        List selComps = this.getSelectedComponents();
        if (selComps.size() == 1) {
            RADComponent metacomp = (RADComponent)selComps.get(0);
            Object bean = metacomp.getBeanInstance();
            if (bean instanceof JTabbedPane) {
                JTabbedPane pane = (JTabbedPane)bean;
                int count = pane.getTabCount();
                switch (count) {
                    case 0: {
                        context = "tabbedPaneEmpty";
                        break;
                    }
                    case 1: {
                        context = "tabbedPaneOne";
                        break;
                    }
                    default: {
                        context = "tabbedPane";
                        break;
                    }
                }
            } else if (bean instanceof JRadioButton) {
                Node.Property property = metacomp.getPropertyByName("buttonGroup");
                try {
                    if (property != null && property.getValue() == null) {
                        context = "buttonGroup";
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            } else if (bean instanceof JPanel && this.getTopDesignComponent() != metacomp && Math.random() < 0.2) {
                context = "designThisContainer";
            } else if (bean instanceof JComboBox && Math.random() < 0.4) {
                context = "comboBoxModel";
            } else if (bean instanceof JList && Math.random() < 0.4) {
                context = "listModel";
            } else if (bean instanceof JTable && Math.random() < 0.4) {
                context = "tableModel";
            } else if (bean instanceof JScrollPane) {
                JScrollPane scrollPane = (JScrollPane)bean;
                if (scrollPane.getViewport().getView() == null) {
                    context = "scrollPaneEmpty";
                } else if (Math.random() < 0.5) {
                    context = "scrollPane";
                }
            }
        }
        FormEditor.getAssistantModel(this.formModel).setContext(context);
    }

    RADVisualComponent getNextVisualComponent(boolean forward) {
        RADVisualComponent currentComp = null;
        int n = this.selectedComponents.size();
        if (n > 0) {
            if (n > 1) {
                return null;
            }
            Object sel = this.selectedComponents.get(0);
            if (sel instanceof RADVisualComponent) {
                currentComp = (RADVisualComponent)sel;
            } else {
                return null;
            }
        }
        return this.getNextVisualComponent(currentComp, forward);
    }

    RADVisualComponent getNextVisualComponent(RADVisualComponent comp, boolean forward) {
        RADVisualComponent[] subComps;
        if (comp == null) {
            return this.topDesignComponent;
        }
        if (this.getComponent(comp) == null) {
            return null;
        }
        if (forward) {
            RADVisualComponent[] subComps2;
            if (comp instanceof RADVisualContainer && (subComps2 = ((RADVisualContainer)comp).getSubComponents()).length > 0) {
                return subComps2[0];
            }
            if (comp == this.topDesignComponent) {
                return this.topDesignComponent;
            }
            RADVisualContainer cont = comp.getParentContainer();
            if (cont == null) {
                return null;
            }
            int i = cont.getIndexOf(comp);
            while (i >= 0) {
                subComps2 = cont.getSubComponents();
                if (i + 1 < subComps2.length) {
                    return subComps2[i + 1];
                }
                if (cont == this.topDesignComponent) break;
                comp = cont;
                if ((cont = comp.getParentContainer()) == null) {
                    return null;
                }
                i = cont.getIndexOf(comp);
            }
            return this.topDesignComponent;
        }
        if (comp != this.topDesignComponent) {
            RADVisualContainer cont = comp.getParentContainer();
            if (cont == null) {
                return null;
            }
            int i = cont.getIndexOf(comp);
            if (i >= 0) {
                if (i == 0) {
                    return cont;
                }
                subComps = cont.getSubComponents();
                comp = subComps[i - 1];
            } else {
                comp = this.topDesignComponent;
            }
        }
        while (comp instanceof RADVisualContainer && (subComps = ((RADVisualContainer)comp).getSubComponents()).length > 0) {
            comp = subComps[subComps.length - 1];
        }
        return comp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void align(boolean closed, int dimension, int alignment) {
        Action action = null;
        for (Action candidate : this.getDesignerActions(true)) {
            AlignAction alignCandidate;
            if (!(candidate instanceof AlignAction) || (alignCandidate = (AlignAction)candidate).getAlignment() != alignment || alignCandidate.getDimension() != dimension) continue;
            action = alignCandidate;
            break;
        }
        if (action == null || !action.isEnabled()) {
            return;
        }
        Collection selectedIds = this.selectedLayoutComponentIds();
        RADComponent parent = this.commonParent(selectedIds);
        LayoutModel layoutModel = this.formModel.getLayoutModel();
        Object layoutUndoMark = layoutModel.getChangeMark();
        UndoableEdit ue = layoutModel.getUndoableEdit();
        boolean autoUndo = true;
        try {
            this.getLayoutDesigner().align(selectedIds, closed, dimension, alignment);
            autoUndo = false;
        }
        finally {
            this.formModel.fireContainerLayoutChanged((RADVisualContainer)parent, null, null, null);
            if (!layoutUndoMark.equals(layoutModel.getChangeMark())) {
                this.formModel.addUndoableEdit(ue);
            }
            if (autoUndo) {
                this.formModel.forceUndoOfCompoundEdit();
            }
        }
    }

    public Collection getDesignerActions(boolean forToolbar) {
        if (this.designerActions == null) {
            this.designerActions = new LinkedList();
            this.designerActions.add(new AlignAction(0, 0, true));
            this.designerActions.add(new AlignAction(0, 1, true));
            this.designerActions.add(new AlignAction(0, 2, true));
            this.designerActions.add(new AlignAction(1, 0, true));
            this.designerActions.add(new AlignAction(1, 1, true));
            this.designerActions.add(new AlignAction(1, 2, true));
            this.designerActions.add(new AlignAction(0, 0, false));
            this.designerActions.add(new AlignAction(0, 1, false));
            this.designerActions.add(new AlignAction(0, 2, false));
            this.designerActions.add(new AlignAction(1, 0, false));
            this.designerActions.add(new AlignAction(1, 1, false));
            this.designerActions.add(new AlignAction(1, 2, false));
        }
        return forToolbar ? this.designerActions.subList(0, this.designerActions.size() / 2) : this.designerActions;
    }

    public Collection getResizabilityActions() {
        if (this.resizabilityActions == null) {
            this.resizabilityActions = new LinkedList();
            this.resizabilityActions.add(new ResizabilityAction(0));
            this.resizabilityActions.add(new ResizabilityAction(1));
        }
        return this.resizabilityActions;
    }

    Collection selectedLayoutComponentIds() {
        Iterator metacomps = this.getSelectedLayoutComponents().iterator();
        LinkedList<String> selectedIds = new LinkedList<String>();
        while (metacomps.hasNext()) {
            RADComponent metacomp = (RADComponent)metacomps.next();
            selectedIds.add(metacomp.getId());
        }
        return selectedIds;
    }

    private RADComponent commonParent(Collection compIds) {
        RADComponent parent = null;
        Iterator iter = compIds.iterator();
        FormModel formModel = this.getFormModel();
        while (iter.hasNext()) {
            String compId = (String)iter.next();
            RADComponent metacomp = formModel.getMetaComponent(compId);
            RADComponent metacont = metacomp.getParentComponent();
            if (parent == null) {
                parent = metacont;
            }
            if (metacont != null && parent == metacont) continue;
            return null;
        }
        return parent;
    }

    void updateComponentInspector() {
        ComponentInspector ci = ComponentInspector.getInstance();
        if (ci.getFocusedForm() != this.formEditor) {
            return;
        }
        Node[] selectedNodes = this.getSelectedComponentNodes();
        try {
            this.setActivatedNodes(selectedNodes);
            ci.setSelectedNodes(selectedNodes, this.formEditor);
        }
        catch (PropertyVetoException ex) {
            ex.printStackTrace();
        }
    }

    void updateVisualSettings() {
        this.componentLayer.updateVisualSettings();
        if (this.nonVisualTray != null) {
            this.nonVisualTray.updateVisualSettings();
        }
        this.layeredPane.revalidate();
        this.layeredPane.repaint();
    }

    private void ensureComponentIsShown(RADVisualComponent metacomp) {
        Component comp = (Component)this.getComponent(metacomp);
        if (comp == null) {
            return;
        }
        if (comp.isShowing()) {
            return;
        }
        if (!this.isInDesignedTree(metacomp)) {
            return;
        }
        Component topComp = (Component)this.getComponent(this.topDesignComponent);
        if (topComp == null || !topComp.isShowing()) {
            return;
        }
        RADVisualComponent child = metacomp;
        for (RADVisualContainer metacont = metacomp.getParentContainer(); metacont != null; metacont = metacont.getParentContainer()) {
            Container cont = (Container)this.getComponent(metacont);
            LayoutSupportManager laysup = metacont.getLayoutSupport();
            if (laysup != null) {
                Container contDelegate = metacont.getContainerDelegate(cont);
                laysup.selectComponent(child.getComponentIndex());
                laysup.arrangeContainer(cont, contDelegate);
            }
            if (metacont == this.topDesignComponent || cont.isShowing()) break;
            child = metacont;
        }
    }

    void connectBean(RADComponent metacomp, boolean showDialog) {
        if (this.connectionSource == null) {
            this.connectionSource = metacomp;
            FormEditor.getAssistantModel(this.formModel).setContext("connectTarget");
            this.handleLayer.repaint();
        } else {
            if (metacomp == this.connectionSource) {
                if (this.connectionTarget != null) {
                    this.resetConnection();
                    this.toggleSelectionMode();
                }
                return;
            }
            this.connectionTarget = metacomp;
            this.handleLayer.repaint();
            if (showDialog) {
                if (this.connectionTarget != null) {
                    FormEditor.getAssistantModel(this.formModel).setContext("connectWizard");
                    this.createConnection(this.connectionSource, this.connectionTarget);
                }
                this.toggleSelectionMode();
            }
        }
    }

    public RADComponent getConnectionSource() {
        return this.connectionSource;
    }

    public RADComponent getConnectionTarget() {
        return this.connectionTarget;
    }

    public void resetConnection() {
        if (this.connectionSource != null || this.connectionTarget != null) {
            this.connectionSource = null;
            this.connectionTarget = null;
            this.handleLayer.repaint();
        }
    }

    private void createConnection(RADComponent source, RADComponent target) {
        ConnectionWizard cw = new ConnectionWizard(this.formModel, source, target);
        if (cw.show()) {
            final Event event = cw.getSelectedEvent();
            final String eventName = cw.getEventName();
            String bodyText = cw.getGeneratedCode();
            this.formModel.getFormEvents().attachEvent(event, eventName, bodyText);
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    FormDesigner.this.formModel.getFormEvents().attachEvent(event, eventName, null);
                }
            });
        }
    }

    public void startInPlaceEditing(RADComponent metacomp) {
        if (this.formModel.isReadOnly()) {
            return;
        }
        if (this.textEditLayer != null && this.textEditLayer.isVisible()) {
            return;
        }
        if (!this.isEditableInPlace(metacomp)) {
            return;
        }
        Component comp = (Component)this.getComponent(metacomp);
        if (comp == null) {
            this.notifyCannotEditInPlace();
            return;
        }
        FormProperty property = null;
        if (JTabbedPane.class.isAssignableFrom(metacomp.getBeanClass())) {
            JTabbedPane tabbedPane = (JTabbedPane)comp;
            int index = tabbedPane.getSelectedIndex();
            RADVisualContainer metacont = (RADVisualContainer)metacomp;
            RADVisualComponent tabComp = metacont.getSubComponent(index);
            Node.Property[] props = tabComp.getConstraintsProperties();
            for (int i = 0; i < props.length; ++i) {
                if (!props[i].getName().equals("TabConstraints.tabTitle")) continue;
                if (props[i] instanceof FormProperty) {
                    property = (FormProperty)props[i];
                    continue;
                }
                return;
            }
            if (property == null) {
                return;
            }
        } else {
            property = metacomp.getBeanProperty("text");
            if (property == null) {
                return;
            }
        }
        String editText = null;
        try {
            Object text = property.getRealValue();
            if (!(text instanceof String)) {
                text = "";
            }
            editText = (String)text;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return;
        }
        this.editedProperty = property;
        if (this.textEditLayer == null) {
            this.textEditLayer = new InPlaceEditLayer();
            this.textEditLayer.setVisible(false);
            this.textEditLayer.addFinishListener(this.getFinnishListener());
            this.layeredPane.add((Component)this.textEditLayer, new Integer(2001));
        }
        try {
            this.textEditLayer.setEditedComponent(comp, editText);
        }
        catch (IllegalArgumentException ex) {
            this.notifyCannotEditInPlace();
            return;
        }
        this.textEditLayer.setVisible(true);
        this.handleLayer.setVisible(false);
        this.textEditLayer.requestFocus();
    }

    private InPlaceEditLayer.FinishListener getFinnishListener() {
        if (this.finnishListener == null) {
            this.finnishListener = new InPlaceEditLayer.FinishListener(){

                public void editingFinished(boolean textChanged) {
                    FormDesigner.this.finishInPlaceEditing(FormDesigner.this.textEditLayer.isTextChanged());
                }
            };
        }
        return this.finnishListener;
    }

    private void finishInPlaceEditing(boolean applyChanges) {
        if (applyChanges) {
            try {
                Object value = this.editedProperty.getValue();
                if (value instanceof String) {
                    this.editedProperty.setValue(this.textEditLayer.getEditedText());
                } else {
                    PropertyEditor prEd = this.editedProperty.findDefaultEditor();
                    this.editedProperty.setValue(new FormProperty.ValueWithEditor((Object)this.textEditLayer.getEditedText(), prEd));
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        if (this.handleLayer != null) {
            this.textEditLayer.setVisible(false);
            this.handleLayer.setVisible(true);
            this.handleLayer.requestFocus();
        }
        this.editedProperty = null;
    }

    public boolean isEditableInPlace(RADComponent metacomp) {
        Component comp = (Component)this.getComponent(metacomp);
        if (comp == null) {
            return false;
        }
        for (RADComponent parent = metacomp.getParentComponent(); parent != null; parent = parent.getParentComponent()) {
            if (JComponent.class.isAssignableFrom(parent.getBeanClass()) || RootPaneContainer.class.isAssignableFrom(parent.getBeanClass())) continue;
            return false;
        }
        Class beanClass = metacomp.getBeanClass();
        return InPlaceEditLayer.supportsEditingFor(beanClass, false) && (!JTabbedPane.class.isAssignableFrom(beanClass) || ((JTabbedPane)comp).getTabCount() != 0);
    }

    private void notifyCannotEditInPlace() {
        DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)FormUtils.getBundleString("MSG_ComponentNotShown"), 2));
    }

    public void openMenu(RADComponent metacomp) {
        MenuEditLayer menuEditLayer = this.getMenuEditLayer();
        Component comp = (Component)this.getComponent(metacomp);
        menuEditLayer.setVisible(true);
        menuEditLayer.requestFocus();
        menuEditLayer.openMenu(metacomp, comp);
    }

    public int getPersistenceType() {
        return 2;
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("gui.formeditor");
    }

    public void componentActivated() {
        if (this.formModel == null) {
            return;
        }
        this.formEditor.setFormDesigner(this);
        ComponentInspector ci = ComponentInspector.getInstance();
        if (ci.getFocusedForm() != this.formEditor) {
            ci.focusForm(this.formEditor);
            if (this.getDesignerMode() == 1) {
                this.clearSelection();
            } else {
                this.updateComponentInspector();
            }
        }
        ci.attachActions();
        if (this.textEditLayer == null || !this.textEditLayer.isVisible()) {
            this.handleLayer.requestFocus();
        }
    }

    public void componentDeactivated() {
        if (this.formModel == null) {
            return;
        }
        if (this.textEditLayer != null && this.textEditLayer.isVisible()) {
            this.textEditLayer.finishEditing(false);
        }
        ComponentInspector.getInstance().detachActions();
        this.resetConnection();
    }

    public UndoRedo getUndoRedo() {
        UndoRedo.Manager ur = this.formModel != null ? this.formModel.getUndoRedoManager() : null;
        return ur != null ? ur : super.getUndoRedo();
    }

    protected String preferredID() {
        return this.formEditor.getFormDataObject().getName();
    }

    public JComponent getToolbarRepresentation() {
        return this.getFormToolBar();
    }

    public JComponent getVisualRepresentation() {
        return this;
    }

    public void setMultiViewCallback(MultiViewElementCallback callback) {
        this.multiViewObserver = callback;
        callback.getTopComponent().putClientProperty((Object)"formDesigner", (Object)this);
        if (this.formEditor != null) {
            FormDataObject formDO = this.formEditor.getFormDataObject();
            formDO.getFormEditorSupport().setTopComponent(callback.getTopComponent());
        }
    }

    public void requestVisible() {
        if (this.multiViewObserver != null) {
            this.multiViewObserver.requestVisible();
        } else {
            super.requestVisible();
        }
    }

    public void requestActive() {
        if (this.multiViewObserver != null) {
            this.multiViewObserver.requestActive();
        } else {
            super.requestActive();
        }
    }

    public void componentClosed() {
        super.componentClosed();
        this.formDesignerOpened = false;
        if (this.formModel != null) {
            if (this.formModelListener != null) {
                this.formModel.removeFormModelListener(this.formModelListener);
            }
            this.topDesignComponent = null;
            this.formModel = null;
        }
        if (this.settingsListener != null) {
            FormLoaderSettings.getInstance();
            FormLoaderSettings.getPreferences().removePreferenceChangeListener(this.settingsListener);
        }
    }

    public void componentShowing() {
        super.componentShowing();
        if (!this.formEditor.isFormLoaded()) {
            this.formEditor.loadFormDesigner();
            if (!this.formEditor.isFormLoaded()) {
                this.removeAll();
                return;
            }
        }
        if (!this.initialized) {
            this.initialize();
        }
        FormEditorSupport.checkFormGroupVisibility();
    }

    public void componentHidden() {
        super.componentHidden();
        FormEditorSupport.checkFormGroupVisibility();
    }

    public void componentOpened() {
        super.componentOpened();
        this.formDesignerOpened = true;
        if (this.formEditor == null && this.multiViewObserver != null) {
            this.multiViewObserver.getTopComponent().close();
            EventQueue.invokeLater(new Runnable(){

                public void run() {
                    FormEditorSupport.checkFormGroupVisibility();
                }
            });
        }
    }

    public boolean isClosed() {
        return !this.formDesignerOpened;
    }

    public CloseOperationState canCloseElement() {
        if (!FormEditorSupport.isLastView(this.multiViewObserver.getTopComponent())) {
            return CloseOperationState.STATE_OK;
        }
        return MultiViewFactory.createUnsafeCloseState((String)"ID_FORM_CLOSING", (Action)MultiViewFactory.NOOP_CLOSE_ACTION, (Action)MultiViewFactory.NOOP_CLOSE_ACTION);
    }

    MenuEditLayer getMenuEditLayer() {
        if (this.menuEditLayer == null) {
            this.menuEditLayer = new MenuEditLayer(this);
            this.menuEditLayer.setVisible(false);
            this.layeredPane.add((Component)this.menuEditLayer, new Integer(2000));
        }
        return this.menuEditLayer;
    }

    private Collection componentIds() {
        LinkedList<String> componentIds = new LinkedList<String>();
        List selectedComps = this.getSelectedLayoutComponents();
        LayoutModel layoutModel = this.getFormModel().getLayoutModel();
        for (RADVisualComponent visualComp : selectedComps) {
            if (visualComp.getParentContainer() == null || visualComp.getParentLayoutSupport() != null || layoutModel.getLayoutComponent(visualComp.getId()) == null) continue;
            componentIds.add(visualComp.getId());
        }
        return componentIds;
    }

    private class AlignAction
    extends AbstractAction {
        private static final String ICON_BASE = "org/netbeans/modules/form/resources/align_";
        private int dimension;
        private int alignment;
        private boolean closed;

        AlignAction(int dimension, int alignment, boolean closed) {
            boolean leading;
            this.dimension = dimension;
            this.alignment = alignment;
            this.closed = closed;
            boolean horizontal = dimension == 0;
            boolean bl = leading = alignment == 0;
            String code = alignment == 2 ? (horizontal ? "ch" : "cv") : (horizontal ? (leading ? "l" : "r") : (leading ? "u" : "d"));
            String iconResource = ICON_BASE + code + ".png";
            this.putValue("SmallIcon", new ImageIcon(Utilities.loadImage((String)iconResource)));
            this.putValue("ShortDescription", FormUtils.getBundleString("CTL_AlignAction_" + code));
            this.setEnabled(false);
        }

        public void actionPerformed(ActionEvent e) {
            FormDesigner.this.align(this.closed, this.dimension, this.alignment);
        }

        public int getDimension() {
            return this.dimension;
        }

        public int getAlignment() {
            return this.alignment;
        }
    }

    private class FormListener
    implements FormModelListener,
    Runnable {
        private FormModelEvent[] events;

        private FormListener() {
        }

        public void formChanged(final FormModelEvent[] events) {
            if (!EventQueue.isDispatchThread()) {
                EventQueue.invokeLater(new Runnable(){

                    public void run() {
                        FormListener.this.processEvents(events);
                    }
                });
            } else {
                this.processEvents(events);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void processEvents(FormModelEvent[] events) {
            boolean lafBlock;
            if (events == null) {
                lafBlock = true;
            } else {
                lafBlock = false;
                boolean modifying = false;
                for (int i = 0; i < events.length; ++i) {
                    FormModelEvent ev = events[i];
                    if (ev.isModifying()) {
                        modifying = true;
                    }
                    if (ev.getChangeType() != 7) continue;
                    lafBlock = true;
                    break;
                }
                if (!modifying) {
                    return;
                }
                assert (EventQueue.isDispatchThread());
            }
            this.events = events;
            if (lafBlock) {
                Locale defaultLocale = FormDesigner.switchToDesignLocale(FormDesigner.this.getFormModel());
                try {
                    FormLAF.executeWithLookAndFeel(this);
                }
                finally {
                    if (defaultLocale != null) {
                        Locale.setDefault(defaultLocale);
                    }
                }
            } else {
                this.run();
            }
        }

        public void run() {
            if (this.events == null) {
                Object originalVisualComp = FormDesigner.this.topDesignComponent == null ? null : FormDesigner.this.replicator.getClonedComponent(FormDesigner.this.topDesignComponent);
                Dimension originalSize = originalVisualComp instanceof Component ? ((Component)originalVisualComp).getSize() : null;
                FormDesigner.this.replicator.setTopMetaComponent(FormDesigner.this.topDesignComponent);
                Component formClone = (Component)FormDesigner.this.replicator.createClone();
                if (formClone != null) {
                    formClone.setVisible(true);
                    FormDesigner.this.componentLayer.setTopDesignComponent(formClone);
                    if (originalSize != null) {
                        FormDesigner.this.componentLayer.setDesignerSize(originalSize);
                        FormDesigner.this.checkDesignerSize();
                    } else {
                        FormDesigner.this.setupDesignerSize();
                    }
                    if (FormDesigner.this.getLayoutDesigner() != null) {
                        FormDesigner.this.getLayoutDesigner().externalSizeChangeHappened();
                    }
                    EventQueue.invokeLater(new Runnable(){

                        public void run() {
                            FormDesigner.this.updateComponentLayer(false);
                        }
                    });
                }
                return;
            }
            FormModelEvent[] events = this.events;
            this.events = null;
            int prevType = 0;
            ComponentContainer prevContainer = null;
            boolean updateDone = false;
            boolean deriveDesignerSize = false;
            for (int i = 0; i < events.length; ++i) {
                FormModelEvent ev = events[i];
                int type = ev.getChangeType();
                ComponentContainer metacont = ev.getContainer();
                if (type == 4 || type == 5 || type == 6) {
                    if (prevType != 4 && prevType != 5 && prevType != 6 || prevContainer != metacont) {
                        FormDesigner.this.replicator.updateContainerLayout((RADVisualContainer)metacont);
                        updateDone = true;
                    }
                } else if (type == 7) {
                    if ((metacont instanceof RADVisualContainer || metacont instanceof RADMenuComponent) && (prevType != 7 || prevContainer != metacont)) {
                        FormDesigner.this.replicator.updateAddedComponents(metacont);
                        updateDone = true;
                    }
                } else if (type == 8) {
                    RADComponent removed = ev.getComponent();
                    if (removed instanceof RADVisualComponent && (removed == FormDesigner.this.topDesignComponent || removed.isParentComponent(FormDesigner.this.topDesignComponent))) {
                        FormDesigner.this.resetTopDesignComponent(false);
                        FormDesigner.this.updateWholeDesigner();
                        return;
                    }
                    FormDesigner.this.replicator.removeComponent(ev.getComponent(), ev.getContainer());
                    updateDone = true;
                } else if (type == 9) {
                    if (prevType != 9 || prevContainer != metacont) {
                        FormDesigner.this.replicator.reorderComponents(metacont);
                        updateDone = true;
                    }
                } else if (type == 10) {
                    RADProperty eventProperty = ev.getComponentProperty();
                    RADComponent eventComponent = ev.getComponent();
                    FormDesigner.this.replicator.updateComponentProperty(eventProperty);
                    this.updateConnectedProperties(eventProperty, eventComponent);
                    updateDone = true;
                } else if (type == 16) {
                    FormDesigner.this.replicator.updateBinding(ev.getNewBinding());
                    updateDone = true;
                } else if (type == 11 && FormDesigner.PROP_DESIGNER_SIZE.equals(ev.getPropertyName())) {
                    Dimension size = (Dimension)ev.getNewPropertyValue();
                    if (size != null) {
                        FormDesigner.this.componentLayer.setDesignerSize(size);
                        deriveDesignerSize = false;
                        updateDone = true;
                    } else {
                        deriveDesignerSize = true;
                        updateDone = true;
                    }
                }
                prevType = type;
                prevContainer = metacont;
            }
            if (updateDone) {
                if (deriveDesignerSize) {
                    FormDesigner.this.setupDesignerSize();
                } else {
                    FormDesigner.this.checkDesignerSize();
                }
                LayoutDesigner layoutDesigner = FormDesigner.this.getLayoutDesigner();
                if (layoutDesigner != null && FormDesigner.this.formModel.isCompoundEditInProgress()) {
                    FormDesigner.this.getLayoutDesigner().externalSizeChangeHappened();
                }
                FormDesigner.this.updateComponentLayer(true);
            }
        }

        private void updateConnectedProperties(RADProperty eventProperty, RADComponent eventComponent) {
            for (RADComponent component : FormDesigner.this.formModel.getAllComponents()) {
                RADProperty[] properties = component.getKnownBeanProperties();
                for (int i = 0; i < properties.length; ++i) {
                    try {
                        RADConnectionPropertyEditor.RADConnectionDesignValue propertyValue;
                        Object value;
                        if (!properties[i].isChanged() || !((value = properties[i].getValue()) instanceof RADConnectionPropertyEditor.RADConnectionDesignValue) || (propertyValue = (RADConnectionPropertyEditor.RADConnectionDesignValue)value).getRADComponent() == null || propertyValue.getProperty() == null || !eventComponent.getName().equals(propertyValue.getRADComponent().getName()) || !eventProperty.getName().equals(propertyValue.getProperty().getName())) continue;
                        FormDesigner.this.replicator.updateComponentProperty(properties[i]);
                        continue;
                    }
                    catch (Exception e) {
                        ErrorManager.getDefault().notify((Throwable)e);
                    }
                }
            }
        }
    }

    static class FormProxyLookup
    extends ProxyLookup {
        FormProxyLookup(Lookup[] lookups) {
            super(lookups);
        }

        Lookup[] getSubLookups() {
            return this.getLookups();
        }

        void setSubLookups(Lookup[] lookups) {
            this.setLookups(lookups);
        }
    }

    private class LayoutMapper
    implements VisualMapper {
        private LayoutMapper() {
        }

        public Rectangle getComponentBounds(String componentId) {
            Component visual = this.getVisualComponent(componentId, true, false);
            Rectangle rect = null;
            if (visual != null) {
                rect = FormDesigner.this.componentBoundsToTop(visual);
            }
            if (FormDesigner.this.getLayoutDesigner().logTestCode()) {
                FormDesigner.this.getLayoutDesigner().testCode.add("  compBounds.put(\"" + componentId + "\", new Rectangle(" + rect.x + ", " + rect.y + ", " + rect.width + ", " + rect.height + "));");
            }
            return rect;
        }

        public Rectangle getContainerInterior(String componentId) {
            Component visual = this.getVisualComponent(componentId, true, false);
            if (visual == null) {
                return null;
            }
            RADVisualContainer metacont = (RADVisualContainer)this.getMetaComponent(componentId);
            Container cont = metacont.getContainerDelegate(visual);
            Rectangle rect = FormDesigner.this.componentBoundsToTop(cont);
            Insets insets = cont.getInsets();
            rect.x += insets.left;
            rect.y += insets.top;
            rect.width -= insets.left + insets.right;
            rect.height -= insets.top + insets.bottom;
            if (FormDesigner.this.getLayoutDesigner().logTestCode()) {
                FormDesigner.this.getLayoutDesigner().testCode.add("  contInterior.put(\"" + componentId + "\", new Rectangle(" + rect.x + ", " + rect.y + ", " + rect.width + ", " + rect.height + "));");
            }
            return rect;
        }

        public Dimension getComponentMinimumSize(String componentId) {
            Component visual = this.getVisualComponent(componentId, false, false);
            Dimension dim = null;
            if (visual != null) {
                dim = visual.getMinimumSize();
            }
            if (FormDesigner.this.getLayoutDesigner().logTestCode()) {
                FormDesigner.this.getLayoutDesigner().testCode.add("  compMinSize.put(\"" + componentId + "\", new Dimension(" + new Double(dim.getWidth()).intValue() + ", " + new Double(dim.getHeight()).intValue() + "));");
            }
            return dim;
        }

        public Dimension getComponentPreferredSize(String componentId) {
            Component visual = this.getVisualComponent(componentId, false, false);
            Dimension dim = null;
            if (visual != null) {
                dim = visual.getPreferredSize();
            }
            if (FormDesigner.this.getLayoutDesigner().logTestCode()) {
                FormDesigner.this.getLayoutDesigner().testCode.add("  compPrefSize.put(\"" + componentId + "\", new Dimension(" + new Double(dim.getWidth()).intValue() + ", " + new Double(dim.getHeight()).intValue() + "));");
            }
            return dim;
        }

        public boolean hasExplicitPreferredSize(String componentId) {
            JComponent visual = (JComponent)this.getVisualComponent(componentId, false, true);
            boolean hasExplPrefSize = false;
            if (visual != null) {
                hasExplPrefSize = visual.isPreferredSizeSet();
            }
            if (FormDesigner.this.getLayoutDesigner().logTestCode()) {
                FormDesigner.this.getLayoutDesigner().testCode.add("  hasExplicitPrefSize.put(\"" + componentId + "\", new Boolean(" + hasExplPrefSize + "));");
            }
            return hasExplPrefSize;
        }

        public int getBaselinePosition(String componentId, int width, int height) {
            int baseLinePos = -1;
            JComponent comp = (JComponent)this.getVisualComponent(componentId, true, true);
            if (comp != null && (comp instanceof JScrollPane || comp.getClass().equals(JPanel.class) || comp instanceof JTabbedPane)) {
                baseLinePos = 0;
            }
            if (baseLinePos == -1) {
                baseLinePos = comp != null ? Baseline.getBaseline((JComponent)comp, (int)width, (int)height) : 0;
            }
            if (FormDesigner.this.getLayoutDesigner().logTestCode()) {
                String id = componentId + "-" + width + "-" + height;
                FormDesigner.this.getLayoutDesigner().testCode.add("  baselinePosition.put(\"" + id + "\", new Integer(" + baseLinePos + "));");
            }
            return baseLinePos;
        }

        public int getPreferredPadding(String comp1Id, String comp2Id, int dimension, int comp2Alignment, LayoutConstants.PaddingType paddingType) {
            int prefPadding;
            String id = null;
            if (FormDesigner.this.getLayoutDesigner().logTestCode()) {
                id = comp1Id + "-" + comp2Id + "-" + dimension + "-" + comp2Alignment + "-" + (paddingType != null ? paddingType.ordinal() : 0);
            }
            JComponent comp1 = (JComponent)this.getVisualComponent(comp1Id, true, true);
            JComponent comp2 = (JComponent)this.getVisualComponent(comp2Id, true, true);
            if (comp1 == null || comp2 == null) {
                if (FormDesigner.this.getLayoutDesigner().logTestCode()) {
                    FormDesigner.this.getLayoutDesigner().testCode.add("  prefPadding.put(\"" + id + "\", new Integer(10)); // comp1Id-comp2Id-dimension-comp2Alignment-paddingType");
                }
                return 10;
            }
            assert (dimension == 0 || dimension == 1);
            assert (comp2Alignment == 0 || comp2Alignment == 1);
            int type = paddingType == LayoutConstants.PaddingType.INDENT ? 3 : (paddingType == LayoutConstants.PaddingType.RELATED ? 0 : 1);
            int position = 0;
            position = dimension == 0 ? (paddingType == LayoutConstants.PaddingType.INDENT ? (comp2Alignment == 0 ? 7 : 3) : (comp2Alignment == 0 ? 3 : 7)) : (comp2Alignment == 0 ? 5 : 1);
            int n = prefPadding = paddingType != LayoutConstants.PaddingType.SEPARATE ? FormLAF.getDesignerLayoutStyle().getPreferredGap(comp1, comp2, type, position, null) : 18;
            if (FormDesigner.this.getLayoutDesigner().logTestCode()) {
                FormDesigner.this.getLayoutDesigner().testCode.add("  prefPadding.put(\"" + id + "\", new Integer(" + prefPadding + ")); // comp1Id-comp2Id-dimension-comp2Alignment-paddingType");
            }
            return prefPadding;
        }

        public int getPreferredPaddingInParent(String parentId, String compId, int dimension, int compAlignment) {
            String id = null;
            if (FormDesigner.this.getLayoutDesigner().logTestCode()) {
                id = parentId + "-" + compId + "-" + dimension + "-" + compAlignment;
            }
            JComponent comp = null;
            Container parent = (Container)this.getVisualComponent(parentId, true, false);
            if (parent != null) {
                RADVisualContainer metacont = (RADVisualContainer)this.getMetaComponent(parentId);
                parent = metacont.getContainerDelegate(parent);
                comp = (JComponent)this.getVisualComponent(compId, true, true);
            }
            if (comp == null) {
                if (FormDesigner.this.getLayoutDesigner().logTestCode()) {
                    FormDesigner.this.getLayoutDesigner().testCode.add("  prefPaddingInParent.put(\"" + id + "\", new Integer(10)); // parentId-compId-dimension-compAlignment");
                }
                return 10;
            }
            assert (dimension == 0 || dimension == 1);
            assert (compAlignment == 0 || compAlignment == 1);
            int alignment = dimension == 0 ? (compAlignment == 0 ? 7 : 3) : (compAlignment == 0 ? 1 : 5);
            int prefPadding = FormLAF.getDesignerLayoutStyle().getContainerGap(comp, alignment, parent);
            if (FormDesigner.this.getLayoutDesigner().logTestCode()) {
                FormDesigner.this.getLayoutDesigner().testCode.add("  prefPaddingInParent.put(\"" + id + "\", new Integer(" + prefPadding + ")); // parentId-compId-dimension-compAlignment");
            }
            return prefPadding;
        }

        public boolean[] getComponentResizability(String compId, boolean[] resizability) {
            resizability[1] = true;
            resizability[0] = true;
            return resizability;
        }

        public void rebuildLayout(String contId) {
            FormDesigner.this.replicator.updateContainerLayout((RADVisualContainer)this.getMetaComponent(contId));
            FormDesigner.this.replicator.getLayoutBuilder(contId).doLayout();
        }

        public void setComponentVisibility(String componentId, boolean visible) {
            Object comp = FormDesigner.this.getComponent(componentId);
            if (comp instanceof Component) {
                ((Component)comp).setVisible(visible);
            }
        }

        private RADComponent getMetaComponent(String compId) {
            RADVisualComponent precreated;
            RADComponent metacomp = FormDesigner.this.formModel.getMetaComponent(compId);
            if (metacomp == null && (precreated = FormDesigner.this.formModel.getComponentCreator().getPrecreatedMetaComponent()) != null && precreated.getId().equals(compId)) {
                metacomp = precreated;
            }
            return metacomp;
        }

        private Component getVisualComponent(String compId, boolean needVisible, boolean needJComponent) {
            Object comp = FormDesigner.this.getComponent(compId);
            if (comp == null) {
                RADComponent metacomp;
                RADVisualComponent precreated = FormDesigner.this.formModel.getComponentCreator().getPrecreatedMetaComponent();
                if (precreated != null && precreated.getId().equals(compId)) {
                    comp = precreated.getBeanInstance();
                }
                if (comp == null && !needVisible && (metacomp = this.getMetaComponent(compId)) != null) {
                    comp = metacomp.getBeanInstance();
                }
            }
            Class type = needJComponent ? JComponent.class : Component.class;
            return comp != null && type.isAssignableFrom(comp.getClass()) ? (Component)comp : null;
        }
    }

    private static class NoNodeLookup
    extends Lookup {
        private final Lookup delegate;

        public NoNodeLookup(Lookup delegate) {
            this.delegate = delegate;
        }

        public Object lookup(Class clazz) {
            return clazz == Node.class ? null : this.delegate.lookup(clazz);
        }

        public Lookup.Result lookup(Lookup.Template template) {
            if (template.getType() == Node.class) {
                return Lookup.EMPTY.lookup(new Lookup.Template(Node.class));
            }
            return this.delegate.lookup(template);
        }
    }

    private class ResizabilityAction
    extends AbstractAction {
        private static final String ICON_BASE = "org/netbeans/modules/form/resources/resize_";
        private int dimension;

        ResizabilityAction(int dimension) {
            this.dimension = dimension;
            String code = dimension == 0 ? "h" : "v";
            String iconResource = ICON_BASE + code + ".png";
            this.putValue("SmallIcon", new ImageIcon(Utilities.loadImage((String)iconResource)));
            this.putValue("ShortDescription", FormUtils.getBundleString("CTL_ResizeButton_" + code));
            this.setEnabled(false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void actionPerformed(ActionEvent e) {
            FormModel formModel = FormDesigner.this.getFormModel();
            LayoutModel layoutModel = formModel.getLayoutModel();
            Object layoutUndoMark = layoutModel.getChangeMark();
            UndoableEdit ue = layoutModel.getUndoableEdit();
            boolean autoUndo = true;
            LayoutDesigner layoutDesigner = FormDesigner.this.getLayoutDesigner();
            Collection componentIds = FormDesigner.this.componentIds();
            HashSet<RADVisualContainer> containers = new HashSet<RADVisualContainer>();
            try {
                for (String compId : componentIds) {
                    LayoutComponent layoutComp = layoutModel.getLayoutComponent(compId);
                    boolean resizing = FormDesigner.this.getResizabilityButtons()[this.dimension].isSelected();
                    if (layoutDesigner.isComponentResizing(layoutComp, this.dimension) == resizing) continue;
                    layoutDesigner.setComponentResizing(layoutComp, this.dimension, resizing);
                    RADVisualComponent comp = (RADVisualComponent)formModel.getMetaComponent(compId);
                    containers.add(comp.getParentContainer());
                }
                autoUndo = false;
            }
            finally {
                Iterator iter = containers.iterator();
                while (iter.hasNext()) {
                    formModel.fireContainerLayoutChanged((RADVisualContainer)iter.next(), null, null, null);
                }
                if (!layoutUndoMark.equals(layoutModel.getChangeMark())) {
                    formModel.addUndoableEdit(ue);
                }
                if (autoUndo) {
                    formModel.forceUndoOfCompoundEdit();
                }
            }
        }
    }
}

