/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form;

import java.beans.PropertyChangeListener;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.swing.LookAndFeel;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.plaf.metal.MetalLookAndFeel;
import javax.swing.plaf.metal.MetalTheme;
import org.jdesktop.layout.LayoutStyle;
import org.openide.ErrorManager;
import org.openide.util.Mutex;
import org.openide.util.MutexException;

public class FormLAF {
    private static final String SWING_NOXP = "swing.noxp";
    private static boolean initialized = false;
    private static boolean lafBlockEntered;
    private static DelegatingDefaults delDefaults;
    private static Map netbeansDefaults;
    private static Map userDefaults;
    private static Map lafToTheme;
    private static boolean ideLafIsMetal;
    private static boolean preview;
    private static Class previewLaf;
    static String oldNoXP;

    private FormLAF() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static UIDefaults initPreviewLaf(Class lafClass) {
        try {
            ClassLoader classLoader;
            boolean previewLafIsMetal = MetalLookAndFeel.class.isAssignableFrom(lafClass);
            if (!ideLafIsMetal && previewLafIsMetal && !MetalLookAndFeel.class.equals((Object)lafClass) && lafToTheme.get(MetalLookAndFeel.class) == null) {
                lafToTheme.put(MetalLookAndFeel.class, MetalLookAndFeel.getCurrentTheme());
            }
            LookAndFeel previewLookAndFeel = (LookAndFeel)lafClass.newInstance();
            if (previewLafIsMetal) {
                MetalTheme theme = (MetalTheme)lafToTheme.get(lafClass);
                if (theme == null) {
                    lafToTheme.put(lafClass, MetalLookAndFeel.getCurrentTheme());
                } else {
                    MetalLookAndFeel.setCurrentTheme(theme);
                }
            }
            String noxp = null;
            boolean classic = FormLAF.isClassicWinLAF(lafClass.getName());
            if (classic) {
                noxp = System.getProperty(SWING_NOXP);
                System.setProperty(SWING_NOXP, "y");
            }
            UIDefaults previewDefaults = null;
            try {
                previewLookAndFeel.initialize();
                previewDefaults = previewLookAndFeel.getDefaults();
            }
            finally {
                if (classic) {
                    if (noxp == null) {
                        System.getProperties().remove(SWING_NOXP);
                    } else {
                        System.setProperty(SWING_NOXP, noxp);
                    }
                }
            }
            if (previewLafIsMetal && ideLafIsMetal) {
                LookAndFeel ideLaf = UIManager.getLookAndFeel();
                MetalTheme theme = (MetalTheme)lafToTheme.get(ideLaf.getClass());
                MetalLookAndFeel.setCurrentTheme(theme);
            }
            if ((classLoader = lafClass.getClassLoader()) != null) {
                previewDefaults.put("ClassLoader", classLoader);
            }
            if (previewDefaults.get("LayoutStyle.instance") == null) {
                previewDefaults.put("LayoutStyle.instance", FormLAF.createLayoutStyle(previewLookAndFeel.getID()));
            }
            previewDefaults.putAll(delDefaults.getCustomizedUIDefaults());
            return previewDefaults;
        }
        catch (Exception ex) {
            ErrorManager.getDefault().notify(1, (Throwable)ex);
        }
        catch (LinkageError ex) {
            ErrorManager.getDefault().notify(1, (Throwable)ex);
        }
        return null;
    }

    private static boolean isClassicWinLAF(String className) {
        return "com.sun.java.swing.plaf.windows.WindowsClassicLookAndFeel".equals(className);
    }

    private static void invalidateXPStyle() {
        try {
            Class<?> xpStyle = Class.forName("com.sun.java.swing.plaf.windows.XPStyle");
            Method method = xpStyle.getDeclaredMethod("invalidateStyle", null);
            method.setAccessible(true);
            method.invoke(null, new Object[0]);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private static void initialize() throws Exception {
        initialized = true;
        UIManager.getDefaults();
        LookAndFeel laf = UIManager.getLookAndFeel();
        ideLafIsMetal = laf instanceof MetalLookAndFeel;
        if (ideLafIsMetal) {
            lafToTheme.put(laf.getClass(), MetalLookAndFeel.getCurrentTheme());
        }
        LookAndFeel original = laf;
        try {
            original = (LookAndFeel)laf.getClass().newInstance();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        Method method = UIManager.class.getDeclaredMethod("getLAFState", new Class[0]);
        method.setAccessible(true);
        Object lafState = method.invoke(null, new Object[0]);
        method = lafState.getClass().getDeclaredMethod("setLookAndFeelDefaults", UIDefaults.class);
        method.setAccessible(true);
        UIDefaults ide = UIManager.getLookAndFeelDefaults();
        assert (!(ide instanceof DelegatingDefaults));
        delDefaults = new DelegatingDefaults(null, original.getDefaults(), ide);
        method.invoke(lafState, delDefaults);
    }

    static Object executeWithLookAndFeel(final Mutex.ExceptionAction act) throws Exception {
        try {
            return Mutex.EVENT.readAccess(new Mutex.ExceptionAction(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public Object run() throws Exception {
                    UIDefaults uIDefaults = UIManager.getDefaults();
                    synchronized (uIDefaults) {
                        Object object;
                        block9: {
                            boolean restoreAfter = true;
                            try {
                                if (lafBlockEntered) {
                                    restoreAfter = false;
                                } else {
                                    lafBlockEntered = true;
                                    FormLAF.useDesignerLookAndFeel();
                                    restoreAfter = true;
                                }
                                object = act.run();
                                if (!restoreAfter) break block9;
                            }
                            catch (Throwable throwable) {
                                if (restoreAfter) {
                                    FormLAF.useIDELookAndFeel();
                                    lafBlockEntered = false;
                                }
                                throw throwable;
                            }
                            FormLAF.useIDELookAndFeel();
                            lafBlockEntered = false;
                        }
                        return object;
                    }
                }
            });
        }
        catch (MutexException ex) {
            throw ex.getException();
        }
    }

    static void executeWithLookAndFeel(final Runnable run) {
        Mutex.EVENT.readAccess(new Mutex.Action(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object run() {
                UIDefaults uIDefaults = UIManager.getDefaults();
                synchronized (uIDefaults) {
                    boolean restoreAfter = true;
                    try {
                        if (lafBlockEntered) {
                            restoreAfter = false;
                        } else {
                            lafBlockEntered = true;
                            FormLAF.useDesignerLookAndFeel();
                            restoreAfter = true;
                        }
                        run.run();
                    }
                    finally {
                        if (restoreAfter) {
                            FormLAF.useIDELookAndFeel();
                            lafBlockEntered = false;
                        }
                    }
                }
                return null;
            }
        });
    }

    private static void useDesignerLookAndFeel() {
        if (!initialized) {
            try {
                FormLAF.initialize();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        UIDefaults defaults = UIManager.getDefaults();
        netbeansDefaults.clear();
        netbeansDefaults.putAll(defaults);
        netbeansDefaults.keySet().removeAll(userDefaults.keySet());
        defaults.keySet().removeAll(netbeansDefaults.keySet());
        if (!preview) {
            FormLAF.setUseDesignerDefaults(true);
        } else if (MetalLookAndFeel.class.isAssignableFrom(previewLaf)) {
            MetalLookAndFeel.setCurrentTheme((MetalTheme)lafToTheme.get(previewLaf));
        }
    }

    private static void useIDELookAndFeel() {
        userDefaults.clear();
        userDefaults.putAll(UIManager.getDefaults());
        UIManager.getDefaults().putAll(netbeansDefaults);
        if (!preview) {
            FormLAF.setUseDesignerDefaults(false);
        } else if (ideLafIsMetal) {
            MetalLookAndFeel.setCurrentTheme((MetalTheme)lafToTheme.get(UIManager.getLookAndFeel().getClass()));
        }
    }

    private static LayoutStyle createLayoutStyle(String lafID) {
        boolean useCoreLayoutStyle = false;
        try {
            Class.forName("javax.swing.LayoutStyle");
            useCoreLayoutStyle = true;
        }
        catch (ClassNotFoundException cnfex) {
            // empty catch block
        }
        String layoutStyleClass = useCoreLayoutStyle ? "Swing" : ("Metal" == lafID ? "Metal" : ("Windows" == lafID ? "Windows" : ("GTK" == lafID ? "Gnome" : ("Aqua" == lafID ? "Aqua" : ""))));
        layoutStyleClass = "org.jdesktop.layout." + layoutStyleClass + "LayoutStyle";
        LayoutStyle layoutStyle = null;
        try {
            Class<?> clazz = Class.forName(layoutStyleClass);
            Constructor<?> constr = clazz.getDeclaredConstructor(new Class[0]);
            constr.setAccessible(true);
            layoutStyle = (LayoutStyle)constr.newInstance(null);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return layoutStyle;
    }

    static LayoutStyle getDesignerLayoutStyle() {
        return LayoutStyle.getSharedInstance();
    }

    static void setUseDesignerDefaults(boolean designerDefaults) {
        delDefaults.setDelegating(designerDefaults);
    }

    static void setUsePreviewDefaults(boolean previewing, Class previewLAF, UIDefaults uiDefaults) {
        boolean classic = previewLAF == null ? (previewLaf == null ? false : FormLAF.isClassicWinLAF(previewLaf.getName())) : FormLAF.isClassicWinLAF(previewLAF.getName());
        preview = previewing;
        previewLaf = previewLAF;
        if (previewing) {
            if (classic) {
                oldNoXP = System.getProperty(SWING_NOXP);
                System.setProperty(SWING_NOXP, "y");
                FormLAF.invalidateXPStyle();
            }
            delDefaults.setPreviewDefaults(uiDefaults);
        } else {
            if (classic) {
                if (oldNoXP == null) {
                    System.getProperties().remove(SWING_NOXP);
                } else {
                    System.setProperty(SWING_NOXP, oldNoXP);
                }
                FormLAF.invalidateXPStyle();
            }
            oldNoXP = null;
        }
        delDefaults.setPreviewing(previewing);
    }

    public static boolean getUsePreviewDefaults() {
        return preview && !delDefaults.isDelegating();
    }

    static void setCustomizingUIClasses(boolean customizing) {
        if (delDefaults != null) {
            delDefaults.setCustomizingUIClasses(customizing);
        }
    }

    static {
        netbeansDefaults = new HashMap();
        userDefaults = new HashMap();
        lafToTheme = new HashMap();
    }

    static class DelegatingDefaults
    extends UIDefaults {
        private UIDefaults preview;
        private UIDefaults original;
        private UIDefaults ide;
        private boolean delegating;
        private boolean previewing;
        private boolean customizingUI;
        private Map customizedUIDefaults = new HashMap();

        DelegatingDefaults(UIDefaults preview, UIDefaults original, UIDefaults ide) {
            this.preview = preview;
            this.original = original;
            this.ide = ide;
        }

        public void setPreviewDefaults(UIDefaults preview) {
            this.preview = preview;
        }

        public void setDelegating(boolean delegating) {
            this.delegating = delegating;
        }

        public boolean isDelegating() {
            return this.delegating;
        }

        public void setPreviewing(boolean previewing) {
            this.previewing = previewing;
        }

        public boolean isPreviewing() {
            return this.previewing;
        }

        public void setCustomizingUIClasses(boolean customizing) {
            this.customizingUI = customizing;
        }

        public Map getCustomizedUIDefaults() {
            return this.customizedUIDefaults;
        }

        private UIDefaults getCurrentDefaults() {
            return this.delegating ? this.original : (this.previewing ? this.preview : this.ide);
        }

        public Object get(Object key) {
            return this.delegating ? this.original.get(key) : (this.previewing ? this.preview.get(key) : this.ide.get(key));
        }

        public Object put(Object key, Object value) {
            if (this.delegating) {
                if (this.customizingUI) {
                    this.customizedUIDefaults.put(key, value);
                }
                return this.original.put(key, value);
            }
            return this.previewing ? this.preview.put(key, value) : this.ide.put(key, value);
        }

        public void putDefaults(Object[] keyValueList) {
            this.getCurrentDefaults().putDefaults(keyValueList);
        }

        public Object get(Object key, Locale l) {
            return this.getCurrentDefaults().get(key, l);
        }

        public synchronized void addResourceBundle(String bundleName) {
            this.getCurrentDefaults().addResourceBundle(bundleName);
        }

        public synchronized void removeResourceBundle(String bundleName) {
            this.getCurrentDefaults().removeResourceBundle(bundleName);
        }

        public void setDefaultLocale(Locale l) {
            this.getCurrentDefaults().setDefaultLocale(l);
        }

        public Locale getDefaultLocale() {
            return this.getCurrentDefaults().getDefaultLocale();
        }

        public synchronized void addPropertyChangeListener(PropertyChangeListener listener) {
            this.getCurrentDefaults().addPropertyChangeListener(listener);
        }

        public synchronized void removePropertyChangeListener(PropertyChangeListener listener) {
            this.getCurrentDefaults().removePropertyChangeListener(listener);
        }

        public synchronized PropertyChangeListener[] getPropertyChangeListeners() {
            return this.getCurrentDefaults().getPropertyChangeListeners();
        }

        protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
            System.out.println("Warning: FormLAF.firePropertyChange called, but not implemented.");
        }
    }
}

