/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form;

import java.beans.PropertyEditor;
import org.netbeans.modules.form.FormAwareEditor;
import org.netbeans.modules.form.FormModel;
import org.netbeans.modules.form.FormProperty;
import org.netbeans.modules.form.RADComponent;

public interface FormPropertyContext {
    public boolean useMultipleEditors();

    public void initPropertyEditor(PropertyEditor var1, FormProperty var2);

    public FormModel getFormModel();

    public String getContextPath();

    public Class getParentObjectType();

    public static class Component
    implements FormPropertyContext {
        private RADComponent component;

        public Component(RADComponent metacomp) {
            this.component = metacomp;
        }

        public boolean useMultipleEditors() {
            return true;
        }

        public void initPropertyEditor(PropertyEditor prEd, FormProperty property) {
            if (prEd instanceof FormAwareEditor) {
                ((FormAwareEditor)((Object)prEd)).setContext(this.getFormModel(), property);
            }
        }

        public FormModel getFormModel() {
            return this.component.getFormModel();
        }

        public String getContextPath() {
            return this.component != this.getFormModel().getTopRADComponent() ? this.component.getName() : "";
        }

        public Class getParentObjectType() {
            return this.component.getBeanClass();
        }
    }

    public static class EmptyImpl
    implements FormPropertyContext {
        private static EmptyImpl theInstance = null;

        public boolean useMultipleEditors() {
            return false;
        }

        public void initPropertyEditor(PropertyEditor prEd, FormProperty property) {
            if (prEd instanceof FormAwareEditor) {
                ((FormAwareEditor)((Object)prEd)).setContext(this.getFormModel(), property);
            }
        }

        public FormModel getFormModel() {
            return null;
        }

        public String getContextPath() {
            return "";
        }

        public Class getParentObjectType() {
            return Object.class;
        }

        public static EmptyImpl getInstance() {
            if (theInstance == null) {
                theInstance = new EmptyImpl();
            }
            return theInstance;
        }
    }

    public static class SubProperty
    implements FormPropertyContext {
        private FormProperty parentProperty;

        public SubProperty(FormProperty parentProp) {
            this.parentProperty = parentProp;
        }

        public boolean useMultipleEditors() {
            return this.parentProperty.getPropertyContext().useMultipleEditors();
        }

        public void initPropertyEditor(PropertyEditor prEd, FormProperty property) {
            this.parentProperty.getPropertyContext().initPropertyEditor(prEd, property);
        }

        public FormModel getFormModel() {
            return this.parentProperty.getPropertyContext().getFormModel();
        }

        public String getContextPath() {
            String parentPath = this.parentProperty.getPropertyContext().getContextPath();
            return parentPath != null && !parentPath.equals("") ? parentPath + "." + this.parentProperty.getName() : this.parentProperty.getName();
        }

        public Class getParentObjectType() {
            return this.parentProperty.getValueType();
        }
    }
}

