/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form;

import javax.swing.Action;
import org.netbeans.modules.form.FormEditor;
import org.netbeans.modules.form.FormModel;
import org.netbeans.modules.form.FormNode;
import org.netbeans.modules.form.FormOthersNode;
import org.netbeans.modules.form.FormUtils;
import org.netbeans.modules.form.RADComponentNode;
import org.netbeans.modules.form.actions.ReloadAction;
import org.openide.actions.PropertiesAction;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.actions.SystemAction;

class FormRootNode
extends FormNode {
    private Node.Property[] codeGenProperties;
    private Node.Property[] resourceProperties;
    private Node.Property[] allProperties;

    public FormRootNode(FormModel formModel) {
        super((Children)new RootChildren(formModel), formModel);
        this.setName("Form Root Node");
        this.setIconBaseWithExtension("org/netbeans/modules/form/resources/formDesigner.gif");
        this.updateName(formModel.getName());
    }

    public boolean canRename() {
        return false;
    }

    public boolean canDestroy() {
        return false;
    }

    public Action[] getActions(boolean context) {
        if (this.systemActions == null) {
            this.systemActions = new SystemAction[]{SystemAction.get(ReloadAction.class), null, SystemAction.get(PropertiesAction.class)};
        }
        return this.systemActions;
    }

    void updateName(String name) {
        this.setDisplayName(FormUtils.getFormattedBundleString("FMT_FormNodeName", new Object[]{name}));
    }

    FormOthersNode getOthersNode() {
        return ((RootChildren)this.getChildren()).othersNode;
    }

    public Node.PropertySet[] getPropertySets() {
        Node.PropertySet codeSet = new Node.PropertySet("codeGeneration", FormUtils.getBundleString("CTL_SyntheticTab"), FormUtils.getBundleString("CTL_SyntheticTabHint")){

            public Node.Property[] getProperties() {
                return FormRootNode.this.getCodeGenProperties();
            }
        };
        Node.PropertySet resourceSet = new Node.PropertySet("resources", FormUtils.getBundleString("CTL_ResourceTab"), FormUtils.getBundleString("CTL_ResourceTabHint")){

            public Node.Property[] getProperties() {
                return FormRootNode.this.getResourceProperties();
            }
        };
        return new Node.PropertySet[]{codeSet, resourceSet};
    }

    Node.Property[] getCodeGenProperties() {
        if (this.codeGenProperties == null) {
            this.codeGenProperties = this.createCodeGenProperties();
        }
        return this.codeGenProperties;
    }

    private Node.Property[] createCodeGenProperties() {
        return FormEditor.getCodeGenerator(this.getFormModel()).getSyntheticProperties(null);
    }

    Node.Property[] getResourceProperties() {
        if (this.resourceProperties == null) {
            this.resourceProperties = this.createResourceProperties();
        }
        return this.resourceProperties;
    }

    private Node.Property[] createResourceProperties() {
        return FormEditor.getResourceSupport(this.getFormModel()).createFormProperties();
    }

    Node.Property[] getAllProperties() {
        if (this.allProperties == null) {
            int codeGenCount = this.getCodeGenProperties().length;
            int resCount = this.getResourceProperties().length;
            this.allProperties = new Node.Property[codeGenCount + resCount];
            System.arraycopy(this.codeGenProperties, 0, this.allProperties, 0, codeGenCount);
            System.arraycopy(this.resourceProperties, 0, this.allProperties, codeGenCount, resCount);
        }
        return this.allProperties;
    }

    static class RootChildren
    extends Children.Keys {
        static final Object OTHERS_ROOT = new Object();
        static final Object MAIN_VISUAL_ROOT = new Object();
        private FormModel formModel;
        private FormOthersNode othersNode;

        protected RootChildren(FormModel formModel) {
            Object[] objectArray;
            this.formModel = formModel;
            if (formModel.getTopRADComponent() != null) {
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = OTHERS_ROOT;
                objectArray = objectArray2;
                objectArray2[1] = MAIN_VISUAL_ROOT;
            } else {
                Object[] objectArray3 = new Object[1];
                objectArray = objectArray3;
                objectArray3[0] = OTHERS_ROOT;
            }
            this.setKeys(objectArray);
        }

        protected Node[] createNodes(Object key) {
            FormNode node;
            if (key == MAIN_VISUAL_ROOT) {
                node = new RADComponentNode(this.formModel.getTopRADComponent());
            } else {
                this.othersNode = new FormOthersNode(this.formModel);
                node = this.othersNode;
            }
            node.getChildren().getNodes();
            return new Node[]{node};
        }

        protected final FormModel getFormModel() {
            return this.formModel;
        }
    }
}

