/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form;

import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyEditor;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.modules.form.FormAwareEditor;
import org.netbeans.modules.form.FormModel;
import org.netbeans.modules.form.FormProperty;
import org.netbeans.modules.form.ResourcePanel;
import org.netbeans.modules.form.ResourceSupport;
import org.netbeans.modules.form.ResourceValue;
import org.openide.explorer.propertysheet.ExPropertyEditor;
import org.openide.explorer.propertysheet.PropertyEnv;

public class ResourceWrapperEditor
implements ExPropertyEditor,
FormAwareEditor,
PropertyChangeListener,
ChangeListener,
VetoableChangeListener {
    protected PropertyEditor delegateEditor;
    protected FormProperty property;
    private boolean ignoreChange;
    private PropertyChangeSupport changeSupport;
    private Object propertyValue;
    protected ResourcePanel resourcePanel;

    public ResourceWrapperEditor(PropertyEditor wrappedPropEd) {
        this.delegateEditor = wrappedPropEd;
        this.delegateEditor.addPropertyChangeListener(this);
    }

    public PropertyEditor getDelegatedPropertyEditor() {
        return this.delegateEditor;
    }

    void setDelegatedPropertyEditor(PropertyEditor delegate) {
        this.delegateEditor.removePropertyChangeListener(this);
        this.delegateEditor = delegate;
        this.delegateEditor.addPropertyChangeListener(this);
        this.propertyValue = this.delegateEditor.getValue();
    }

    public void setContext(FormModel formModel, FormProperty prop) {
        this.property = prop;
        if (this.delegateEditor instanceof FormAwareEditor) {
            ((FormAwareEditor)((Object)this.delegateEditor)).setContext(formModel, prop);
        }
    }

    public void attachEnv(PropertyEnv env) {
        if (this.property != null) {
            env.removeVetoableChangeListener((VetoableChangeListener)this);
            env.setState(PropertyEnv.STATE_NEEDS_VALIDATION);
            env.addVetoableChangeListener((VetoableChangeListener)this);
        }
        if (this.delegateEditor instanceof ExPropertyEditor) {
            ((ExPropertyEditor)this.delegateEditor).attachEnv(env);
        }
    }

    public void setValue(Object value) {
        this.propertyValue = value;
        this.ignoreChange = true;
        this.setValueToDelegate(value);
        this.ignoreChange = false;
        this.firePropertyChange();
    }

    public Object getValue() {
        return this.propertyValue;
    }

    public Object getUnwrappedValue() {
        return this.delegateEditor.getValue();
    }

    public void setAsText(String text) {
        if (text.equals(this.delegateEditor.getAsText())) {
            return;
        }
        this.ignoreChange = true;
        this.delegateEditor.setAsText(text);
        this.ignoreChange = false;
        this.propertyValue = this.delegateEditor.getValue();
        this.firePropertyChange();
    }

    public String getAsText() {
        return this.delegateEditor.getAsText();
    }

    public boolean isPaintable() {
        return this.delegateEditor.isPaintable();
    }

    public void paintValue(Graphics g, Rectangle box) {
        this.delegateEditor.paintValue(g, box);
    }

    public String getJavaInitializationString() {
        if (this.propertyValue instanceof ResourceValue) {
            return ((ResourceValue)this.propertyValue).getJavaInitializationCode();
        }
        return this.delegateEditor.getJavaInitializationString();
    }

    public String[] getTags() {
        return this.delegateEditor.getTags();
    }

    public Component getCustomEditor() {
        JComponent resGUI;
        if (this.resourcePanel == null) {
            this.createResourcePanel();
        }
        if (this.resourcePanel != null) {
            boolean enable;
            String key;
            if (this.propertyValue instanceof ResourceValue) {
                key = ((ResourceValue)this.propertyValue).getKey();
                enable = true;
            } else {
                key = ResourceSupport.getDefaultKey(this.property);
                enable = ResourceSupport.isPropertyForResourcing(this.property);
            }
            this.resourcePanel.init(key, enable);
            resGUI = this.resourcePanel.getComponent();
        } else {
            resGUI = null;
        }
        return this.createCustomEditorGUI(resGUI);
    }

    public boolean supportsCustomEditor() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPropertyChangeListener(PropertyChangeListener l) {
        ResourceWrapperEditor resourceWrapperEditor = this;
        synchronized (resourceWrapperEditor) {
            if (this.changeSupport == null) {
                this.changeSupport = new PropertyChangeSupport(this);
            }
        }
        this.changeSupport.addPropertyChangeListener(l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        if (this.changeSupport != null) {
            this.changeSupport.removePropertyChangeListener(l);
        }
    }

    protected void setValueToDelegate(Object value) {
        if (value instanceof ResourceValue) {
            value = ((ResourceValue)value).getValue();
        }
        this.delegateEditor.setValue(value);
    }

    protected void setValueToResourcePanel() {
        this.resourcePanel.setValue(this.delegateEditor.getValue(), null, null);
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if (!this.ignoreChange) {
            if (this.propertyValue instanceof ResourceValue) {
                this.setValueToResourcePanel();
            } else {
                this.propertyValue = this.delegateEditor.getValue();
            }
            this.firePropertyChange();
        }
    }

    public void stateChanged(ChangeEvent e) {
        ResourceValue resValue = this.resourcePanel.getResource();
        if (resValue != null) {
            if (resValue.getValue() == null) {
                this.setValueToResourcePanel();
                resValue = this.resourcePanel.getResource();
            }
            this.setValue(resValue);
        } else {
            this.propertyValue = this.delegateEditor.getValue();
            this.firePropertyChange();
        }
    }

    public void vetoableChange(PropertyChangeEvent ev) throws PropertyVetoException {
        if ("state".equals(ev.getPropertyName())) {
            boolean excludeRes = false;
            if (this.resourcePanel != null) {
                ResourceValue resValue;
                if (this.propertyValue instanceof ResourceValue && (resValue = this.resourcePanel.getResource()) != null) {
                    if (resValue.getValue() == ResourceValue.IGNORED_VALUE) {
                        throw new PropertyVetoException("Invalid resource value", ev);
                    }
                    if (resValue != this.propertyValue) {
                        this.setValue(resValue);
                    }
                } else {
                    excludeRes = true;
                }
            }
            ResourceSupport.setExcludedProperty(this.property, excludeRes);
        }
    }

    private void firePropertyChange() {
        if (this.changeSupport != null) {
            this.changeSupport.firePropertyChange("", null, null);
        }
    }

    private void createResourcePanel() {
        this.resourcePanel = ResourceSupport.createResourcePanel(this.property, this.propertyValue instanceof ResourceValue);
        if (this.resourcePanel != null) {
            this.resourcePanel.addChangeListener(this);
        }
    }

    protected Component createCustomEditorGUI(Component resourcePanelGUI) {
        if (resourcePanelGUI == null) {
            return this.delegateEditor.getCustomEditor();
        }
        JPanel panel = new JPanel();
        Component delComp = this.delegateEditor.getCustomEditor();
        GroupLayout layout = new GroupLayout((Container)panel);
        panel.setLayout((LayoutManager)layout);
        layout.setAutocreateGaps(true);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup().add(delComp).add((GroupLayout.Group)layout.createSequentialGroup().addPreferredGap(0).add(resourcePanelGUI).addPreferredGap(0)));
        layout.setVerticalGroup((GroupLayout.Group)layout.createSequentialGroup().add(delComp).addPreferredGap(1).add(resourcePanelGUI));
        return panel;
    }
}

