/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form.editors;

import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.beans.PropertyEditorSupport;
import java.io.IOException;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerDateModel;
import javax.swing.SpinnerListModel;
import javax.swing.SpinnerNumberModel;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.modules.form.FormAwareEditor;
import org.netbeans.modules.form.FormDesignValueAdapter;
import org.netbeans.modules.form.FormModel;
import org.netbeans.modules.form.FormProperty;
import org.netbeans.modules.form.NamedPropertyEditor;
import org.netbeans.modules.form.RADProperty;
import org.netbeans.modules.form.codestructure.CodeVariable;
import org.netbeans.modules.form.editors2.SpinnerModelEditor;
import org.openide.explorer.propertysheet.editors.XMLPropertyEditor;
import org.openide.util.NbBundle;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class SpinnerEditorEditor
extends PropertyEditorSupport
implements XMLPropertyEditor,
NamedPropertyEditor,
FormAwareEditor {
    private boolean initialized;
    private boolean fireChanges;
    private FormProperty property;
    private JPanel customizerPanel;
    private JTextField formatField;
    private JLabel formatLabel;
    private JComboBox typeCombo;
    private JLabel typeLabel;
    private static final String XML_SPINNER_EDITOR = "SpinnerEditor";
    private static final String ATTR_TYPE = "type";
    private static final String ATTR_FORMAT = "format";

    private void initGUI() {
        this.initialized = true;
        this.initComponents();
        DefaultComboBoxModel<String> comboModel = new DefaultComboBoxModel<String>();
        comboModel.addElement(this.typeToString(0));
        comboModel.addElement(this.typeToString(1));
        comboModel.addElement(this.typeToString(2));
        comboModel.addElement(this.typeToString(3));
        this.typeCombo.setModel(comboModel);
    }

    private int stringToType(String string) {
        int type = -1;
        if (NbBundle.getMessage(this.getClass(), (String)"LBL_SpinnerEditorEditor_Default").equals(string)) {
            type = 0;
        } else if (NbBundle.getMessage(this.getClass(), (String)"LBL_SpinnerEditorEditor_Date").equals(string)) {
            type = 1;
        } else if (NbBundle.getMessage(this.getClass(), (String)"LBL_SpinnerEditorEditor_List").equals(string)) {
            type = 2;
        } else if (NbBundle.getMessage(this.getClass(), (String)"LBL_SpinnerEditorEditor_Number").equals(string)) {
            type = 3;
        }
        return type;
    }

    private String typeToString(int type) {
        String string = null;
        switch (type) {
            case 0: {
                string = NbBundle.getMessage(this.getClass(), (String)"LBL_SpinnerEditorEditor_Default");
                break;
            }
            case 1: {
                string = NbBundle.getMessage(this.getClass(), (String)"LBL_SpinnerEditorEditor_Date");
                break;
            }
            case 2: {
                string = NbBundle.getMessage(this.getClass(), (String)"LBL_SpinnerEditorEditor_List");
                break;
            }
            case 3: {
                string = NbBundle.getMessage(this.getClass(), (String)"LBL_SpinnerEditorEditor_Number");
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        return string;
    }

    public String getAsText() {
        String text = null;
        Object value = this.getValue();
        if (value instanceof FormSpinnerEditor) {
            FormSpinnerEditor editor = (FormSpinnerEditor)value;
            text = this.typeToString(editor.getType());
            String format = editor.getFormat();
            if (format != null) {
                text = text + " " + format;
            }
        } else {
            text = this.typeToString(0);
        }
        return text;
    }

    public void setAsText(String text) {
        String format;
        String typeText;
        if (text == null) {
            throw new IllegalArgumentException();
        }
        int index = text.indexOf(32);
        if (index == -1) {
            typeText = text;
            format = null;
        } else {
            typeText = text.substring(0, index);
            format = text.substring(index + 1);
        }
        int type = this.stringToType(typeText);
        if (type == -1) {
            throw new IllegalArgumentException();
        }
        if (type != 0) {
            FormSpinnerEditor editor = new FormSpinnerEditor(this.property, type, format);
            this.setValue(editor);
        }
    }

    public boolean supportsCustomEditor() {
        return true;
    }

    public Component getCustomEditor() {
        Object value;
        this.fireChanges = false;
        if (!this.initialized) {
            this.initGUI();
        }
        if ((value = this.getValue()) instanceof FormSpinnerEditor) {
            FormSpinnerEditor editor = (FormSpinnerEditor)value;
            this.typeCombo.setSelectedIndex(editor.getType());
            String format = editor.getFormat();
            if (format != null) {
                this.formatField.setText(format);
            }
        } else {
            this.typeCombo.setSelectedIndex(0);
        }
        this.fireChanges = true;
        return this.customizerPanel;
    }

    private void initComponents() {
        this.customizerPanel = new JPanel();
        this.typeLabel = new JLabel();
        this.typeCombo = new JComboBox();
        this.formatLabel = new JLabel();
        this.formatField = new JTextField();
        this.typeLabel.setText(NbBundle.getMessage(SpinnerEditorEditor.class, (String)"LBL_SpinnerEditorEditor_Type"));
        this.typeCombo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SpinnerEditorEditor.this.typeComboActionPerformed(evt);
            }
        });
        this.formatLabel.setText(NbBundle.getMessage(SpinnerEditorEditor.class, (String)"LBL_SpinnerEditorEditor_Format"));
        this.formatField.setColumns(15);
        this.formatField.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent evt) {
                SpinnerEditorEditor.this.formatFieldFocusLost(evt);
            }
        });
        GroupLayout customizerPanelLayout = new GroupLayout((Container)this.customizerPanel);
        this.customizerPanel.setLayout((LayoutManager)customizerPanelLayout);
        customizerPanelLayout.setHorizontalGroup((GroupLayout.Group)customizerPanelLayout.createParallelGroup(1).add((GroupLayout.Group)customizerPanelLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)customizerPanelLayout.createParallelGroup(1).add((Component)this.typeLabel).add((Component)this.formatLabel)).addPreferredGap(0).add((GroupLayout.Group)customizerPanelLayout.createParallelGroup(1).add((Component)this.typeCombo, 0, 126, Short.MAX_VALUE).add((Component)this.formatField)).addContainerGap()));
        customizerPanelLayout.setVerticalGroup((GroupLayout.Group)customizerPanelLayout.createParallelGroup(1).add((GroupLayout.Group)customizerPanelLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)customizerPanelLayout.createParallelGroup(3).add((Component)this.typeLabel).add((Component)this.typeCombo, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)customizerPanelLayout.createParallelGroup(3).add((Component)this.formatLabel).add((Component)this.formatField, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
    }

    private void formatFieldFocusLost(FocusEvent evt) {
        this.updateValueFromUI();
    }

    private void typeComboActionPerformed(ActionEvent evt) {
        boolean editable;
        int index = this.typeCombo.getSelectedIndex();
        boolean bl = editable = index % 2 == 1;
        if (editable != this.formatField.isEditable()) {
            this.formatField.setText("");
            this.formatField.setEditable(editable);
        }
        this.updateValueFromUI();
    }

    private void updateValueFromUI() {
        if (!this.fireChanges) {
            return;
        }
        Object value = this.valueFromUI();
        if (value == null) {
            value = this.property.getDefaultValue();
        }
        this.updateModelProperty(value);
        this.setValue(value);
    }

    private void updateModelProperty(Object value) {
        RADProperty editorProperty;
        RADProperty modelProperty;
        if (value instanceof FormSpinnerEditor && this.property instanceof RADProperty && (modelProperty = (RADProperty)(editorProperty = (RADProperty)this.property).getRADComponent().getPropertyByName("model")) != null) {
            try {
                Object spinnerModel = modelProperty.getRealValue();
                FormSpinnerEditor editor = (FormSpinnerEditor)value;
                int type = editor.getType();
                if (type == 1 && !(spinnerModel instanceof SpinnerDateModel)) {
                    SpinnerDateModel newModel = new SpinnerDateModel();
                    modelProperty.setValue(new SpinnerModelEditor.FormSpinnerModel(newModel, newModel.getValue(), true, false, false));
                } else if (type == 3 && !(spinnerModel instanceof SpinnerNumberModel)) {
                    SpinnerNumberModel newModel = new SpinnerNumberModel();
                    modelProperty.setValue(new SpinnerModelEditor.FormSpinnerModel(newModel, newModel.getValue()));
                } else if (type == 2 && !(spinnerModel instanceof SpinnerListModel)) {
                    SpinnerListModel newModel = new SpinnerListModel();
                    modelProperty.setValue(new SpinnerModelEditor.FormSpinnerModel(newModel, newModel.getValue()));
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    private FormSpinnerEditor valueFromUI() {
        FormSpinnerEditor value;
        int index = this.typeCombo.getSelectedIndex();
        if (index == 0) {
            value = null;
        } else {
            String format = this.formatField.getText();
            if (index % 2 == 0) {
                format = null;
            }
            value = new FormSpinnerEditor(this.property, index, format);
        }
        return value;
    }

    public void readFromXML(Node element) throws IOException {
        NamedNodeMap attributes = element.getAttributes();
        String typeTxt = attributes.getNamedItem(ATTR_TYPE).getNodeValue();
        int type = Integer.parseInt(typeTxt);
        Node node = attributes.getNamedItem(ATTR_FORMAT);
        String format = null;
        if (node != null) {
            format = node.getNodeValue();
        }
        this.setValue(new FormSpinnerEditor(this.property, type, format));
    }

    public Node storeToXML(Document doc) {
        Element el = doc.createElement(XML_SPINNER_EDITOR);
        Object value = this.getValue();
        if (!(value instanceof FormSpinnerEditor)) {
            el.setAttribute(ATTR_TYPE, "0");
        } else {
            FormSpinnerEditor editor = (FormSpinnerEditor)value;
            el.setAttribute(ATTR_TYPE, "" + editor.getType());
            String format = editor.getFormat();
            if (format != null) {
                el.setAttribute(ATTR_FORMAT, editor.getFormat());
            }
        }
        return el;
    }

    public String getDisplayName() {
        return NbBundle.getMessage(this.getClass(), (String)"CTL_SpinnerEditorEditor_DisplayName");
    }

    public void setContext(FormModel formModel, FormProperty property) {
        this.property = property;
    }

    public String getJavaInitializationString() {
        Object value = this.getValue();
        if (!(value instanceof FormSpinnerEditor)) {
            return super.getJavaInitializationString();
        }
        FormSpinnerEditor editor = (FormSpinnerEditor)value;
        CodeVariable var = editor.getProperty().getRADComponent().getCodeExpression().getVariable();
        int type = editor.getType();
        String code = null;
        switch (type) {
            case 1: {
                String format = editor.getFormat().replace("\"", "\\\"");
                code = "new javax.swing.JSpinner.DateEditor(" + var.getName() + ", \"" + format + "\")";
                break;
            }
            case 2: {
                code = "new javax.swing.JSpinner.ListEditor(" + var.getName() + ")";
                break;
            }
            case 3: {
                String format = editor.getFormat().replace("\"", "\\\"");
                code = "new javax.swing.JSpinner.NumberEditor(" + var.getName() + ", \"" + format + "\")";
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        return code;
    }

    static class FormSpinnerEditor
    extends FormDesignValueAdapter {
        public static final int TYPE_DEFAULT = 0;
        public static final int TYPE_DATE = 1;
        public static final int TYPE_LIST = 2;
        public static final int TYPE_NUMBER = 3;
        private int type;
        private String format;
        private RADProperty property;

        FormSpinnerEditor(FormProperty property, int type, String format) {
            this.property = (RADProperty)property;
            this.type = type;
            this.format = format;
        }

        public int getType() {
            return this.type;
        }

        public String getFormat() {
            return this.format;
        }

        RADProperty getProperty() {
            return this.property;
        }

        public Object getDesignValue() {
            Object value = null;
            switch (this.type) {
                case 0: {
                    value = this.property.getDefaultValue();
                    break;
                }
                case 1: {
                    value = new JSpinner.DateEditor((JSpinner)this.property.getRADComponent().getBeanInstance(), this.format);
                    break;
                }
                case 2: {
                    value = new JSpinner.ListEditor((JSpinner)this.property.getRADComponent().getBeanInstance());
                    break;
                }
                case 3: {
                    value = new JSpinner.NumberEditor((JSpinner)this.property.getRADComponent().getBeanInstance(), this.format);
                    break;
                }
                default: {
                    assert (false);
                    break;
                }
            }
            return value;
        }

        public Object copy(FormProperty targetFormProperty) {
            return new FormSpinnerEditor(targetFormProperty, this.type, this.format);
        }
    }
}

