/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form.fakepeer;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.SystemColor;
import java.awt.TextArea;
import org.netbeans.modules.form.fakepeer.FakePeerUtils;
import org.netbeans.modules.form.fakepeer.FakeTextComponentPeer;

class FakeTextAreaPeer
extends FakeTextComponentPeer {
    FakeTextAreaPeer(TextArea target) {
        super(target);
    }

    Component createDelegate() {
        return new Delegate();
    }

    public void insert(String text, int pos) {
    }

    public void replaceRange(String text, int start, int end) {
    }

    public Dimension getPreferredSize(int rows, int columns) {
        return new Dimension(100, 80);
    }

    public Dimension getMinimumSize(int rows, int columns) {
        return new Dimension(100, 80);
    }

    public void insertText(String txt, int pos) {
        this.insert(txt, pos);
    }

    public void replaceText(String txt, int start, int end) {
        this.replaceRange(txt, start, end);
    }

    public Dimension preferredSize(int rows, int cols) {
        return this.getPreferredSize(rows, cols);
    }

    public Dimension minimumSize(int rows, int cols) {
        return this.getMinimumSize(rows, cols);
    }

    private class Delegate
    extends FakeTextComponentPeer.Delegate {
        private Delegate() {
            super(FakeTextAreaPeer.this);
        }

        public void paint(Graphics g) {
            super.paint(g);
            TextArea target = (TextArea)FakeTextAreaPeer.this._target;
            Dimension sz = target.getSize();
            int w = sz.width;
            int h = sz.height;
            String text = target.getText();
            if (text != null) {
                int th;
                g.setFont(target.getFont());
                g.setColor(target.getForeground());
                FontMetrics fm = g.getFontMetrics();
                int ty = th = fm.getHeight();
                int len = text.length();
                StringBuffer buf = new StringBuffer(len);
                for (int i = target.getCaretPosition(); i < len; ++i) {
                    char ch = text.charAt(i);
                    if (ch != '\n' && ch != '\r') {
                        buf.append(ch);
                        continue;
                    }
                    if (ch != '\n') continue;
                    g.drawString(buf.toString(), 4, ty);
                    if (ty > h) break;
                    ty += th;
                    buf.delete(0, buf.length());
                }
                g.drawString(buf.toString(), 4, ty);
            }
            if (sz.width > 32 && sz.height > 32) {
                g.setColor(SystemColor.controlHighlight);
                FakePeerUtils.drawScrollbar(g, 2, h - 16 - 2, w - 4 - 16, 16, 0, false, true, 0, 0, 0);
                g.setColor(SystemColor.controlHighlight);
                FakePeerUtils.drawScrollbar(g, w - 16 - 2, 2, 16, h - 4 - 16, 1, false, true, 0, 0, 0);
                g.setColor(SystemColor.controlHighlight);
                g.fillRect(w - 16 - 2, h - 16 - 2, 16, 16);
            }
        }

        public Dimension getMinimumSize() {
            TextArea target = (TextArea)FakeTextAreaPeer.this._target;
            return FakeTextAreaPeer.this.getMinimumSize(target.getColumns(), target.getRows());
        }
    }
}

