/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form.layoutdesign;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.netbeans.modules.form.layoutdesign.LayoutComponent;
import org.netbeans.modules.form.layoutdesign.LayoutConstants;
import org.netbeans.modules.form.layoutdesign.LayoutInterval;
import org.netbeans.modules.form.layoutdesign.LayoutModel;
import org.netbeans.modules.form.layoutdesign.LayoutRegion;
import org.netbeans.modules.form.layoutdesign.LayoutUtils;
import org.netbeans.modules.form.layoutdesign.VisualMapper;

class LayoutOperations
implements LayoutConstants {
    private LayoutModel layoutModel;
    private VisualMapper visualMapper;

    LayoutOperations(LayoutModel model, VisualMapper mapper) {
        this.layoutModel = model;
        this.visualMapper = mapper;
    }

    LayoutModel getModel() {
        return this.layoutModel;
    }

    VisualMapper getMapper() {
        return this.visualMapper;
    }

    int extract(LayoutInterval interval, int alignment, boolean closed, List restLeading, List restTrailing) {
        return this.extract(interval, interval, alignment, closed, restLeading, restTrailing);
    }

    int extract(LayoutInterval leading, LayoutInterval trailing, int alignment, boolean closed, List restLeading, List restTrailing) {
        int extractCount;
        LayoutInterval seq = leading.getParent();
        assert (seq.isSequential());
        int leadingIndex = seq.indexOf(leading);
        int trailingIndex = seq.indexOf(trailing);
        int count = seq.getSubIntervalCount();
        if (closed) {
            extractCount = trailingIndex - leadingIndex + 1;
        } else if (alignment != 0 && alignment != 1) {
            extractCount = 1;
        } else {
            int n = extractCount = alignment == 0 ? count - leadingIndex : leadingIndex + 1;
        }
        if (extractCount < seq.getSubIntervalCount()) {
            LinkedList<LayoutInterval> toRemainL = null;
            LinkedList<LayoutInterval> toRemainT = null;
            int startIndex = alignment == 0 ? leadingIndex : leadingIndex - extractCount + 1;
            int endIndex = alignment == 0 ? trailingIndex + extractCount - 1 : trailingIndex;
            Iterator it = seq.getSubIntervals();
            int idx = 0;
            while (it.hasNext()) {
                LayoutInterval li = (LayoutInterval)it.next();
                if (idx < startIndex) {
                    if (toRemainL == null) {
                        toRemainL = new LinkedList<LayoutInterval>();
                        toRemainL.add((LayoutInterval)((Object)new Integer(LayoutInterval.getEffectiveAlignment(li))));
                    }
                    toRemainL.add(li);
                } else if (idx > endIndex) {
                    if (toRemainT == null) {
                        toRemainT = new LinkedList<LayoutInterval>();
                        toRemainT.add((LayoutInterval)((Object)new Integer(LayoutInterval.getEffectiveAlignment(li))));
                    }
                    toRemainT.add(li);
                }
                ++idx;
            }
            if (toRemainL != null) {
                it = toRemainL.iterator();
                it.next();
                do {
                    this.layoutModel.removeInterval((LayoutInterval)it.next());
                } while (it.hasNext());
                restLeading.add(toRemainL);
            }
            if (toRemainT != null) {
                it = toRemainT.iterator();
                it.next();
                do {
                    this.layoutModel.removeInterval((LayoutInterval)it.next());
                } while (it.hasNext());
                restTrailing.add(toRemainT);
            }
        }
        return extractCount;
    }

    LayoutInterval addGroupContent(List list, LayoutInterval seq, int index, int dimension, int position) {
        assert (seq.isSequential() && (position == 0 || position == 1));
        boolean resizingFillGap = false;
        LayoutInterval commonGap = null;
        boolean onlyGaps = true;
        for (int i = list.size() - 1; i >= 0; --i) {
            List subList = (List)list.get(i);
            assert (subList.size() >= 2);
            if (subList.size() == 2) {
                LayoutInterval li = (LayoutInterval)subList.get(1);
                if (li.isEmptySpace()) {
                    if (commonGap == null || li.getPreferredSize() > commonGap.getPreferredSize()) {
                        commonGap = li;
                    }
                    if (LayoutInterval.canResize(li)) {
                        resizingFillGap = true;
                    }
                    list.remove(i);
                    continue;
                }
                onlyGaps = false;
                continue;
            }
            onlyGaps = false;
        }
        if (onlyGaps) {
            if (resizingFillGap && !LayoutInterval.canResize(commonGap)) {
                this.layoutModel.setIntervalSize(commonGap, -1, commonGap.getPreferredSize(), Short.MAX_VALUE);
            }
            this.insertGapIntoSequence(commonGap, seq, index, dimension);
            return null;
        }
        if (list.size() == 1) {
            List subList = (List)list.get(0);
            int n = subList.size();
            for (int i = n - 1; i > 0; --i) {
                LayoutInterval li = (LayoutInterval)subList.get(i);
                if (resizingFillGap && li.isEmptySpace() && !LayoutInterval.canResize(li) && (i == 1 && position == 1 || i == n - 1 && position == 0)) {
                    this.layoutModel.setIntervalSize(li, -1, li.getPreferredSize(), Short.MAX_VALUE);
                }
                if (i == 1 && li.isEmptySpace()) {
                    this.insertGapIntoSequence(li, seq, index, dimension);
                    continue;
                }
                this.layoutModel.addInterval(li, seq, index);
            }
            return null;
        }
        LayoutInterval group = new LayoutInterval(103);
        for (List subList : list) {
            LayoutInterval interval;
            int alignment;
            if (subList.size() == 2) {
                alignment = (Integer)subList.get(0);
                interval = (LayoutInterval)subList.get(1);
                if (alignment == 0 || alignment == 1) {
                    this.layoutModel.setIntervalAlignment(interval, alignment);
                }
            } else {
                interval = new LayoutInterval(102);
                alignment = (Integer)subList.get(0);
                if (alignment == 0 || alignment == 1) {
                    interval.setAlignment(alignment);
                }
                int n = subList.size();
                for (int i = 1; i < n; ++i) {
                    LayoutInterval li = (LayoutInterval)subList.get(i);
                    if (resizingFillGap && li.isEmptySpace() && !LayoutInterval.canResize(li) && (i == 1 && position == 1 || i == n - 1 && position == 0)) {
                        this.layoutModel.setIntervalSize(li, -1, li.getPreferredSize(), Short.MAX_VALUE);
                    }
                    this.layoutModel.addInterval(li, interval, -1);
                }
            }
            this.layoutModel.addInterval(interval, group, -1);
        }
        this.layoutModel.addInterval(group, seq, index);
        return group;
    }

    boolean addContent(LayoutInterval interval, LayoutInterval target, int index) {
        if (interval.isGroup() && interval.getSubIntervalCount() == 1) {
            return this.addContent(this.layoutModel.removeInterval(interval, 0), target, index);
        }
        if (interval.isSequential() && target.isSequential()) {
            if (index < 0) {
                index = target.getSubIntervalCount();
            }
            while (interval.getSubIntervalCount() > 0) {
                LayoutInterval li = this.layoutModel.removeInterval(interval, 0);
                this.layoutModel.addInterval(li, target, index++);
            }
            return true;
        }
        if (interval.isParallel() && target.isParallel()) {
            LayoutInterval li;
            int align = interval.getAlignment();
            if (align == -1) {
                align = target.getGroupAlignment();
            }
            boolean sameAlign = true;
            Iterator it = interval.getSubIntervals();
            while (it.hasNext()) {
                li = (LayoutInterval)it.next();
                if (LayoutInterval.wantResize(li)) {
                    sameAlign = true;
                    break;
                }
                if (li.getAlignment() == align) continue;
                sameAlign = false;
            }
            if (sameAlign && (LayoutInterval.canResize(interval) || !LayoutInterval.canResize(target) || !LayoutInterval.wantResize(target))) {
                assert (interval.getParent() == null);
                while (interval.getSubIntervalCount() > 0) {
                    li = interval.getSubInterval(0);
                    if (li.getRawAlignment() == -1 && interval.getGroupAlignment() != target.getGroupAlignment()) {
                        this.layoutModel.setIntervalAlignment(li, li.getAlignment());
                    }
                    this.layoutModel.removeInterval(li);
                    this.layoutModel.addInterval(li, target, index);
                    if (index < 0) continue;
                    ++index;
                }
                if (!LayoutInterval.canResize(interval) && LayoutInterval.canResize(target)) {
                    this.suppressGroupResizing(target);
                }
                return true;
            }
            this.layoutModel.addInterval(interval, target, index);
        } else {
            if (target.isSequential() && interval.getRawAlignment() != -1) {
                this.layoutModel.setIntervalAlignment(interval, -1);
            }
            this.layoutModel.addInterval(interval, target, index);
        }
        return false;
    }

    void resizeInterval(LayoutInterval interval, int size) {
        int min;
        assert (size >= 0 || size == -1);
        int n = min = interval.getMinimumSize() == interval.getPreferredSize() && interval.getMaximumSize() < Short.MAX_VALUE ? size : interval.getMinimumSize();
        int max = interval.getMaximumSize() == interval.getPreferredSize() ? (size == -1 ? -2 : size) : interval.getMaximumSize();
        this.layoutModel.setIntervalSize(interval, min, size, max);
    }

    void suppressGroupResizing(LayoutInterval group) {
        if (group.getParent() != null) {
            this.layoutModel.setIntervalSize(group, group.getMinimumSize(), group.getPreferredSize(), -2);
        }
    }

    void enableGroupResizing(LayoutInterval group) {
        this.layoutModel.setIntervalSize(group, group.getMinimumSize(), group.getPreferredSize(), -1);
    }

    void mergeParallelGroups(LayoutInterval group) {
        assert (group.isParallel());
        if (!group.isParallel()) {
            return;
        }
        for (int i = group.getSubIntervalCount() - 1; i >= 0; --i) {
            LayoutInterval sub = group.getSubInterval(i);
            if (!sub.isParallel()) continue;
            this.mergeParallelGroups(sub);
            this.dissolveRedundantGroup(sub);
        }
    }

    boolean dissolveRedundantGroup(LayoutInterval group) {
        LayoutInterval parent = group.getParent();
        if (parent == null) {
            return false;
        }
        boolean dissolve = false;
        if (group.getSubIntervalCount() == 1) {
            dissolve = true;
        } else if (group.isSequential() && parent.isSequential()) {
            dissolve = true;
        } else if (group.isParallel() && parent.isParallel()) {
            boolean compatible;
            int align = group.getAlignment();
            boolean sameAlign = true;
            boolean subResizing = false;
            Iterator it = group.getSubIntervals();
            while (it.hasNext()) {
                LayoutInterval li = (LayoutInterval)it.next();
                if (!subResizing && LayoutInterval.wantResize(li)) {
                    subResizing = true;
                }
                if (li.getAlignment() == align || group.getSubIntervalCount() <= 1) continue;
                sameAlign = false;
            }
            if (subResizing && (sameAlign || group.getGroupAlignment() != 3)) {
                compatible = false;
                if (LayoutInterval.canResize(group) || !LayoutInterval.canResize(parent)) {
                    LayoutInterval neighbor;
                    it = parent.getSubIntervals();
                    while (it.hasNext()) {
                        LayoutInterval li = (LayoutInterval)it.next();
                        if (li == group || !LayoutInterval.wantResize(li)) continue;
                        compatible = true;
                        break;
                    }
                    if (!compatible && (neighbor = LayoutInterval.getNeighbor(parent, group.getAlignment() ^ 1, false, true, true)) != null && neighbor.isEmptySpace() && neighbor.getPreferredSize() == -1) {
                        compatible = true;
                    }
                }
            } else {
                compatible = sameAlign;
            }
            dissolve = compatible;
        }
        if (dissolve) {
            int index = this.layoutModel.removeInterval(group);
            while (group.getSubIntervalCount() > 0) {
                LayoutInterval li = group.getSubInterval(0);
                if (parent.isParallel()) {
                    if (group.isParallel()) {
                        if (li.getRawAlignment() == -1 && group.getGroupAlignment() != parent.getGroupAlignment()) {
                            this.layoutModel.setIntervalAlignment(li, li.getAlignment());
                        }
                    } else {
                        this.layoutModel.setIntervalAlignment(li, group.getRawAlignment());
                    }
                } else if (li.getRawAlignment() != -1) {
                    this.layoutModel.setIntervalAlignment(li, -1);
                }
                this.layoutModel.removeInterval(li);
                this.layoutModel.addInterval(li, parent, index++);
            }
            return true;
        }
        return false;
    }

    void moveInsideSequential(LayoutInterval parent, int dimension) {
        block18: {
            LayoutInterval outGroup;
            assert (parent.isSequential());
            if (!parent.isSequential()) {
                return;
            }
            int alignment = 0;
            block0: do {
                int addIdx;
                int idx;
                LayoutInterval inGroup;
                LayoutInterval extend;
                if ((extend = this.findIntervalToExtend(parent, dimension, alignment)) == null) {
                    if (alignment == 0) {
                        alignment = 1;
                        extend = this.findIntervalToExtend(parent, dimension, alignment);
                    }
                    if (extend == null) break block18;
                }
                outGroup = inGroup = extend.getParent();
                while (outGroup.getParent() != parent) {
                    outGroup = outGroup.getParent();
                }
                int index = parent.indexOf(outGroup);
                int d = alignment == 0 ? -1 : 1;
                boolean commonEndingGap = true;
                int n = parent.getSubIntervalCount();
                for (int i = index - d; i >= 0 && i < n; i -= d) {
                    LayoutInterval par;
                    LayoutInterval li = parent.getSubInterval(i);
                    if (li.isEmptySpace() && (i - d < 0 || i - d >= n) || !LayoutInterval.wantResize(li)) continue;
                    LayoutInterval endGap = parent.getSubInterval(alignment == 0 ? n - 1 : 0);
                    if (endGap != null && endGap.getPreferredSize() == -1) break;
                    commonEndingGap = false;
                    LayoutInterval closing = extend;
                    int borderPos = parent.getCurrentSpace().positions[dimension][alignment ^ 1];
                    do {
                        if (!(par = closing.getParent()).isParallel()) continue;
                        this.separateGroupContent(closing, borderPos, dimension, alignment ^ 1);
                    } while ((closing = par) != outGroup);
                    break;
                }
                int extendPos = extend.getCurrentSpace().positions[dimension][alignment ^ 1];
                if (!extend.isSequential()) {
                    LayoutInterval seq = new LayoutInterval(102);
                    seq.setAlignment(extend.getAlignment());
                    this.layoutModel.addInterval(seq, inGroup, this.layoutModel.removeInterval(extend));
                    this.layoutModel.setIntervalAlignment(extend, -1);
                    this.layoutModel.addInterval(extend, seq, 0);
                    extend = seq;
                }
                LayoutInterval connectingGap = null;
                if (alignment == 0) {
                    idx = index + 1;
                    addIdx = extend.getSubIntervalCount();
                } else {
                    idx = index - 1;
                    addIdx = 0;
                }
                while (idx >= 0 && idx < parent.getSubIntervalCount()) {
                    LayoutInterval li = parent.getSubInterval(idx);
                    if (li.isEmptySpace()) {
                        if (connectingGap == null) {
                            int neighborPos;
                            int distance;
                            if (extendPos != outGroup.getCurrentSpace().positions[dimension][alignment ^ 1] && (distance = d * (extendPos - (neighborPos = parent.getSubInterval((int)(idx - d)).getCurrentSpace().positions[dimension][alignment]))) > 0) {
                                this.resizeInterval(li, distance);
                            }
                            connectingGap = li;
                        } else if ((idx == 0 || idx == parent.getSubIntervalCount() - 1) && commonEndingGap) continue block0;
                    }
                    this.layoutModel.removeInterval(li);
                    this.layoutModel.addInterval(li, extend, addIdx);
                    if (alignment == 0) {
                        ++addIdx;
                        continue;
                    }
                    --idx;
                }
            } while (parent.getSubIntervalCount() != 1);
            assert (outGroup == parent.getSubInterval(0));
            this.layoutModel.removeInterval(outGroup);
            LayoutInterval superParent = parent.getParent();
            this.addContent(outGroup, superParent, this.layoutModel.removeInterval(parent));
        }
    }

    private LayoutInterval findIntervalToExtend(LayoutInterval parent, int dimension, int alignment) {
        int d = alignment == 0 ? -1 : 1;
        int count = parent.getSubIntervalCount();
        boolean atBorder = true;
        boolean gap = false;
        for (int idx = alignment == 0 ? count - 1 : 0; idx >= 0 && idx < parent.getSubIntervalCount(); idx += d) {
            LayoutInterval sub = parent.getSubInterval(idx);
            if (sub.isEmptySpace()) {
                gap = true;
                continue;
            }
            if (!atBorder && gap && sub.isParallel() && !LayoutInterval.isClosedGroup(sub, alignment ^ 1)) {
                int endIndex;
                int startIndex;
                if (alignment == 0) {
                    startIndex = idx + 1;
                    endIndex = parent.getSubIntervalCount() - 1;
                } else {
                    startIndex = 0;
                    endIndex = idx - 1;
                }
                LayoutInterval extend = this.prepareGroupExtension(sub, parent, startIndex, endIndex, dimension, alignment ^ 1);
                if (extend != null) {
                    return extend;
                }
            }
            gap = false;
            atBorder = false;
        }
        return null;
    }

    private LayoutInterval prepareGroupExtension(LayoutInterval group, LayoutInterval parent, int startIndex, int endIndex, int dimension, int alignment) {
        boolean allOverlapping = true;
        LayoutInterval singleOverlap = null;
        LinkedList<LayoutInterval> overlapList = null;
        Iterator it = group.getSubIntervals();
        while (it.hasNext()) {
            LayoutInterval li = (LayoutInterval)it.next();
            if (li.isEmptySpace()) continue;
            if (LayoutUtils.contentOverlap(li, parent, startIndex, endIndex, dimension ^ 1)) {
                if (singleOverlap == null) {
                    singleOverlap = li;
                    continue;
                }
                if (overlapList == null) {
                    overlapList = new LinkedList<LayoutInterval>();
                    overlapList.add(singleOverlap);
                }
                overlapList.add(li);
                continue;
            }
            allOverlapping = false;
        }
        if (allOverlapping || singleOverlap == null) {
            return null;
        }
        if (overlapList != null) {
            LayoutInterval subGroup = new LayoutInterval(103);
            subGroup.setGroupAlignment(alignment ^ 1);
            subGroup.setAlignment(alignment ^ 1);
            int index = -1;
            do {
                LayoutInterval li = (LayoutInterval)overlapList.remove(0);
                int idx = this.layoutModel.removeInterval(li);
                if (index < 0) {
                    index = idx;
                }
                this.layoutModel.addInterval(li, subGroup, -1);
                subGroup.getCurrentSpace().expand(li.getCurrentSpace());
            } while (overlapList.size() > 0);
            this.layoutModel.addInterval(subGroup, group, index);
            singleOverlap = subGroup;
        } else {
            LayoutInterval subOverlap;
            LayoutInterval subParallel;
            if (singleOverlap.isSequential()) {
                subParallel = singleOverlap.getSubInterval(alignment == 0 ? 0 : singleOverlap.getSubIntervalCount() - 1);
                if (!subParallel.isParallel()) {
                    subParallel = null;
                }
            } else {
                subParallel = singleOverlap.isParallel() ? singleOverlap : null;
            }
            if (subParallel != null && !LayoutInterval.isClosedGroup(subParallel, alignment) && (subOverlap = this.prepareGroupExtension(subParallel, parent, startIndex, endIndex, dimension, alignment)) != null) {
                singleOverlap = subOverlap;
            }
        }
        return singleOverlap;
    }

    private void separateGroupContent(LayoutInterval separate, int outPos, int dimension, int alignment) {
        LayoutInterval remainderGap;
        LayoutInterval group = separate.getParent();
        assert (group.isParallel());
        LayoutInterval remainder = null;
        LayoutInterval remainderGroup = null;
        LayoutRegion remainderSpace = null;
        int i = 0;
        while (i < group.getSubIntervalCount()) {
            LayoutInterval li = group.getSubInterval(i);
            if (li != separate) {
                assert (li.getAlignment() == (alignment ^ 1));
                this.layoutModel.removeInterval(li);
                if (remainder == null) {
                    remainder = li;
                } else {
                    if (remainderGroup == null) {
                        remainderGroup = new LayoutInterval(103);
                        remainderGroup.setAlignment(alignment ^ 1);
                        remainderGroup.setGroupAlignment(alignment ^ 1);
                        this.layoutModel.addInterval(remainder, remainderGroup, 0);
                        remainder = remainderGroup;
                    }
                    this.layoutModel.addInterval(li, remainderGroup, -1);
                }
                if (li.isEmptySpace()) continue;
                if (remainderSpace == null) {
                    remainderSpace = new LayoutRegion();
                }
                remainderSpace.expand(li.getCurrentSpace());
                continue;
            }
            ++i;
        }
        remainder.setCurrentSpace(remainderSpace);
        int remainderPos = remainderSpace.positions[dimension][alignment];
        if (LayoutRegion.isValidCoordinate(outPos)) {
            int gapSize = alignment == 0 ? remainderPos - outPos : outPos - remainderPos;
            remainderGap = new LayoutInterval(101);
            remainderGap.setSizes(-1, gapSize, Short.MAX_VALUE);
        } else {
            remainderGap = LayoutInterval.getDirectNeighbor(group, alignment, false);
            if (remainderGap != null && remainderGap.isEmptySpace()) {
                this.layoutModel.removeInterval(remainderGap);
                LayoutInterval neighbor = LayoutInterval.getDirectNeighbor(group, alignment, true);
                outPos = neighbor != null ? neighbor.getCurrentSpace().positions[dimension][alignment ^ 1] : group.getParent().getCurrentSpace().positions[dimension][alignment];
                int gapSize = alignment == 0 ? remainderPos - outPos : outPos - remainderPos;
                this.resizeInterval(remainderGap, gapSize);
            } else {
                remainderGap = null;
            }
        }
        if (remainderGap != null) {
            LayoutInterval seq;
            if (remainder.isSequential()) {
                seq = remainder;
            } else {
                seq = new LayoutInterval(102);
                this.layoutModel.setIntervalAlignment(remainder, -1);
                this.layoutModel.addInterval(remainder, seq, 0);
            }
            this.layoutModel.addInterval(remainderGap, seq, alignment == 0 ? 0 : -1);
            this.layoutModel.addInterval(seq, group, -1);
            group.getCurrentSpace().positions[dimension][alignment] = outPos;
        } else {
            this.layoutModel.addInterval(remainder, group, -1);
        }
    }

    void parallelizeWithParentSequence(LayoutInterval interval, int endIndex, int dimension) {
        LayoutInterval parent = interval.getParent();
        assert (parent.isParallel());
        LayoutInterval parParent = parent;
        while (!parParent.getParent().isSequential()) {
            parParent = parParent.getParent();
        }
        LayoutInterval parentSeq = parParent.getParent();
        int startIndex = parentSeq.indexOf(parParent);
        if (endIndex < 0) {
            endIndex = parentSeq.getSubIntervalCount() - 1;
        } else if (startIndex > endIndex) {
            int temp = startIndex;
            startIndex = endIndex;
            endIndex = temp;
        }
        this.layoutModel.removeInterval(interval);
        if (interval.getAlignment() == -1) {
            this.layoutModel.setIntervalAlignment(interval, parent.getGroupAlignment());
        }
        this.addParallelWithSequence(interval, parentSeq, startIndex, endIndex, dimension);
        if (parent.getSubIntervalCount() == 1) {
            this.addContent(this.layoutModel.removeInterval(parent, 0), parent.getParent(), this.layoutModel.removeInterval(parent));
        } else if (parent.getSubIntervalCount() == 0) {
            this.layoutModel.removeInterval(parent);
        }
    }

    void addParallelWithSequence(LayoutInterval interval, LayoutInterval seq, int startIndex, int endIndex, int dimension) {
        LayoutInterval group;
        if (startIndex > 0 || endIndex < seq.getSubIntervalCount() - 1) {
            group = new LayoutInterval(103);
            if (interval.getAlignment() != -1) {
                group.setGroupAlignment(interval.getAlignment());
            }
            int startPos = LayoutUtils.getVisualPosition(seq.getSubInterval(startIndex), dimension, 0);
            int endPos = LayoutUtils.getVisualPosition(seq.getSubInterval(endIndex), dimension, 1);
            group.getCurrentSpace().set(dimension, startPos, endPos);
            if (startIndex != endIndex) {
                LayoutInterval subSeq = new LayoutInterval(102);
                subSeq.setAlignment(seq.getAlignment());
                for (int n = endIndex - startIndex + 1; n > 0; --n) {
                    this.layoutModel.addInterval(this.layoutModel.removeInterval(seq, startIndex), subSeq, -1);
                }
                this.layoutModel.addInterval(subSeq, group, 0);
            } else {
                this.layoutModel.addInterval(this.layoutModel.removeInterval(seq, startIndex), group, 0);
            }
            this.layoutModel.addInterval(group, seq, startIndex);
        } else {
            group = seq.getParent();
        }
        this.layoutModel.addInterval(interval, group, -1);
    }

    int optimizeGaps(LayoutInterval group, int dimension) {
        boolean anyAlignedLeading = false;
        boolean anyAlignedTrailing = false;
        boolean anyAlignedBoth = false;
        boolean anyGapLeading = false;
        boolean anyGapTrailing = false;
        boolean sameMinGapLeading = true;
        boolean sameMinGapTrailing = true;
        int commonGapLeadingSize = Integer.MIN_VALUE;
        int commonGapTrailingSize = Integer.MIN_VALUE;
        for (int i = 0; i < group.getSubIntervalCount(); ++i) {
            int size;
            LayoutInterval li = group.getSubInterval(i);
            if (li.isEmptySpace() && group.getSubIntervalCount() > 1) {
                this.layoutModel.removeInterval(group, i);
                --i;
                continue;
            }
            boolean leadingAlign = false;
            boolean trailingAlign = false;
            LayoutInterval leadingGap = null;
            LayoutInterval trailingGap = null;
            boolean contentResizing = false;
            boolean noResizing = false;
            if (li.isSequential()) {
                boolean leadGapRes = false;
                boolean trailGapRes = false;
                for (int j = 0; j < li.getSubIntervalCount(); ++j) {
                    LayoutInterval sub = li.getSubInterval(j);
                    if (j == 0 && sub.isEmptySpace()) {
                        leadingGap = sub;
                        leadGapRes = LayoutInterval.wantResize(sub);
                        continue;
                    }
                    if (j + 1 == li.getSubIntervalCount() && sub.isEmptySpace()) {
                        trailingGap = sub;
                        trailGapRes = LayoutInterval.wantResize(sub);
                        continue;
                    }
                    if (contentResizing || !LayoutInterval.wantResize(sub)) continue;
                    contentResizing = true;
                }
                if (!contentResizing) {
                    if (leadGapRes || trailGapRes) {
                        leadingAlign = trailGapRes && !leadGapRes;
                        trailingAlign = leadGapRes && !trailGapRes;
                    } else {
                        noResizing = true;
                    }
                }
            } else if (LayoutInterval.wantResize(li)) {
                contentResizing = true;
            } else {
                noResizing = true;
            }
            if (contentResizing) {
                trailingAlign = true;
                leadingAlign = true;
            } else if (noResizing) {
                int alignment = li.getAlignment();
                leadingAlign = alignment == 0;
                boolean bl = trailingAlign = alignment == 1;
            }
            if (leadingAlign) {
                anyAlignedLeading = true;
                if (trailingAlign) {
                    anyAlignedBoth = true;
                }
            }
            if (trailingAlign) {
                anyAlignedTrailing = true;
            }
            if (leadingGap != null) {
                anyGapLeading = true;
                if (sameMinGapLeading) {
                    int n = size = leadingAlign || leadingGap.getMinimumSize() == -2 ? leadingGap.getPreferredSize() : leadingGap.getMinimumSize();
                    if (commonGapLeadingSize != Integer.MIN_VALUE) {
                        if (size != commonGapLeadingSize) {
                            sameMinGapLeading = false;
                        }
                    } else {
                        commonGapLeadingSize = size;
                    }
                }
            } else {
                sameMinGapLeading = false;
            }
            if (trailingGap != null) {
                anyGapTrailing = true;
                if (!sameMinGapTrailing) continue;
                int n = size = trailingAlign || trailingGap.getMinimumSize() == -2 ? trailingGap.getPreferredSize() : trailingGap.getMinimumSize();
                if (commonGapTrailingSize != Integer.MIN_VALUE) {
                    if (size == commonGapTrailingSize) continue;
                    sameMinGapTrailing = false;
                    continue;
                }
                commonGapTrailingSize = size;
                continue;
            }
            sameMinGapTrailing = false;
        }
        if (group.getSubIntervalCount() <= 1 || !anyGapLeading && !anyGapTrailing) {
            return -1;
        }
        if (!anyAlignedBoth) {
            if (anyAlignedTrailing) {
                sameMinGapLeading = false;
            }
            if (anyAlignedLeading) {
                sameMinGapTrailing = false;
            }
        }
        int[] groupOuterPos = group.getCurrentSpace().positions[dimension];
        assert (groupOuterPos[0] > Short.MIN_VALUE && groupOuterPos[1] > Short.MIN_VALUE);
        int groupInnerPosLeading = LayoutUtils.getOutermostComponent((LayoutInterval)group, (int)dimension, (int)0).getCurrentSpace().positions[dimension][0];
        int groupInnerPosTrailing = LayoutUtils.getOutermostComponent((LayoutInterval)group, (int)dimension, (int)1).getCurrentSpace().positions[dimension][1];
        boolean defaultPaddingLeading = false;
        boolean defaultPaddingTrailing = false;
        boolean resizingGapLeading = false;
        boolean resizingGapTrailing = false;
        for (int i = 0; i < group.getSubIntervalCount(); ++i) {
            LayoutInterval gap;
            LayoutInterval li = group.getSubInterval(i);
            if (!li.isSequential()) continue;
            if (anyGapLeading && (!anyAlignedLeading || sameMinGapLeading) && (gap = li.getSubInterval(0)).isEmptySpace()) {
                if (gap.getPreferredSize() == -1 && this.isEndingDefaultGapEffective(li, dimension, 0)) {
                    defaultPaddingLeading = true;
                }
                if (gap.getMaximumSize() >= Short.MAX_VALUE) {
                    if (li.getAlignment() == 0) {
                        this.layoutModel.setIntervalAlignment(li, 1);
                    }
                    if (!anyAlignedLeading) {
                        resizingGapLeading = true;
                    }
                }
                this.layoutModel.removeInterval(gap);
            }
            if (anyGapTrailing && (!anyAlignedTrailing || sameMinGapTrailing) && (gap = li.getSubInterval(li.getSubIntervalCount() - 1)).isEmptySpace()) {
                if (gap.getPreferredSize() == -1 && this.isEndingDefaultGapEffective(li, dimension, 1)) {
                    defaultPaddingTrailing = true;
                }
                if (gap.getMaximumSize() >= Short.MAX_VALUE) {
                    if (li.getAlignment() == 1) {
                        this.layoutModel.setIntervalAlignment(li, 0);
                    }
                    if (!anyAlignedTrailing) {
                        resizingGapTrailing = true;
                    }
                }
                this.layoutModel.removeInterval(gap);
            }
            if (li.getSubIntervalCount() != 1) continue;
            this.layoutModel.removeInterval(group, i);
            LayoutInterval sub = this.layoutModel.removeInterval(li, 0);
            this.layoutModel.setIntervalAlignment(sub, li.getRawAlignment());
            this.layoutModel.addInterval(sub, group, i);
        }
        LayoutInterval leadingGap = null;
        LayoutInterval trailingGap = null;
        if (anyGapLeading) {
            if (!anyAlignedLeading) {
                int size = groupInnerPosLeading - groupOuterPos[0];
                if (size > 0 || defaultPaddingLeading) {
                    leadingGap = new LayoutInterval(101);
                    if (!defaultPaddingLeading) {
                        leadingGap.setPreferredSize(size);
                        if (!resizingGapLeading) {
                            leadingGap.setMinimumSize(-2);
                        }
                    }
                    if (resizingGapLeading) {
                        leadingGap.setMaximumSize(Short.MAX_VALUE);
                    }
                }
            } else if (sameMinGapLeading) {
                leadingGap = new LayoutInterval(101);
                leadingGap.setSizes(commonGapLeadingSize, commonGapLeadingSize, -2);
            }
        }
        if (anyGapTrailing) {
            if (!anyAlignedTrailing) {
                int size = groupOuterPos[1] - groupInnerPosTrailing;
                if (size > 0 || defaultPaddingTrailing) {
                    trailingGap = new LayoutInterval(101);
                    if (!defaultPaddingTrailing) {
                        trailingGap.setPreferredSize(size);
                        if (!resizingGapTrailing) {
                            trailingGap.setMinimumSize(-2);
                        }
                    }
                    if (resizingGapTrailing) {
                        trailingGap.setMaximumSize(Short.MAX_VALUE);
                    }
                }
            } else if (sameMinGapTrailing) {
                trailingGap = new LayoutInterval(101);
                trailingGap.setSizes(commonGapTrailingSize, commonGapTrailingSize, -2);
            }
        }
        if (leadingGap != null || trailingGap != null) {
            LayoutInterval parent;
            if (leadingGap != null || !LayoutRegion.isValidCoordinate(groupOuterPos[0])) {
                groupOuterPos[0] = groupInnerPosLeading;
            }
            if (trailingGap != null || !LayoutRegion.isValidCoordinate(groupOuterPos[1])) {
                groupOuterPos[1] = groupInnerPosTrailing;
            }
            groupOuterPos[2] = (groupInnerPosLeading + groupInnerPosTrailing) / 2;
            if (leadingGap != null) {
                group = this.insertGap(leadingGap, group, groupInnerPosLeading, dimension, 0);
            }
            if (trailingGap != null) {
                group = this.insertGap(trailingGap, group, groupInnerPosTrailing, dimension, 1);
            }
            return (parent = group.getParent()) != null ? parent.indexOf(group) : -1;
        }
        return -1;
    }

    private boolean isEndingDefaultGapEffective(LayoutInterval seq, int dimension, int alignment) {
        assert (seq.isSequential() && (alignment == 0 || alignment == 1));
        int idx = alignment == 0 ? 0 : seq.getSubIntervalCount() - 1;
        int d = alignment == 0 ? 1 : -1;
        LayoutInterval gap = seq.getSubInterval(idx);
        LayoutInterval neighbor = seq.getSubInterval(idx + d);
        if (LayoutInterval.getEffectiveAlignment(neighbor, alignment) == alignment) {
            return true;
        }
        int prefDistance = LayoutUtils.getSizeOfDefaultGap(gap, this.visualMapper);
        int pos1 = neighbor.getCurrentSpace().positions[dimension][alignment];
        LayoutInterval outerNeighbor = LayoutInterval.getNeighbor(gap, alignment, true, true, false);
        int pos2 = outerNeighbor != null ? outerNeighbor.getCurrentSpace().positions[dimension][alignment ^ 1] : LayoutInterval.getRoot((LayoutInterval)seq).getCurrentSpace().positions[dimension][alignment];
        int currentDistance = (pos1 - pos2) * d;
        return currentDistance <= prefDistance;
    }

    boolean cutStartingGap(LayoutInterval group, int size, int dimension, int alignment) {
        LayoutInterval li;
        assert (group.isGroup() && size > 0 && (alignment == 0 || alignment == 1));
        LayoutInterval seq = null;
        if (group.isSequential()) {
            seq = group;
        } else if (group.getSubIntervalCount() == 1 && (li = group.getSubInterval(0)).isSequential() && LayoutInterval.isAlignedAtBorder(li, alignment)) {
            seq = li;
        }
        if (seq != null && seq.getSubIntervalCount() > 1) {
            LayoutInterval gap = seq.getSubInterval(alignment == 0 ? 0 : seq.getSubIntervalCount() - 1);
            LayoutInterval neighbor = LayoutInterval.getDirectNeighbor(gap, alignment ^ 1, true);
            if (gap != null && gap.isEmptySpace() && neighbor != null) {
                int currentSize = gap.getPreferredSize();
                if (currentSize == -1) {
                    currentSize = LayoutRegion.distance(group.getCurrentSpace(), neighbor.getCurrentSpace(), dimension, alignment, alignment) * (alignment == 1 ? -1 : 1);
                }
                if (currentSize >= size) {
                    if (currentSize > size) {
                        this.resizeInterval(gap, currentSize - size);
                    } else {
                        this.layoutModel.removeInterval(gap);
                    }
                    return true;
                }
            }
        }
        return false;
    }

    LayoutInterval insertGap(LayoutInterval gap, LayoutInterval interval, int pos, int dimension, int alignment) {
        LayoutInterval seq;
        assert (alignment == 0 || alignment == 1);
        assert (!interval.isSequential());
        assert (gap.isEmptySpace());
        LayoutInterval parent = interval.getParent();
        if (parent == null) {
            assert (interval.isParallel());
            parent = interval;
            if (parent.getSubIntervalCount() > 1) {
                seq = new LayoutInterval(102);
                seq.getCurrentSpace().set(dimension, alignment == 0 ? pos : interval.getCurrentSpace().positions[dimension][0], alignment == 0 ? interval.getCurrentSpace().positions[dimension][1] : pos);
                this.layoutModel.addInterval(seq, parent, -1);
                interval = new LayoutInterval(103);
                interval.getCurrentSpace().set(dimension, parent.getCurrentSpace());
                this.layoutModel.addInterval(interval, seq, 0);
                while (parent.getSubIntervalCount() > 1) {
                    this.layoutModel.addInterval(this.layoutModel.removeInterval(parent, 0), interval, -1);
                }
                parent = seq;
            } else {
                interval = parent.getSubInterval(0);
                if (interval.isSequential()) {
                    parent = interval;
                    int subIdx = alignment == 0 ? 0 : parent.getSubIntervalCount() - 1;
                    if ((interval = parent.getSubInterval(subIdx)).isEmptySpace()) {
                        LayoutInterval neighbor = (subIdx += alignment == 0 ? 1 : -1) >= 0 && subIdx < parent.getSubIntervalCount() ? parent.getSubInterval(subIdx) : null;
                        int[] outerSpace = parent.getParent().getCurrentSpace().positions[dimension];
                        int otherPos = neighbor != null ? neighbor.getCurrentSpace().positions[dimension][alignment] : outerSpace[alignment ^ 1];
                        int mergedSize = (outerSpace[alignment] - otherPos) * (alignment == 0 ? -1 : 1);
                        this.eatGap(interval, gap, mergedSize);
                        return neighbor != null ? neighbor : interval;
                    }
                } else {
                    seq = new LayoutInterval(102);
                    seq.getCurrentSpace().set(dimension, alignment == 0 ? pos : interval.getCurrentSpace().positions[dimension][0], alignment == 0 ? interval.getCurrentSpace().positions[dimension][1] : pos);
                    this.layoutModel.addInterval(seq, parent, -1);
                    this.layoutModel.removeInterval(interval);
                    this.layoutModel.addInterval(interval, seq, -1);
                    parent = seq;
                }
            }
        }
        if (parent.isSequential()) {
            LayoutInterval neighbor = LayoutInterval.getDirectNeighbor(interval, alignment, false);
            if (neighbor != null && neighbor.isEmptySpace()) {
                LayoutInterval next = LayoutInterval.getDirectNeighbor(neighbor, alignment, false);
                int otherPos = next != null ? next.getCurrentSpace().positions[dimension][alignment ^ 1] : parent.getCurrentSpace().positions[dimension][alignment];
                int mergedSize = (pos - otherPos) * (alignment == 0 ? 1 : -1);
                this.eatGap(neighbor, gap, mergedSize);
            } else {
                int idx = parent.indexOf(interval) + (alignment == 0 ? 0 : 1);
                this.layoutModel.addInterval(gap, parent, idx);
            }
        } else {
            seq = new LayoutInterval(102);
            int idx = this.layoutModel.removeInterval(interval);
            seq.setAlignment(interval.getAlignment());
            seq.getCurrentSpace().set(dimension, alignment == 0 ? pos : interval.getCurrentSpace().positions[dimension][0], alignment == 0 ? interval.getCurrentSpace().positions[dimension][1] : pos);
            this.layoutModel.addInterval(seq, parent, idx);
            this.layoutModel.setIntervalAlignment(interval, -1);
            this.layoutModel.addInterval(interval, seq, 0);
            this.layoutModel.addInterval(gap, seq, alignment == 0 ? 0 : 1);
        }
        return interval;
    }

    int insertGapIntoSequence(LayoutInterval gap, LayoutInterval seq, int index, int dimension) {
        assert (gap.isEmptySpace());
        LayoutInterval otherGap = null;
        int alignment = -1;
        if (index >= 0 && index < seq.getSubIntervalCount() && (otherGap = seq.getSubInterval(index)).isEmptySpace()) {
            alignment = 1;
        }
        if (alignment == -1 && index > 0 && (otherGap = seq.getSubInterval(index - 1)).isEmptySpace()) {
            alignment = 0;
        }
        if (alignment == -1) {
            this.layoutModel.addInterval(gap, seq, index);
            return index;
        }
        LayoutInterval neighbor = LayoutInterval.getDirectNeighbor(otherGap, alignment, true);
        int pos1 = neighbor != null ? neighbor.getCurrentSpace().positions[dimension][alignment ^ 1] : seq.getCurrentSpace().positions[dimension][alignment];
        neighbor = LayoutInterval.getDirectNeighbor(otherGap, alignment ^ 1, true);
        int pos2 = neighbor != null ? neighbor.getCurrentSpace().positions[dimension][alignment] : seq.getCurrentSpace().positions[dimension][alignment ^ 1];
        this.eatGap(otherGap, gap, Math.abs(pos2 - pos1));
        return alignment == 0 ? index - 1 : index;
    }

    void eatGap(LayoutInterval main, LayoutInterval eaten, int currentMergedSize) {
        int min2;
        int min1 = main.getMinimumSize();
        if (min1 == -2) {
            min1 = main.getPreferredSize();
        }
        if ((min2 = eaten.getMinimumSize()) == -2) {
            min2 = eaten.getPreferredSize();
        }
        int min = min1 == 0 ? min2 : (min2 == 0 ? min1 : (!LayoutInterval.canResize(main) && !LayoutInterval.canResize(eaten) ? -2 : (min1 == -1 || min2 == -1 ? -1 : min1 + min2)));
        int pref1 = main.getPreferredSize();
        int pref2 = eaten.getPreferredSize();
        int pref = pref1 == 0 ? pref2 : (pref2 == 0 ? pref1 : (pref1 == -1 || pref2 == -1 ? currentMergedSize : pref1 + pref2));
        int max = main.getMaximumSize() >= Short.MAX_VALUE || eaten.getMaximumSize() >= Short.MAX_VALUE ? Short.MAX_VALUE : -2;
        this.layoutModel.setIntervalSize(main, min, pref, max);
        if (eaten.getParent() != null) {
            this.layoutModel.removeInterval(eaten);
        }
    }

    void mergeAdjacentGaps(Set updatedContainers) {
        Iterator it = this.layoutModel.getAllComponents();
        while (it.hasNext()) {
            LayoutComponent comp = (LayoutComponent)it.next();
            if (!comp.isLayoutContainer()) continue;
            boolean updated = false;
            for (LayoutInterval[] roots : comp.getLayoutRoots()) {
                for (int dim = 0; dim < 2; ++dim) {
                    updated = this.mergeAdjacentGaps(roots[dim], dim) || updated;
                }
            }
            if (!updated) continue;
            updatedContainers.add(comp);
        }
    }

    boolean mergeAdjacentGaps(LayoutInterval root, int dimension) {
        assert (root.isGroup());
        boolean updated = false;
        if (root.isSequential()) {
            for (int i = 0; i < root.getSubIntervalCount(); ++i) {
                LayoutInterval nextNext;
                LayoutInterval next;
                LayoutInterval interval = root.getSubInterval(i);
                if (!interval.isEmptySpace() || i + 1 >= root.getSubIntervalCount() || !(next = root.getSubInterval(i + 1)).isEmptySpace()) continue;
                if (i + 2 < root.getSubIntervalCount() && (nextNext = root.getSubInterval(i + 2)).isEmptySpace()) {
                    --i;
                }
                updated = true;
                this.eatGap(interval, next, -1);
            }
        }
        Iterator iter = root.getSubIntervals();
        while (iter.hasNext()) {
            LayoutInterval subInterval = (LayoutInterval)iter.next();
            if (!subInterval.isGroup()) continue;
            updated = updated || this.mergeAdjacentGaps(subInterval, dimension);
        }
        return updated;
    }

    void suppressResizingOfSurroundingGaps(LayoutInterval interval) {
        LayoutInterval parent = interval.getParent();
        while (parent != null) {
            if (parent.isSequential()) {
                Iterator it = parent.getSubIntervals();
                while (it.hasNext()) {
                    LayoutInterval sub = (LayoutInterval)it.next();
                    if (sub == interval || !sub.isEmptySpace() || !LayoutInterval.canResize(sub)) continue;
                    int pref = sub.getPreferredSize();
                    int min = sub.getMinimumSize() != pref ? -2 : pref;
                    int max = -2;
                    this.layoutModel.setIntervalSize(sub, min, pref, max);
                }
            } else if (!LayoutInterval.canResize(parent)) break;
            interval = parent;
            parent = interval.getParent();
        }
    }
}

