/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form.layoutdesign.support;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.modules.form.layoutdesign.LayoutComponent;
import org.netbeans.modules.form.layoutdesign.LayoutConstants;
import org.netbeans.modules.form.layoutdesign.LayoutInterval;
import org.netbeans.modules.form.layoutdesign.LayoutModel;
import org.netbeans.modules.form.layoutdesign.support.SwingLayoutUtils;

public class SwingLayoutBuilder {
    public static final int PADDING_SEPARATE_VALUE = 18;
    private LayoutModel layoutModel;
    private Container container;
    private LayoutComponent containerLC;
    private Map componentIDMap = new HashMap();
    private boolean designMode;

    public SwingLayoutBuilder(LayoutModel layoutModel, Container container, String containerId, boolean designMode) {
        this.layoutModel = layoutModel;
        this.container = container;
        this.containerLC = layoutModel.getLayoutComponent(containerId);
        this.designMode = designMode;
    }

    public void setupContainerLayout(Component[] components, String[] compIds) {
        for (int counter = 0; counter < components.length; ++counter) {
            this.componentIDMap.put(compIds[counter], components[counter]);
        }
        this.createLayout();
    }

    public void removeComponentsFromContainer(Component[] components, String[] compIds) {
        if (components.length != compIds.length) {
            throw new IllegalArgumentException("Sizes must match");
        }
        for (int counter = 0; counter < components.length; ++counter) {
            this.componentIDMap.remove(compIds[counter]);
        }
        this.createLayout();
    }

    public void clearContainer() {
        this.container.removeAll();
        this.componentIDMap.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createLayout() {
        Object th = null;
        boolean reset = true;
        this.container.removeAll();
        try {
            GroupLayout layout = new GroupLayout(this.container);
            this.container.setLayout((LayoutManager)layout);
            GroupLayout.Group[] layoutGroups = new GroupLayout.Group[2];
            for (int i = this.containerLC.getLayoutRootCount() - 1; i >= 0; --i) {
                for (int dim = 0; dim < layoutGroups.length; ++dim) {
                    GroupLayout.ParallelGroup parallel;
                    LayoutInterval interval = this.containerLC.getLayoutRoot(i, dim);
                    GroupLayout.Group group = this.composeGroup(layout, interval, true, true);
                    if (layoutGroups[dim] == null) {
                        layoutGroups[dim] = group;
                        continue;
                    }
                    if (!(layoutGroups[dim] instanceof GroupLayout.ParallelGroup)) {
                        parallel = layout.createParallelGroup();
                        parallel.add(layoutGroups[dim]);
                        layoutGroups[dim] = parallel;
                    } else {
                        parallel = (GroupLayout.ParallelGroup)layoutGroups[dim];
                    }
                    parallel.add(group);
                }
            }
            layout.setHorizontalGroup(layoutGroups[0]);
            layout.setVerticalGroup(layoutGroups[1]);
            this.composeLinks(layout);
            layout.layoutContainer(this.container);
            layout.invalidateLayout(this.container);
            reset = false;
        }
        finally {
            if (reset) {
                this.container.setLayout(null);
            }
        }
    }

    public void doLayout() {
        this.container.doLayout();
    }

    public static boolean isRelevantContainer(Container cont) {
        return cont.getLayout() != null && cont.getLayout().getClass().getName().equals("org.jdesktop.layout.GroupLayout");
    }

    private GroupLayout.Group composeGroup(GroupLayout layout, LayoutInterval interval, boolean first, boolean last) {
        GroupLayout.SequentialGroup group = null;
        if (interval.isGroup()) {
            if (interval.isParallel()) {
                int groupAlignment = SwingLayoutBuilder.convertAlignment(interval.getGroupAlignment());
                boolean notResizable = interval.getMaximumSize(this.designMode) == -2;
                group = layout.createParallelGroup(groupAlignment, !notResizable);
            } else if (interval.isSequential()) {
                group = layout.createSequentialGroup();
            } else assert (false);
            Iterator subIntervals = interval.getSubIntervals();
            while (subIntervals.hasNext()) {
                LayoutInterval subInterval = (LayoutInterval)subIntervals.next();
                this.fillGroup(layout, (GroupLayout.Group)group, subInterval, first, last && (!interval.isSequential() || !subIntervals.hasNext()));
                if (!first || !interval.isSequential()) continue;
                first = false;
            }
        } else {
            group = layout.createSequentialGroup();
            this.fillGroup(layout, (GroupLayout.Group)group, interval, true, true);
        }
        return group;
    }

    private void fillGroup(GroupLayout layout, GroupLayout.Group group, LayoutInterval interval, boolean first, boolean last) {
        int alignment = SwingLayoutBuilder.getIntervalAlignment(interval);
        if (interval.isGroup()) {
            if (group instanceof GroupLayout.SequentialGroup) {
                ((GroupLayout.SequentialGroup)group).add(this.composeGroup(layout, interval, first, last));
            } else {
                ((GroupLayout.ParallelGroup)group).add(SwingLayoutBuilder.convertAlignment(alignment), this.composeGroup(layout, interval, first, last));
            }
        } else {
            int minimum = interval.getMinimumSize(this.designMode);
            int preferred = interval.getPreferredSize(this.designMode);
            int min = this.convertSize(minimum, interval);
            int pref = this.convertSize(preferred, interval);
            int max = this.convertSize(interval.getMaximumSize(this.designMode), interval);
            if (interval.isComponent()) {
                LayoutComponent layoutComp = interval.getComponent();
                Component comp = (Component)this.componentIDMap.get(layoutComp.getId());
                assert (comp != null);
                if (minimum == -1) {
                    boolean dimension;
                    boolean bl = dimension = layoutComp.getLayoutInterval(0) != interval;
                    if (!dimension && comp.getClass().getName().equals("javax.swing.JComboBox")) {
                        min = 0;
                    } else if (preferred >= 0) {
                        int compMin;
                        Dimension minDim = comp.getMinimumSize();
                        int n = compMin = !dimension ? minDim.width : minDim.height;
                        if (compMin > preferred) {
                            min = this.convertSize(-2, interval);
                        }
                    }
                }
                if (group instanceof GroupLayout.SequentialGroup) {
                    ((GroupLayout.SequentialGroup)group).add(comp, min, pref, max);
                } else {
                    GroupLayout.ParallelGroup pGroup = (GroupLayout.ParallelGroup)group;
                    pGroup.add(SwingLayoutBuilder.convertAlignment(alignment), comp, min, pref, max);
                }
            } else {
                assert (interval.isEmptySpace());
                if (interval.isDefaultPadding(this.designMode)) {
                    assert (group instanceof GroupLayout.SequentialGroup);
                    GroupLayout.SequentialGroup seqGroup = (GroupLayout.SequentialGroup)group;
                    if (first || last) {
                        seqGroup.addContainerGap(pref, max);
                    } else {
                        LayoutConstants.PaddingType paddingType = interval.getPaddingType();
                        if (paddingType == null || paddingType == LayoutConstants.PaddingType.RELATED) {
                            seqGroup.addPreferredGap(0, pref, max);
                        } else if (paddingType == LayoutConstants.PaddingType.UNRELATED) {
                            seqGroup.addPreferredGap(1, pref, max);
                        } else if (paddingType == LayoutConstants.PaddingType.SEPARATE) {
                            if (pref == -1) {
                                pref = 18;
                            }
                            if (max == -1) {
                                max = 18;
                            }
                            seqGroup.add(18, pref, max);
                        } else assert (paddingType == LayoutConstants.PaddingType.INDENT);
                    }
                } else {
                    if (min < 0) {
                        min = pref;
                    }
                    min = Math.min(pref, min);
                    max = Math.max(pref, max);
                    if (group instanceof GroupLayout.SequentialGroup) {
                        ((GroupLayout.SequentialGroup)group).add(min, pref, max);
                    } else {
                        ((GroupLayout.ParallelGroup)group).add(min, pref, max);
                    }
                }
            }
        }
    }

    private static int getIntervalAlignment(LayoutInterval interval) {
        int alignment = interval.getAlignment();
        LayoutInterval group = interval.getParent();
        if (group.isParallel()) {
            int groupAlignment = group.getGroupAlignment();
            if (alignment == 3 && groupAlignment != 3 || alignment != 3 && groupAlignment == 3) {
                alignment = groupAlignment;
                System.err.println("WARNING: Illegal use of baseline alignment, ignoring interval's alignment.");
            }
        } else if (alignment != -1) {
            System.err.println("WARNING: Ignoring non-default alignment of interval in sequential group.");
        }
        return alignment;
    }

    private static int convertAlignment(int alignment) {
        int groupAlignment = 0;
        switch (alignment) {
            case -1: {
                groupAlignment = 1;
                break;
            }
            case 0: {
                groupAlignment = 1;
                break;
            }
            case 1: {
                groupAlignment = 2;
                break;
            }
            case 2: {
                groupAlignment = 4;
                break;
            }
            case 3: {
                groupAlignment = 3;
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        return groupAlignment;
    }

    private int convertSize(int size, LayoutInterval interval) {
        int convertedSize;
        switch (size) {
            case -1: {
                convertedSize = -1;
                break;
            }
            case -2: {
                convertedSize = interval.isEmptySpace() ? this.convertSize(interval.getPreferredSize(this.designMode), interval) : -2;
                break;
            }
            default: {
                assert (size >= 0);
                convertedSize = size;
            }
        }
        return convertedSize;
    }

    private void composeLinks(GroupLayout layout) {
        this.composeLinks(layout, 0);
        this.composeLinks(layout, 1);
    }

    private void composeLinks(GroupLayout layout, int dimension) {
        Map links = SwingLayoutUtils.createLinkSizeGroups(this.containerLC, dimension);
        Set linksSet = links.keySet();
        Iterator i = linksSet.iterator();
        while (i.hasNext()) {
            List group = (List)links.get(i.next());
            ArrayList<Component> components = new ArrayList<Component>();
            for (int j = 0; j < group.size(); ++j) {
                String compId = (String)group.get(j);
                LayoutComponent lc = this.layoutModel.getLayoutComponent(compId);
                if (lc == null) continue;
                Component comp = (Component)this.componentIDMap.get(lc.getId());
                if (comp == null) {
                    return;
                }
                components.add(comp);
            }
            Component[] compArray = components.toArray(new Component[components.size()]);
            if (compArray == null) continue;
            if (dimension == 0) {
                layout.linkSize(compArray, 1);
            }
            if (dimension != 1) continue;
            layout.linkSize(compArray, 2);
        }
    }
}

