/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form.layoutsupport.delegates;

import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.LayoutManager2;
import java.awt.Point;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorSupport;
import java.beans.PropertyVetoException;
import java.lang.reflect.Constructor;
import java.util.ResourceBundle;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import org.netbeans.modules.form.FormProperty;
import org.netbeans.modules.form.codestructure.CodeExpression;
import org.netbeans.modules.form.codestructure.CodeGroup;
import org.netbeans.modules.form.codestructure.CodeStructure;
import org.netbeans.modules.form.codestructure.FormCodeSupport;
import org.netbeans.modules.form.layoutsupport.AbstractLayoutSupport;
import org.netbeans.modules.form.layoutsupport.LayoutConstraints;
import org.openide.nodes.Node;

public class BoxLayoutSupport
extends AbstractLayoutSupport {
    private int axis = 2;
    private FormProperty[] properties;
    private static Constructor boxLayoutConstructor;
    private int assistantParams;

    public Class getSupportedClass() {
        return BoxLayout.class;
    }

    public void acceptContainerLayoutChange(PropertyChangeEvent ev) throws PropertyVetoException {
        this.updateLayoutInstance();
        super.acceptContainerLayoutChange(ev);
    }

    public int getNewIndex(Container container, Container containerDelegate, Component component, int index, Point posInCont, Point posInComp) {
        if (!(containerDelegate.getLayout() instanceof BoxLayout)) {
            return -1;
        }
        this.assistantParams = 0;
        Component[] components = containerDelegate.getComponents();
        for (int i = 0; i < components.length; ++i) {
            if (components[i] == component) {
                --this.assistantParams;
                continue;
            }
            Rectangle b = components[i].getBounds();
            if (this.axis == 0 || this.axis == 2) {
                if (posInCont.x >= b.x + b.width / 2) continue;
                this.assistantParams += i;
                return i;
            }
            if (posInCont.y >= b.y + b.height / 2) continue;
            this.assistantParams += i;
            return i;
        }
        this.assistantParams += components.length;
        return components.length;
    }

    public String getAssistantContext() {
        return "boxLayout";
    }

    public Object[] getAssistantParams() {
        return new Object[]{this.assistantParams + 1};
    }

    public boolean paintDragFeedback(Container container, Container containerDelegate, Component component, LayoutConstraints newConstraints, int newIndex, Graphics g) {
        Rectangle rect;
        if (!(containerDelegate.getLayout() instanceof BoxLayout)) {
            return false;
        }
        Component[] components = containerDelegate.getComponents();
        if (components.length == 0 || components.length == 1 && components[0] == component) {
            Insets ins = containerDelegate.getInsets();
            rect = this.axis == 0 || this.axis == 2 ? new Rectangle(ins.left, ins.top + (containerDelegate.getHeight() - ins.top - ins.bottom - 20) / 2, 30, 20) : new Rectangle(ins.left + (containerDelegate.getWidth() - ins.left - ins.right - 30) / 2, ins.top, 30, 20);
        } else if (newIndex < 0 || newIndex >= components.length) {
            Component comp = components[components.length - 1];
            if (comp == component) {
                comp = components[components.length - 2];
            }
            Rectangle b = comp.getBounds();
            rect = this.axis == 0 || this.axis == 2 ? new Rectangle(b.x + b.width - 10, b.y, 20, b.height) : new Rectangle(b.x, b.y + b.height - 10, b.width, 20);
        } else {
            Rectangle b = components[newIndex].getBounds();
            rect = this.axis == 0 || this.axis == 2 ? new Rectangle(b.x - 10, b.y, 20, b.height) : new Rectangle(b.x, b.y - 10, b.width, 20);
        }
        g.drawRect(rect.x, rect.y, rect.width, rect.height);
        return true;
    }

    public void setLayoutToContainer(Container container, Container containerDelegate) {
        containerDelegate.setLayout(this.cloneLayoutInstance(container, containerDelegate));
    }

    public void addComponentsToContainer(Container container, Container containerDelegate, Component[] components, int index) {
        ((LayoutManager2)containerDelegate.getLayout()).invalidateLayout(containerDelegate);
        super.addComponentsToContainer(container, containerDelegate, components, index);
    }

    protected LayoutManager createDefaultLayoutInstance() {
        return new BoxLayout(new JPanel(), 2);
    }

    protected LayoutManager cloneLayoutInstance(Container container, Container containerDelegate) {
        return new BoxLayout(containerDelegate, this.axis);
    }

    protected void readInitLayoutCode(CodeExpression layoutExp, CodeGroup layoutCode) {
        CodeExpression[] params = layoutExp.getOrigin().getCreationParameters();
        if (params.length == 2) {
            FormCodeSupport.readPropertyExpression(params[1], this.getProperties()[0], false);
            this.updateLayoutInstance();
        }
    }

    protected CodeExpression createInitLayoutCode(CodeGroup layoutCode) {
        CodeStructure codeStructure = this.getCodeStructure();
        CodeExpression[] params = new CodeExpression[]{this.getLayoutContext().getContainerDelegateCodeExpression(), codeStructure.createExpression(FormCodeSupport.createOrigin(this.getProperties()[0]))};
        return codeStructure.createExpression(BoxLayoutSupport.getBoxLayoutConstructor(), params);
    }

    protected FormProperty[] getProperties() {
        if (this.properties == null) {
            this.properties = new FormProperty[1];
            this.properties[0] = new FormProperty("axis", Integer.TYPE, BoxLayoutSupport.getBundle().getString("PROP_axis"), BoxLayoutSupport.getBundle().getString("HINT_axis")){

                public Object getTargetValue() {
                    return new Integer(BoxLayoutSupport.this.axis);
                }

                public void setTargetValue(Object value) {
                    int ax = (Integer)value;
                    if (ax == 0 || ax == 1 || ax == 2 || ax == 3) {
                        BoxLayoutSupport.this.axis = ax;
                    }
                }

                public boolean supportsDefaultValue() {
                    return true;
                }

                public Object getDefaultValue() {
                    return new Integer(2);
                }

                public PropertyEditor getExpliciteEditor() {
                    return new BoxAxisEditor();
                }
            };
        }
        return this.properties;
    }

    protected Node.Property getProperty(String propName) {
        return "axis".equals(propName) ? this.getProperties()[0] : null;
    }

    private static Constructor getBoxLayoutConstructor() {
        if (boxLayoutConstructor == null) {
            try {
                boxLayoutConstructor = BoxLayout.class.getConstructor(Container.class, Integer.TYPE);
            }
            catch (NoSuchMethodException ex) {
                ex.printStackTrace();
            }
        }
        return boxLayoutConstructor;
    }

    static /* synthetic */ ResourceBundle access$100() {
        return BoxLayoutSupport.getBundle();
    }

    static /* synthetic */ ResourceBundle access$200() {
        return BoxLayoutSupport.getBundle();
    }

    static /* synthetic */ ResourceBundle access$300() {
        return BoxLayoutSupport.getBundle();
    }

    static /* synthetic */ ResourceBundle access$400() {
        return BoxLayoutSupport.getBundle();
    }

    public static final class BoxAxisEditor
    extends PropertyEditorSupport {
        private final String[] tags = new String[]{BoxLayoutSupport.access$100().getString("VALUE_axis_line"), BoxLayoutSupport.access$200().getString("VALUE_axis_page"), BoxLayoutSupport.access$300().getString("VALUE_axis_x"), BoxLayoutSupport.access$400().getString("VALUE_axis_y")};
        private final Integer[] values = new Integer[]{new Integer(2), new Integer(3), new Integer(0), new Integer(1)};
        private final String[] javaInitStrings = new String[]{"javax.swing.BoxLayout.LINE_AXIS", "javax.swing.BoxLayout.PAGE_AXIS", "javax.swing.BoxLayout.X_AXIS", "javax.swing.BoxLayout.Y_AXIS"};

        public String[] getTags() {
            return this.tags;
        }

        public String getAsText() {
            Object value = this.getValue();
            for (int i = 0; i < this.values.length; ++i) {
                if (!this.values[i].equals(value)) continue;
                return this.tags[i];
            }
            return null;
        }

        public void setAsText(String str) {
            for (int i = 0; i < this.values.length; ++i) {
                if (!this.tags[i].equals(str)) continue;
                this.setValue(this.values[i]);
                break;
            }
        }

        public String getJavaInitializationString() {
            Object value = this.getValue();
            for (int i = 0; i < this.values.length; ++i) {
                if (!this.values[i].equals(value)) continue;
                return this.javaInitStrings[i];
            }
            return null;
        }
    }
}

