/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form.layoutsupport.delegates;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorSupport;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;
import org.netbeans.modules.form.FormProperty;
import org.netbeans.modules.form.FormPropertyContext;
import org.netbeans.modules.form.codestructure.CodeExpression;
import org.netbeans.modules.form.codestructure.CodeGroup;
import org.netbeans.modules.form.codestructure.CodeStatement;
import org.netbeans.modules.form.codestructure.CodeStructure;
import org.netbeans.modules.form.codestructure.CodeVariable;
import org.netbeans.modules.form.codestructure.FormCodeSupport;
import org.netbeans.modules.form.layoutsupport.AbstractLayoutSupport;
import org.netbeans.modules.form.layoutsupport.LayoutConstraints;
import org.netbeans.modules.form.layoutsupport.LayoutSupportContext;
import org.netbeans.modules.form.layoutsupport.delegates.AbsoluteLayoutSupport;
import org.netbeans.modules.form.layoutsupport.delegates.GridBagCustomizer;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;

public class GridBagLayoutSupport
extends AbstractLayoutSupport {
    private static Reference customizerRef;

    public Class getSupportedClass() {
        return GridBagLayout.class;
    }

    public Class getCustomizerClass() {
        return GridBagCustomizer.Window.class;
    }

    public Component getSupportCustomizer() {
        GridBagCustomizer.Window customizer = null;
        if (customizerRef != null) {
            customizer = (GridBagCustomizer.Window)customizerRef.get();
        }
        if (customizer == null) {
            customizer = new GridBagCustomizer.Window();
            customizerRef = new WeakReference<GridBagCustomizer.Window>(customizer);
        }
        customizer.setObject(this);
        return customizer;
    }

    public void convertConstraints(LayoutConstraints[] previousConstraints, LayoutConstraints[] currentConstraints, Component[] components) {
        int i;
        Rectangle jbounds;
        int j;
        int i2;
        if (currentConstraints == null || components == null || components.length > currentConstraints.length || components.length == 0 || !(previousConstraints[0] instanceof AbsoluteLayoutSupport.AbsoluteLayoutConstraints)) {
            return;
        }
        ArrayList xlines = new ArrayList();
        ArrayList ylines = new ArrayList();
        Container con = components[0].getParent();
        Rectangle parentbound = con == null ? components[0].getBounds() : con.getBounds();
        GridBagLayoutSupport.insertLines(0, xlines);
        GridBagLayoutSupport.insertLines(0, ylines);
        for (int i3 = 0; i3 < components.length; ++i3) {
            Rectangle ibounds = components[i3].getBounds();
            if (ibounds.width > 0) {
                GridBagLayoutSupport.insertLines(ibounds.x + ibounds.width, xlines);
            } else {
                GridBagLayoutSupport.insertLines(ibounds.x + 1, xlines);
            }
            if (ibounds.height > 0) {
                GridBagLayoutSupport.insertLines(ibounds.y + ibounds.height, ylines);
                continue;
            }
            GridBagLayoutSupport.insertLines(ibounds.y + 1, ylines);
        }
        LayoutInfo[] layouts = new LayoutInfo[components.length];
        for (i2 = 0; i2 < layouts.length; ++i2) {
            layouts[i2] = new LayoutInfo();
        }
        for (i2 = 0; i2 < xlines.size() - 1; ++i2) {
            int x1 = (Integer)xlines.get(i2);
            int x2 = (Integer)xlines.get(i2 + 1);
            for (j = 0; j < components.length; ++j) {
                jbounds = components[j].getBounds();
                if (jbounds.width <= 0) {
                    jbounds.width = 1;
                }
                if (!GridBagLayoutSupport.isOverlapped(x1, x2, jbounds.x, jbounds.x + jbounds.width - 1)) continue;
                layouts[j].incGridWidth(i2);
            }
        }
        for (i2 = 0; i2 < ylines.size() - 1; ++i2) {
            int y1 = (Integer)ylines.get(i2);
            int y2 = (Integer)ylines.get(i2 + 1);
            for (j = 0; j < components.length; ++j) {
                jbounds = components[j].getBounds();
                if (jbounds.height <= 0) {
                    jbounds.height = 1;
                }
                if (!GridBagLayoutSupport.isOverlapped(y1, y2, jbounds.y, jbounds.y + jbounds.height - 1)) continue;
                layouts[j].incGridHeight(i2);
            }
        }
        for (i2 = 0; i2 < components.length; ++i2) {
            int height;
            Rectangle curbounds = components[i2].getBounds();
            int lastleft = 0;
            int lasttop = 0;
            for (int j2 = 0; j2 < components.length; ++j2) {
                int height2;
                Rectangle jbounds2 = components[j2].getBounds();
                int width = jbounds2.width;
                if (width < 0) {
                    width = 0;
                }
                if (jbounds2.x + width - 1 < curbounds.x && jbounds2.x + width > lastleft) {
                    lastleft = jbounds2.x + width;
                }
                if ((height2 = jbounds2.height) < 0) {
                    height2 = 0;
                }
                if (jbounds2.y + height2 - 1 >= curbounds.y || jbounds2.y + height2 <= lasttop) continue;
                lasttop = jbounds2.y + height2;
            }
            layouts[i2].setLeft(curbounds.x - lastleft);
            layouts[i2].setTop(curbounds.y - lasttop);
            int width = curbounds.width < 0 ? 0 : curbounds.width;
            int n = height = curbounds.height < 0 ? 0 : curbounds.height;
            if (layouts[i2].getLastGridX() == xlines.size() - 2) {
                layouts[i2].setRight(parentbound.width - curbounds.x - width);
            }
            if (layouts[i2].getLastGridY() != ylines.size() - 2) continue;
            layouts[i2].setBottom(parentbound.height - curbounds.y - height);
        }
        LayoutInfoComparator comp = new LayoutInfoComparator(0);
        LayoutInfo[] layoutsX = (LayoutInfo[])layouts.clone();
        LayoutInfo[] layoutsY = (LayoutInfo[])layouts.clone();
        Arrays.sort(layoutsX, comp);
        comp.cord = 1;
        Arrays.sort(layoutsY, comp);
        for (i = 0; i < components.length; ++i) {
            int j3;
            int expand = 0;
            int lastgrid = layoutsX[i].getLastGridX();
            for (j3 = i + 1; j3 < components.length; ++j3) {
                if (!layoutsX[j3].containsGridX(lastgrid) || layoutsX[j3].getLastGridX() <= lastgrid || layoutsX[i].gridwidth < layoutsX[j3].gridwidth || expand >= layoutsX[i].gridwidth - layoutsX[j3].gridwidth + 1) continue;
                expand = layoutsX[i].gridwidth - layoutsX[j3].gridwidth + 1;
            }
            if (expand > 0) {
                for (j3 = i + 1; j3 < components.length; ++j3) {
                    if (layoutsX[j3].containsGridX(lastgrid) && layoutsX[j3].getLastGridX() > lastgrid) {
                        layoutsX[j3].expandGridWidth(expand);
                        continue;
                    }
                    if (layoutsX[j3].gridx <= lastgrid) continue;
                    layoutsX[j3].moveGridX(expand);
                }
            }
            expand = 0;
            lastgrid = layoutsY[i].getLastGridY();
            for (j3 = i + 1; j3 < components.length; ++j3) {
                if (!layoutsY[j3].containsGridY(lastgrid) || layoutsY[j3].getLastGridY() <= lastgrid || layoutsY[i].gridheight < layoutsY[j3].gridheight || expand >= layoutsY[i].gridheight - layoutsY[j3].gridheight + 1) continue;
                expand = layoutsY[i].gridheight - layoutsY[j3].gridheight + 1;
            }
            if (expand <= 0) continue;
            for (j3 = i + 1; j3 < components.length; ++j3) {
                if (layoutsY[j3].containsGridY(lastgrid) && layoutsY[j3].getLastGridY() > lastgrid) {
                    layoutsY[j3].expandGridHeight(expand);
                    continue;
                }
                if (layoutsY[j3].gridy <= lastgrid) continue;
                layoutsY[j3].moveGridY(expand);
            }
        }
        for (i = 0; i < components.length; ++i) {
            if (Math.max(layouts[i].gridx + layouts[i].gridwidth - 1, layouts[i].gridy + layouts[i].gridheight - 1) >= 512) {
                for (int j4 = 0; j4 < i; ++j4) {
                    currentConstraints[j4] = null;
                }
                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(AbstractLayoutSupport.class, (String)"MSG_ERR_MoreThan512")));
                return;
            }
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.gridx = layouts[i].gridx;
            gbc.gridy = layouts[i].gridy;
            gbc.gridwidth = layouts[i].gridwidth;
            gbc.gridheight = layouts[i].gridheight;
            gbc.anchor = 18;
            gbc.insets = new Insets(layouts[i].top, layouts[i].left, layouts[i].bottom, layouts[i].right);
            if (components[i].getClass().getName().equals("javax.swing.JScrollPane")) {
                gbc.weightx = 1.0;
                gbc.weighty = 1.0;
                gbc.fill = 1;
            }
            Rectangle bounds = components[i].getBounds();
            Dimension minsize = components[i].getMinimumSize();
            Dimension prefsize = components[i].getPreferredSize();
            if (bounds.width > minsize.width) {
                gbc.ipadx = bounds.width - minsize.width;
            } else if (bounds.width < prefsize.width) {
                gbc.ipadx = bounds.width - prefsize.width;
            }
            if (bounds.height > minsize.height) {
                gbc.ipady = bounds.height - minsize.height;
            } else if (bounds.height < prefsize.height) {
                gbc.ipady = bounds.height - prefsize.height;
            }
            currentConstraints[i] = new GridBagLayoutConstraints(gbc);
        }
    }

    private static boolean isOverlapped(int border1, int border2, int compPos1, int compPos2) {
        return compPos2 >= border1 && compPos1 < border2;
    }

    private static void insertLines(int line, List lines) {
        if (line < 0) {
            line = 0;
        }
        for (int i = 0; i < lines.size(); ++i) {
            int ival = (Integer)lines.get(i);
            if (line < ival) {
                lines.add(i, new Integer(line));
                return;
            }
            if (line != ival) continue;
            return;
        }
        lines.add(new Integer(line));
    }

    protected LayoutConstraints readConstraintsCode(CodeExpression constrExp, CodeGroup constrCode, CodeExpression compExp) {
        GridBagLayoutConstraints constr = new GridBagLayoutConstraints();
        constr.readCodeExpression(constrExp, constrCode);
        return constr;
    }

    protected CodeExpression createConstraintsCode(CodeGroup constrCode, LayoutConstraints constr, CodeExpression compExp, int index) {
        if (!(constr instanceof GridBagLayoutConstraints)) {
            return null;
        }
        return ((GridBagLayoutConstraints)constr).createCodeExpression(this.getCodeStructure(), constrCode);
    }

    protected LayoutConstraints createDefaultConstraints() {
        return new GridBagLayoutConstraints();
    }

    static ResourceBundle getBundleHack() {
        return GridBagLayoutSupport.getBundle();
    }

    LayoutSupportContext getLayoutSupportHack() {
        return super.getLayoutContext();
    }

    public static final class AnchorEditor
    extends GridBagConstrEditor {
        public AnchorEditor() {
            this.tags = new String[]{GridBagLayoutSupport.getBundle().getString("VALUE_anchor_center"), GridBagLayoutSupport.getBundle().getString("VALUE_anchor_north"), GridBagLayoutSupport.getBundle().getString("VALUE_anchor_northeast"), GridBagLayoutSupport.getBundle().getString("VALUE_anchor_east"), GridBagLayoutSupport.getBundle().getString("VALUE_anchor_southeast"), GridBagLayoutSupport.getBundle().getString("VALUE_anchor_south"), GridBagLayoutSupport.getBundle().getString("VALUE_anchor_southwest"), GridBagLayoutSupport.getBundle().getString("VALUE_anchor_west"), GridBagLayoutSupport.getBundle().getString("VALUE_anchor_northwest"), GridBagLayoutSupport.getBundle().getString("VALUE_anchor_pagestart"), GridBagLayoutSupport.getBundle().getString("VALUE_anchor_pageend"), GridBagLayoutSupport.getBundle().getString("VALUE_anchor_linestart"), GridBagLayoutSupport.getBundle().getString("VALUE_anchor_lineend"), GridBagLayoutSupport.getBundle().getString("VALUE_anchor_firstlinestart"), GridBagLayoutSupport.getBundle().getString("VALUE_anchor_firstlineend"), GridBagLayoutSupport.getBundle().getString("VALUE_anchor_lastlinestart"), GridBagLayoutSupport.getBundle().getString("VALUE_anchor_lastlineend")};
            this.values = new Integer[]{new Integer(10), new Integer(11), new Integer(12), new Integer(13), new Integer(14), new Integer(15), new Integer(16), new Integer(17), new Integer(18), new Integer(19), new Integer(20), new Integer(21), new Integer(22), new Integer(23), new Integer(24), new Integer(25), new Integer(26)};
            this.javaInitStrings = new String[]{"java.awt.GridBagConstraints.CENTER", "java.awt.GridBagConstraints.NORTH", "java.awt.GridBagConstraints.NORTHEAST", "java.awt.GridBagConstraints.EAST", "java.awt.GridBagConstraints.SOUTHEAST", "java.awt.GridBagConstraints.SOUTH", "java.awt.GridBagConstraints.SOUTHWEST", "java.awt.GridBagConstraints.WEST", "java.awt.GridBagConstraints.NORTHWEST", "java.awt.GridBagConstraints.PAGE_START", "java.awt.GridBagConstraints.PAGE_END", "java.awt.GridBagConstraints.LINE_START", "java.awt.GridBagConstraints.LINE_END", "java.awt.GridBagConstraints.FIRST_LINE_START", "java.awt.GridBagConstraints.FIRST_LINE_END", "java.awt.GridBagConstraints.LAST_LINE_START", "java.awt.GridBagConstraints.LAST_LINE_END"};
            this.otherValuesAllowed = false;
        }
    }

    public static final class FillEditor
    extends GridBagConstrEditor {
        public FillEditor() {
            this.tags = new String[]{GridBagLayoutSupport.getBundle().getString("VALUE_fill_none"), GridBagLayoutSupport.getBundle().getString("VALUE_fill_horizontal"), GridBagLayoutSupport.getBundle().getString("VALUE_fill_vertical"), GridBagLayoutSupport.getBundle().getString("VALUE_fill_both")};
            this.values = new Integer[]{new Integer(0), new Integer(2), new Integer(3), new Integer(1)};
            this.javaInitStrings = new String[]{"java.awt.GridBagConstraints.NONE", "java.awt.GridBagConstraints.HORIZONTAL", "java.awt.GridBagConstraints.VERTICAL", "java.awt.GridBagConstraints.BOTH"};
            this.otherValuesAllowed = false;
        }
    }

    private static abstract class GridBagConstrEditor
    extends PropertyEditorSupport {
        String[] tags;
        Integer[] values;
        String[] javaInitStrings;
        boolean otherValuesAllowed;

        private GridBagConstrEditor() {
        }

        public String[] getTags() {
            return this.tags;
        }

        public String getAsText() {
            Object value = this.getValue();
            for (int i = 0; i < this.values.length; ++i) {
                if (!this.values[i].equals(value)) continue;
                return this.tags[i];
            }
            return this.otherValuesAllowed && value != null ? value.toString() : null;
        }

        public void setAsText(String str) {
            for (int i = 0; i < this.tags.length; ++i) {
                if (!this.tags[i].equals(str)) continue;
                this.setValue(this.values[i]);
                return;
            }
            if (this.otherValuesAllowed) {
                try {
                    this.setValue(new Integer(Integer.parseInt(str)));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }

        public String getJavaInitializationString() {
            Object value = this.getValue();
            for (int i = 0; i < this.values.length; ++i) {
                if (!this.values[i].equals(value)) continue;
                return this.javaInitStrings[i];
            }
            if (!this.otherValuesAllowed) {
                return this.javaInitStrings[0];
            }
            return value != null ? value.toString() : null;
        }
    }

    public static class GridBagLayoutConstraints
    implements LayoutConstraints {
        private GridBagConstraints constraints;
        private GridBagConstraints defaultConstraints = new GridBagConstraints();
        private Property[] properties;
        private CodeExpression constraintsExpression;
        private CodeGroup constraintsCode;
        private CodeStatement[] propertyStatements;
        private static Constructor constrConstructor;
        private static final int variableType = 20480;
        private static final int variableMask = 28672;
        private static final String defaultVariableName = "gridBagConstraints";

        public GridBagLayoutConstraints() {
            this.constraints = new GridBagConstraints();
        }

        public GridBagLayoutConstraints(GridBagConstraints constraints) {
            this.constraints = constraints;
        }

        public Node.Property[] getProperties() {
            if (this.properties == null) {
                this.createProperties();
                this.reinstateProperties();
            }
            return this.properties;
        }

        public Object getConstraintsObject() {
            return this.constraints;
        }

        public LayoutConstraints cloneConstraints() {
            return new GridBagLayoutConstraints((GridBagConstraints)this.constraints.clone());
        }

        private CodeExpression createCodeExpression(CodeStructure codeStructure, CodeGroup constrCode) {
            this.constraintsCode = constrCode;
            this.propertyStatements = null;
            this.constraintsExpression = codeStructure.createExpression(GridBagLayoutConstraints.getConstraintsConstructor(), CodeStructure.EMPTY_PARAMS);
            this.updateCodeExpression();
            return this.constraintsExpression;
        }

        private void readCodeExpression(CodeExpression constrExp, CodeGroup constrCode) {
            this.constraintsExpression = constrExp;
            this.constraintsCode = constrCode;
            this.propertyStatements = null;
            this.getProperties();
            boolean isAnyChanged = false;
            Iterator it = CodeStructure.getDefinedStatementsIterator(constrExp);
            block0: while (it.hasNext()) {
                CodeStatement statement = (CodeStatement)it.next();
                for (int j = 0; j < this.properties.length; ++j) {
                    Property prop = this.properties[j];
                    if (!prop.field.equals(statement.getMetaObject())) continue;
                    FormCodeSupport.readPropertyStatement(statement, prop, false);
                    this.setPropertyStatement(j, statement);
                    if (!prop.isChanged()) continue block0;
                    constrCode.addStatement(statement);
                    isAnyChanged = true;
                    continue block0;
                }
            }
            this.setupVariable(isAnyChanged);
        }

        private void updateCodeExpression() {
            if (this.constraintsCode == null || this.constraintsExpression == null) {
                return;
            }
            this.constraintsCode.removeAll();
            this.getProperties();
            boolean isAnyChanged = false;
            for (int i = 0; i < this.properties.length; ++i) {
                if (!this.properties[i].isChanged()) continue;
                this.constraintsCode.addStatement(this.getPropertyStatement(i));
                isAnyChanged = true;
            }
            this.setupVariable(isAnyChanged);
        }

        private CodeStatement getPropertyStatement(int index) {
            CodeStatement propStatement;
            if (this.propertyStatements == null) {
                this.propertyStatements = new CodeStatement[this.properties.length];
            }
            if ((propStatement = this.propertyStatements[index]) == null) {
                CodeExpression propExp = this.constraintsExpression.getCodeStructure().createExpression(FormCodeSupport.createOrigin(this.properties[index]));
                this.propertyStatements[index] = propStatement = CodeStructure.createStatement(this.constraintsExpression, this.properties[index].field, propExp);
            }
            return propStatement;
        }

        private void setPropertyStatement(int index, CodeStatement propStatement) {
            if (this.propertyStatements == null) {
                this.propertyStatements = new CodeStatement[this.properties.length];
            }
            this.propertyStatements[index] = propStatement;
        }

        private void setupVariable(boolean anyChangedProperty) {
            CodeStructure codeStructure = this.constraintsExpression.getCodeStructure();
            CodeVariable var = this.constraintsExpression.getVariable();
            if (anyChangedProperty) {
                if (var == null) {
                    var = this.findVariable();
                    if (var == null) {
                        var = codeStructure.createVariableForExpression(this.constraintsExpression, 20480, defaultVariableName);
                    } else {
                        codeStructure.attachExpressionToVariable(this.constraintsExpression, var);
                    }
                }
                this.constraintsCode.addStatement(0, var.getAssignment(this.constraintsExpression));
            } else {
                codeStructure.removeExpressionFromVariable(this.constraintsExpression);
            }
        }

        private CodeVariable findVariable() {
            CodeStructure codeStructure = this.constraintsExpression.getCodeStructure();
            CodeVariable var = codeStructure.getVariable(defaultVariableName);
            if (var != null && (var.getType() & 0x7000) == 20480 && GridBagConstraints.class.equals((Object)var.getDeclaredType())) {
                return var;
            }
            Iterator it = codeStructure.getVariablesIterator(20480, 28672, GridBagConstraints.class);
            while (it.hasNext()) {
                var = (CodeVariable)it.next();
                if (!var.getName().startsWith(defaultVariableName)) continue;
                return var;
            }
            return null;
        }

        private void createProperties() {
            this.properties = new Property[]{new Property("gridx", Integer.TYPE, GridBagLayoutSupport.getBundle().getString("PROP_gridx"), GridBagLayoutSupport.getBundle().getString("HINT_gridx"), GridPosEditor.class), new Property("gridy", Integer.TYPE, GridBagLayoutSupport.getBundle().getString("PROP_gridy"), GridBagLayoutSupport.getBundle().getString("HINT_gridy"), GridPosEditor.class), new Property("gridwidth", Integer.TYPE, GridBagLayoutSupport.getBundle().getString("PROP_gridwidth"), GridBagLayoutSupport.getBundle().getString("HINT_gridwidth"), GridSizeEditor.class), new Property("gridheight", Integer.TYPE, GridBagLayoutSupport.getBundle().getString("PROP_gridheight"), GridBagLayoutSupport.getBundle().getString("HINT_gridheight"), GridSizeEditor.class), new Property("fill", Integer.TYPE, GridBagLayoutSupport.getBundle().getString("PROP_fill"), GridBagLayoutSupport.getBundle().getString("HINT_fill"), FillEditor.class), new Property("ipadx", Integer.TYPE, GridBagLayoutSupport.getBundle().getString("PROP_ipadx"), GridBagLayoutSupport.getBundle().getString("HINT_ipadx"), null), new Property("ipady", Integer.TYPE, GridBagLayoutSupport.getBundle().getString("PROP_ipady"), GridBagLayoutSupport.getBundle().getString("HINT_ipady"), null), new Property("anchor", Integer.TYPE, GridBagLayoutSupport.getBundle().getString("PROP_anchor"), GridBagLayoutSupport.getBundle().getString("HINT_anchor"), AnchorEditor.class), new Property("weightx", Double.TYPE, GridBagLayoutSupport.getBundle().getString("PROP_weightx"), GridBagLayoutSupport.getBundle().getString("HINT_weightx"), null), new Property("weighty", Double.TYPE, GridBagLayoutSupport.getBundle().getString("PROP_weighty"), GridBagLayoutSupport.getBundle().getString("HINT_weighty"), null), new Property("insets", Insets.class, GridBagLayoutSupport.getBundle().getString("PROP_insets"), GridBagLayoutSupport.getBundle().getString("HINT_insets"), null)};
            this.properties[0].setValue("canEditAsText", Boolean.TRUE);
            this.properties[1].setValue("canEditAsText", Boolean.TRUE);
            this.properties[2].setValue("canEditAsText", Boolean.TRUE);
            this.properties[3].setValue("canEditAsText", Boolean.TRUE);
        }

        private void reinstateProperties() {
            try {
                for (int i = 0; i < this.properties.length; ++i) {
                    Property prop = this.properties[i];
                    prop.reinstateProperty();
                }
            }
            catch (IllegalAccessException e1) {
            }
            catch (InvocationTargetException invocationTargetException) {
                // empty catch block
            }
        }

        private static Constructor getConstraintsConstructor() {
            if (constrConstructor == null) {
                try {
                    constrConstructor = GridBagConstraints.class.getConstructor(new Class[0]);
                }
                catch (NoSuchMethodException ex) {
                    ex.printStackTrace();
                }
            }
            return constrConstructor;
        }

        private final class Property
        extends FormProperty {
            private Field field;
            private Class propertyEditorClass;

            Property(String name, Class type, String displayName, String shortDescription, Class propertyEditorClass) {
                super("GridBagLayoutConstraints " + name, type, displayName, shortDescription);
                this.propertyEditorClass = propertyEditorClass;
                try {
                    this.field = GridBagConstraints.class.getField(name);
                }
                catch (NoSuchFieldException ex) {
                    ex.printStackTrace();
                }
            }

            public Object getTargetValue() {
                try {
                    return this.field.get(GridBagLayoutConstraints.this.constraints);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    return null;
                }
            }

            public void setTargetValue(Object value) {
                try {
                    this.field.set(GridBagLayoutConstraints.this.constraints, value);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }

            public boolean supportsDefaultValue() {
                return true;
            }

            public Object getDefaultValue() {
                try {
                    return this.field.get(GridBagLayoutConstraints.this.defaultConstraints);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    return null;
                }
            }

            public PropertyEditor getExpliciteEditor() {
                if (this.propertyEditorClass == null) {
                    return null;
                }
                try {
                    return (PropertyEditor)this.propertyEditorClass.newInstance();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    return null;
                }
            }

            protected void propertyValueChanged(Object old, Object current) {
                String name;
                if (current instanceof Integer && (((name = this.getName()).endsWith("gridx") || name.endsWith("gridwidth")) && ((GridBagLayoutConstraints)GridBagLayoutConstraints.this).constraints.gridx + ((GridBagLayoutConstraints)GridBagLayoutConstraints.this).constraints.gridwidth > 512 || (name.endsWith("gridy") || name.endsWith("gridheight")) && ((GridBagLayoutConstraints)GridBagLayoutConstraints.this).constraints.gridy + ((GridBagLayoutConstraints)GridBagLayoutConstraints.this).constraints.gridheight > 512)) {
                    boolean fire = this.isChangeFiring();
                    this.setChangeFiring(false);
                    try {
                        this.setValue(old);
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                    this.setChangeFiring(fire);
                    return;
                }
                if (this.isChangeFiring()) {
                    GridBagLayoutConstraints.this.updateCodeExpression();
                }
                super.propertyValueChanged(old, current);
            }

            public void setPropertyContext(FormPropertyContext ctx) {
            }
        }
    }

    public static final class GridPosEditor
    extends GridBagConstrEditor {
        public GridPosEditor() {
            this.tags = new String[]{GridBagLayoutSupport.getBundle().getString("VALUE_relative")};
            this.values = new Integer[]{new Integer(-1)};
            this.javaInitStrings = new String[]{"java.awt.GridBagConstraints.RELATIVE"};
            this.otherValuesAllowed = true;
        }
    }

    public static final class GridSizeEditor
    extends GridBagConstrEditor {
        public GridSizeEditor() {
            this.tags = new String[]{GridBagLayoutSupport.getBundle().getString("VALUE_relative"), GridBagLayoutSupport.getBundle().getString("VALUE_remainder")};
            this.values = new Integer[]{new Integer(-1), new Integer(0)};
            this.javaInitStrings = new String[]{"java.awt.GridBagConstraints.RELATIVE", "java.awt.GridBagConstraints.REMAINDER"};
            this.otherValuesAllowed = true;
        }
    }

    private static class LayoutInfo {
        int gridx;
        int gridy;
        int gridwidth;
        int gridheight;
        int top = 0;
        int left = 0;
        int bottom = 0;
        int right = 0;

        private LayoutInfo() {
        }

        void setLeft(int left) {
            if (left < 0) {
                left = 0;
            }
            this.left = left;
        }

        void setTop(int top) {
            if (top < 0) {
                top = 0;
            }
            this.top = top;
        }

        void setBottom(int bottom) {
            if (bottom < 0) {
                bottom = 0;
            }
            this.bottom = bottom;
        }

        void setRight(int right) {
            if (right < 0) {
                right = 0;
            }
            this.right = right;
        }

        void moveGridX(int diff) {
            this.gridx += diff;
        }

        void moveGridY(int diff) {
            this.gridy += diff;
        }

        void expandGridWidth(int diff) {
            this.gridwidth += diff;
        }

        void expandGridHeight(int diff) {
            this.gridheight += diff;
        }

        void incGridWidth(int gridx) {
            if (this.gridwidth == 0) {
                this.gridx = gridx;
            }
            ++this.gridwidth;
        }

        void incGridHeight(int gridy) {
            if (this.gridheight == 0) {
                this.gridy = gridy;
            }
            ++this.gridheight;
        }

        boolean containsGridX(int grid) {
            return grid >= this.gridx && grid < this.gridx + this.gridwidth;
        }

        boolean containsGridY(int grid) {
            return grid >= this.gridy && grid < this.gridy + this.gridheight;
        }

        int getLastGridX() {
            return this.gridx + this.gridwidth - 1;
        }

        int getLastGridY() {
            return this.gridy + this.gridheight - 1;
        }
    }

    private static class LayoutInfoComparator
    implements Comparator {
        static final int XAXIS = 0;
        static final int YAXIS = 1;
        int cord;

        public LayoutInfoComparator(int cord) {
            this.cord = cord;
        }

        public int compare(Object left, Object right) {
            LayoutInfo layoutleft = (LayoutInfo)left;
            LayoutInfo layoutright = (LayoutInfo)right;
            if (left == null || right == null) {
                return 0;
            }
            if (this.cord == 0) {
                return layoutleft.getLastGridX() - layoutright.getLastGridX();
            }
            return layoutleft.getLastGridY() - layoutright.getLastGridY();
        }
    }
}

