/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form.layoutsupport.delegates;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.lang.reflect.Method;
import javax.swing.JScrollPane;
import org.netbeans.modules.form.codestructure.CodeExpression;
import org.netbeans.modules.form.codestructure.CodeGroup;
import org.netbeans.modules.form.codestructure.CodeStatement;
import org.netbeans.modules.form.codestructure.CodeStructure;
import org.netbeans.modules.form.layoutsupport.AbstractLayoutSupport;
import org.netbeans.modules.form.layoutsupport.LayoutConstraints;

public class JScrollPaneSupport
extends AbstractLayoutSupport {
    private static Method setViewportViewMethod;
    private boolean assistantParams;

    public Class getSupportedClass() {
        return JScrollPane.class;
    }

    public boolean checkEmptyContainer(Container cont) {
        return cont instanceof JScrollPane && ((JScrollPane)cont).getViewport().getView() == null;
    }

    public int getNewIndex(Container container, Container containerDelegate, Component component, int index, Point posInCont, Point posInComp) {
        this.assistantParams = container instanceof JScrollPane && ((JScrollPane)container).getViewport().getView() == null;
        return this.assistantParams ? 0 : -1;
    }

    public String getAssistantContext() {
        return this.assistantParams ? "jscrollPaneLayout" : null;
    }

    public boolean paintDragFeedback(Container container, Container containerDelegate, Component component, LayoutConstraints newConstraints, int newIndex, Graphics g) {
        if (container instanceof JScrollPane && ((JScrollPane)container).getViewport().getView() == null) {
            Dimension sz = container.getSize();
            Insets insets = container.getInsets();
            sz.width -= insets.left + insets.right;
            sz.height -= insets.top + insets.bottom;
            g.drawRect(0, 0, sz.width, sz.height);
            return true;
        }
        return false;
    }

    public void addComponentsToContainer(Container container, Container containerDelegate, Component[] components, int index) {
        if (components.length == 0) {
            return;
        }
        if (container instanceof JScrollPane) {
            ((JScrollPane)container).setViewportView(components[0]);
        }
    }

    public boolean removeComponentFromContainer(Container container, Container containerDelegate, Component component) {
        return false;
    }

    public boolean clearContainer(Container container, Container containerDelegate) {
        if (container instanceof JScrollPane) {
            JScrollPane scrollPane = (JScrollPane)container;
            Component comp = scrollPane.getViewport().getView();
            if (comp != null) {
                comp.removeNotify();
                comp.setBounds(0, 0, 0, 0);
            }
            scrollPane.setViewportView(null);
            return true;
        }
        return super.clearContainer(container, containerDelegate);
    }

    protected CodeExpression getActiveContainerCodeExpression() {
        return this.getLayoutContext().getContainerCodeExpression();
    }

    protected CodeExpression readComponentCode(CodeStatement statement, CodeGroup componentCode) {
        if (JScrollPaneSupport.getSetViewportViewMethod().equals(statement.getMetaObject()) || JScrollPaneSupport.getSimpleAddMethod().equals(statement.getMetaObject())) {
            componentCode.addStatement(statement);
            this.getConstraintsList().add(null);
            return statement.getStatementParameters()[0];
        }
        return null;
    }

    protected void createComponentCode(CodeGroup componentCode, CodeExpression componentExpression, int index) {
        CodeStatement addStatement = CodeStructure.createStatement(this.getLayoutContext().getContainerCodeExpression(), JScrollPaneSupport.getSetViewportViewMethod(), new CodeExpression[]{componentExpression});
        componentCode.addStatement(addStatement);
    }

    private static Method getSetViewportViewMethod() {
        if (setViewportViewMethod == null) {
            try {
                setViewportViewMethod = JScrollPane.class.getMethod("setViewportView", Component.class);
            }
            catch (NoSuchMethodException ex) {
                ex.printStackTrace();
            }
        }
        return setViewportViewMethod;
    }
}

