/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form.menu;

import java.awt.Component;
import java.awt.Container;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.util.Arrays;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JPanel;
import org.netbeans.modules.form.FormModelEvent;
import org.netbeans.modules.form.MetaComponentCreator;
import org.netbeans.modules.form.RADVisualComponent;
import org.netbeans.modules.form.RADVisualContainer;
import org.netbeans.modules.form.layoutdesign.LayoutComponent;
import org.netbeans.modules.form.menu.MenuEditLayer;
import org.netbeans.modules.form.menu.MenuItemSender;
import org.netbeans.modules.form.palette.PaletteItem;
import org.netbeans.spi.palette.PaletteController;
import org.openide.util.Lookup;

class MenuItemReceiverAndSender
extends MenuItemSender {
    private static final boolean DEBUG = false;
    private final MenuEditLayer layer;

    public MenuItemReceiverAndSender(MenuEditLayer layer) {
        this.layer = layer;
    }

    public int getSourceActions(JComponent c) {
        return 2;
    }

    public boolean canImport(JComponent c, DataFlavor[] flavors) {
        List<DataFlavor> list = Arrays.asList(flavors);
        if (list.contains(COMPONENT_FLAVOR)) {
            return true;
        }
        return list.contains(PaletteController.ITEM_DATA_FLAVOR);
    }

    public boolean importData(JComponent targetComponent, Transferable t) {
        this.p("---\nimporting data for component: " + targetComponent);
        targetComponent.setBorder(MenuEditLayer.UNSELECTED_BORDER);
        JComponent newComponent = null;
        JComponent menuParent = this.layer.getMenuParent(targetComponent);
        try {
            if (t.isDataFlavorSupported(PaletteController.ITEM_DATA_FLAVOR)) {
                this.p("new from the palette");
                Object data = t.getTransferData(PaletteController.ITEM_DATA_FLAVOR);
                Lookup itemLookup = (Lookup)t.getTransferData(PaletteController.ITEM_DATA_FLAVOR);
                PaletteItem paletteItem = (PaletteItem)itemLookup.lookup(PaletteItem.class);
                RADVisualComponent precreated = this.getComponentCreator().precreateVisualComponent(paletteItem.getComponentClassSource());
                newComponent = (JComponent)precreated.getBeanInstance();
                if (newComponent == null) {
                    newComponent = (JComponent)paletteItem.getComponentClass().newInstance();
                }
                LayoutComponent layoutComponent = this.getComponentCreator().getPrecreatedLayoutComponent();
                Object constraints = null;
                if (targetComponent instanceof JMenu) {
                    this.p("============== doing a new comp to a jmenu");
                    RADVisualContainer targetContainer = (RADVisualContainer)this.layer.formDesigner.getMetaComponent(targetComponent);
                    this.p("target container = " + targetContainer);
                    boolean added = this.getComponentCreator().addPrecreatedComponent(targetContainer, constraints);
                    return true;
                }
                RADVisualContainer targetContainer = (RADVisualContainer)this.layer.formDesigner.getMetaComponent(menuParent);
                boolean added = this.getComponentCreator().addPrecreatedComponent(targetContainer, constraints);
                return true;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
        try {
            if (t.isDataFlavorSupported(COMPONENT_FLAVOR)) {
                this.p("is a component");
                Integer data = (Integer)t.getTransferData(COMPONENT_FLAVOR);
                JComponent payloadComponent = (JComponent)dataMap.get(data);
                if (targetComponent == payloadComponent) {
                    return false;
                }
                newComponent = payloadComponent;
                this.p("the target is: " + targetComponent);
                this.p("payload = " + payloadComponent);
                if (targetComponent instanceof JMenu) {
                    this.p("================== doing a menu drop");
                    this.removeRadComponent(payloadComponent, menuParent);
                    this.addRadComponentBefore(payloadComponent, null, targetComponent);
                } else {
                    this.removeRadComponent(payloadComponent, menuParent);
                    this.addRadComponentBefore(payloadComponent, targetComponent, menuParent);
                }
                return true;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return false;
    }

    private void addComponentBefore(JComponent payloadComponent, JComponent targetComponent, JComponent targetParent) {
        this.p("addComponentBefore: payload = " + payloadComponent + "\n" + " target comp = " + targetComponent + "\n" + " target parent = " + targetParent);
        int index = -1;
        for (int i = 0; i < targetParent.getComponentCount(); ++i) {
            if (targetParent.getComponent(i) != targetComponent) continue;
            index = i;
        }
        if (index < 0) {
            this.p("putting at the beginning");
            index = 0;
        }
        if (targetParent instanceof JMenu) {
            JPanel panel = this.layer.hackedPopupFactory.containerMap.get((JMenu)targetParent);
            panel.add((Component)payloadComponent, index);
            panel.setSize(panel.getLayout().preferredLayoutSize(panel));
            panel.revalidate();
        } else {
            targetParent.add((Component)payloadComponent, index);
            targetParent.revalidate();
            if (targetParent.getLayout() != null) {
                targetParent.setSize(targetParent.getLayout().preferredLayoutSize(targetParent));
            }
        }
        targetParent.repaint();
    }

    private void addRadComponentBefore(JComponent comp, JComponent target, JComponent parent) {
        try {
            RADVisualContainer parentRAD = (RADVisualContainer)this.layer.formDesigner.getMetaComponent(parent);
            RADVisualComponent compRAD = (RADVisualComponent)this.layer.formDesigner.getMetaComponent(comp);
            RADVisualComponent targetRAD = (RADVisualComponent)this.layer.formDesigner.getMetaComponent(target);
            int index = parentRAD.getIndexOf(targetRAD);
            parentRAD.add(compRAD, index);
            FormModelEvent fme = this.layer.formDesigner.getFormModel().fireComponentAdded(compRAD, true);
            compRAD = (RADVisualComponent)this.layer.formDesigner.getMetaComponent(comp);
        }
        catch (Exception ex) {
            this.p(ex);
        }
    }

    private void removeComponent(JComponent payloadComponent, JComponent parent) {
        parent.remove(payloadComponent);
        parent.setSize(parent.getLayout().preferredLayoutSize(parent));
        parent.validate();
    }

    private void removeRadComponent(JComponent comp, JComponent parent) {
        try {
            RADVisualContainer parentRAD = (RADVisualContainer)this.layer.formDesigner.getMetaComponent(parent);
            RADVisualComponent compRAD = (RADVisualComponent)this.layer.formDesigner.getMetaComponent(comp);
            int index = parentRAD.getIndexOf(compRAD);
            parentRAD.remove(compRAD);
            FormModelEvent fme = this.layer.formDesigner.getFormModel().fireComponentRemoved(compRAD, parentRAD, index, false);
        }
        catch (Exception ex) {
            this.p(ex);
        }
    }

    private void addComponent(JComponent targetComponent, JComponent newComponent) {
        if (newComponent != null) {
            Container parent = targetComponent.getParent();
            JComponent menuParent = this.layer.getMenuParent(targetComponent);
            int index = this.getMenuItemIndex(parent, targetComponent);
            if (index == -1) {
                System.out.println("couldn't find the component");
            }
            if (newComponent instanceof JMenu) {
                this.layer.configureMenu((JComponent)parent, (JMenu)newComponent);
            } else {
                this.layer.configureMenuItem((JMenu)menuParent, newComponent);
            }
            if (targetComponent instanceof JMenu) {
                parent = targetComponent;
                index = 0;
            }
            parent.add((Component)newComponent, index);
            parent.setSize(parent.getLayout().preferredLayoutSize(parent));
            parent.validate();
            if (targetComponent instanceof JMenu) {
                parent = targetComponent.getParent();
                parent.setSize(parent.getLayout().preferredLayoutSize(parent));
                parent.validate();
            }
        }
    }

    private int getMenuItemIndex(Container parent, JComponent comp) {
        int index = -1;
        for (int i = 0; i < parent.getComponentCount(); ++i) {
            if (parent.getComponent(i) != comp) continue;
            index = i;
            break;
        }
        return index;
    }

    private MetaComponentCreator getComponentCreator() {
        return this.layer.formDesigner.getFormModel().getComponentCreator();
    }

    private void p(Exception ex) {
        System.out.println("exception = " + ex.getMessage());
        ex.printStackTrace();
    }

    private void p(String string) {
    }
}

