/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form.menu;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.TransferHandler;

class MenuItemSender
extends TransferHandler {
    protected static Map<JComponent, JComponent> transferComps = new HashMap<JComponent, JComponent>();
    protected static Map<Integer, JComponent> dataMap = new HashMap<Integer, JComponent>();
    public static final DataFlavor COMPONENT_FLAVOR = new DataFlavor(Integer.class, "hacked menu item transfer");

    protected Transferable createTransferable(final JComponent source) {
        if (transferComps.containsKey(source)) {
            return new Transferable(){

                public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
                    if (this.isDataFlavorSupported(flavor)) {
                        JComponent comp = transferComps.get(source);
                        return comp.hashCode();
                    }
                    throw new UnsupportedFlavorException(flavor);
                }

                public DataFlavor[] getTransferDataFlavors() {
                    return new DataFlavor[]{COMPONENT_FLAVOR};
                }

                public boolean isDataFlavorSupported(DataFlavor flavor) {
                    return COMPONENT_FLAVOR.equals(flavor);
                }
            };
        }
        return new Transferable(){

            public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
                return "a transfered string";
            }

            public DataFlavor[] getTransferDataFlavors() {
                return new DataFlavor[]{DataFlavor.stringFlavor};
            }

            public boolean isDataFlavorSupported(DataFlavor flavor) {
                return flavor == DataFlavor.stringFlavor;
            }
        };
    }

    public int getSourceActions(JComponent c) {
        return 1;
    }

    public void registerTransferComponent(JComponent source, JComponent comp) {
        transferComps.put(source, comp);
        dataMap.put(comp.hashCode(), comp);
    }
}

