/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form.menu;

import java.awt.Point;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import javax.swing.JComponent;
import javax.swing.JMenu;
import org.netbeans.modules.form.menu.MenuEditLayer;

class VisualDesignerItemDropTargetListener
implements DropTargetListener {
    private final MenuEditLayer layer;

    public VisualDesignerItemDropTargetListener(MenuEditLayer layer) {
        this.layer = layer;
    }

    public void dragEnter(DropTargetDragEvent dtde) {
        JComponent comp = (JComponent)dtde.getDropTargetContext().getComponent();
        comp.setBorder(MenuEditLayer.INSERTION_BORDER);
        if (comp instanceof JMenu) {
            this.styleMenu((JMenu)comp, dtde.getLocation());
        }
    }

    public void dragOver(DropTargetDragEvent dtde) {
        JComponent comp = (JComponent)dtde.getDropTargetContext().getComponent();
        if (comp instanceof JMenu) {
            this.styleMenu((JMenu)comp, dtde.getLocation());
        }
    }

    public void dropActionChanged(DropTargetDragEvent dtde) {
    }

    public void dragExit(DropTargetEvent dte) {
        JComponent comp = (JComponent)dte.getDropTargetContext().getComponent();
        comp.setBorder(MenuEditLayer.UNSELECTED_BORDER);
    }

    public void drop(DropTargetDropEvent dtde) {
        dtde.acceptDrop(3);
        dtde.dropComplete(true);
    }

    private void styleMenu(JMenu menu, Point point) {
        menu.setBorderPainted(true);
        if (point.x > menu.getWidth() - 30) {
            menu.setBorder(MenuEditLayer.INSERTION_BORDER_MENU_RIGHT);
        } else {
            menu.setBorder(MenuEditLayer.INSERTION_BORDER);
        }
        this.layer.showMenuPopup(menu);
    }

    private void p(String string) {
        System.out.println(string);
    }
}

