/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form.menu;

import java.awt.Color;
import java.awt.Component;
import java.awt.Point;
import java.util.HashMap;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.JMenu;
import javax.swing.JPanel;
import javax.swing.Popup;
import javax.swing.PopupFactory;
import javax.swing.SwingUtilities;
import org.netbeans.modules.form.menu.MenuEditLayer;
import org.netbeans.modules.form.menu.VisualDesignerJPanelPopup;

class VisualDesignerPopupFactory
extends PopupFactory {
    private static final boolean DEBUG = false;
    public Map<JMenu, JPanel> containerMap = new HashMap<JMenu, JPanel>();
    public Map<JMenu, Popup> popupMap = new HashMap<JMenu, Popup>();
    public MenuEditLayer canvas;

    public VisualDesignerPopupFactory(MenuEditLayer canvas) {
        this.canvas = canvas;
    }

    public Popup getPopup(Component owner, Component contents, int x, int y) throws IllegalArgumentException {
        JMenu menu = (JMenu)owner;
        JComponent parent = this.canvas.getMenuParent(menu);
        JPanel cont = this.containerMap.get(menu);
        if (cont == null) {
            cont = new VisualDesignerJPanelContainer(menu);
            cont.setLayout(new BoxLayout(cont, 1));
            for (Component c : menu.getMenuComponents()) {
                cont.add(c);
            }
            cont.setBorder(BorderFactory.createLineBorder(Color.BLACK));
            this.containerMap.put(menu, cont);
            this.canvas.layers.add((Component)cont, JLayeredPane.DEFAULT_LAYER);
        }
        if (parent instanceof JMenu) {
            this.setLocationFromMenu(menu, cont);
        } else {
            Point pt = new Point(x, y);
            SwingUtilities.convertPointFromScreen(pt, this.canvas);
            cont.setLocation(pt);
        }
        cont.setSize(cont.getLayout().preferredLayoutSize(cont));
        this.canvas.validate();
        this.canvas.repaint();
        VisualDesignerJPanelPopup popup = new VisualDesignerJPanelPopup(cont, menu, this);
        this.popupMap.put(menu, popup);
        return popup;
    }

    private void setLocationFromMenu(JMenu menu, JPanel cont) {
        Point pt = menu.getLocationOnScreen();
        SwingUtilities.convertPointFromScreen(pt, this.canvas);
        JComponent parent = this.canvas.getMenuParent(menu);
        this.p("parent = " + parent);
        pt = parent instanceof JMenu ? new Point(pt.x + menu.getWidth(), pt.y) : new Point(pt.x, pt.y + menu.getHeight());
        cont.setLocation(pt);
    }

    private void p(String string) {
    }

    void hideOtherMenus(JMenu menu) {
        this.p("hiding other menus");
        for (JMenu m : this.containerMap.keySet()) {
            if (m == menu) continue;
            this.p("checking for ancestor");
            if (this.isAncestor(m, menu)) continue;
            JPanel popup = this.containerMap.get(m);
            popup.setVisible(false);
        }
    }

    private boolean isAncestor(JMenu m, JMenu menu) {
        return this.canvas.isAncestor(menu, m);
    }

    private class VisualDesignerJPanelContainer
    extends JPanel {
        JMenu menu;

        VisualDesignerJPanelContainer(JMenu menu) {
            this.menu = menu;
        }

        public void setVisible(boolean visible) {
            VisualDesignerPopupFactory.this.p("setting vis : " + visible);
            if (visible) {
                VisualDesignerPopupFactory.this.hideOtherMenus(this.menu);
                VisualDesignerPopupFactory.this.setLocationFromMenu(this.menu, this);
            }
            super.setVisible(visible);
        }
    }
}

